/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation;

import com.agfa.pacs.data.shared.BitWriter;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataFactory;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class OverlayContainer {
    private static final ALogger log = ALogger.getLogger(OverlayContainer.class);
    private List<OverlayFrame> overlayFrames;
    private String layer;
    private int numFrames;
    private int firstFrame;
    private String label;
    private String description;
    private String subtype;
    private String type;
    private OverlayPlane overlayPlane;

    public OverlayContainer(OverlayPlane overlayPlane, String string) {
        this.layer = string;
        this.numFrames = overlayPlane.getNumberOfFramesInOverlay();
        this.firstFrame = overlayPlane.getImageFrameOrigin() - 1;
        this.label = overlayPlane.getOverlayLabel();
        this.description = overlayPlane.getOverlayDescription();
        this.subtype = overlayPlane.getOverlaySubtype();
        this.type = overlayPlane.getOverlayType();
        this.overlayPlane = overlayPlane;
        this.overlayFrames = new ArrayList<OverlayFrame>();
        int n = 0;
        while (n < this.numFrames) {
            OverlayFrame overlayFrame = new OverlayFrame(this, this.firstFrame + n);
            this.overlayFrames.add(overlayFrame);
            ++n;
        }
    }

    public OverlayContainer() {
        this("G");
    }

    public OverlayContainer(String string) {
        this.overlayFrames = new ArrayList<OverlayFrame>();
        this.numFrames = 0;
        this.firstFrame = 0;
        this.type = string;
    }

    public OverlayFrame appendOverlayFrame() {
        OverlayFrame overlayFrame = new OverlayFrame(this, this.firstFrame + this.numFrames);
        this.overlayFrames.add(overlayFrame);
        ++this.numFrames;
        return overlayFrame;
    }

    public void setOverlayFrame(OverlayFrame overlayFrame, int n) {
        if (this.overlayFrames.isEmpty()) {
            this.firstFrame = n;
            ++this.numFrames;
            this.overlayFrames.add(overlayFrame);
        } else if (n < this.firstFrame) {
            int n2 = this.firstFrame - n;
            int n3 = 1;
            while (n3 < n2) {
                this.overlayFrames.add(0, new OverlayFrame(this, n + n3));
                ++n3;
            }
            this.overlayFrames.add(0, overlayFrame);
            this.numFrames += n2;
            this.firstFrame = n;
        } else if (n >= this.firstFrame && n < this.firstFrame + this.numFrames) {
            this.overlayFrames.set(n - this.firstFrame, overlayFrame);
        } else {
            int n4 = n - (this.firstFrame + this.numFrames);
            int n5 = 0;
            while (n5 < n4 - 1) {
                this.overlayFrames.add(new OverlayFrame(this, this.firstFrame + this.numFrames + n5));
                ++n5;
            }
            this.overlayFrames.add(overlayFrame);
            this.numFrames += n4;
        }
    }

    public OverlayContainer(List<OverlayFrame> list, int n) {
        this.overlayFrames = list;
        this.numFrames = list.size();
        this.firstFrame = n;
        this.type = "G";
    }

    public OverlayPlane toOverlayPlane() {
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (OverlayFrame object2 : this.overlayFrames) {
            if (object2.getOverlayData() == null) continue;
            n = object2.getOrigX();
            int bitWriter = object2.getOrigX() + object2.getWidth();
            int overlayFrame = object2.getOrigY();
            int n6 = object2.getOrigY() + object2.getHeight();
            if (n < n2) {
                n2 = n;
            }
            if (bitWriter > n3) {
                n3 = bitWriter;
            }
            if (overlayFrame < n4) {
                n4 = overlayFrame;
            }
            if (n6 <= n5) continue;
            n5 = n6;
        }
        int[] nArray = new int[]{n4, n2};
        int n9 = n3 - n2;
        n = n5 - n4;
        BitWriter bitWriter = new BitWriter();
        for (OverlayFrame overlayPlane : this.overlayFrames) {
            if (overlayPlane.getOverlayData() != null) {
                int n7 = overlayPlane.getOrigX() - n2;
                int n8 = n3 - overlayPlane.getOrigX() - overlayPlane.getWidth();
                int n10 = overlayPlane.getOrigY() - n2;
                int n11 = n5 - overlayPlane.getOrigY() - overlayPlane.getHeight();
                overlayPlane.getOverlayData().writePackedBits(bitWriter, n9, n7, n8, n10, n11);
                continue;
            }
            bitWriter.writeBit(0, n9 * n);
        }
        bitWriter.flush();
        OverlayPlane overlayPlane = new OverlayPlane();
        overlayPlane.setImageFrameOrigin(Integer.valueOf(this.firstFrame + 1));
        overlayPlane.setNumberOfFramesInOverlay(Integer.valueOf(this.overlayFrames.size()));
        overlayPlane.setOverlayBitPosition(Integer.valueOf(0));
        overlayPlane.setOverlayBitsAllocated(Integer.valueOf(1));
        overlayPlane.setOverlayColumns(Integer.valueOf(n9));
        overlayPlane.setOverlayData(bitWriter.toBytes());
        overlayPlane.setOverlayDescription(this.description);
        overlayPlane.setOverlayLabel(this.label);
        overlayPlane.setOverlayOrigin(nArray);
        overlayPlane.setOverlayRows(n);
        overlayPlane.setOverlaySubtype(this.subtype);
        overlayPlane.setOverlayType(this.type);
        return overlayPlane;
    }

    public OverlayFrame getOverlayFrame(int n, IPixelDataFrame<?> iPixelDataFrame, IOverlayDataFactory iOverlayDataFactory) {
        if (n - this.firstFrame < 0) {
            return null;
        }
        if (n - this.firstFrame >= this.numFrames) {
            return null;
        }
        return this.getFrame(n - this.firstFrame, iPixelDataFrame, iOverlayDataFactory);
    }

    private OverlayFrame getFrame(int n, IPixelDataFrame<?> iPixelDataFrame, IOverlayDataFactory iOverlayDataFactory) {
        OverlayFrame overlayFrame = this.overlayFrames.get(n);
        if (overlayFrame.getOverlayData() == null) {
            if (this.overlayPlane.getOverlayOrigin() == null || this.overlayPlane.getOverlayOrigin().length != 2) {
                log.error("Origin on the overlay plane incorrect or not specified.");
                return null;
            }
            int n2 = this.overlayPlane.getOverlayOrigin()[1] - 1;
            int n3 = this.overlayPlane.getOverlayOrigin()[0] - 1;
            int n4 = this.overlayPlane.getOverlayColumns();
            int n5 = this.overlayPlane.getOverlayRows();
            int n6 = this.overlayPlane.getOverlayBitPosition();
            if (n6 == 0) {
                byte[] byArray = this.overlayPlane.getOverlayData();
                if (byArray != null && byArray.length > 1) {
                    try {
                        overlayFrame.setOverlayData(n2, n3, n4, n5, iOverlayDataFactory.createOverlayData(byArray, n4, n5, n));
                    }
                    catch (Exception exception) {
                        log.error("Error while creating overlay data... Ommiting overlay...", (Throwable)exception);
                        overlayFrame = null;
                    }
                } else {
                    log.error("Expected bitmap overlay data not found. Omitting overlay.");
                    overlayFrame = null;
                }
            } else {
                if (iPixelDataFrame.getWidth() != n4 || iPixelDataFrame.getHeight() != n5) {
                    log.warn("Correcting embedded overlay bitmap inconsistency - image:" + iPixelDataFrame.getWidth() + "x" + iPixelDataFrame.getHeight() + " bitmap:" + n4 + "x" + n5);
                    n4 = iPixelDataFrame.getWidth();
                    n5 = iPixelDataFrame.getHeight();
                }
                overlayFrame.setOverlayData(n2, n3, n4, n5, iOverlayDataFactory.createOverlayData(iPixelDataFrame, n6));
            }
        }
        return overlayFrame;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getType() {
        return this.type;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setLayer(String string) {
        this.layer = string;
    }

    public void setSubtype(String string) {
        this.subtype = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getProviderUID() {
        return this.overlayPlane.getProviderUID();
    }

    public int getGroupTag() {
        return this.overlayPlane.getGroupTag();
    }
}

