/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.launch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.launch.EquinoxFWClassLoader;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Equinox
implements Framework {
    private static final String implName = "org.eclipse.osgi.framework.internal.core.EquinoxLauncher";
    private Framework impl;
    private final boolean useSeparateCL;
    private final Map<String, Object> configuration;
    static /* synthetic */ Class class$0;

    public Equinox(Map<String, ?> map) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        this.useSeparateCL = FrameworkProperties.inUse();
        Map<Object, Object> map2 = Collections.EMPTY_MAP;
        this.configuration = map == null ? map2 : new HashMap(map);
    }

    private Framework createImpl() {
        if (System.getSecurityManager() == null) {
            return this.createImpl0();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Framework>(){

            @Override
            public Framework run() {
                return Equinox.this.createImpl0();
            }
        });
    }

    Framework createImpl0() {
        try {
            Class<?> clazz = this.getImplClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (Framework)constructor.newInstance(this.configuration);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(implName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getMessage(), instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    private Class<?> getImplClass() throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!this.useSeparateCL || !(classLoader instanceof URLClassLoader)) {
            return Class.forName(implName);
        }
        URL[] uRLArray = this.getFrameworkURLs((URLClassLoader)classLoader);
        EquinoxFWClassLoader equinoxFWClassLoader = new EquinoxFWClassLoader(uRLArray, classLoader);
        return equinoxFWClassLoader.loadClass(implName);
    }

    /*
     * Unable to fully structure code
     */
    private URL[] getFrameworkURLs(URLClassLoader var1_1) {
        var2_2 = var1_1.getURLs();
        var3_3 = new ArrayList<URL>(var2_2.length);
        var4_4 = 0;
        while (var4_4 < var2_2.length) {
            block28: {
                block26: {
                    block27: {
                        block25: {
                            var5_5 = null;
                            var5_5 = var2_2[var4_4].getFile().endsWith("/") != false ? new URL(var2_2[var4_4], "META-INF/MANIFEST.MF").openStream() : new URL(new StringBuffer("jar:").append(var2_2[var4_4].toExternalForm()).append("!/").append("META-INF/MANIFEST.MF").toString()).openStream();
                            var6_6 = ManifestElement.parseBundleManifest(var5_5, new Headers<String, String>(10));
                            var7_7 = this.getValue(var6_6, "Bundle-SymbolicName");
                            if (var7_7 != null) break block25;
                            if (var5_5 == null) ** GOTO lbl67
                            try {
                                var5_5.close();
                            }
                            catch (IOException v0) {}
                            break block28;
                        }
                        var8_8 = Constants.getInternalSymbolicName();
                        if (var8_8.equals(var7_7)) {
                            this.addDevClassPaths(var2_2[var4_4], var7_7, var3_3);
                            var3_3.add(var2_2[var4_4]);
                            break block26;
                        }
                        if (this.isFrameworkFragment(var6_6, var8_8)) break block27;
                        ** if (var5_5 == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var5_5.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block28;
                        }
                    }
                    try {
                        this.addDevClassPaths(var2_2[var4_4], var7_7, var3_3);
                        var3_3.add(var2_2[var4_4]);
                    }
                    catch (IOException v2) {
                        if (var5_5 == null) ** GOTO lbl67
                        try {
                            var5_5.close();
                        }
                        catch (IOException v3) {}
                    }
                    catch (BundleException v4) {
                        try {
                            if (var5_5 == null) ** GOTO lbl67
                        }
                        catch (Throwable var9_9) {
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (IOException v5) {}
                            }
                            throw var9_9;
                        }
                        try {
                            var5_5.close();
                        }
                        catch (IOException v6) {}
                    }
                }
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (IOException v7) {}
                }
            }
            ++var4_4;
        }
        return var3_3.toArray(new URL[var3_3.size()]);
    }

    private void addDevClassPaths(URL uRL, String string, List<URL> list) {
        if (!uRL.getPath().endsWith("/")) {
            return;
        }
        String[] stringArray = DevClassPathHelper.getDevClassPath(string);
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                char c = stringArray[n].charAt(stringArray[n].length() - 1);
                URL uRL2 = stringArray[n].endsWith(".jar") || c == '/' || c == '\\' ? new URL(uRL, stringArray[n]) : new URL(uRL, new StringBuffer(String.valueOf(stringArray[n])).append("/").toString());
                list.add(uRL2);
            }
            catch (MalformedURLException malformedURLException) {}
            ++n;
        }
    }

    private boolean isFrameworkFragment(Map<String, String> map, String string) {
        String string2 = this.getValue(map, "Fragment-Host");
        return string.equals(string2) || "system.bundle".equals(string2);
    }

    private String getValue(Map<String, String> map, String string) {
        ManifestElement[] manifestElementArray;
        String string2 = map.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            manifestElementArray = ManifestElement.parseHeader(string, string2);
        }
        catch (BundleException bundleException) {
            return null;
        }
        if (manifestElementArray == null) {
            return null;
        }
        return manifestElementArray[0].getValue();
    }

    private synchronized Framework getImpl() {
        if (this.impl == null) {
            this.impl = this.createImpl();
        }
        return this.impl;
    }

    @Override
    public void init() throws BundleException {
        this.getImpl().init();
    }

    @Override
    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        return this.getImpl().waitForStop(l);
    }

    @Override
    public Enumeration<URL> findEntries(String string, String string2, boolean bl) {
        return this.getImpl().findEntries(string, string2, bl);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.getImpl().getBundleContext();
    }

    @Override
    public long getBundleId() {
        return this.getImpl().getBundleId();
    }

    @Override
    public URL getEntry(String string) {
        return this.getImpl().getEntry(string);
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) {
        return this.getImpl().getEntryPaths(string);
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.getImpl().getHeaders();
    }

    @Override
    public Dictionary<String, String> getHeaders(String string) {
        return this.getImpl().getHeaders(string);
    }

    @Override
    public long getLastModified() {
        return this.getImpl().getLastModified();
    }

    @Override
    public String getLocation() {
        return this.getImpl().getLocation();
    }

    @Override
    public ServiceReference<?>[] getRegisteredServices() {
        return this.getImpl().getRegisteredServices();
    }

    @Override
    public URL getResource(String string) {
        return this.getImpl().getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.getImpl().getResources(string);
    }

    @Override
    public ServiceReference<?>[] getServicesInUse() {
        return this.getImpl().getServicesInUse();
    }

    @Override
    public int getState() {
        return this.getImpl().getState();
    }

    @Override
    public String getSymbolicName() {
        return this.getImpl().getSymbolicName();
    }

    @Override
    public boolean hasPermission(Object object) {
        return this.getImpl().hasPermission(object);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.getImpl().loadClass(string);
    }

    @Override
    public void start(int n) throws BundleException {
        this.getImpl().start(n);
    }

    @Override
    public void start() throws BundleException {
        this.getImpl().start();
    }

    @Override
    public void stop(int n) throws BundleException {
        this.getImpl().stop(n);
    }

    @Override
    public void stop() throws BundleException {
        this.getImpl().stop();
    }

    @Override
    public void uninstall() throws BundleException {
        this.getImpl().uninstall();
    }

    @Override
    public void update() throws BundleException {
        this.getImpl().update();
    }

    @Override
    public void update(InputStream inputStream) throws BundleException {
        this.getImpl().update(inputStream);
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int n) {
        return this.getImpl().getSignerCertificates(n);
    }

    @Override
    public Version getVersion() {
        return this.getImpl().getVersion();
    }

    @Override
    public <A> A adapt(Class<A> clazz) {
        return this.getImpl().adapt(clazz);
    }

    @Override
    public int compareTo(Bundle bundle) {
        return this.getImpl().compareTo(bundle);
    }

    @Override
    public File getDataFile(String string) {
        return this.getImpl().getDataFile(string);
    }
}

