/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedContentFile
implements SignedContent {
    private final SignedContentImpl signedContent;
    private Map<String, Throwable> entryExceptions = null;

    public SignedContentFile(SignedContentImpl signedContentImpl) {
        try {
            signedContentImpl.content.close();
        }
        catch (IOException iOException) {}
        this.signedContent = signedContentImpl;
    }

    @Override
    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        this.signedContent.checkValidity(signerInfo);
    }

    @Override
    public synchronized SignedContentEntry[] getSignedEntries() {
        SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
        if (this.signedContent == null) {
            return null;
        }
        SignedContentEntry[] signedContentEntryArray2 = new SignedContentEntry[signedContentEntryArray.length];
        Map<String, Throwable> map = this.getEntryExceptions(true);
        int n = 0;
        while (n < signedContentEntryArray.length) {
            try {
                signedContentEntryArray[n].verify();
            }
            catch (Throwable throwable) {
                map.put(signedContentEntryArray[n].getName(), throwable);
            }
            signedContentEntryArray2[n] = new SignedContentFileEntry(signedContentEntryArray[n]);
            ++n;
        }
        try {
            this.signedContent.content.close();
        }
        catch (IOException iOException) {}
        return signedContentEntryArray2;
    }

    @Override
    public synchronized SignedContentEntry getSignedEntry(String string) {
        SignedContentEntry signedContentEntry;
        if (this.getEntryExceptions(false) == null) {
            this.getSignedEntries();
        }
        return (signedContentEntry = this.signedContent.getSignedEntry(string)) == null ? null : new SignedContentFileEntry(signedContentEntry);
    }

    @Override
    public SignerInfo[] getSignerInfos() {
        return this.signedContent.getSignerInfos();
    }

    @Override
    public Date getSigningTime(SignerInfo signerInfo) {
        return this.signedContent.getSigningTime(signerInfo);
    }

    @Override
    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        return this.signedContent.getTSASignerInfo(signerInfo);
    }

    @Override
    public boolean isSigned() {
        return this.signedContent.isSigned();
    }

    synchronized Map<String, Throwable> getEntryExceptions(boolean bl) {
        if (bl && this.entryExceptions == null) {
            this.entryExceptions = new HashMap<String, Throwable>(5);
        }
        return this.entryExceptions;
    }

    public class SignedContentFileEntry
    implements SignedContentEntry {
        private final SignedContentEntry entry;

        public SignedContentFileEntry(SignedContentEntry signedContentEntry) {
            this.entry = signedContentEntry;
        }

        public String getName() {
            return this.entry.getName();
        }

        public SignerInfo[] getSignerInfos() {
            return this.entry.getSignerInfos();
        }

        public boolean isSigned() {
            return this.entry.isSigned();
        }

        public void verify() throws IOException, InvalidContentException {
            Throwable throwable;
            Map<String, Throwable> map = SignedContentFile.this.getEntryExceptions(false);
            Throwable throwable2 = throwable = map == null ? null : map.get(this.entry.getName());
            if (throwable == null) {
                return;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof InvalidContentException) {
                throw (InvalidContentException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        }
    }
}

