/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.service.security.DefaultAuthorizationEngine;
import org.eclipse.osgi.internal.service.security.KeyStoreTrustEngine;
import org.eclipse.osgi.internal.signedcontent.BundleInstallListener;
import org.eclipse.osgi.internal.signedcontent.LegacyVerifierFactory;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.internal.signedcontent.TrustEngineListener;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class SignedBundleHook
implements AdaptorHook,
BundleFileWrapperFactoryHook,
HookConfigurator,
SignedContentFactory {
    static final int VERIFY_CERTIFICATE = 1;
    static final int VERIFY_TRUST = 2;
    static final int VERIFY_RUNTIME = 4;
    static final int VERIFY_AUTHORITY = 8;
    static final int VERIFY_ALL = 15;
    private static String SUPPORT_CERTIFICATE = "certificate";
    private static String SUPPORT_TRUST = "trust";
    private static String SUPPORT_RUNTIME = "runtime";
    private static String SUPPORT_AUTHORITY = "authority";
    private static String SUPPORT_ALL = "all";
    private static String SUPPORT_TRUE = "true";
    private static String CACERTS_PATH = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "lib" + File.separatorChar + "security" + File.separatorChar + "cacerts";
    private static String CACERTS_TYPE = "JKS";
    private static ServiceTracker<TrustEngine, TrustEngine> trustEngineTracker;
    private static BaseAdaptor ADAPTOR;
    private static String SIGNED_BUNDLE_SUPPORT;
    private static String SIGNED_CONTENT_SUPPORT;
    private static String OSGI_KEYSTORE;
    private static int supportSignedBundles;
    private TrustEngineListener trustEngineListener;
    private BundleInstallListener installListener;
    private ServiceRegistration<?> signedContentFactoryReg;
    private ServiceRegistration<?> systemTrustEngineReg;
    private ServiceRegistration<?> defaultAuthEngineReg;
    private List<ServiceRegistration<?>> osgiTrustEngineReg;
    private ServiceRegistration<?> legacyFactoryReg;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
        SIGNED_CONTENT_SUPPORT = "osgi.signedcontent.support";
        OSGI_KEYSTORE = "osgi.framework.keystore";
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        ADAPTOR = baseAdaptor;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        Class<?> clazz;
        block28: {
            Hashtable<String, Object> hashtable;
            if ((supportSignedBundles & 8) != 0) {
                this.installListener = new BundleInstallListener();
                bundleContext.addBundleListener(this.installListener);
                hashtable = new Hashtable(7);
                ((Dictionary)hashtable).put("service.ranking", new Integer(Integer.MIN_VALUE));
                ((Dictionary)hashtable).put("osgi.signedcontent.authorization.engine", SignedContentConstants.DEFAULT_AUTHORIZATION_ENGINE);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.defaultAuthEngineReg = bundleContext.registerService(clazz2.getName(), (Object)new DefaultAuthorizationEngine(bundleContext, ADAPTOR.getState()), hashtable);
            }
            hashtable = new Hashtable<String, Object>(7);
            ((Dictionary)hashtable).put("service.ranking", new Integer(Integer.MIN_VALUE));
            ((Dictionary)hashtable).put("osgi.signedcontent.trust.engine", SignedContentConstants.DEFAULT_TRUST_ENGINE);
            KeyStoreTrustEngine keyStoreTrustEngine = new KeyStoreTrustEngine(CACERTS_PATH, CACERTS_TYPE, null, "System");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.systemTrustEngineReg = bundleContext.registerService(clazz3.getName(), (Object)keyStoreTrustEngine, hashtable);
            String string = bundleContext.getProperty(OSGI_KEYSTORE);
            if (string != null) {
                try {
                    URL uRL = new URL(string);
                    if (!"file".equals(uRL.getProtocol())) break block28;
                    ((Dictionary)hashtable).put("osgi.signedcontent.trust.engine", OSGI_KEYSTORE);
                    String string2 = uRL.getPath();
                    this.osgiTrustEngineReg = new ArrayList(1);
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.osgiTrustEngineReg.add(bundleContext.registerService(clazz4.getName(), (Object)new KeyStoreTrustEngine(string2, CACERTS_TYPE, null, OSGI_KEYSTORE), hashtable));
                }
                catch (MalformedURLException malformedURLException) {
                    SignedBundleHook.log("Invalid setting for " + OSGI_KEYSTORE, 2, malformedURLException);
                }
            } else {
                String string3 = bundleContext.getProperty("org.osgi.framework.trust.repositories");
                if (string3 != null) {
                    ((Dictionary)hashtable).put("osgi.signedcontent.trust.engine", "org.osgi.framework.trust.repositories");
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
                    this.osgiTrustEngineReg = new ArrayList(1);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        Class<?> clazz5 = class$1;
                        if (clazz5 == null) {
                            try {
                                clazz5 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.osgiTrustEngineReg.add(bundleContext.registerService(clazz5.getName(), (Object)new KeyStoreTrustEngine(string4, CACERTS_TYPE, null, OSGI_KEYSTORE), hashtable));
                    }
                }
            }
        }
        if ((supportSignedBundles & 2) != 0) {
            this.trustEngineListener = new TrustEngineListener(bundleContext);
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.signedcontent.SignedContentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.signedContentFactoryReg = bundleContext.registerService(clazz.getName(), (Object)this, null);
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.legacyFactoryReg = bundleContext.registerService(clazz6.getName(), (Object)new LegacyVerifierFactory(this), null);
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (this.legacyFactoryReg != null) {
            this.legacyFactoryReg.unregister();
            this.legacyFactoryReg = null;
        }
        if (this.signedContentFactoryReg != null) {
            this.signedContentFactoryReg.unregister();
            this.signedContentFactoryReg = null;
        }
        if (this.systemTrustEngineReg != null) {
            this.systemTrustEngineReg.unregister();
            this.systemTrustEngineReg = null;
        }
        if (this.osgiTrustEngineReg != null) {
            Iterator<ServiceRegistration<?>> iterator = this.osgiTrustEngineReg.iterator();
            while (iterator.hasNext()) {
                iterator.next().unregister();
            }
            this.osgiTrustEngineReg = null;
        }
        if (this.defaultAuthEngineReg != null) {
            this.defaultAuthEngineReg.unregister();
            this.defaultAuthEngineReg = null;
        }
        if (this.trustEngineListener != null) {
            this.trustEngineListener.stopTrustEngineListener();
            this.trustEngineListener = null;
        }
        if (this.installListener != null) {
            bundleContext.removeBundleListener(this.installListener);
            this.installListener = null;
        }
        if (trustEngineTracker != null) {
            trustEngineTracker.close();
            trustEngineTracker = null;
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object object, BaseData baseData, boolean bl) {
        try {
            if (bundleFile != null) {
                SignedContentImpl signedContentImpl;
                SignedBundleFile signedBundleFile;
                SignedStorageHook signedStorageHook = (SignedStorageHook)baseData.getStorageHook(SignedStorageHook.KEY);
                if (bl && signedStorageHook != null) {
                    signedBundleFile = new SignedBundleFile(signedStorageHook.signedContent, supportSignedBundles);
                    if (signedStorageHook.signedContent == null) {
                        signedBundleFile.setBundleFile(bundleFile);
                        signedContentImpl = signedBundleFile.getSignedContent();
                        signedStorageHook.signedContent = signedContentImpl != null && signedContentImpl.isSigned() ? signedContentImpl : null;
                    }
                } else {
                    signedBundleFile = new SignedBundleFile(null, supportSignedBundles);
                }
                signedBundleFile.setBundleFile(bundleFile);
                signedContentImpl = signedBundleFile.getSignedContent();
                if (signedContentImpl != null && signedContentImpl.isSigned()) {
                    signedContentImpl.setContent(signedBundleFile);
                    bundleFile = signedBundleFile;
                }
            }
        }
        catch (IOException iOException) {
            SignedBundleHook.log("Bad bundle file: " + bundleFile.getBaseFile(), 2, iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            SignedBundleHook.log("Bad bundle file: " + bundleFile.getBaseFile(), 2, generalSecurityException);
        }
        return bundleFile;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
        String[] stringArray = ManifestElement.getArrayFromList(FrameworkProperties.getProperty(SIGNED_CONTENT_SUPPORT, FrameworkProperties.getProperty(SIGNED_BUNDLE_SUPPORT)), ",");
        int n = 0;
        while (n < stringArray.length) {
            if (SUPPORT_CERTIFICATE.equals(stringArray[n])) {
                supportSignedBundles |= 1;
            } else if (SUPPORT_TRUST.equals(stringArray[n])) {
                supportSignedBundles |= 3;
            } else if (SUPPORT_RUNTIME.equals(stringArray[n])) {
                supportSignedBundles |= 5;
            } else if (SUPPORT_AUTHORITY.equals(stringArray[n])) {
                supportSignedBundles |= 0xB;
            } else if (SUPPORT_TRUE.equals(stringArray[n]) || SUPPORT_ALL.equals(stringArray[n])) {
                supportSignedBundles |= 0xF;
            }
            ++n;
        }
        if ((supportSignedBundles & 1) != 0) {
            hookRegistry.addStorageHook(new SignedStorageHook());
            hookRegistry.addBundleFileWrapperFactoryHook(this);
        }
    }

    public SignedContent getSignedContent(File file) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        if (file == null) {
            throw new IllegalArgumentException("null content");
        }
        BundleFile bundleFile = file.isDirectory() ? new DirBundleFile(file) : new ZipBundleFile(file, null);
        SignedBundleFile signedBundleFile = new SignedBundleFile(null, 15);
        try {
            signedBundleFile.setBundleFile(bundleFile);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (InvalidKeyException)new InvalidKeyException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, file)).initCause(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw (SignatureException)new SignatureException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, file)).initCause(signatureException);
        }
        catch (CertificateException certificateException) {
            throw (CertificateException)new CertificateException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, file)).initCause(certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, file)).initCause(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw (NoSuchProviderException)new NoSuchProviderException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, file)).initCause(noSuchProviderException);
        }
        return new SignedContentFile(signedBundleFile.getSignedContent());
    }

    public SignedContent getSignedContent(Bundle bundle) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException {
        SignedContentImpl signedContentImpl;
        final BundleData bundleData = ((AbstractBundle)bundle).getBundleData();
        if (!(bundleData instanceof BaseData)) {
            throw new IllegalArgumentException("Invalid bundle object.  No BaseData found.");
        }
        SignedStorageHook signedStorageHook = (SignedStorageHook)((BaseData)bundleData).getStorageHook(SignedStorageHook.KEY);
        SignedContentImpl signedContentImpl2 = signedContentImpl = signedStorageHook != null ? signedStorageHook.signedContent : null;
        if (signedContentImpl != null) {
            return signedContentImpl;
        }
        if (System.getSecurityManager() == null) {
            return this.getSignedContent(((BaseData)bundleData).getBundleFile().getBaseFile());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SignedContent>(){

                @Override
                public SignedContent run() throws Exception {
                    return SignedBundleHook.this.getSignedContent(((BaseData)bundleData).getBundleFile().getBaseFile());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            if (privilegedActionException.getException() instanceof InvalidKeyException) {
                throw (InvalidKeyException)privilegedActionException.getException();
            }
            if (privilegedActionException.getException() instanceof SignatureException) {
                throw (SignatureException)privilegedActionException.getException();
            }
            if (privilegedActionException.getException() instanceof CertificateException) {
                throw (CertificateException)privilegedActionException.getException();
            }
            if (privilegedActionException.getException() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)privilegedActionException.getException();
            }
            if (privilegedActionException.getException() instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)privilegedActionException.getException();
            }
            throw new RuntimeException("Unknown error.", privilegedActionException.getException());
        }
    }

    public static void log(String string, int n, Throwable throwable) {
        if (ADAPTOR == null) {
            System.err.println(string);
            throwable.printStackTrace();
            return;
        }
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", n, 0, string, 0, throwable, null);
        ADAPTOR.getFrameworkLog().log(frameworkLogEntry);
    }

    static BundleContext getContext() {
        if (ADAPTOR == null) {
            return null;
        }
        return ADAPTOR.getContext();
    }

    static TrustEngine[] getTrustEngines() {
        Object object;
        Object[] objectArray;
        BundleContext bundleContext = SignedBundleHook.getContext();
        if (bundleContext == null) {
            return new TrustEngine[0];
        }
        if (trustEngineTracker == null) {
            objectArray = FrameworkProperties.getProperty("osgi.signedcontent.trust.engine");
            object = null;
            if (objectArray != null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    object = FilterImpl.newInstance(stringBuffer.append(clazz.getName()).append(")(").append("osgi.signedcontent.trust.engine").append("=").append((String)objectArray).append("))").toString());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    SignedBundleHook.log("Invalid trust engine filter", 2, invalidSyntaxException);
                }
            }
            if (object != null) {
                trustEngineTracker = new ServiceTracker(bundleContext, (Filter)object, null);
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                trustEngineTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            }
            trustEngineTracker.open();
        }
        if ((objectArray = trustEngineTracker.getServices()) != null) {
            object = new TrustEngine[objectArray.length];
            System.arraycopy(objectArray, 0, object, 0, objectArray.length);
            return object;
        }
        return new TrustEngine[0];
    }
}

