/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.FilterInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.signedcontent.SignatureBlockProcessor;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;

class DigestedInputStream
extends FilterInputStream {
    private final MessageDigest[] digests;
    private final byte[][] result;
    private final BundleEntry entry;
    private final BundleFile bundleFile;
    private long remaining;

    DigestedInputStream(BundleEntry bundleEntry, BundleFile bundleFile, SignerInfo[] signerInfoArray, byte[][] byArray, long l) throws IOException {
        super(bundleEntry.getInputStream());
        this.entry = bundleEntry;
        this.bundleFile = bundleFile;
        this.remaining = l;
        this.digests = new MessageDigest[signerInfoArray.length];
        int n = 0;
        while (n < signerInfoArray.length) {
            this.digests[n] = SignatureBlockProcessor.getMessageDigest(signerInfoArray[n].getMessageDigestAlgorithm());
            ++n;
        }
        this.result = byArray;
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            int n2 = 0;
            while (n2 < this.digests.length) {
                this.digests[n2].update((byte)n);
                ++n2;
            }
            --this.remaining;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining == 0L) {
            this.verifyDigests();
        }
        return n;
    }

    private void verifyDigests() throws InvalidContentException {
        int n = 0;
        while (n < this.digests.length) {
            byte[] byArray = this.digests[n].digest();
            if (!MessageDigest.isEqual(this.result[n], byArray)) {
                throw new InvalidContentException(NLS.bind(SignedContentMessages.File_In_Jar_Is_Tampered, this.entry.getName(), this.bundleFile.getBaseFile()), null);
            }
            ++n;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            int n4 = 0;
            while (n4 < this.digests.length) {
                this.digests[n4].update(byArray, n, n3);
                ++n4;
            }
            this.remaining -= (long)n3;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining <= 0L) {
            this.verifyDigests();
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while (l - l2 > 0L) {
            int n = l - l2 > (long)byArray.length ? byArray.length : (int)(l - l2);
            if ((n = this.read(byArray, 0, n)) == -1) break;
            l2 += (long)n;
            l -= (long)n;
        }
        return l2;
    }
}

