/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUse<S> {
    final ServiceFactory<S> factory;
    final BundleContextImpl context;
    final ServiceRegistrationImpl<S> registration;
    private S cachedService;
    private int useCount = 0;
    private boolean factoryInUse = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.internal.serviceregistry.ServiceUse");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    ServiceUse(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl<S> serviceRegistrationImpl) {
        S s = serviceRegistrationImpl.getServiceObject();
        if (s instanceof ServiceFactory) {
            ServiceFactory serviceFactory;
            this.factory = serviceFactory = (ServiceFactory)s;
            this.cachedService = null;
        } else {
            this.factory = null;
            this.cachedService = s;
        }
        this.context = bundleContextImpl;
        this.registration = serviceRegistrationImpl;
    }

    S getService() {
        Object t;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.useCount > 0 || this.factory == null) {
            ++this.useCount;
            return this.cachedService;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println(new StringBuffer("getService[factory=").append(this.registration.getBundle()).append("](").append(this.context.getBundleImpl()).append(",").append(this.registration).append(")").toString());
        }
        if (this.factoryInUse) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(new StringBuffer().append(this.factory).append(".getService() recursively called.").toString());
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_RECURSION, this.factory.getClass().getName(), "getService"), 6);
            this.context.getFramework().publishFrameworkEvent(16, this.registration.getBundle(), serviceException);
            return null;
        }
        this.factoryInUse = true;
        try {
            try {
                t = AccessController.doPrivileged(new PrivilegedAction<S>(){

                    @Override
                    public S run() {
                        return ServiceUse.this.factory.getService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration);
                    }
                });
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(new StringBuffer().append(this.factory).append(".getService() exception: ").append(throwable.getMessage()).toString());
                    Debug.printStackTrace(throwable);
                }
                this.context.getFramework().getAdaptor().handleRuntimeError(throwable);
                ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "getService"), 3, throwable);
                this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
                this.factoryInUse = false;
                return null;
            }
        }
        finally {
            this.factoryInUse = false;
        }
        if (t == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(new StringBuffer().append(this.factory).append(".getService() returned null.").toString());
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_OBJECT_NULL_EXCEPTION, this.factory.getClass().getName()), 2);
            this.context.getFramework().publishFrameworkEvent(16, this.registration.getBundle(), serviceException);
            return null;
        }
        String[] stringArray = this.registration.getClasses();
        String string = ServiceRegistry.checkServiceClass(stringArray, t);
        if (string != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(new StringBuffer("Service object is not an instanceof ").append(string).toString());
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_NOT_INSTANCEOF_CLASS_EXCEPTION, this.factory.getClass().getName(), string), 2);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
            return null;
        }
        this.cachedService = t;
        ++this.useCount;
        return (S)t;
    }

    boolean ungetService() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount > 0) {
            return false;
        }
        if (this.factory == null) {
            return true;
        }
        final S s = this.cachedService;
        this.cachedService = null;
        if (Debug.DEBUG_SERVICES) {
            Debug.println(new StringBuffer("ungetService[factory=").append(this.registration.getBundle()).append("](").append(this.context.getBundleImpl()).append(",").append(this.registration).append(")").toString());
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<S>(){

                @Override
                public S run() {
                    ServiceUse.this.factory.ungetService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration, s);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println(new StringBuffer().append(this.factory).append(".ungetService() exception").toString());
                Debug.printStackTrace(throwable);
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, throwable);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
        }
        return true;
    }

    void releaseService() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.useCount == 0 || this.factory == null) {
            return;
        }
        final S s = this.cachedService;
        this.cachedService = null;
        this.useCount = 0;
        if (Debug.DEBUG_SERVICES) {
            Debug.println(new StringBuffer("releaseService[factory=").append(this.registration.getBundle()).append("](").append(this.context.getBundleImpl()).append(",").append(this.registration).append(")").toString());
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<S>(){

                @Override
                public S run() {
                    ServiceUse.this.factory.ungetService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration, s);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(new StringBuffer().append(this.factory).append(".ungetService() exception").toString());
                Debug.printStackTrace(throwable);
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, throwable);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
        }
    }
}

