/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.util.Headers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceProperties
extends Headers<String, Object> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProperties(int n, Dictionary<String, ?> dictionary) {
        super(n);
        if (dictionary == null) {
            return;
        }
        Dictionary<String, ?> dictionary2 = dictionary;
        synchronized (dictionary2) {
            Enumeration<String> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!(string instanceof String)) continue;
                String string2 = string;
                this.setProperty(string2, dictionary.get(string2));
            }
        }
    }

    ServiceProperties(Dictionary<String, ?> dictionary) {
        this(dictionary == null ? 2 : dictionary.size() + 2, dictionary);
    }

    Object getProperty(String string) {
        return ServiceProperties.cloneValue(this.get(string));
    }

    synchronized String[] getPropertyKeys() {
        int n = this.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.keys();
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        return stringArray;
    }

    synchronized Object setProperty(String string, Object object) {
        return this.set(string, ServiceProperties.cloneValue(object));
    }

    private static Object cloneValue(Object object) {
        block10: {
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return object;
            }
            if (object instanceof Number) {
                return object;
            }
            if (object instanceof Character) {
                return object;
            }
            if (object instanceof Boolean) {
                return object;
            }
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                int n = Array.getLength(object);
                Object object2 = Array.newInstance(clazz2, n);
                System.arraycopy(object, 0, object2, 0, n);
                return object2;
            }
            try {
                return clazz.getMethod("clone", null).invoke(object, null);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                if (object instanceof Vector) {
                    return ((Vector)object).clone();
                }
                if (!(object instanceof Hashtable)) break block10;
                return ((Hashtable)object).clone();
            }
        }
        return object;
    }

    @Override
    public synchronized String toString() {
        String[] stringArray = this.getPropertyKeys();
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(20 * n);
        stringBuffer.append('{');
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = stringArray[n3];
            if (!string.equals("objectClass")) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                stringBuffer.append('=');
                Object v = this.get(string);
                if (v.getClass().isArray()) {
                    stringBuffer.append('[');
                    int n4 = Array.getLength(v);
                    int n5 = 0;
                    while (n5 < n4) {
                        if (n5 > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(Array.get(v, n5));
                        ++n5;
                    }
                    stringBuffer.append(']');
                } else {
                    stringBuffer.append(v);
                }
                ++n2;
            }
            ++n3;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

