/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.serviceregistry.ModifiedServiceEvent;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.ListenerHook;

class FilteredServiceListener
implements ServiceListener,
ListenerHook.ListenerInfo {
    private final FilterImpl filter;
    private final ServiceListener listener;
    private final BundleContextImpl context;
    private final boolean allservices;
    private final String objectClass;
    private volatile boolean removed;

    FilteredServiceListener(BundleContextImpl bundleContextImpl, ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        if (string == null) {
            this.filter = null;
            this.objectClass = null;
        } else {
            FilterImpl filterImpl = FilterImpl.newInstance(string);
            String string2 = filterImpl.getRequiredObjectClass();
            if (string2 == null) {
                this.objectClass = null;
                this.filter = filterImpl;
            } else {
                this.objectClass = string2.intern();
                this.filter = string.equals(FilteredServiceListener.getObjectClassFilterString(this.objectClass)) ? null : filterImpl;
            }
        }
        this.removed = false;
        this.listener = serviceListener;
        this.context = bundleContextImpl;
        this.allservices = serviceListener instanceof AllServiceListener;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object object;
        ServiceReferenceImpl serviceReferenceImpl;
        block8: {
            serviceReferenceImpl = (ServiceReferenceImpl)serviceEvent.getServiceReference();
            if (this.objectClass != null) {
                object = serviceReferenceImpl.getClasses();
                int n = ((String[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    if (object[n2] != this.objectClass) {
                        ++n2;
                        continue;
                    }
                    break block8;
                }
                return;
            }
        }
        if (!ServiceRegistry.hasListenServicePermission(serviceEvent, this.context)) {
            return;
        }
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this));
            Debug.println("filterServiceEvent(" + (String)object + ", \"" + this.getFilter() + "\", " + serviceReferenceImpl.getRegistration().getProperties() + ")");
        }
        if ((serviceEvent = this.filterMatch(serviceEvent)) == null) {
            return;
        }
        if (this.allservices || ServiceRegistry.isAssignableTo(this.context, serviceReferenceImpl)) {
            if (Debug.DEBUG_EVENTS) {
                object = String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener));
                Debug.println("dispatchFilteredServiceEvent(" + (String)object + ")");
            }
            this.listener.serviceChanged(serviceEvent);
        }
    }

    private ServiceEvent filterMatch(ServiceEvent serviceEvent) {
        ModifiedServiceEvent modifiedServiceEvent;
        ServiceEvent serviceEvent2;
        boolean bl = serviceEvent.getType() == 2;
        ServiceEvent serviceEvent3 = serviceEvent2 = bl ? ((ModifiedServiceEvent)serviceEvent).getModifiedEvent() : serviceEvent;
        if (this.filter == null) {
            return serviceEvent2;
        }
        ServiceReference<?> serviceReference = serviceEvent2.getServiceReference();
        if (this.filter.match(serviceReference)) {
            return serviceEvent2;
        }
        if (bl && (modifiedServiceEvent = (ModifiedServiceEvent)serviceEvent).matchPreviousProperties(this.filter)) {
            return modifiedServiceEvent.getModifiedEndMatchEvent();
        }
        return null;
    }

    public String toString() {
        String string = this.getFilter();
        if (string == null) {
            string = "";
        }
        return String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener)) + string;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getFilter() {
        if (this.filter != null) {
            return this.filter.toString();
        }
        return FilteredServiceListener.getObjectClassFilterString(this.objectClass);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    void markRemoved() {
        this.removed = true;
    }

    private static String getObjectClassFilterString(String string) {
        if (string == null) {
            return null;
        }
        return "(objectClass=" + string + ")";
    }
}

