/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StateWriter {
    private final Map<Object, Integer> objectTable = new HashMap<Object, Integer>();
    private final List<Object> forcedWrite = new ArrayList<Object>();

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        Integer n = this.objectTable.get(object);
        if (n != null) {
            return n;
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Integer n;
        if (this.objectTable != null && (n = this.objectTable.get(object)) != null) {
            return n;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (this.writeIndex(object, dataOutputStream)) {
            return true;
        }
        int n = this.addToObjectTable(object);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(n);
        return false;
    }

    private void writeStateDeprecated(StateImpl stateImpl, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(36);
        if (this.writePrefix(stateImpl, dataOutputStream)) {
            return;
        }
        dataOutputStream.writeLong(stateImpl.getTimeStamp());
        String[] stringArray = stateImpl.getPlatformPropertyKeys();
        this.writePlatformProp(stringArray, dataOutputStream);
        Dictionary[] dictionaryArray = stateImpl.getPlatformProperties();
        dataOutputStream.writeInt(dictionaryArray.length);
        int n = 0;
        while (n < dictionaryArray.length) {
            Dictionary dictionary = dictionaryArray[n];
            dataOutputStream.writeInt(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.writePlatformProp(dictionary.get(stringArray[n2]), dataOutputStream);
                ++n2;
            }
            ++n;
        }
        BundleDescription[] bundleDescriptionArray = stateImpl.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundleDescriptionArray);
        dataOutputStream.writeInt(bundleDescriptionArray.length);
        if (bundleDescriptionArray.length == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < bundleDescriptionArray.length) {
            this.writeBundleDescription(bundleDescriptionArray[n3], dataOutputStream, false);
            ++n3;
        }
        dataOutputStream.writeBoolean(stateImpl.isResolved());
        dataOutputStream.writeInt(dataOutputStream.size());
        n3 = 0;
        while (n3 < bundleDescriptionArray.length) {
            this.writeBundleDescriptionLazyData(bundleDescriptionArray[n3], dataOutputStream);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(StateImpl stateImpl, File file, File file2) throws IOException {
        DataOutputStream dataOutputStream = null;
        DataOutputStream dataOutputStream2 = null;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        Object object = stateImpl.monitor;
        synchronized (object) {
            BundleDescription[] bundleDescriptionArray;
            block42: {
                block43: {
                    bundleDescriptionArray = stateImpl.getBundles();
                    StateHelperImpl.getInstance().sortBundles(bundleDescriptionArray);
                    int n = 0;
                    while (n < bundleDescriptionArray.length) {
                        this.addToObjectTable(bundleDescriptionArray[n]);
                        if (bundleDescriptionArray[n].getHost() != null) {
                            this.addToObjectTable(bundleDescriptionArray[n].getHost());
                        }
                        ++n;
                    }
                    fileOutputStream = new FileOutputStream(file2);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
                    n = 0;
                    while (n < bundleDescriptionArray.length) {
                        this.writeBundleDescriptionLazyData(bundleDescriptionArray[n], dataOutputStream);
                        ++n;
                    }
                    fileOutputStream2 = new FileOutputStream(file);
                    dataOutputStream2 = new DataOutputStream(new BufferedOutputStream(fileOutputStream2));
                    dataOutputStream2.write(36);
                    if (!this.writePrefix(stateImpl, dataOutputStream2)) break block42;
                    if (dataOutputStream == null) break block43;
                    try {
                        dataOutputStream.flush();
                        fileOutputStream.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (dataOutputStream2 != null) {
                    try {
                        dataOutputStream2.flush();
                        fileOutputStream2.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        dataOutputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
            try {
                dataOutputStream2.writeLong(stateImpl.getTimeStamp());
                String[] stringArray = stateImpl.getPlatformPropertyKeys();
                this.writePlatformProp(stringArray, dataOutputStream2);
                Dictionary[] dictionaryArray = stateImpl.getPlatformProperties();
                dataOutputStream2.writeInt(dictionaryArray.length);
                int n = 0;
                while (n < dictionaryArray.length) {
                    Dictionary dictionary = dictionaryArray[n];
                    dataOutputStream2.writeInt(stringArray.length);
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        this.writePlatformProp(dictionary.get(stringArray[n2]), dataOutputStream2);
                        ++n2;
                    }
                    ++n;
                }
                dataOutputStream2.writeInt(bundleDescriptionArray.length);
                n = 0;
                while (n < bundleDescriptionArray.length) {
                    this.writeBundleDescription(bundleDescriptionArray[n], dataOutputStream2, true);
                    ++n;
                }
                DisabledInfo[] disabledInfoArray = stateImpl.getDisabledInfos();
                dataOutputStream2.writeInt(disabledInfoArray.length);
                int n3 = 0;
                while (n3 < disabledInfoArray.length) {
                    this.writeDisabledInfo(disabledInfoArray[n3], dataOutputStream2);
                    ++n3;
                }
                dataOutputStream2.writeBoolean(stateImpl.isResolved());
            }
            catch (Throwable throwable) {
                if (dataOutputStream != null) {
                    try {
                        dataOutputStream.flush();
                        fileOutputStream.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (dataOutputStream2 != null) {
                    try {
                        dataOutputStream2.flush();
                        fileOutputStream2.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        dataOutputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.flush();
                    fileOutputStream.getFD().sync();
                }
                catch (IOException iOException) {}
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (dataOutputStream2 != null) {
                try {
                    dataOutputStream2.flush();
                    fileOutputStream2.getFD().sync();
                }
                catch (IOException iOException) {}
                try {
                    dataOutputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writePlatformProp(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (!(object instanceof String) && !(object instanceof String[])) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            if (object instanceof String) {
                dataOutputStream.writeInt(1);
                this.writeStringOrNull((String)object, dataOutputStream);
            } else {
                String[] stringArray = (String[])object;
                dataOutputStream.writeInt(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    this.writeStringOrNull(stringArray[n], dataOutputStream);
                    ++n;
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundleDescription, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (bl && !this.forcedWrite.contains(bundleDescription)) {
            int n = this.addToObjectTable(bundleDescription);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(n);
            this.forcedWrite.add(bundleDescription);
        } else if (this.writePrefix(bundleDescription, dataOutputStream)) {
            return;
        }
        dataOutputStream.writeLong(bundleDescription.getBundleId());
        this.writeBaseDescription(bundleDescription, dataOutputStream);
        dataOutputStream.writeInt(((BundleDescriptionImpl)bundleDescription).getLazyDataOffset());
        dataOutputStream.writeInt(((BundleDescriptionImpl)bundleDescription).getLazyDataSize());
        dataOutputStream.writeBoolean(bundleDescription.isResolved());
        dataOutputStream.writeBoolean(bundleDescription.isSingleton());
        dataOutputStream.writeBoolean(bundleDescription.hasDynamicImports());
        dataOutputStream.writeBoolean(bundleDescription.attachFragments());
        dataOutputStream.writeBoolean(bundleDescription.dynamicFragments());
        this.writeList(dataOutputStream, (String[])((BundleDescriptionImpl)bundleDescription).getDirective("mandatory"));
        this.writeMap(dataOutputStream, bundleDescription.getAttributes());
        this.writeHostSpec((HostSpecificationImpl)bundleDescription.getHost(), dataOutputStream, bl);
        List<BundleDescription> list = ((BundleDescriptionImpl)bundleDescription).getBundleDependencies();
        dataOutputStream.writeInt(list.size());
        Iterator<BundleDescription> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.writeBundleDescription(iterator.next(), dataOutputStream, bl);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeBundleDescriptionLazyData(BundleDescription bundleDescription, DataOutputStream dataOutputStream) throws IOException {
        int n = dataOutputStream.size();
        int n2 = this.getFromObjectTable(bundleDescription);
        ((BundleDescriptionImpl)bundleDescription).setLazyDataOffset(dataOutputStream.size());
        dataOutputStream.writeInt(n2);
        this.writeStringOrNull(bundleDescription.getLocation(), dataOutputStream);
        this.writeStringOrNull(bundleDescription.getPlatformFilter(), dataOutputStream);
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        dataOutputStream.writeInt(exportPackageDescriptionArray.length);
        int n3 = 0;
        while (n3 < exportPackageDescriptionArray.length) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n3], dataOutputStream);
            ++n3;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescription.getImportPackages();
        dataOutputStream.writeInt(importPackageSpecificationArray.length);
        int n4 = 0;
        while (n4 < importPackageSpecificationArray.length) {
            this.writeImportPackageSpec(importPackageSpecificationArray[n4], dataOutputStream);
            ++n4;
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        dataOutputStream.writeInt(bundleSpecificationArray.length);
        int n5 = 0;
        while (n5 < bundleSpecificationArray.length) {
            this.writeBundleSpec((BundleSpecificationImpl)bundleSpecificationArray[n5], dataOutputStream);
            ++n5;
        }
        ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getSelectedExports();
        if (exportPackageDescriptionArray2 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(exportPackageDescriptionArray2.length);
            int n6 = 0;
            while (n6 < exportPackageDescriptionArray2.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray2[n6], dataOutputStream);
                ++n6;
            }
        }
        ExportPackageDescription[] exportPackageDescriptionArray3 = bundleDescription.getSubstitutedExports();
        if (exportPackageDescriptionArray3 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(exportPackageDescriptionArray3.length);
            int n7 = 0;
            while (n7 < exportPackageDescriptionArray3.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray3[n7], dataOutputStream);
                ++n7;
            }
        }
        ExportPackageDescription[] exportPackageDescriptionArray4 = bundleDescription.getResolvedImports();
        if (exportPackageDescriptionArray4 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(exportPackageDescriptionArray4.length);
            int n8 = 0;
            while (n8 < exportPackageDescriptionArray4.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray4[n8], dataOutputStream);
                ++n8;
            }
        }
        BundleDescription[] bundleDescriptionArray = bundleDescription.getResolvedRequires();
        if (bundleDescriptionArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(bundleDescriptionArray.length);
            int n9 = 0;
            while (n9 < bundleDescriptionArray.length) {
                this.writeBundleDescription(bundleDescriptionArray[n9], dataOutputStream, false);
                ++n9;
            }
        }
        String[] stringArray = bundleDescription.getExecutionEnvironments();
        dataOutputStream.writeInt(stringArray.length);
        int n10 = 0;
        while (n10 < stringArray.length) {
            this.writeStringOrNull(stringArray[n10], dataOutputStream);
            ++n10;
        }
        Map<String, Long> map = ((BundleDescriptionImpl)bundleDescription).getDynamicStamps();
        if (map == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(map.size());
            for (String object2 : map.keySet()) {
                this.writeStringOrNull(object2, dataOutputStream);
                dataOutputStream.writeLong(map.get(object2));
            }
        }
        GenericDescription[] genericDescriptionArray = bundleDescription.getGenericCapabilities();
        if (genericDescriptionArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            void var15_25;
            dataOutputStream.writeInt(genericDescriptionArray.length);
            boolean n11 = false;
            while (var15_25 < genericDescriptionArray.length) {
                this.writeGenericDescription((GenericDescription)genericDescriptionArray[var15_25], dataOutputStream);
                ++var15_25;
            }
        }
        GenericSpecification[] genericSpecificationArray = bundleDescription.getGenericRequires();
        if (genericSpecificationArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(genericSpecificationArray.length);
            int n6 = 0;
            while (n6 < genericSpecificationArray.length) {
                this.writeGenericSpecification(genericSpecificationArray[n6], dataOutputStream);
                ++n6;
            }
        }
        GenericDescription[] genericDescriptionArray2 = bundleDescription.getSelectedGenericCapabilities();
        if (genericDescriptionArray2 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(genericDescriptionArray2.length);
            int n7 = 0;
            while (n7 < genericDescriptionArray2.length) {
                this.writeGenericDescription(genericDescriptionArray2[n7], dataOutputStream);
                ++n7;
            }
        }
        GenericDescription[] genericDescriptionArray3 = bundleDescription.getResolvedGenericRequires();
        if (genericDescriptionArray3 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(genericDescriptionArray3.length);
            int n8 = 0;
            while (n8 < genericDescriptionArray3.length) {
                this.writeGenericDescription(genericDescriptionArray3[n8], dataOutputStream);
                ++n8;
            }
        }
        this.writeNativeCode(bundleDescription.getNativeCodeSpecification(), dataOutputStream);
        this.writeMap(dataOutputStream, ((BundleDescriptionImpl)bundleDescription).getWiresInternal());
        ((BundleDescriptionImpl)bundleDescription).setLazyDataSize(dataOutputStream.size() - n);
    }

    private void writeDisabledInfo(DisabledInfo disabledInfo, DataOutputStream dataOutputStream) throws IOException {
        this.writeStringOrNull(disabledInfo.getPolicyName(), dataOutputStream);
        this.writeStringOrNull(disabledInfo.getMessage(), dataOutputStream);
        this.writeBundleDescription(disabledInfo.getBundle(), dataOutputStream, false);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundleSpecificationImpl, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(bundleSpecificationImpl, dataOutputStream)) {
            return;
        }
        this.writeVersionConstraint(bundleSpecificationImpl, dataOutputStream);
        this.writeBundleDescription((BundleDescription)bundleSpecificationImpl.getSupplier(), dataOutputStream, false);
        dataOutputStream.writeBoolean(bundleSpecificationImpl.isExported());
        dataOutputStream.writeBoolean(bundleSpecificationImpl.isOptional());
        this.writeMap(dataOutputStream, bundleSpecificationImpl.getAttributes());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDescriptionImpl, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(exportPackageDescriptionImpl, dataOutputStream)) {
            return;
        }
        this.writeBaseDescription(exportPackageDescriptionImpl, dataOutputStream);
        this.writeBundleDescription(exportPackageDescriptionImpl.getExporter(), dataOutputStream, false);
        this.writeMap(dataOutputStream, exportPackageDescriptionImpl.getAttributes());
        this.writeMap(dataOutputStream, exportPackageDescriptionImpl.getDirectives());
        this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionImpl.getFragmentDeclaration(), dataOutputStream);
    }

    private void writeGenericDescription(GenericDescription genericDescription, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(genericDescription, dataOutputStream)) {
            return;
        }
        this.writeBaseDescription(genericDescription, dataOutputStream);
        this.writeBundleDescription(genericDescription.getSupplier(), dataOutputStream, false);
        this.writeStringOrNull(genericDescription.getType() == "generic" ? null : genericDescription.getType(), dataOutputStream);
        Dictionary<String, Object> dictionary = genericDescription.getAttributes();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(dictionary.size());
        Object object = dictionary.keys();
        while (object.hasMoreElements()) {
            String string = object.nextElement();
            hashMap.put(string, dictionary.get(string));
        }
        this.writeMap(dataOutputStream, hashMap);
        object = genericDescription.getDeclaredDirectives();
        this.writeMap(dataOutputStream, (Map<String, ?>)object);
        this.writeGenericDescription((GenericDescription)((BaseDescriptionImpl)((Object)genericDescription)).getFragmentDeclaration(), dataOutputStream);
    }

    private void writeGenericSpecification(GenericSpecification genericSpecification, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(genericSpecification, dataOutputStream)) {
            return;
        }
        this.writeVersionConstraint(genericSpecification, dataOutputStream);
        this.writeStringOrNull(genericSpecification.getType() == "generic" ? null : genericSpecification.getType(), dataOutputStream);
        GenericDescription[] genericDescriptionArray = genericSpecification.getSuppliers();
        dataOutputStream.writeInt(genericDescriptionArray == null ? 0 : genericDescriptionArray.length);
        if (genericDescriptionArray != null) {
            int n = 0;
            while (n < genericDescriptionArray.length) {
                this.writeGenericDescription(genericDescriptionArray[n], dataOutputStream);
                ++n;
            }
        }
        dataOutputStream.writeInt(genericSpecification.getResolution());
        this.writeStringOrNull(genericSpecification.getMatchingFilter(), dataOutputStream);
    }

    private void writeNativeCode(NativeCodeSpecification nativeCodeSpecification, DataOutputStream dataOutputStream) throws IOException {
        if (nativeCodeSpecification == null) {
            dataOutputStream.writeBoolean(false);
            return;
        }
        dataOutputStream.writeBoolean(true);
        dataOutputStream.writeBoolean(nativeCodeSpecification.isOptional());
        NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
        int n = nativeCodeDescriptionArray == null ? 0 : nativeCodeDescriptionArray.length;
        dataOutputStream.writeInt(n);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if (nativeCodeDescriptionArray[n3] == nativeCodeSpecification.getSupplier()) {
                n2 = n3;
            }
            this.writeNativeCodeDescription(nativeCodeDescriptionArray[n3], dataOutputStream);
            ++n3;
        }
        dataOutputStream.writeInt(n2);
    }

    private void writeNativeCodeDescription(NativeCodeDescription nativeCodeDescription, DataOutputStream dataOutputStream) throws IOException {
        this.writeBaseDescription(nativeCodeDescription, dataOutputStream);
        this.writeBundleDescription(nativeCodeDescription.getSupplier(), dataOutputStream, false);
        Filter filter = nativeCodeDescription.getFilter();
        this.writeStringOrNull(filter == null ? null : filter.toString(), dataOutputStream);
        this.writeStringArray(nativeCodeDescription.getLanguages(), dataOutputStream);
        this.writeStringArray(nativeCodeDescription.getNativePaths(), dataOutputStream);
        this.writeStringArray(nativeCodeDescription.getOSNames(), dataOutputStream);
        this.writeVersionRanges(nativeCodeDescription.getOSVersions(), dataOutputStream);
        this.writeStringArray(nativeCodeDescription.getProcessors(), dataOutputStream);
        dataOutputStream.writeBoolean(nativeCodeDescription.hasInvalidNativePaths());
    }

    private void writeVersionRanges(VersionRange[] versionRangeArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(versionRangeArray == null ? 0 : versionRangeArray.length);
        if (versionRangeArray == null) {
            return;
        }
        int n = 0;
        while (n < versionRangeArray.length) {
            this.writeVersionRange(versionRangeArray[n], dataOutputStream);
            ++n;
        }
    }

    private void writeStringArray(String[] stringArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(stringArray == null ? 0 : stringArray.length);
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.writeStringOrNull(stringArray[n], dataOutputStream);
            ++n;
        }
    }

    private void writeMap(DataOutputStream dataOutputStream, Map<String, ?> map) throws IOException {
        if (map == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(map.size());
            for (String string : map.keySet()) {
                Object obj = map.get(string);
                this.writeStringOrNull(string, dataOutputStream);
                if (obj instanceof String) {
                    dataOutputStream.writeByte(0);
                    this.writeStringOrNull((String)obj, dataOutputStream);
                    continue;
                }
                if (obj instanceof String[]) {
                    dataOutputStream.writeByte(1);
                    this.writeList(dataOutputStream, (String[])obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    dataOutputStream.writeByte(2);
                    dataOutputStream.writeBoolean((Boolean)obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    dataOutputStream.writeByte(3);
                    dataOutputStream.writeInt((Integer)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    dataOutputStream.writeByte(4);
                    dataOutputStream.writeLong((Long)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeDouble((Double)obj);
                    continue;
                }
                if (obj instanceof Version) {
                    dataOutputStream.writeByte(6);
                    this.writeVersion((Version)obj, dataOutputStream);
                    continue;
                }
                if ("java.net.URI".equals(obj.getClass().getName())) {
                    dataOutputStream.writeByte(7);
                    this.writeStringOrNull(obj.toString(), dataOutputStream);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                this.writeList(dataOutputStream, (List)obj);
            }
        }
    }

    private void writeList(DataOutputStream dataOutputStream, List<?> list) throws IOException {
        byte by = this.getListType(list);
        if (by == -2) {
            return;
        }
        dataOutputStream.writeByte(8);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(list.size());
        for (Object obj : list) {
            switch (by) {
                case 0: {
                    this.writeStringOrNull((String)obj, dataOutputStream);
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt((Integer)obj);
                    break;
                }
                case 4: {
                    dataOutputStream.writeLong((Long)obj);
                    break;
                }
                case 5: {
                    dataOutputStream.writeDouble((Double)obj);
                    break;
                }
                case 6: {
                    this.writeVersion((Version)obj, dataOutputStream);
                    break;
                }
                case 7: {
                    this.writeStateWire((StateWire)obj, dataOutputStream);
                }
            }
        }
    }

    private void writeStateWire(StateWire stateWire, DataOutputStream dataOutputStream) throws IOException {
        VersionConstraint versionConstraint = stateWire.getDeclaredRequirement();
        if (versionConstraint instanceof ImportPackageSpecificationImpl) {
            dataOutputStream.writeByte(0);
            this.writeImportPackageSpec((ImportPackageSpecificationImpl)versionConstraint, dataOutputStream);
        } else if (versionConstraint instanceof BundleSpecificationImpl) {
            dataOutputStream.writeByte(1);
            this.writeBundleSpec((BundleSpecificationImpl)versionConstraint, dataOutputStream);
        } else if (versionConstraint instanceof HostSpecificationImpl) {
            dataOutputStream.writeByte(2);
            this.writeHostSpec((HostSpecificationImpl)versionConstraint, dataOutputStream, false);
        } else if (versionConstraint instanceof GenericSpecificationImpl) {
            dataOutputStream.writeByte(3);
            this.writeGenericSpecification((GenericSpecificationImpl)versionConstraint, dataOutputStream);
        } else {
            throw new IllegalArgumentException(new StringBuffer("Unknown requiement type: ").append(versionConstraint.getClass()).toString());
        }
        BaseDescription baseDescription = stateWire.getDeclaredCapability();
        if (baseDescription instanceof BundleDescription) {
            this.writeBundleDescription((BundleDescription)baseDescription, dataOutputStream, false);
        } else if (baseDescription instanceof ExportPackageDescriptionImpl) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)baseDescription, dataOutputStream);
        } else if (baseDescription instanceof GenericDescription) {
            this.writeGenericDescription((GenericDescription)baseDescription, dataOutputStream);
        } else {
            throw new IllegalArgumentException(new StringBuffer("Unknown capability type: ").append(versionConstraint.getClass()).toString());
        }
        this.writeBundleDescription(stateWire.getRequirementHost(), dataOutputStream, false);
        this.writeBundleDescription(stateWire.getCapabilityHost(), dataOutputStream, false);
    }

    private byte getListType(List<?> list) {
        if (list.size() == 0) {
            return -1;
        }
        Object obj = list.get(0);
        if (obj instanceof String) {
            return 0;
        }
        if (obj instanceof Integer) {
            return 3;
        }
        if (obj instanceof Long) {
            return 4;
        }
        if (obj instanceof Double) {
            return 5;
        }
        if (obj instanceof Version) {
            return 6;
        }
        if (obj instanceof StateWire) {
            return 7;
        }
        return -2;
    }

    private void writeList(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
        if (stringArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.writeStringOrNull(stringArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private void writeBaseDescription(BaseDescription baseDescription, DataOutputStream dataOutputStream) throws IOException {
        this.writeStringOrNull(baseDescription.getName(), dataOutputStream);
        this.writeVersion(baseDescription.getVersion(), dataOutputStream);
    }

    private void writeImportPackageSpec(ImportPackageSpecification importPackageSpecification, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(importPackageSpecification, dataOutputStream)) {
            return;
        }
        this.writeVersionConstraint(importPackageSpecification, dataOutputStream);
        if (importPackageSpecification.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpecification.getSupplier(), dataOutputStream);
        } else {
            dataOutputStream.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpecification.getBundleSymbolicName(), dataOutputStream);
        this.writeVersionRange(importPackageSpecification.getBundleVersionRange(), dataOutputStream);
        this.writeMap(dataOutputStream, importPackageSpecification.getAttributes());
        this.writeMap(dataOutputStream, importPackageSpecification.getDirectives());
    }

    private void writeHostSpec(HostSpecificationImpl hostSpecificationImpl, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (hostSpecificationImpl != null && bl && !this.forcedWrite.contains(hostSpecificationImpl)) {
            int n = this.addToObjectTable(hostSpecificationImpl);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(n);
            this.forcedWrite.add(hostSpecificationImpl);
        } else if (this.writePrefix(hostSpecificationImpl, dataOutputStream)) {
            return;
        }
        this.writeVersionConstraint(hostSpecificationImpl, dataOutputStream);
        BundleDescription[] bundleDescriptionArray = hostSpecificationImpl.getHosts();
        if (bundleDescriptionArray == null) {
            dataOutputStream.writeInt(0);
            return;
        }
        dataOutputStream.writeInt(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.writeBundleDescription(bundleDescriptionArray[n], dataOutputStream, bl);
            ++n;
        }
        this.writeMap(dataOutputStream, hostSpecificationImpl.getAttributes());
    }

    private void writeVersionConstraint(VersionConstraint versionConstraint, DataOutputStream dataOutputStream) throws IOException {
        this.writeStringOrNull(versionConstraint.getName(), dataOutputStream);
        this.writeVersionRange(versionConstraint.getVersionRange(), dataOutputStream);
    }

    private void writeVersion(Version version, DataOutputStream dataOutputStream) throws IOException {
        if (version == null || version.equals(Version.emptyVersion)) {
            dataOutputStream.writeByte(0);
            return;
        }
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(version.getMajor());
        dataOutputStream.writeInt(version.getMinor());
        dataOutputStream.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), dataOutputStream);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream dataOutputStream) throws IOException {
        if (versionRange == null || versionRange.equals(VersionRange.emptyRange)) {
            dataOutputStream.writeByte(0);
            return;
        }
        dataOutputStream.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), dataOutputStream);
        dataOutputStream.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), dataOutputStream);
        dataOutputStream.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
            return true;
        }
        int n = this.getFromObjectTable(object);
        if (n == -1) {
            return false;
        }
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n);
        return true;
    }

    public void saveStateDeprecated(StateImpl stateImpl, DataOutputStream dataOutputStream) throws IOException {
        try {
            this.writeStateDeprecated(stateImpl, dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    private void writeStringOrNull(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string);
        }
    }

    private void writeQualifier(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, dataOutputStream);
    }
}

