/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ResolverErrorImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.ResolverHookException;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateImpl
implements State {
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_NL = "osgi.nl";
    private static final String OSGI_ARCH = "osgi.arch";
    public static final String[] PROPS = new String[]{"osgi.os", "osgi.ws", "osgi.nl", "osgi.arch", "org.osgi.framework.system.packages", "org.osgi.framework.system.packages.extra", "osgi.resolverMode", "org.osgi.framework.executionenvironment", "osgi.resolveOptional", "osgi.genericAliases", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.language", "osgi.system.bundle", "org.osgi.framework.system.capabilities", "org.osgi.framework.system.capabilities.extra"};
    private static final DisabledInfo[] EMPTY_DISABLEDINFOS = new DisabledInfo[0];
    private transient Resolver resolver;
    private transient StateDeltaImpl changes;
    private transient boolean resolving = false;
    private transient LinkedList<BundleDescription> removalPendings = new LinkedList();
    private boolean resolved = true;
    private long timeStamp = System.currentTimeMillis();
    private final KeyedHashSet bundleDescriptions = new KeyedHashSet(false);
    private final Map<BundleDescription, List<ResolverError>> resolverErrors = new HashMap<BundleDescription, List<ResolverError>>();
    private StateObjectFactory factory;
    private final KeyedHashSet resolvedBundles = new KeyedHashSet();
    private final Map<BundleDescription, List<DisabledInfo>> disabledBundles = new HashMap<BundleDescription, List<DisabledInfo>>();
    private boolean fullyLoaded = false;
    private boolean dynamicCacheChanged = false;
    private StateReader reader;
    private Dictionary<Object, Object>[] platformProperties = new Dictionary[]{new Hashtable(PROPS.length)};
    private long highestBundleId = -1L;
    private final Set<String> platformPropertyKeys = new HashSet<String>(PROPS.length);
    private ResolverHookFactory hookFactory;
    private ResolverHook hook;
    private boolean developmentMode = false;
    private static long cumulativeTime;
    final Object monitor = new Object();

    protected StateImpl() {
        this.addPlatformPropertyKeys(PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBundle(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            Object object2;
            block12: {
                if (this.basicAddBundle(bundleDescription)) break block12;
                return false;
            }
            String string = bundleDescription.getPlatformFilter();
            if (string != null) {
                try {
                    object2 = FilterImpl.newInstance(string);
                    this.addPlatformPropertyKeys(((FilterImpl)object2).getAttributes());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
            if ((object2 = bundleDescription.getNativeCodeSpecification()) != null) {
                NativeCodeDescription[] nativeCodeDescriptionArray = object2.getPossibleSuppliers();
                int n = 0;
                while (n < nativeCodeDescriptionArray.length) {
                    FilterImpl filterImpl = (FilterImpl)nativeCodeDescriptionArray[n].getFilter();
                    if (filterImpl != null) {
                        this.addPlatformPropertyKeys(filterImpl.getAttributes());
                    }
                    ++n;
                }
            }
            this.resolved = false;
            this.getDelta().recordBundleAdded((BundleDescriptionImpl)bundleDescription);
            if (this.getSystemBundle().equals(bundleDescription.getSymbolicName())) {
                this.resetAllSystemCapabilities();
            }
            if (this.resolver != null) {
                this.resolver.bundleAdded(bundleDescription);
            }
            this.updateTimeStamp();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateBundle(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescriptionImpl bundleDescriptionImpl;
            block17: {
                block16: {
                    block15: {
                        bundleDescriptionImpl = (BundleDescriptionImpl)this.bundleDescriptions.get((BundleDescriptionImpl)bundleDescription);
                        if (bundleDescriptionImpl != null) break block15;
                        return false;
                    }
                    if (this.bundleDescriptions.remove(bundleDescriptionImpl)) break block16;
                    return false;
                }
                this.resolvedBundles.remove(bundleDescriptionImpl);
                List<DisabledInfo> list = this.disabledBundles.remove(bundleDescriptionImpl);
                if (list != null) {
                    ArrayList<DisabledInfo> arrayList = new ArrayList<DisabledInfo>(list.size());
                    for (DisabledInfo disabledInfo : list) {
                        arrayList.add(new DisabledInfo(disabledInfo.getPolicyName(), disabledInfo.getMessage(), bundleDescription));
                    }
                    this.disabledBundles.put(bundleDescription, arrayList);
                }
                bundleDescriptionImpl.setStateBit(4, true);
                if (this.basicAddBundle(bundleDescription)) break block17;
                return false;
            }
            this.resolved = false;
            this.getDelta().recordBundleUpdated((BundleDescriptionImpl)bundleDescription);
            if (this.getSystemBundle().equals(bundleDescription.getSymbolicName())) {
                this.resetAllSystemCapabilities();
            }
            if (this.resolver != null) {
                boolean bl = this.isInUse(bundleDescriptionImpl);
                this.resolver.bundleUpdated(bundleDescription, bundleDescriptionImpl, bl);
                if (bl) {
                    this.getDelta().recordBundleRemovalPending(bundleDescriptionImpl);
                    this.addRemovalPending(bundleDescriptionImpl);
                } else {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(bundleDescriptionImpl);
                        this.resolveBundle(bundleDescriptionImpl, false, null, null, null, null, null, null, null, null);
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }
            this.updateTimeStamp();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription removeBundle(long l) {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescription bundleDescription;
            block4: {
                bundleDescription = this.getBundle(l);
                if (bundleDescription != null && this.removeBundle(bundleDescription)) break block4;
                return null;
            }
            return bundleDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBundle(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            block10: {
                bundleDescription = (BundleDescription)((Object)this.bundleDescriptions.get((KeyedElement)((Object)bundleDescription)));
                if (bundleDescription != null && this.bundleDescriptions.remove((KeyedElement)((Object)bundleDescription))) break block10;
                return false;
            }
            this.resolvedBundles.remove((KeyedElement)((Object)bundleDescription));
            this.disabledBundles.remove(bundleDescription);
            this.resolved = false;
            this.getDelta().recordBundleRemoved((BundleDescriptionImpl)bundleDescription);
            ((BundleDescriptionImpl)bundleDescription).setStateBit(4, true);
            if (this.resolver != null) {
                boolean bl = this.isInUse(bundleDescription);
                this.resolver.bundleRemoved(bundleDescription, bl);
                if (bl) {
                    this.getDelta().recordBundleRemovalPending((BundleDescriptionImpl)bundleDescription);
                    this.addRemovalPending(bundleDescription);
                } else {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(bundleDescription);
                        this.resolveBundle(bundleDescription, false, null, null, null, null, null);
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }
            this.updateTimeStamp();
            return true;
        }
    }

    private boolean isInUse(BundleDescription bundleDescription) {
        Object object = bundleDescription.getUserObject();
        if (object instanceof BundleLoaderProxy) {
            return ((BundleLoaderProxy)object).inUse();
        }
        return bundleDescription.getDependents().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateDelta getChanges() {
        Object object = this.monitor;
        synchronized (object) {
            return this.getDelta();
        }
    }

    private StateDeltaImpl getDelta() {
        if (this.changes == null) {
            this.changes = new StateDeltaImpl(this);
        }
        return this.changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getBundles(String string) {
        Object object = this.monitor;
        synchronized (object) {
            if ("system.bundle".equals(string)) {
                string = this.getSystemBundle();
            }
            ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>();
            Iterator<KeyedElement> iterator = this.bundleDescriptions.iterator();
            while (iterator.hasNext()) {
                BundleDescription bundleDescription = (BundleDescription)((Object)iterator.next());
                if (!string.equals(bundleDescription.getSymbolicName())) continue;
                arrayList.add(bundleDescription);
            }
            return arrayList.toArray(new BundleDescription[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getBundles() {
        Object object = this.monitor;
        synchronized (object) {
            return (BundleDescription[])this.bundleDescriptions.elements(new BundleDescription[this.bundleDescriptions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription getBundle(long l) {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescription bundleDescription = (BundleDescription)((Object)this.bundleDescriptions.getByKey(new Long(l)));
            if (bundleDescription != null) {
                return bundleDescription;
            }
            for (BundleDescription bundleDescription2 : this.removalPendings) {
                if (bundleDescription2.getBundleId() != l) continue;
                return bundleDescription2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription getBundle(String string, Version version) {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescription[] bundleDescriptionArray;
            block14: {
                bundleDescriptionArray = this.getBundles(string);
                if (bundleDescriptionArray.length == 1) {
                    return version == null || bundleDescriptionArray[0].getVersion().equals(version) ? bundleDescriptionArray[0] : null;
                }
                if (bundleDescriptionArray.length != 0) break block14;
                return null;
            }
            BaseDescription baseDescription = null;
            BaseDescription baseDescription2 = null;
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                BundleDescription bundleDescription = bundleDescriptionArray[n];
                BaseDescription baseDescription3 = bundleDescription.isResolved() ? baseDescription2 : baseDescription;
                if (version == null || bundleDescription.getVersion().equals(version)) {
                    if (baseDescription3 != null && (baseDescription3.getVersion().compareTo(bundleDescription.getVersion()) <= 0 || baseDescription3.getBundleId() > bundleDescription.getBundleId())) {
                        if (baseDescription3 == baseDescription2) {
                            baseDescription2 = bundleDescription;
                        } else {
                            baseDescription = bundleDescription;
                        }
                    } else if (bundleDescription.isResolved()) {
                        baseDescription2 = bundleDescription;
                    } else {
                        baseDescription = bundleDescription;
                    }
                }
                ++n;
            }
            if (baseDescription2 != null) {
                return baseDescription2;
            }
            return baseDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeStamp() {
        Object object = this.monitor;
        synchronized (object) {
            return this.timeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.resolved || this.isEmpty();
        }
    }

    @Override
    public void resolveConstraint(VersionConstraint versionConstraint, BaseDescription baseDescription) {
        ((VersionConstraintImpl)versionConstraint).setSupplier(baseDescription);
    }

    @Override
    public void resolveBundle(BundleDescription bundleDescription, boolean bl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray2) {
        this.resolveBundle(bundleDescription, bl, bundleDescriptionArray, exportPackageDescriptionArray, null, bundleDescriptionArray2, exportPackageDescriptionArray2);
    }

    @Override
    public void resolveBundle(BundleDescription bundleDescription, boolean bl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray2, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray3) {
        this.resolveBundle(bundleDescription, bl, bundleDescriptionArray, exportPackageDescriptionArray, exportPackageDescriptionArray2, null, bundleDescriptionArray2, exportPackageDescriptionArray3, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveBundle(BundleDescription bundleDescription, boolean bl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray2, GenericDescription[] genericDescriptionArray, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray3, GenericDescription[] genericDescriptionArray2, Map<String, List<StateWire>> map) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.resolving) {
                throw new IllegalStateException();
            }
            BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescription;
            this.getDelta().recordBundleResolved(bundleDescriptionImpl, bl);
            bundleDescriptionImpl.setLazyLoaded(false);
            bundleDescriptionImpl.setStateBit(1, bl);
            if (bl) {
                this.resolverErrors.remove(bundleDescriptionImpl);
                this.resolvedBundles.add(bundleDescriptionImpl);
            } else {
                this.resolvedBundles.remove(bundleDescriptionImpl);
                bundleDescriptionImpl.removeDependencies();
            }
            if (exportPackageDescriptionArray == null || bundleDescriptionArray2 == null || exportPackageDescriptionArray3 == null) {
                this.unresolveConstraints(bundleDescriptionImpl);
            } else {
                this.resolveConstraints(bundleDescriptionImpl, bundleDescriptionArray, exportPackageDescriptionArray, exportPackageDescriptionArray2, genericDescriptionArray, bundleDescriptionArray2, exportPackageDescriptionArray3, genericDescriptionArray2, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleComplete(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.resolving) {
                throw new IllegalStateException();
            }
            this.getDelta().recordBundleRemovalComplete((BundleDescriptionImpl)bundleDescription);
            this.removalPendings.remove(bundleDescription);
        }
    }

    private void resolveConstraints(BundleDescriptionImpl bundleDescriptionImpl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray2, GenericDescription[] genericDescriptionArray, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray3, GenericDescription[] genericDescriptionArray2, Map<String, List<StateWire>> map) {
        HostSpecificationImpl hostSpecificationImpl = (HostSpecificationImpl)bundleDescriptionImpl.getHost();
        if (hostSpecificationImpl != null && bundleDescriptionArray != null) {
            hostSpecificationImpl.setHosts(bundleDescriptionArray);
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                ((BundleDescriptionImpl)bundleDescriptionArray[n]).addDependency(bundleDescriptionImpl, true);
                this.checkHostForSubstitutedExports((BundleDescriptionImpl)bundleDescriptionArray[n], bundleDescriptionImpl);
                ++n;
            }
        }
        bundleDescriptionImpl.setSelectedExports(exportPackageDescriptionArray);
        bundleDescriptionImpl.setResolvedRequires(bundleDescriptionArray2);
        bundleDescriptionImpl.setResolvedImports(exportPackageDescriptionArray3);
        bundleDescriptionImpl.setSubstitutedExports(exportPackageDescriptionArray2);
        bundleDescriptionImpl.setSelectedCapabilities(genericDescriptionArray);
        bundleDescriptionImpl.setResolvedCapabilities(genericDescriptionArray2);
        bundleDescriptionImpl.setStateWires(map);
        bundleDescriptionImpl.addDependencies(bundleDescriptionArray, true);
        bundleDescriptionImpl.addDependencies(bundleDescriptionArray2, true);
        bundleDescriptionImpl.addDependencies(exportPackageDescriptionArray3, true);
        bundleDescriptionImpl.addDependencies(genericDescriptionArray2, true);
    }

    private void checkHostForSubstitutedExports(BundleDescriptionImpl bundleDescriptionImpl, BundleDescriptionImpl bundleDescriptionImpl2) {
    }

    private void unresolveConstraints(BundleDescriptionImpl bundleDescriptionImpl) {
        HostSpecificationImpl hostSpecificationImpl = (HostSpecificationImpl)bundleDescriptionImpl.getHost();
        if (hostSpecificationImpl != null) {
            hostSpecificationImpl.setHosts(null);
        }
        bundleDescriptionImpl.setSelectedExports(null);
        bundleDescriptionImpl.setResolvedImports(null);
        bundleDescriptionImpl.setResolvedRequires(null);
        bundleDescriptionImpl.setSubstitutedExports(null);
        bundleDescriptionImpl.setSelectedCapabilities(null);
        bundleDescriptionImpl.setResolvedCapabilities(null);
        bundleDescriptionImpl.setStateWires(null);
        bundleDescriptionImpl.clearAddedDynamicImportPackages();
        NativeCodeSpecificationImpl nativeCodeSpecificationImpl = (NativeCodeSpecificationImpl)bundleDescriptionImpl.getNativeCodeSpecification();
        if (nativeCodeSpecificationImpl != null) {
            nativeCodeSpecificationImpl.setSupplier(null);
        }
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescriptionImpl.getImportPackages();
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            ((ImportPackageSpecificationImpl)importPackageSpecificationArray[n]).setSupplier(null);
            ++n;
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescriptionImpl.getRequiredBundles();
        int n2 = 0;
        while (n2 < bundleSpecificationArray.length) {
            ((BundleSpecificationImpl)bundleSpecificationArray[n2]).setSupplier(null);
            ++n2;
        }
        GenericSpecification[] genericSpecificationArray = bundleDescriptionImpl.getGenericRequires();
        if (genericSpecificationArray.length > 0) {
            int n3 = 0;
            while (n3 < genericSpecificationArray.length) {
                ((GenericSpecificationImpl)genericSpecificationArray[n3]).setSupplers(null);
                ++n3;
            }
        }
        bundleDescriptionImpl.removeDependencies();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StateDelta resolve(boolean bl, BundleDescription[] bundleDescriptionArray, BundleDescription[] bundleDescriptionArray2) {
        this.fullyLoad();
        Object object = this.monitor;
        synchronized (object) {
            if (this.resolver == null) {
                throw new IllegalStateException("no resolver set");
            }
            if (this.resolving) {
                throw new IllegalStateException("An attempt to start a nested resolve process has been detected.");
            }
            ResolverHook resolverHook = null;
            try {
                void var10_22;
                Object object2;
                BundleDescription[] bundleDescriptionArray3;
                this.resolving = true;
                long l = 0L;
                if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                    l = System.currentTimeMillis();
                }
                if (!bl) {
                    this.resolved = false;
                    bundleDescriptionArray = this.getBundles();
                    if (this.removalPendings.size() > 0) {
                        bundleDescriptionArray3 = this.internalGetRemovalPending();
                        bundleDescriptionArray = this.mergeBundles(bundleDescriptionArray, bundleDescriptionArray3);
                    }
                    this.flush(bundleDescriptionArray);
                } else {
                    if (this.resolved && bundleDescriptionArray == null) {
                        StateDeltaImpl stateDeltaImpl = new StateDeltaImpl(this);
                        return stateDeltaImpl;
                    }
                    if (this.developmentMode && this.removalPendings.size() > 0) {
                        bundleDescriptionArray3 = this.internalGetRemovalPending();
                        bundleDescriptionArray = this.mergeBundles(bundleDescriptionArray, bundleDescriptionArray3);
                    }
                    if (bundleDescriptionArray == null) {
                        bundleDescriptionArray = this.internalGetRemovalPending();
                    }
                    if (bundleDescriptionArray2 == null) {
                        bundleDescriptionArray3 = new HashSet();
                        Collection<BundleDescription> collection = this.getDependencyClosure(Arrays.asList(bundleDescriptionArray));
                        for (BundleDescription bundleDescription : collection) {
                            Bundle bundle = bundleDescription.getBundle();
                            if (bundle == null || (bundle.getState() & 7) != 0) continue;
                            bundleDescriptionArray3.add(bundleDescription);
                        }
                        bundleDescriptionArray2 = bundleDescriptionArray3.toArray(new BundleDescription[bundleDescriptionArray3.size()]);
                    }
                }
                bundleDescriptionArray3 = new Headers[this.platformProperties.length];
                int n = 0;
                while (n < this.platformProperties.length) {
                    bundleDescriptionArray3[n] = new Headers(this.platformProperties[n].size());
                    Enumeration<Object> enumeration = this.platformProperties[n].keys();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        ((Headers)((Object)bundleDescriptionArray3[n])).put(object2, this.platformProperties[n].get(object2));
                    }
                    ++n;
                }
                ResolverHookFactory resolverHookFactory = this.hookFactory;
                if (resolverHookFactory != null) {
                    Collection<BundleRevision> collection = Collections.unmodifiableCollection(bundleDescriptionArray2 == null ? Collections.EMPTY_LIST : Arrays.asList(bundleDescriptionArray2));
                    resolverHook = this.begin(collection);
                }
                Object var10_20 = null;
                try {
                    this.resolver.resolve(bundleDescriptionArray, (Dictionary<Object, Object>[])bundleDescriptionArray3);
                }
                catch (ResolverHookException resolverHookException) {
                    ResolverHookException resolverHookException2 = resolverHookException;
                    this.resolverErrors.clear();
                }
                this.resolved = this.removalPendings.size() == 0;
                object2 = this.changes == null ? new StateDeltaImpl(this) : this.changes;
                ((StateDeltaImpl)object2).setResolverHookException((ResolverHookException)var10_22);
                this.changes = new StateDeltaImpl(this);
                if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                    long l2 = System.currentTimeMillis() - l;
                    Debug.println(new StringBuffer("Time spent resolving: ").append(l2).toString());
                    FrameworkDebugOptions.getDefault().setOption("org.eclipse.core.runtime.adaptor/resolver/timing/value", Long.toString(cumulativeTime += l2));
                }
                if (((StateDeltaImpl)object2).getChanges().length > 0) {
                    this.updateTimeStamp();
                }
                Object object3 = object2;
                return object3;
            }
            finally {
                if (resolverHook != null) {
                    resolverHook.end();
                }
                this.resolving = false;
            }
        }
    }

    private BundleDescription[] mergeBundles(BundleDescription[] bundleDescriptionArray, BundleDescription[] bundleDescriptionArray2) {
        if (bundleDescriptionArray == null) {
            return bundleDescriptionArray2;
        }
        if (bundleDescriptionArray.length == 0) {
            return bundleDescriptionArray;
        }
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(bundleDescriptionArray.length + bundleDescriptionArray2.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            arrayList.add(bundleDescriptionArray[n]);
            ++n;
        }
        n = 0;
        while (n < bundleDescriptionArray2.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < bundleDescriptionArray.length) {
                if (bundleDescriptionArray2[n] == bundleDescriptionArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                arrayList.add(bundleDescriptionArray2[n]);
            }
            ++n;
        }
        return arrayList.toArray(new BundleDescription[arrayList.size()]);
    }

    private void flush(BundleDescription[] bundleDescriptionArray) {
        this.resolver.flush();
        this.resolved = false;
        this.resolverErrors.clear();
        if (this.resolvedBundles.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.resolveBundle(bundleDescriptionArray[n], false, null, null, null, null, null);
            ++n;
        }
        this.resolvedBundles.clear();
    }

    @Override
    public StateDelta resolve() {
        return this.resolve(true, null, null);
    }

    @Override
    public StateDelta resolve(boolean bl) {
        return this.resolve(bl, null, null);
    }

    @Override
    public StateDelta resolve(BundleDescription[] bundleDescriptionArray) {
        return this.resolve(true, bundleDescriptionArray, null);
    }

    @Override
    public StateDelta resolve(BundleDescription[] bundleDescriptionArray, boolean bl) {
        BundleDescription[] bundleDescriptionArray2 = bl ? bundleDescriptionArray : new BundleDescription[]{};
        BundleDescription[] bundleDescriptionArray3 = bl ? null : bundleDescriptionArray;
        return this.resolve(true, bundleDescriptionArray2, bundleDescriptionArray3);
    }

    @Override
    public void setOverrides(Object object) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResolverHookFactory(ResolverHookFactory resolverHookFactory) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.hookFactory != null) {
                throw new IllegalStateException("Resolver hook factory is already set.");
            }
            this.hookFactory = resolverHookFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolverHook begin(Collection<BundleRevision> collection) {
        ResolverHookFactory resolverHookFactory;
        Object object = this.monitor;
        synchronized (object) {
            resolverHookFactory = this.hookFactory;
        }
        object = resolverHookFactory.begin(collection);
        Object object2 = this.monitor;
        synchronized (object2) {
            this.hook = object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolverHookFactory getResolverHookFactory() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hookFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolverHook getResolverHook() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hook;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getResolvedBundles() {
        Object object = this.monitor;
        synchronized (object) {
            return (BundleDescription[])this.resolvedBundles.elements(new BundleDescription[this.resolvedBundles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundleDescriptions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResolved(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.resolved = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean basicAddBundle(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            block8: {
                StateImpl stateImpl = (StateImpl)bundleDescription.getContainingState();
                if (stateImpl != null && stateImpl != this) {
                    if (stateImpl.removalPendings.contains(bundleDescription)) {
                        throw new IllegalStateException(NLS.bind(StateMsg.BUNDLE_PENDING_REMOVE_STATE, bundleDescription.toString()));
                    }
                    if (stateImpl.getBundle(bundleDescription.getBundleId()) == bundleDescription) {
                        throw new IllegalStateException(NLS.bind(StateMsg.BUNDLE_IN_OTHER_STATE, bundleDescription.toString()));
                    }
                }
                ((BundleDescriptionImpl)bundleDescription).setContainingState(this);
                ((BundleDescriptionImpl)bundleDescription).setStateBit(4, false);
                if (!this.bundleDescriptions.add((BundleDescriptionImpl)bundleDescription)) break block8;
                if (bundleDescription.getBundleId() > this.getHighestBundleId()) {
                    this.highestBundleId = bundleDescription.getBundleId();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResolvedBundle(BundleDescriptionImpl bundleDescriptionImpl) {
        Object object = this.monitor;
        synchronized (object) {
            this.resolvedBundles.add(bundleDescriptionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportPackageDescription[] getExportedPackages() {
        this.fullyLoad();
        Object object = this.monitor;
        synchronized (object) {
            int n;
            ExportPackageDescription[] exportPackageDescriptionArray;
            ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>();
            Iterator<KeyedElement> iterator = this.resolvedBundles.iterator();
            while (iterator.hasNext()) {
                BundleDescription bundleDescription = (BundleDescription)((Object)iterator.next());
                exportPackageDescriptionArray = bundleDescription.getSelectedExports();
                if (exportPackageDescriptionArray == null) continue;
                n = 0;
                while (n < exportPackageDescriptionArray.length) {
                    arrayList.add(exportPackageDescriptionArray[n]);
                    ++n;
                }
            }
            for (BundleDescription bundleDescription : this.removalPendings) {
                exportPackageDescriptionArray = bundleDescription.getSelectedExports();
                if (exportPackageDescriptionArray == null) continue;
                n = 0;
                while (n < exportPackageDescriptionArray.length) {
                    arrayList.add(exportPackageDescriptionArray[n]);
                    ++n;
                }
            }
            return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
        }
    }

    BundleDescription[] getFragments(BundleDescription bundleDescription) {
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>();
        Iterator<KeyedElement> iterator = this.bundleDescriptions.iterator();
        block0: while (iterator.hasNext()) {
            BundleDescription[] bundleDescriptionArray;
            BundleDescription bundleDescription2 = (BundleDescription)((Object)iterator.next());
            HostSpecification hostSpecification = bundleDescription2.getHost();
            if (hostSpecification == null || (bundleDescriptionArray = hostSpecification.getHosts()) == null) continue;
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                if (bundleDescriptionArray[n] == bundleDescription) {
                    arrayList.add(bundleDescription2);
                    continue block0;
                }
                ++n;
            }
        }
        return arrayList.toArray(new BundleDescription[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeStamp(long l) {
        Object object = this.monitor;
        synchronized (object) {
            this.timeStamp = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeStamp() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.getTimeStamp() == Long.MAX_VALUE) {
                this.setTimeStamp(0L);
            }
            this.setTimeStamp(this.getTimeStamp() + 1L);
        }
    }

    @Override
    public StateObjectFactory getFactory() {
        return this.factory;
    }

    void setFactory(StateObjectFactory stateObjectFactory) {
        this.factory = stateObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription getBundleByLocation(String string) {
        Object object = this.monitor;
        synchronized (object) {
            Iterator<KeyedElement> iterator = this.bundleDescriptions.iterator();
            while (iterator.hasNext()) {
                BundleDescription bundleDescription = (BundleDescription)((Object)iterator.next());
                if (!string.equals(bundleDescription.getLocation())) continue;
                return bundleDescription;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resolver getResolver() {
        Object object = this.monitor;
        synchronized (object) {
            return this.resolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResolver(Resolver resolver) {
        Object object;
        if (this.resolver == resolver) {
            return;
        }
        if (this.resolver != null) {
            object = this.resolver;
            this.resolver = null;
            object.setState(null);
        }
        object = this.monitor;
        synchronized (object) {
            this.resolver = resolver;
        }
        if (this.resolver == null) {
            return;
        }
        this.resolver.setState(this);
    }

    @Override
    public boolean setPlatformProperties(Dictionary<?, ?> dictionary) {
        return this.setPlatformProperties(new Dictionary[]{dictionary});
    }

    @Override
    public boolean setPlatformProperties(Dictionary<?, ?>[] dictionaryArray) {
        return this.setPlatformProperties(dictionaryArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean setPlatformProperties(Dictionary<?, ?>[] dictionaryArray, boolean bl) {
        String[] stringArray;
        if (dictionaryArray.length == 0) {
            throw new IllegalArgumentException();
        }
        Dictionary[] dictionaryArray2 = new Dictionary[dictionaryArray.length];
        int n = 0;
        while (n < dictionaryArray.length) {
            dictionaryArray2[n] = new Hashtable(dictionaryArray[n].size());
            Object object = dictionaryArray[n];
            synchronized (object) {
                Enumeration<?> enumeration = dictionaryArray[n].keys();
                while (enumeration.hasMoreElements()) {
                    stringArray = enumeration.nextElement();
                    Object obj = dictionaryArray[n].get(stringArray);
                    dictionaryArray2[n].put(stringArray, obj);
                }
            }
            if (dictionaryArray2[n].get("org.osgi.framework.os.name") == null && dictionaryArray2[n].get(OSGI_OS) != null) {
                dictionaryArray2[n].put("org.osgi.framework.os.name", dictionaryArray2[n].get(OSGI_OS));
            }
            if (dictionaryArray2[n].get("org.osgi.framework.processor") == null && dictionaryArray2[n].get(OSGI_ARCH) != null) {
                dictionaryArray2[n].put("org.osgi.framework.processor", dictionaryArray2[n].get(OSGI_ARCH));
            }
            if (dictionaryArray2[n].get("org.osgi.framework.language") == null && dictionaryArray2[n].get(OSGI_NL) instanceof String) {
                object = (String)dictionaryArray2[n].get(OSGI_NL);
                int n2 = ((String)object).indexOf(95);
                if (n2 >= 0) {
                    object = ((String)object).substring(0, n2);
                }
                dictionaryArray2[n].put("org.osgi.framework.language", object);
            }
            ++n;
        }
        n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.platformProperties.length != dictionaryArray2.length) {
            n = 1;
            bl2 = true;
            bl3 = true;
        } else {
            stringArray = this.getPlatformPropertyKeys();
            int n3 = 0;
            while (n3 < dictionaryArray2.length && n == 0) {
                n |= this.changedProps(this.platformProperties[n3], dictionaryArray2[n3], stringArray);
                if (bl) {
                    bl2 |= this.checkProp(this.platformProperties[n3].get("org.osgi.framework.system.packages"), dictionaryArray2[n3].get("org.osgi.framework.system.packages"));
                    bl2 |= this.checkProp(this.platformProperties[n3].get("org.osgi.framework.system.packages.extra"), dictionaryArray2[n3].get("org.osgi.framework.system.packages.extra"));
                    bl2 |= this.checkProp(this.platformProperties[n3].get("system.bundle"), dictionaryArray2[n3].get("system.bundle"));
                    bl3 |= this.checkProp(this.platformProperties[n3].get("org.osgi.framework.system.capabilities"), dictionaryArray2[n3].get("org.osgi.framework.system.capabilities"));
                    bl3 |= this.checkProp(this.platformProperties[n3].get("org.osgi.framework.system.capabilities.extra"), dictionaryArray2[n3].get("org.osgi.framework.system.capabilities.extra"));
                }
                ++n3;
            }
        }
        this.platformProperties = dictionaryArray2;
        if (bl2) {
            this.resetSystemExports();
        }
        if (bl3) {
            this.resetSystemCapabilities();
        }
        this.developmentMode = this.platformProperties.length == 0 ? false : "development".equals(this.platformProperties[0].get("osgi.resolverMode"));
        return n != 0;
    }

    private void resetAllSystemCapabilities() {
        this.resetSystemExports();
        this.resetSystemCapabilities();
    }

    private void resetSystemExports() {
        BundleDescription[] bundleDescriptionArray = this.getBundles("system.bundle");
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescriptionArray[n];
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionImpl.getExportPackages();
            ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(exportPackageDescriptionArray.length);
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                if ((Integer)exportPackageDescriptionArray[n2].getDirective("x-equinox-ee") < 0) {
                    arrayList.add(exportPackageDescriptionArray[n2]);
                }
                ++n2;
            }
            this.addSystemExports(arrayList);
            bundleDescriptionImpl.setExportPackages(arrayList.toArray(new ExportPackageDescription[arrayList.size()]));
            ++n;
        }
    }

    private void addSystemExports(List<ExportPackageDescription> list) {
        int n = 0;
        while (n < this.platformProperties.length) {
            try {
                this.addSystemExports(list, ManifestElement.parseHeader("Export-Package", (String)this.platformProperties[n].get("org.osgi.framework.system.packages")), n);
                this.addSystemExports(list, ManifestElement.parseHeader("Export-Package", (String)this.platformProperties[n].get("org.osgi.framework.system.packages.extra")), n);
            }
            catch (BundleException bundleException) {}
            ++n;
        }
    }

    private void addSystemExports(List<ExportPackageDescription> list, ManifestElement[] manifestElementArray, int n) {
        if (manifestElementArray == null) {
            return;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = StateBuilder.createExportPackages(manifestElementArray, null, null, 2, false);
        Integer n2 = new Integer(n);
        int n3 = 0;
        while (n3 < exportPackageDescriptionArray.length) {
            ((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n3]).setDirective("x-equinox-ee", n2);
            list.add(exportPackageDescriptionArray[n3]);
            ++n3;
        }
    }

    private void resetSystemCapabilities() {
        BundleDescription[] bundleDescriptionArray = this.getBundles("system.bundle");
        Long l = new Long(1L);
        BundleDescription[] bundleDescriptionArray2 = bundleDescriptionArray;
        int n = bundleDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundleDescription = bundleDescriptionArray2[n2];
            GenericDescription[] genericDescriptionArray = bundleDescription.getGenericCapabilities();
            ArrayList<GenericDescription> arrayList = new ArrayList<GenericDescription>(genericDescriptionArray.length);
            GenericDescription[] genericDescriptionArray2 = genericDescriptionArray;
            int n3 = genericDescriptionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GenericDescription genericDescription = genericDescriptionArray2[n4];
                if (l.equals(genericDescription.getDeclaredAttributes().get("equinox.builtin"))) {
                    arrayList.add(genericDescription);
                }
                ++n4;
            }
            this.addSystemCapabilities(arrayList);
            ((BundleDescriptionImpl)bundleDescription).setGenericCapabilities(arrayList.toArray(new GenericDescription[arrayList.size()]));
            ++n2;
        }
    }

    private void addSystemCapabilities(List<GenericDescription> list) {
        int n = 0;
        while (n < this.platformProperties.length) {
            try {
                this.addSystemCapabilities(list, ManifestElement.parseHeader("Provide-Capability", (String)this.platformProperties[n].get("org.osgi.framework.system.capabilities")));
                this.addSystemCapabilities(list, ManifestElement.parseHeader("Provide-Capability", (String)this.platformProperties[n].get("org.osgi.framework.system.capabilities.extra")));
            }
            catch (BundleException bundleException) {}
            ++n;
        }
    }

    private void addSystemCapabilities(List<GenericDescription> list, ManifestElement[] manifestElementArray) {
        StateBuilder.createOSGiCapabilities(manifestElementArray, list);
    }

    @Override
    public Dictionary[] getPlatformProperties() {
        return this.platformProperties;
    }

    private boolean checkProp(Object object, Object object2) {
        if (object == null && object2 != null || object != null && object2 == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            return true;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            String[] stringArray2 = (String[])object2;
            if (stringArray.length != stringArray2.length) {
                return true;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].equals(stringArray2[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return !object.equals(object2);
    }

    private boolean changedProps(Dictionary<Object, Object> dictionary, Dictionary<Object, Object> dictionary2, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            Object object2 = dictionary.get(stringArray[n]);
            if (this.checkProp(object2, object = dictionary2.get(stringArray[n]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getSystemBundle() {
        String string = null;
        if (this.platformProperties != null && this.platformProperties.length > 0) {
            string = (String)this.platformProperties[0].get("osgi.system.bundle");
        }
        return string != null ? string : Constants.getInternalSymbolicName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getRemovalPending() {
        Object object = this.monitor;
        synchronized (object) {
            return this.removalPendings.toArray(new BundleDescription[this.removalPendings.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemovalPending(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.removalPendings.contains(bundleDescription)) {
                this.removalPendings.addFirst(bundleDescription);
            }
        }
    }

    @Override
    public Collection<BundleDescription> getDependencyClosure(Collection<BundleDescription> collection) {
        BundleDescription[] bundleDescriptionArray = this.getRemovalPending();
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>();
        for (BundleDescription bundleDescription : collection) {
            StateImpl.addDependents(bundleDescription, hashSet, bundleDescriptionArray);
        }
        return hashSet;
    }

    private static void addDependents(BundleDescription bundleDescription, Set<BundleDescription> set, BundleDescription[] bundleDescriptionArray) {
        BundleDescription bundleDescription2;
        BundleDescription[] bundleDescriptionArray2;
        if (set.contains(bundleDescription)) {
            return;
        }
        set.add(bundleDescription);
        BundleDescription[] bundleDescriptionArray3 = bundleDescriptionArray2 = bundleDescription.getDependents();
        int n = bundleDescriptionArray2.length;
        int n2 = 0;
        while (n2 < n) {
            bundleDescription2 = bundleDescriptionArray3[n2];
            StateImpl.addDependents(bundleDescription2, set, bundleDescriptionArray);
            ++n2;
        }
        bundleDescriptionArray3 = bundleDescriptionArray;
        n = bundleDescriptionArray.length;
        n2 = 0;
        while (n2 < n) {
            bundleDescription2 = bundleDescriptionArray3[n2];
            if (bundleDescription2.getBundleId() == bundleDescription.getBundleId()) {
                StateImpl.addDependents(bundleDescription2, set, bundleDescriptionArray);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleDescription[] internalGetRemovalPending() {
        Object object = this.monitor;
        synchronized (object) {
            Iterator iterator = this.removalPendings.iterator();
            BundleDescription[] bundleDescriptionArray = new BundleDescription[this.removalPendings.size()];
            int n = 0;
            while (iterator.hasNext()) {
                bundleDescriptionArray[n++] = this.getBundle(((BundleDescription)iterator.next()).getBundleId());
            }
            return bundleDescriptionArray;
        }
    }

    @Override
    public ExportPackageDescription linkDynamicImport(BundleDescription bundleDescription, String string) {
        if (this.resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescription;
        if (bundleDescriptionImpl.getDynamicStamp(string) == this.getTimeStamp()) {
            return null;
        }
        this.fullyLoad();
        Object object = this.monitor;
        synchronized (object) {
            Collection<BundleRevision> collection;
            block12: {
                ResolverHook resolverHook = null;
                try {
                    Collection<BundleRevision> collection2;
                    this.resolving = true;
                    ResolverHookFactory resolverHookFactory = this.hookFactory;
                    if (resolverHookFactory != null) {
                        collection2 = new ArrayList<BundleDescription>(1);
                        collection2.add(bundleDescription);
                        collection2 = Collections.unmodifiableCollection(collection2);
                        resolverHook = this.begin(collection2);
                    }
                    if ((collection2 = (ExportPackageDescriptionImpl)this.resolver.resolveDynamicImport(bundleDescription, string)) == null) {
                        bundleDescriptionImpl.setDynamicStamp(string, new Long(this.getTimeStamp()));
                    } else {
                        bundleDescriptionImpl.setDynamicStamp(string, null);
                        bundleDescriptionImpl.addDynamicResolvedImport((ExportPackageDescriptionImpl)((Object)collection2));
                    }
                    this.setDynamicCacheChanged(true);
                    collection = collection2;
                    this.resolving = false;
                    if (resolverHook == null) break block12;
                    resolverHook.end();
                }
                catch (Throwable throwable) {
                    this.resolving = false;
                    if (resolverHook != null) {
                        resolverHook.end();
                    }
                    throw throwable;
                }
            }
            return collection;
        }
    }

    @Override
    public void addDynamicImportPackages(BundleDescription bundleDescription, ImportPackageSpecification[] importPackageSpecificationArray) {
        ((BundleDescriptionImpl)bundleDescription).addDynamicImportPackages(importPackageSpecificationArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReader(StateReader stateReader) {
        Object object = this.monitor;
        synchronized (object) {
            this.reader = stateReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StateReader getReader() {
        Object object = this.monitor;
        synchronized (object) {
            return this.reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fullyLoad() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.reader == null) {
                return;
            }
            if (this.fullyLoaded) {
                return;
            }
            if (this.reader.isLazyLoaded()) {
                this.reader.fullyLoad();
            }
            this.fullyLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unloadLazyData(long l) {
        Object object = this.monitor;
        synchronized (object) {
            block7: {
                block6: {
                    if (l == this.getTimeStamp() && !this.dynamicCacheChanged()) break block6;
                    return false;
                }
                if (!this.reader.getAccessedFlag()) break block7;
                this.reader.setAccessedFlag(false);
                return true;
            }
            this.fullyLoaded = false;
            BundleDescription[] bundleDescriptionArray = this.getBundles();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                ((BundleDescriptionImpl)bundleDescriptionArray[n]).unload();
                ++n;
            }
            this.reader.flushLazyObjectCache();
            this.resolver.flush();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportPackageDescription[] getSystemPackages() {
        Object object = this.monitor;
        synchronized (object) {
            ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>();
            BundleDescription[] bundleDescriptionArray = this.getBundles("system.bundle");
            if (bundleDescriptionArray.length > 0) {
                BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescriptionArray[0];
                ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionImpl.getExportPackages();
                int n = 0;
                while (n < exportPackageDescriptionArray.length) {
                    if ((Integer)exportPackageDescriptionArray[n].getDirective("x-equinox-ee") >= 0) {
                        arrayList.add(exportPackageDescriptionArray[n]);
                    }
                    ++n;
                }
            }
            return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inStrictMode() {
        Object object = this.monitor;
        synchronized (object) {
            return "strict".equals(this.getPlatformProperties()[0].get("osgi.resolverMode"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolverError[] getResolverErrors(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (bundleDescription.isResolved()) {
                return new ResolverError[0];
            }
            List<ResolverError> list = this.resolverErrors.get(bundleDescription);
            ResolverError[] resolverErrorArray = list == null ? new ResolverError[]{} : list.toArray(new ResolverError[list.size()]);
            return resolverErrorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResolverError(BundleDescription bundleDescription, int n, String string, VersionConstraint versionConstraint) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.resolving) {
                throw new IllegalStateException();
            }
            List<ResolverError> list = this.resolverErrors.get(bundleDescription);
            if (list == null) {
                list = new ArrayList<ResolverError>(1);
                this.resolverErrors.put(bundleDescription, list);
            }
            list.add(new ResolverErrorImpl((BundleDescriptionImpl)bundleDescription, n, string, versionConstraint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResolverErrors(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.resolving) {
                throw new IllegalStateException();
            }
            this.resolverErrors.remove(bundleDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dynamicCacheChanged() {
        Object object = this.monitor;
        synchronized (object) {
            return this.dynamicCacheChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDynamicCacheChanged(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.dynamicCacheChanged = bl;
        }
    }

    @Override
    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPlatformPropertyKeys(String[] stringArray) {
        Set<String> set = this.platformPropertyKeys;
        synchronized (set) {
            int n = 0;
            while (n < stringArray.length) {
                if (!this.platformPropertyKeys.contains(stringArray[n])) {
                    this.platformPropertyKeys.add(stringArray[n]);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPlatformPropertyKeys() {
        Set<String> set = this.platformPropertyKeys;
        synchronized (set) {
            return this.platformPropertyKeys.toArray(new String[this.platformPropertyKeys.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHighestBundleId() {
        Object object = this.monitor;
        synchronized (object) {
            return this.highestBundleId;
        }
    }

    @Override
    public void setNativePathsInvalid(NativeCodeDescription nativeCodeDescription, boolean bl) {
        ((NativeCodeDescriptionImpl)nativeCodeDescription).setInvalidNativePaths(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getDisabledBundles() {
        Object object = this.monitor;
        synchronized (object) {
            return this.disabledBundles.keySet().toArray(new BundleDescription[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDisabledInfo(DisabledInfo disabledInfo) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.getBundle(disabledInfo.getBundle().getBundleId()) != disabledInfo.getBundle()) {
                throw new IllegalArgumentException(NLS.bind(StateMsg.BUNDLE_NOT_IN_STATE, disabledInfo.getBundle()));
            }
            List<DisabledInfo> list = this.disabledBundles.get(disabledInfo.getBundle());
            if (list == null) {
                list = new ArrayList<DisabledInfo>(1);
                list.add(disabledInfo);
                this.disabledBundles.put(disabledInfo.getBundle(), list);
            } else {
                for (DisabledInfo disabledInfo2 : list) {
                    if (!disabledInfo.getPolicyName().equals(disabledInfo2.getPolicyName())) continue;
                    list.remove(disabledInfo2);
                    break;
                }
                list.add(disabledInfo);
            }
            this.updateTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDisabledInfo(DisabledInfo disabledInfo) {
        Object object = this.monitor;
        synchronized (object) {
            List<DisabledInfo> list = this.disabledBundles.get(disabledInfo.getBundle());
            if (list != null && list.contains(disabledInfo)) {
                list.remove(disabledInfo);
                if (list.isEmpty()) {
                    this.disabledBundles.remove(disabledInfo.getBundle());
                }
            }
            this.updateTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisabledInfo getDisabledInfo(BundleDescription bundleDescription, String string) {
        Object object = this.monitor;
        synchronized (object) {
            List<DisabledInfo> list;
            block5: {
                list = this.disabledBundles.get(bundleDescription);
                if (list != null) break block5;
                return null;
            }
            for (DisabledInfo disabledInfo : list) {
                if (!disabledInfo.getPolicyName().equals(string)) continue;
                return disabledInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisabledInfo[] getDisabledInfos(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            List<DisabledInfo> list = this.disabledBundles.get(bundleDescription);
            return list == null ? EMPTY_DISABLEDINFOS : list.toArray(new DisabledInfo[list.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisabledInfo[] getDisabledInfos() {
        ArrayList arrayList = new ArrayList();
        Object object = this.monitor;
        synchronized (object) {
            Iterator<List<DisabledInfo>> iterator = this.disabledBundles.values().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(iterator.next());
            }
        }
        return arrayList.toArray(new DisabledInfo[arrayList.size()]);
    }
}

