/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDeltaImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverHookException;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;

final class StateDeltaImpl
implements StateDelta {
    private final State state;
    private final Map<BundleDescription, BundleDelta> changes = new HashMap<BundleDescription, BundleDelta>();
    private ResolverHookException error;

    public StateDeltaImpl(State state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDelta[] getChanges() {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            return this.changes.values().toArray(new BundleDelta[this.changes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDelta[] getChanges(int n, boolean bl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            ArrayList<BundleDelta> arrayList = new ArrayList<BundleDelta>();
            Iterator<BundleDelta> iterator = this.changes.values().iterator();
            while (iterator.hasNext()) {
                BundleDelta bundleDelta = iterator.next();
                if (n != bundleDelta.getType() && (bl || (bundleDelta.getType() & n) == 0)) continue;
                arrayList.add(bundleDelta);
            }
            return arrayList.toArray(new BundleDelta[arrayList.size()]);
        }
    }

    public State getState() {
        return this.state;
    }

    public ResolverHookException getResovlerHookException() {
        return this.error;
    }

    void setResolverHookException(ResolverHookException resolverHookException) {
        this.error = resolverHookException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordBundleAdded(BundleDescriptionImpl bundleDescriptionImpl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            BundleDeltaImpl bundleDeltaImpl = (BundleDeltaImpl)this.changes.get(bundleDescriptionImpl);
            if (bundleDeltaImpl == null) {
                this.changes.put(bundleDescriptionImpl, new BundleDeltaImpl(bundleDescriptionImpl, 1));
                return;
            }
            if (bundleDeltaImpl.getType() == 2) {
                this.changes.remove(bundleDescriptionImpl);
                return;
            }
            int n = bundleDeltaImpl.getType();
            if ((n & 2) != 0) {
                n &= 0xFFFFFFFD;
            }
            bundleDeltaImpl.setType(n | 1);
            bundleDeltaImpl.setBundle(bundleDescriptionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordBundleUpdated(BundleDescriptionImpl bundleDescriptionImpl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            BundleDeltaImpl bundleDeltaImpl = (BundleDeltaImpl)this.changes.get(bundleDescriptionImpl);
            if (bundleDeltaImpl == null) {
                this.changes.put(bundleDescriptionImpl, new BundleDeltaImpl(bundleDescriptionImpl, 4));
                return;
            }
            if ((bundleDeltaImpl.getType() & 3) != 0) {
                return;
            }
            bundleDeltaImpl.setType(bundleDeltaImpl.getType() | 4);
            bundleDeltaImpl.setBundle(bundleDescriptionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordBundleRemoved(BundleDescriptionImpl bundleDescriptionImpl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            BundleDeltaImpl bundleDeltaImpl = (BundleDeltaImpl)this.changes.get(bundleDescriptionImpl);
            if (bundleDeltaImpl == null) {
                this.changes.put(bundleDescriptionImpl, new BundleDeltaImpl(bundleDescriptionImpl, 2));
                return;
            }
            if (bundleDeltaImpl.getType() == 1) {
                this.changes.remove(bundleDescriptionImpl);
                return;
            }
            int n = bundleDeltaImpl.getType();
            if ((n & 1) != 0) {
                n &= 0xFFFFFFFE;
            }
            bundleDeltaImpl.setType(n | 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordBundleRemovalPending(BundleDescriptionImpl bundleDescriptionImpl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            BundleDeltaImpl bundleDeltaImpl = (BundleDeltaImpl)this.changes.get(bundleDescriptionImpl);
            if (bundleDeltaImpl == null) {
                this.changes.put(bundleDescriptionImpl, new BundleDeltaImpl(bundleDescriptionImpl, 128));
                return;
            }
            int n = bundleDeltaImpl.getType();
            if ((n & 0x100) != 0) {
                n &= 0xFFFFFEFF;
            }
            bundleDeltaImpl.setType(n | 0x80);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordBundleRemovalComplete(BundleDescriptionImpl bundleDescriptionImpl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            BundleDeltaImpl bundleDeltaImpl = (BundleDeltaImpl)this.changes.get(bundleDescriptionImpl);
            if (bundleDeltaImpl == null) {
                this.changes.put(bundleDescriptionImpl, new BundleDeltaImpl(bundleDescriptionImpl, 256));
                return;
            }
            int n = bundleDeltaImpl.getType();
            if ((n & 0x80) != 0) {
                n &= 0xFFFFFF7F;
            }
            bundleDeltaImpl.setType(n | 0x100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordBundleResolved(BundleDescriptionImpl bundleDescriptionImpl, boolean bl) {
        Map<BundleDescription, BundleDelta> map = this.changes;
        synchronized (map) {
            int n;
            if (bundleDescriptionImpl.isResolved() == bl) {
                return;
            }
            BundleDeltaImpl bundleDeltaImpl = (BundleDeltaImpl)this.changes.get(bundleDescriptionImpl);
            int n2 = n = bl ? 8 : 16;
            if (bundleDeltaImpl == null) {
                bundleDeltaImpl = new BundleDeltaImpl(bundleDescriptionImpl, n);
                this.changes.put(bundleDescriptionImpl, bundleDeltaImpl);
                return;
            }
            bundleDeltaImpl.setType(n |= bundleDeltaImpl.getType() & 0xFFFFFFE7);
            bundleDeltaImpl.setBundle(bundleDescriptionImpl);
        }
    }
}

