/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.Tokenizer;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateBuilder {
    static final String[] DEFINED_PACKAGE_MATCHING_ATTRS = new String[]{"bundle-symbolic-name", "bundle-version", "specification-version", "version"};
    static final String[] DEFINED_BSN_MATCHING_ATTRS = new String[]{"bundle-version", "optional", "reprovide"};
    static final String[] DEFINED_OSGI_VALIDATE_HEADERS = new String[]{"Import-Package", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Bundle-SymbolicName", "Require-Bundle"};
    static final String GENERIC_REQUIRE = "Eclipse-GenericRequire";
    static final String GENERIC_CAPABILITY = "Eclipse-GenericCapability";
    private static final String ATTR_TYPE_STRING = "string";
    private static final String ATTR_TYPE_VERSION = "version";
    private static final String ATTR_TYPE_URI = "uri";
    private static final String ATTR_TYPE_LONG = "long";
    private static final String ATTR_TYPE_DOUBLE = "double";
    private static final String ATTR_TYPE_SET = "set";
    private static final String ATTR_TYPE_LIST = "List";
    private static final String OPTIONAL_ATTR = "optional";
    private static final String MULTIPLE_ATTR = "multiple";
    private static final String TRUE = "true";
    static /* synthetic */ Class class$0;

    static BundleDescription createBundleDescription(StateImpl stateImpl, Dictionary<String, String> dictionary, String string) throws BundleException {
        ManifestElement[] manifestElementArray;
        ManifestElement[] manifestElementArray2;
        ManifestElement[] manifestElementArray3;
        int n;
        BundleDescriptionImpl bundleDescriptionImpl;
        block11: {
            Object object;
            String string2;
            bundleDescriptionImpl = new BundleDescriptionImpl();
            String string3 = dictionary.get("Bundle-ManifestVersion");
            boolean bl = TRUE.equals(dictionary.get("Eclipse-JREBundle"));
            n = 1;
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            if (n >= 2) {
                StateBuilder.validateHeaders(dictionary, bl);
            }
            if ((string2 = dictionary.get("Bundle-SymbolicName")) != null && ((ManifestElement[])(object = ManifestElement.parseHeader("Bundle-SymbolicName", string2))).length > 0) {
                manifestElementArray3 = object[0];
                bundleDescriptionImpl.setSymbolicName(manifestElementArray3.getValue());
                manifestElementArray2 = manifestElementArray3.getDirective("singleton");
                if (manifestElementArray2 == null) {
                    manifestElementArray2 = manifestElementArray3.getAttribute("singleton");
                }
                bundleDescriptionImpl.setStateBit(2, TRUE.equals(manifestElementArray2));
                manifestElementArray = manifestElementArray3.getDirective("fragment-attachment");
                if (manifestElementArray != null) {
                    if (manifestElementArray.equals("resolve-time")) {
                        bundleDescriptionImpl.setStateBit(64, true);
                        bundleDescriptionImpl.setStateBit(128, false);
                    } else if (manifestElementArray.equals("never")) {
                        bundleDescriptionImpl.setStateBit(64, false);
                        bundleDescriptionImpl.setStateBit(128, false);
                    }
                }
                bundleDescriptionImpl.setDirective("mandatory", ManifestElement.getArrayFromList(manifestElementArray3.getDirective("mandatory")));
                bundleDescriptionImpl.setAttributes(StateBuilder.getAttributes((ManifestElement)manifestElementArray3, DEFINED_BSN_MATCHING_ATTRS));
            }
            object = dictionary.get("Bundle-Version");
            try {
                bundleDescriptionImpl.setVersion(object != null ? Version.parseVersion((String)object) : Version.emptyVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (n < 2) break block11;
                manifestElementArray2 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, "Bundle-Version", object);
                throw new BundleException(new StringBuffer(String.valueOf(manifestElementArray2)).append(" : ").append(illegalArgumentException.getMessage()).toString(), 3, illegalArgumentException);
            }
        }
        bundleDescriptionImpl.setLocation(string);
        bundleDescriptionImpl.setPlatformFilter(dictionary.get("Eclipse-PlatformFilter"));
        bundleDescriptionImpl.setExecutionEnvironments(ManifestElement.getArrayFromList(dictionary.get("Bundle-RequiredExecutionEnvironment")));
        manifestElementArray3 = ManifestElement.parseHeader("Fragment-Host", dictionary.get("Fragment-Host"));
        if (manifestElementArray3 != null) {
            bundleDescriptionImpl.setHost(StateBuilder.createHostSpecification(manifestElementArray3[0], stateImpl));
        }
        manifestElementArray2 = ManifestElement.parseHeader("Export-Package", dictionary.get("Export-Package"));
        manifestElementArray = ManifestElement.parseHeader("Provide-Package", dictionary.get("Provide-Package"));
        boolean bl = stateImpl != null && stateImpl.inStrictMode();
        ArrayList<String> arrayList = new ArrayList<String>(manifestElementArray == null ? 0 : manifestElementArray.length);
        bundleDescriptionImpl.setExportPackages(StateBuilder.createExportPackages(manifestElementArray2, manifestElementArray, arrayList, n, bl));
        ManifestElement[] manifestElementArray4 = ManifestElement.parseHeader("Import-Package", dictionary.get("Import-Package"));
        ManifestElement[] manifestElementArray5 = ManifestElement.parseHeader("DynamicImport-Package", dictionary.get("DynamicImport-Package"));
        bundleDescriptionImpl.setImportPackages(StateBuilder.createImportPackages(bundleDescriptionImpl.getExportPackages(), arrayList, manifestElementArray4, manifestElementArray5, n));
        ManifestElement[] manifestElementArray6 = ManifestElement.parseHeader("Require-Bundle", dictionary.get("Require-Bundle"));
        bundleDescriptionImpl.setRequiredBundles(StateBuilder.createRequiredBundles(manifestElementArray6));
        String[][] stringArray = StateBuilder.getGenericAliases(stateImpl);
        ManifestElement[] manifestElementArray7 = StateBuilder.getGenericRequires(dictionary, stringArray);
        ManifestElement[] manifestElementArray8 = ManifestElement.parseHeader("Require-Capability", dictionary.get("Require-Capability"));
        bundleDescriptionImpl.setGenericRequires(StateBuilder.createGenericRequires(manifestElementArray7, manifestElementArray8));
        ManifestElement[] manifestElementArray9 = StateBuilder.getGenericCapabilities(dictionary, stringArray);
        ManifestElement[] manifestElementArray10 = ManifestElement.parseHeader("Provide-Capability", dictionary.get("Provide-Capability"));
        bundleDescriptionImpl.setGenericCapabilities(StateBuilder.createGenericCapabilities(manifestElementArray9, manifestElementArray10));
        ManifestElement[] manifestElementArray11 = ManifestElement.parseHeader("Bundle-NativeCode", dictionary.get("Bundle-NativeCode"));
        bundleDescriptionImpl.setNativeCodeSpecification(StateBuilder.createNativeCode(manifestElementArray11));
        return bundleDescriptionImpl;
    }

    private static ManifestElement[] getGenericRequires(Dictionary<String, String> dictionary, String[][] stringArray) throws BundleException {
        int n;
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader(GENERIC_REQUIRE, dictionary.get(GENERIC_REQUIRE));
        ArrayList<ManifestElement> arrayList = null;
        if (stringArray.length > 0) {
            arrayList = new ArrayList<ManifestElement>(manifestElementArray == null ? 0 : manifestElementArray.length);
            n = 0;
            while (n < stringArray.length) {
                ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader(stringArray[n][1], dictionary.get(stringArray[n][1]));
                if (manifestElementArray2 != null) {
                    int n2 = 0;
                    while (n2 < manifestElementArray2.length) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(manifestElementArray2[n2].getValue()).append(':').append(stringArray[n][2]);
                        String string = manifestElementArray2[n2].getAttribute("selection-filter");
                        if (string != null) {
                            stringBuffer.append("; ").append("selection-filter").append(string).append("=\"").append(string).append("\"");
                        }
                        ManifestElement[] manifestElementArray3 = ManifestElement.parseHeader(stringArray[n][1], stringBuffer.toString());
                        arrayList.add(manifestElementArray3[0]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return manifestElementArray;
        }
        if (manifestElementArray != null) {
            n = 0;
            while (n < manifestElementArray.length) {
                arrayList.add(manifestElementArray[n]);
                ++n;
            }
        }
        return arrayList.toArray(new ManifestElement[arrayList.size()]);
    }

    private static ManifestElement[] getGenericCapabilities(Dictionary<String, String> dictionary, String[][] stringArray) throws BundleException {
        int n;
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader(GENERIC_CAPABILITY, dictionary.get(GENERIC_CAPABILITY));
        ArrayList<ManifestElement> arrayList = null;
        if (stringArray.length > 0) {
            arrayList = new ArrayList<ManifestElement>(manifestElementArray == null ? 0 : manifestElementArray.length);
            n = 0;
            while (n < stringArray.length) {
                ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader(stringArray[n][0], dictionary.get(stringArray[n][0]));
                if (manifestElementArray2 != null) {
                    int n2 = 0;
                    while (n2 < manifestElementArray2.length) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(manifestElementArray2[n2].getValue()).append(':').append(stringArray[n][2]);
                        ManifestElement[] manifestElementArray3 = manifestElementArray2[n2].getKeys();
                        while (manifestElementArray3 != null && manifestElementArray3.hasMoreElements()) {
                            String string = manifestElementArray3.nextElement();
                            stringBuffer.append("; ").append(string).append("=\"").append(manifestElementArray2[n2].getAttribute(string)).append("\"");
                        }
                        manifestElementArray3 = ManifestElement.parseHeader(stringArray[n][0], stringBuffer.toString());
                        arrayList.add(manifestElementArray3[0]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return manifestElementArray;
        }
        if (manifestElementArray != null) {
            n = 0;
            while (n < manifestElementArray.length) {
                arrayList.add(manifestElementArray[n]);
                ++n;
            }
        }
        return arrayList.toArray(new ManifestElement[arrayList.size()]);
    }

    private static String[][] getGenericAliases(StateImpl stateImpl) {
        String string = StateBuilder.getPlatformProperty(stateImpl, "osgi.genericAliases");
        if (string == null) {
            return new String[0][0];
        }
        String[] stringArray = ManifestElement.getArrayFromList(string, ",");
        String[][] stringArray2 = new String[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = ManifestElement.getArrayFromList(stringArray[n], ":");
            ++n;
        }
        return stringArray2;
    }

    private static String getPlatformProperty(StateImpl stateImpl, String string) {
        Dictionary[] dictionaryArray = stateImpl == null ? null : stateImpl.getPlatformProperties();
        return dictionaryArray == null || dictionaryArray.length == 0 ? null : (String)dictionaryArray[0].get(string);
    }

    private static void validateHeaders(Dictionary<String, String> dictionary, boolean bl) throws BundleException {
        int n = 0;
        while (n < DEFINED_OSGI_VALIDATE_HEADERS.length) {
            String string = dictionary.get(DEFINED_OSGI_VALIDATE_HEADERS[n]);
            if (string != null) {
                ManifestElement[] manifestElementArray = ManifestElement.parseHeader(DEFINED_OSGI_VALIDATE_HEADERS[n], string);
                StateBuilder.checkForDuplicateDirectivesAttributes(DEFINED_OSGI_VALIDATE_HEADERS[n], manifestElementArray);
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Import-Package") {
                    StateBuilder.checkImportExportSyntax(DEFINED_OSGI_VALIDATE_HEADERS[n], manifestElementArray, false, false, bl);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "DynamicImport-Package") {
                    StateBuilder.checkImportExportSyntax(DEFINED_OSGI_VALIDATE_HEADERS[n], manifestElementArray, false, true, bl);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Export-Package") {
                    StateBuilder.checkImportExportSyntax(DEFINED_OSGI_VALIDATE_HEADERS[n], manifestElementArray, true, false, bl);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Fragment-Host") {
                    StateBuilder.checkExtensionBundle(DEFINED_OSGI_VALIDATE_HEADERS[n], manifestElementArray);
                }
            } else if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Bundle-SymbolicName") {
                throw new BundleException(NLS.bind(StateMsg.HEADER_REQUIRED, "Bundle-SymbolicName"), 3);
            }
            ++n;
        }
    }

    private static BundleSpecification[] createRequiredBundles(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            return null;
        }
        BundleSpecification[] bundleSpecificationArray = new BundleSpecification[manifestElementArray.length];
        int n = 0;
        while (n < manifestElementArray.length) {
            bundleSpecificationArray[n] = StateBuilder.createRequiredBundle(manifestElementArray[n]);
            ++n;
        }
        return bundleSpecificationArray;
    }

    private static BundleSpecification createRequiredBundle(ManifestElement manifestElement) {
        BundleSpecificationImpl bundleSpecificationImpl = new BundleSpecificationImpl();
        bundleSpecificationImpl.setName(manifestElement.getValue());
        bundleSpecificationImpl.setVersionRange(StateBuilder.getVersionRange(manifestElement.getAttribute("bundle-version")));
        bundleSpecificationImpl.setExported("reexport".equals(manifestElement.getDirective("visibility")) || TRUE.equals(manifestElement.getAttribute("reprovide")));
        bundleSpecificationImpl.setOptional(OPTIONAL_ATTR.equals(manifestElement.getDirective("resolution")) || TRUE.equals(manifestElement.getAttribute(OPTIONAL_ATTR)));
        bundleSpecificationImpl.setAttributes(StateBuilder.getAttributes(manifestElement, DEFINED_BSN_MATCHING_ATTRS));
        return bundleSpecificationImpl;
    }

    private static ImportPackageSpecification[] createImportPackages(ExportPackageDescription[] exportPackageDescriptionArray, List<String> list, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, int n) {
        int n2;
        ArrayList<ImportPackageSpecification> arrayList = null;
        if (n < 2) {
            if (exportPackageDescriptionArray.length == 0 && manifestElementArray == null && manifestElementArray2 == null) {
                return null;
            }
            arrayList = new ArrayList(exportPackageDescriptionArray.length + (manifestElementArray == null ? 0 : manifestElementArray.length));
            n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                if (!list.contains(exportPackageDescriptionArray[n2].getName())) {
                    ImportPackageSpecificationImpl importPackageSpecificationImpl = new ImportPackageSpecificationImpl();
                    importPackageSpecificationImpl.setName(exportPackageDescriptionArray[n2].getName());
                    importPackageSpecificationImpl.setVersionRange(StateBuilder.getVersionRange(exportPackageDescriptionArray[n2].getVersion().toString()));
                    importPackageSpecificationImpl.setDirective("resolution", "static");
                    arrayList.add(importPackageSpecificationImpl);
                }
                ++n2;
            }
        } else {
            arrayList = new ArrayList<ImportPackageSpecification>(manifestElementArray == null ? 0 : manifestElementArray.length);
        }
        if (manifestElementArray2 != null) {
            n2 = 0;
            while (n2 < manifestElementArray2.length) {
                StateBuilder.addImportPackages(manifestElementArray2[n2], arrayList, n, true);
                ++n2;
            }
        }
        if (manifestElementArray != null) {
            n2 = 0;
            while (n2 < manifestElementArray.length) {
                StateBuilder.addImportPackages(manifestElementArray[n2], arrayList, n, false);
                ++n2;
            }
        }
        return arrayList.toArray(new ImportPackageSpecification[arrayList.size()]);
    }

    public static void addImportPackages(ManifestElement manifestElement, List<ImportPackageSpecification> list, int n, boolean bl) {
        String[] stringArray = manifestElement.getValueComponents();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object;
            if (n < 2) {
                object = list.iterator();
                while (object.hasNext()) {
                    if (!stringArray[n2].equals(((ImportPackageSpecification)object.next()).getName())) continue;
                    object.remove();
                }
            }
            object = new ImportPackageSpecificationImpl();
            ((VersionConstraintImpl)object).setName(stringArray[n2]);
            String string = manifestElement.getAttribute(ATTR_TYPE_VERSION);
            if (string == null) {
                string = manifestElement.getAttribute("specification-version");
            }
            ((VersionConstraintImpl)object).setVersionRange(StateBuilder.getVersionRange(string));
            ((ImportPackageSpecificationImpl)object).setBundleSymbolicName(manifestElement.getAttribute("bundle-symbolic-name"));
            ((ImportPackageSpecificationImpl)object).setBundleVersionRange(StateBuilder.getVersionRange(manifestElement.getAttribute("bundle-version")));
            if (n >= 2) {
                ((ImportPackageSpecificationImpl)object).setAttributes(StateBuilder.getAttributes(manifestElement, DEFINED_PACKAGE_MATCHING_ATTRS));
            }
            if (bl) {
                ((ImportPackageSpecificationImpl)object).setDirective("resolution", "dynamic");
            } else {
                ((ImportPackageSpecificationImpl)object).setDirective("resolution", StateBuilder.getResolution(manifestElement.getDirective("resolution")));
            }
            list.add((ImportPackageSpecification)object);
            ++n2;
        }
    }

    private static String getResolution(String string) {
        String string2 = "static";
        if (OPTIONAL_ATTR.equals(string)) {
            string2 = OPTIONAL_ATTR;
        }
        return string2;
    }

    static ExportPackageDescription[] createExportPackages(ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, List<String> list, int n, boolean bl) {
        int n2 = (manifestElementArray == null ? 0 : manifestElementArray.length) + (manifestElementArray2 == null ? 0 : manifestElementArray2.length);
        if (n2 == 0) {
            return null;
        }
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(n2);
        if (manifestElementArray != null) {
            int n3 = 0;
            while (n3 < manifestElementArray.length) {
                StateBuilder.addExportPackages(manifestElementArray[n3], arrayList, n, bl);
                ++n3;
            }
        }
        if (manifestElementArray2 != null) {
            StateBuilder.addProvidePackages(manifestElementArray2, arrayList, list);
        }
        return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
    }

    private static void addExportPackages(ManifestElement manifestElement, List<ExportPackageDescription> list, int n, boolean bl) {
        String[] stringArray = manifestElement.getValueComponents();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!bl || !TRUE.equals(manifestElement.getDirective("x-internal"))) {
                ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
                exportPackageDescriptionImpl.setName(stringArray[n2]);
                String string = manifestElement.getAttribute(ATTR_TYPE_VERSION);
                if (string == null) {
                    string = manifestElement.getAttribute("specification-version");
                }
                if (string != null) {
                    exportPackageDescriptionImpl.setVersion(Version.parseVersion(string));
                }
                exportPackageDescriptionImpl.setDirective("uses", ManifestElement.getArrayFromList(manifestElement.getDirective("uses")));
                exportPackageDescriptionImpl.setDirective("include", manifestElement.getDirective("include"));
                exportPackageDescriptionImpl.setDirective("exclude", manifestElement.getDirective("exclude"));
                exportPackageDescriptionImpl.setDirective("x-friends", ManifestElement.getArrayFromList(manifestElement.getDirective("x-friends")));
                exportPackageDescriptionImpl.setDirective("x-internal", Boolean.valueOf(manifestElement.getDirective("x-internal")));
                exportPackageDescriptionImpl.setDirective("mandatory", ManifestElement.getArrayFromList(manifestElement.getDirective("mandatory")));
                exportPackageDescriptionImpl.setAttributes(StateBuilder.getAttributes(manifestElement, DEFINED_PACKAGE_MATCHING_ATTRS));
                list.add(exportPackageDescriptionImpl);
            }
            ++n2;
        }
    }

    private static void addProvidePackages(ManifestElement[] manifestElementArray, List<ExportPackageDescription> list, List<String> list2) {
        ExportPackageDescription[] exportPackageDescriptionArray = list.toArray(new ExportPackageDescription[list.size()]);
        int n = 0;
        while (n < manifestElementArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                if (manifestElementArray[n].getValue().equals(exportPackageDescriptionArray[n2].getName())) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
                exportPackageDescriptionImpl.setName(manifestElementArray[n].getValue());
                list.add(exportPackageDescriptionImpl);
            }
            list2.add(manifestElementArray[n].getValue());
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, Object> getAttributes(ManifestElement var0, String[] var1_1) {
        var2_2 = var0.getKeys();
        var3_3 = null;
        if (var2_2 != null) ** GOTO lbl25
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = false;
            var5_5 = var2_2.nextElement();
            var6_7 = 0;
            while (var6_7 < var1_1.length) {
                if (var1_1[var6_7].equals(var5_5)) {
                    var4_4 = true;
                    break;
                }
                ++var6_7;
            }
            var6_6 = var0.getAttribute(var5_5);
            var7_8 = var5_5.indexOf(58);
            var8_9 = "string";
            if (var7_8 > 0) {
                var8_9 = var5_5.substring(var7_8 + 1).trim();
                var5_5 = var5_5.substring(0, var7_8).trim();
            }
            if (var4_4) continue;
            if (var3_3 == null) {
                var3_3 = new HashMap<String, Object>();
            }
            var3_3.put(var5_5, StateBuilder.convertValue(var8_9, var6_6));
lbl25:
            // 3 sources

            ** while (var2_2.hasMoreElements())
        }
lbl26:
        // 1 sources

        return var3_3;
    }

    private static Object convertValue(String string, String string2) {
        if (ATTR_TYPE_STRING.equalsIgnoreCase(string)) {
            return string2;
        }
        String string3 = string2.trim();
        if (ATTR_TYPE_DOUBLE.equalsIgnoreCase(string)) {
            return new Double(string3);
        }
        if (ATTR_TYPE_LONG.equalsIgnoreCase(string)) {
            return new Long(string3);
        }
        if (ATTR_TYPE_URI.equalsIgnoreCase(string)) {
            try {
                Class<?> clazz = Class.forName("java.net.URI");
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Constructor<?> constructor = clazz.getConstructor(classArray);
                return constructor.newInstance(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return string2;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        if (ATTR_TYPE_VERSION.equalsIgnoreCase(string)) {
            return new Version(string3);
        }
        if (ATTR_TYPE_SET.equalsIgnoreCase(string)) {
            return ManifestElement.getArrayFromList(string3, ",");
        }
        Tokenizer tokenizer = new Tokenizer(string);
        String string4 = tokenizer.getToken("<");
        if (!ATTR_TYPE_LIST.equalsIgnoreCase(string4)) {
            throw new RuntimeException(new StringBuffer("Unsupported type: ").append(string).toString());
        }
        char c = tokenizer.getChar();
        String string5 = ATTR_TYPE_STRING;
        if (c == '<') {
            string5 = tokenizer.getToken(">");
            if (tokenizer.getChar() != '>') {
                throw new RuntimeException(new StringBuffer("Invalid type, missing ending '>' : ").append(string).toString());
            }
        }
        List<String> list = new Tokenizer(string2).getEscapedTokens(",");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string6 : list) {
            arrayList.add(StateBuilder.convertValue(string5, string6));
        }
        return arrayList;
    }

    private static HostSpecification createHostSpecification(ManifestElement manifestElement, StateImpl stateImpl) {
        if (manifestElement == null) {
            return null;
        }
        HostSpecificationImpl hostSpecificationImpl = new HostSpecificationImpl();
        hostSpecificationImpl.setName(manifestElement.getValue());
        hostSpecificationImpl.setVersionRange(StateBuilder.getVersionRange(manifestElement.getAttribute("bundle-version")));
        String string = manifestElement.getDirective("multiple-hosts");
        if (string == null) {
            string = StateBuilder.getPlatformProperty(stateImpl, "osgi.support.multipleHosts");
        }
        hostSpecificationImpl.setIsMultiHost(TRUE.equals(string));
        hostSpecificationImpl.setAttributes(StateBuilder.getAttributes(manifestElement, DEFINED_BSN_MATCHING_ATTRS));
        return hostSpecificationImpl;
    }

    private static GenericSpecification[] createGenericRequires(ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2) throws BundleException {
        List<GenericSpecification> list = StateBuilder.createEquinoxRequires(manifestElementArray);
        return (list = StateBuilder.createOSGiRequires(manifestElementArray2, list)) == null ? null : list.toArray(new GenericSpecification[list.size()]);
    }

    private static List<GenericSpecification> createOSGiRequires(ManifestElement[] manifestElementArray, List<GenericSpecification> list) throws BundleException {
        if (manifestElementArray == null) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<GenericSpecification>();
        }
        ManifestElement[] manifestElementArray2 = manifestElementArray;
        int n = manifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray;
            ManifestElement manifestElement = manifestElementArray2[n2];
            String[] stringArray2 = stringArray = manifestElement.getValueComponents();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object object;
                String string = stringArray2[n4];
                String string2 = manifestElement.getDirective("effective");
                if (string2 != null && !"resolve".equals(string2)) break;
                GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
                genericSpecificationImpl.setType(string);
                String string3 = manifestElement.getDirective("filter");
                if (string3 != null) {
                    String string4;
                    try {
                        object = FilterImpl.newInstance(string3);
                        genericSpecificationImpl.setMatchingFilter((Filter)object);
                        string4 = ((FilterImpl)object).getPrimaryKeyValue(string);
                        if (string4 != null) {
                            genericSpecificationImpl.setName(string4);
                        }
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        string4 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, "Require-Capability", manifestElement.toString());
                        throw new BundleException(new StringBuffer(String.valueOf(string4)).append(" : filter").toString(), 3, invalidSyntaxException);
                    }
                }
                if (OPTIONAL_ATTR.equals(object = manifestElement.getDirective("resolution"))) {
                    genericSpecificationImpl.setResolution(1);
                }
                list.add(genericSpecificationImpl);
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    private static List<GenericSpecification> createEquinoxRequires(ManifestElement[] manifestElementArray) throws BundleException {
        if (manifestElementArray == null) {
            return null;
        }
        ArrayList<GenericSpecification> arrayList = new ArrayList<GenericSpecification>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            String[] stringArray = manifestElementArray[n].getValueComponents();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string;
                GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
                int n3 = stringArray[n2].indexOf(58);
                if (n3 > 0) {
                    genericSpecificationImpl.setName(stringArray[n2].substring(0, n3));
                    genericSpecificationImpl.setType(stringArray[n2].substring(n3 + 1));
                } else {
                    genericSpecificationImpl.setName(stringArray[n2]);
                }
                try {
                    genericSpecificationImpl.setMatchingFilter(manifestElementArray[n].getAttribute("selection-filter"), true);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    string = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, GENERIC_REQUIRE, manifestElementArray[n].toString());
                    throw new BundleException(new StringBuffer(String.valueOf(string)).append(" : ").append("selection-filter").toString(), 3, invalidSyntaxException);
                }
                String string2 = manifestElementArray[n].getAttribute(OPTIONAL_ATTR);
                string = manifestElementArray[n].getAttribute(MULTIPLE_ATTR);
                int n4 = 0;
                if (TRUE.equals(string2)) {
                    n4 |= 1;
                }
                if (TRUE.equals(string)) {
                    n4 |= 2;
                }
                genericSpecificationImpl.setResolution(n4);
                arrayList.add(genericSpecificationImpl);
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static GenericDescription[] createGenericCapabilities(ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2) {
        List<GenericDescription> list = StateBuilder.createEquinoxCapabilities(manifestElementArray);
        return (list = StateBuilder.createOSGiCapabilities(manifestElementArray2, list)) == null ? null : list.toArray(new GenericDescription[list.size()]);
    }

    static List<GenericDescription> createOSGiCapabilities(ManifestElement[] manifestElementArray, List<GenericDescription> list) {
        if (manifestElementArray == null) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<GenericDescription>(manifestElementArray.length);
        }
        ManifestElement[] manifestElementArray2 = manifestElementArray;
        int n = manifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray;
            ManifestElement manifestElement = manifestElementArray2[n2];
            String[] stringArray2 = stringArray = manifestElement.getValueComponents();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray2[n4];
                String string2 = manifestElement.getDirective("effective");
                if (string2 != null && !"resolve".equals(string2)) break;
                GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
                genericDescriptionImpl.setType(string);
                Map<String, Object> map = StateBuilder.getAttributes(manifestElement, new String[0]);
                Hashtable<String, Object> hashtable = map == null ? new Hashtable<String, Object>() : new Hashtable<String, Object>(map);
                genericDescriptionImpl.setAttributes(hashtable);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Enumeration<String> enumeration = manifestElement.getDirectiveKeys();
                if (enumeration != null) {
                    enumeration = manifestElement.getDirectiveKeys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = enumeration.nextElement();
                        hashMap.put(string3, manifestElement.getDirective(string3));
                    }
                }
                genericDescriptionImpl.setDirectives(hashMap);
                list.add(genericDescriptionImpl);
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    private static List<GenericDescription> createEquinoxCapabilities(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            return null;
        }
        ArrayList<GenericDescription> arrayList = new ArrayList<GenericDescription>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            String[] stringArray = manifestElementArray[n].getValueComponents();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Map<String, Object> map;
                GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
                String string = stringArray[n2];
                int n3 = stringArray[n2].indexOf(58);
                if (n3 > 0) {
                    string = stringArray[n2].substring(0, n3);
                    genericDescriptionImpl.setType(stringArray[n2].substring(n3 + 1));
                }
                Hashtable<String, Object> hashtable = (map = StateBuilder.getAttributes(manifestElementArray[n], new String[]{ATTR_TYPE_VERSION})) == null ? new Hashtable<String, Object>() : new Hashtable<String, Object>(map);
                ((Dictionary)hashtable).put(genericDescriptionImpl.getType(), string);
                String string2 = manifestElementArray[n].getAttribute(ATTR_TYPE_VERSION);
                if (string2 != null) {
                    ((Dictionary)hashtable).put(ATTR_TYPE_VERSION, Version.parseVersion(string2));
                }
                genericDescriptionImpl.setAttributes(hashtable);
                arrayList.add(genericDescriptionImpl);
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static NativeCodeSpecification createNativeCode(ManifestElement[] manifestElementArray) throws BundleException {
        if (manifestElementArray == null) {
            return null;
        }
        NativeCodeSpecificationImpl nativeCodeSpecificationImpl = new NativeCodeSpecificationImpl();
        nativeCodeSpecificationImpl.setName("Bundle-NativeCode");
        int n = manifestElementArray.length;
        if (n > 0 && manifestElementArray[n - 1].getValue().equals("*")) {
            nativeCodeSpecificationImpl.setOptional(true);
            --n;
        }
        NativeCodeDescription[] nativeCodeDescriptionArray = new NativeCodeDescriptionImpl[n];
        int n2 = 0;
        while (n2 < n) {
            nativeCodeDescriptionArray[n2] = StateBuilder.createNativeCodeDescription(manifestElementArray[n2]);
            ++n2;
        }
        nativeCodeSpecificationImpl.setPossibleSuppliers(nativeCodeDescriptionArray);
        return nativeCodeSpecificationImpl;
    }

    private static NativeCodeDescriptionImpl createNativeCodeDescription(ManifestElement manifestElement) throws BundleException {
        NativeCodeDescriptionImpl nativeCodeDescriptionImpl = new NativeCodeDescriptionImpl();
        nativeCodeDescriptionImpl.setName("Bundle-NativeCode");
        nativeCodeDescriptionImpl.setNativePaths(manifestElement.getValueComponents());
        nativeCodeDescriptionImpl.setOSNames(manifestElement.getAttributes("osname"));
        nativeCodeDescriptionImpl.setProcessors(manifestElement.getAttributes("processor"));
        nativeCodeDescriptionImpl.setOSVersions(StateBuilder.createVersionRanges(manifestElement.getAttributes("osversion")));
        nativeCodeDescriptionImpl.setLanguages(manifestElement.getAttributes("language"));
        try {
            nativeCodeDescriptionImpl.setFilter(manifestElement.getAttribute("selection-filter"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            String string = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, "Bundle-NativeCode", manifestElement.toString());
            throw new BundleException(new StringBuffer(String.valueOf(string)).append(" : ").append("selection-filter").toString(), 3, invalidSyntaxException);
        }
        return nativeCodeDescriptionImpl;
    }

    private static VersionRange[] createVersionRanges(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        VersionRange[] versionRangeArray = new VersionRange[stringArray.length];
        int n = 0;
        while (n < versionRangeArray.length) {
            versionRangeArray[n] = new VersionRange(stringArray[n]);
            ++n;
        }
        return versionRangeArray;
    }

    private static VersionRange getVersionRange(String string) {
        if (string == null) {
            return null;
        }
        return new VersionRange(string);
    }

    public static void checkImportExportSyntax(String string, ManifestElement[] manifestElementArray, boolean bl, boolean bl2, boolean bl3) throws BundleException {
        if (manifestElementArray == null) {
            return;
        }
        int n = manifestElementArray.length;
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String[] stringArray = manifestElementArray[n2].getValueComponents();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!bl && !bl2 && hashSet.contains(stringArray[n3])) {
                    string2 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[n2].toString());
                    throw new BundleException(new StringBuffer(String.valueOf(string2)).append(" : ").append(NLS.bind(StateMsg.HEADER_PACKAGE_DUPLICATES, stringArray[n3])).toString(), 3);
                }
                if (!bl3 && stringArray[n3].startsWith("java.")) {
                    string2 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[n2].toString());
                    throw new BundleException(new StringBuffer(String.valueOf(string2)).append(" : ").append(NLS.bind(StateMsg.HEADER_PACKAGE_JAVA, stringArray[n3])).toString(), 3);
                }
                hashSet.add(stringArray[n3]);
                ++n3;
            }
            String string3 = manifestElementArray[n2].getAttribute(ATTR_TYPE_VERSION);
            if (string3 != null && (string2 = manifestElementArray[n2].getAttribute("specification-version")) != null && !string2.equals(string3)) {
                throw new BundleException(NLS.bind(StateMsg.HEADER_VERSION_ERROR, ATTR_TYPE_VERSION, "specification-version"), 3);
            }
            if (bl) {
                if (manifestElementArray[n2].getAttribute("bundle-symbolic-name") != null) {
                    string2 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[n2].toString());
                    throw new BundleException(new StringBuffer(String.valueOf(string2)).append(" : ").append(NLS.bind(StateMsg.HEADER_EXPORT_ATTR_ERROR, "bundle-symbolic-name", "Export-Package")).toString(), 3);
                }
                if (manifestElementArray[n2].getAttribute("bundle-version") != null) {
                    string2 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[n2].toString());
                    throw new BundleException(NLS.bind(new StringBuffer(String.valueOf(string2)).append(" : ").append(StateMsg.HEADER_EXPORT_ATTR_ERROR).toString(), "bundle-version", "Export-Package"), 3);
                }
            }
            ++n2;
        }
    }

    private static void checkForDuplicateDirectivesAttributes(String string, ManifestElement[] manifestElementArray) throws BundleException {
        int n = 0;
        while (n < manifestElementArray.length) {
            Object object;
            Object object2;
            Object object3;
            Enumeration<String> enumeration = manifestElementArray[n].getDirectiveKeys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    object3 = enumeration.nextElement();
                    object2 = manifestElementArray[n].getDirectives((String)object3);
                    if (((String[])object2).length <= 1) continue;
                    object = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[n].toString());
                    throw new BundleException(NLS.bind(new StringBuffer(String.valueOf(object)).append(" : ").append(StateMsg.HEADER_DIRECTIVE_DUPLICATES).toString(), object3), 3);
                }
            }
            if ((object3 = manifestElementArray[n].getKeys()) != null) {
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    object = manifestElementArray[n].getAttributes((String)object2);
                    if (((String[])object).length <= 1) continue;
                    String string2 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[n].toString());
                    throw new BundleException(new StringBuffer(String.valueOf(string2)).append(" : ").append(NLS.bind(StateMsg.HEADER_ATTRIBUTE_DUPLICATES, object2)).toString(), 3);
                }
            }
            ++n;
        }
    }

    private static void checkExtensionBundle(String string, ManifestElement[] manifestElementArray) throws BundleException {
        if (manifestElementArray.length == 0 || manifestElementArray[0].getDirective("extension") == null) {
            return;
        }
        String string2 = manifestElementArray[0].getValue();
        if (!string2.equals("system.bundle") && !string2.equals(Constants.getInternalSymbolicName())) {
            String string3 = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, string, manifestElementArray[0].toString());
            throw new BundleException(new StringBuffer(String.valueOf(string3)).append(" : ").append(NLS.bind(StateMsg.HEADER_EXTENSION_ERROR, string2)).toString(), 3);
        }
    }
}

