/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;

class ImportsHolder {
    private final ImportPackageSpecification[] importedPackages;
    private final ExportPackageDescription[] resolvedImports;
    private final boolean isUsingResolved;

    ImportsHolder(BundleDescription bundleDescription, int n) {
        boolean bl = this.isUsingResolved = (n & 2) != 0;
        if (this.isUsingResolved) {
            this.importedPackages = null;
            this.resolvedImports = bundleDescription.getResolvedImports();
        } else {
            this.importedPackages = bundleDescription.getImportPackages();
            this.resolvedImports = null;
        }
    }

    ExportPackageDescription getSupplier(int n) {
        if (this.isUsingResolved) {
            return this.resolvedImports[n];
        }
        return (ExportPackageDescription)this.importedPackages[n].getSupplier();
    }

    String getName(int n) {
        if (this.isUsingResolved) {
            return this.resolvedImports[n].getName();
        }
        return this.importedPackages[n].getName();
    }

    int getSize() {
        if (this.isUsingResolved) {
            return this.resolvedImports.length;
        }
        return this.importedPackages.length;
    }
}

