/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSpecificationImpl
extends VersionConstraintImpl
implements GenericSpecification {
    private Filter matchingFilter;
    private String type = "generic";
    private int resolution = 0;
    private GenericDescription[] suppliers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMatchingFilter() {
        Object object = this.monitor;
        synchronized (object) {
            return this.matchingFilter == null ? null : this.matchingFilter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMatchingFilter(String string, boolean bl) throws InvalidSyntaxException {
        Object object = this.monitor;
        synchronized (object) {
            String string2 = this.getName();
            if (bl && string2 != null && !"*".equals(string2)) {
                String string3 = new StringBuffer("(").append(this.getType()).append("=").append(this.getName()).append(")").toString();
                string = string == null ? string3 : new StringBuffer("(&").append(string3).append(string).append(")").toString();
            }
            this.matchingFilter = string == null ? null : FilterImpl.newInstance(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMatchingFilter(Filter filter) {
        Object object = this.monitor;
        synchronized (object) {
            this.matchingFilter = filter;
        }
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        if (!(baseDescription instanceof GenericDescription)) {
            return false;
        }
        GenericDescription genericDescription = (GenericDescription)baseDescription;
        if (!this.getType().equals(genericDescription.getType())) {
            return false;
        }
        return this.matchingFilter == null || this.matchingFilter.match(genericDescription.getAttributes());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Require-Capability").append(": ").append(this.getType());
        if (this.matchingFilter != null) {
            stringBuffer.append("; filter=\"").append(this.getMatchingFilter()).append('\"');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType() {
        Object object = this.monitor;
        synchronized (object) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setType(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.type = string == null || string.equals("generic") ? "generic" : string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResolution() {
        Object object = this.monitor;
        synchronized (object) {
            return this.resolution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers != null && this.suppliers.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResolution(int n) {
        Object object = this.monitor;
        synchronized (object) {
            this.resolution = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDescription getSupplier() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers == null || this.suppliers.length == 0 ? null : this.suppliers[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSupplier(BaseDescription baseDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (baseDescription == null) {
                this.suppliers = null;
                return;
            }
            int n = this.suppliers == null ? 0 : this.suppliers.length;
            GenericDescription[] genericDescriptionArray = new GenericDescription[n + 1];
            if (this.suppliers != null) {
                System.arraycopy(this.suppliers, 0, genericDescriptionArray, 0, n);
            }
            genericDescriptionArray[n] = (GenericDescription)baseDescription;
            this.suppliers = genericDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescription[] getSuppliers() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSupplers(GenericDescription[] genericDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.suppliers = genericDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> getInternalDirectives() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        Object object = this.monitor;
        synchronized (object) {
            if ((this.resolution & 1) != 0) {
                hashMap.put("resolution", "optional");
            }
            if (this.matchingFilter != null) {
                hashMap.put("filter", this.matchingFilter.toString());
            }
        }
        return hashMap;
    }

    @Override
    protected Map<String, Object> getInteralAttributes() {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected String getInternalNameSpace() {
        return this.getType();
    }
}

