/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleSpecificationImpl
extends VersionConstraintImpl
implements BundleSpecification {
    private boolean exported;
    private boolean optional;
    private Map<String, Object> attributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExported(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.exported = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOptional(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.optional = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExported() {
        Object object = this.monitor;
        synchronized (object) {
            return this.exported;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOptional() {
        Object object = this.monitor;
        synchronized (object) {
            return this.optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributes(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = map;
        }
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        Object object;
        String[] stringArray;
        if (!(baseDescription instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)baseDescription;
        if (bundleDescriptionImpl.getHost() != null) {
            return false;
        }
        Map<String, Object> map = this.getAttributes();
        if (map != null) {
            stringArray = bundleDescriptionImpl.getAttributes();
            if (stringArray == null) {
                return false;
            }
            for (String string : map.keySet()) {
                Object object2 = map.get(string);
                object = stringArray.get(string);
                if (object != null && object2.equals(object)) continue;
                return false;
            }
        }
        if ((stringArray = (String[])bundleDescriptionImpl.getDirective("mandatory")) != null) {
            object = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                string = object[n2];
                if (!("bundle-version".equals(string) || map != null && map.get(string) != null)) {
                    return false;
                }
                ++n2;
            }
        }
        return this.getName() != null && this.getName().equals(bundleDescriptionImpl.getSymbolicName()) && (this.getVersionRange() == null || this.getVersionRange().isIncluded(bundleDescriptionImpl.getVersion()));
    }

    public String toString() {
        return new StringBuffer("Require-Bundle: ").append(this.getName()).append("; bundle-version=\"").append(this.getVersionRange()).append("\"").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> getInternalDirectives() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        Object object = this.monitor;
        synchronized (object) {
            if (this.exported) {
                hashMap.put("visibility", "reexport");
            }
            if (this.optional) {
                hashMap.put("resolution", "optional");
            }
            hashMap.put("filter", this.createFilterDirective());
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFilterDirective() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        Object object = this.monitor;
        synchronized (object) {
            BundleSpecificationImpl.addFilterAttribute(stringBuffer, "osgi.wiring.bundle", this.getName());
            VersionRange versionRange = this.getVersionRange();
            if (versionRange != null && versionRange != VersionRange.emptyRange) {
                BundleSpecificationImpl.addFilterAttribute(stringBuffer, "bundle-version", versionRange);
            }
            if (this.attributes != null) {
                BundleSpecificationImpl.addFilterAttributes(stringBuffer, this.attributes);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    protected Map<String, Object> getInteralAttributes() {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected String getInternalNameSpace() {
        return "osgi.wiring.bundle";
    }
}

