/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDescriptionImpl
implements BaseDescription {
    protected final Object monitor = new Object();
    private volatile String name;
    private volatile Version version;

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Version getVersion() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.version == null) {
                return Version.emptyVersion;
            }
            return this.version;
        }
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected void setVersion(Version version) {
        this.version = version;
    }

    static String toString(Map<String, Object> map, boolean bl) {
        if (map.size() == 0) {
            return "";
        }
        String string = bl ? ":=" : "=";
        Set<Map.Entry<String, Object>> set = map.entrySet();
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, Object> entry : set) {
            String string2;
            Object object;
            stringBuffer.append("; ");
            String string3 = entry.getKey();
            Object object2 = entry.getValue();
            if (object2 instanceof List) {
                object = (List)object2;
                if (object.size() == 0) continue;
                string2 = object.get(0);
                String string4 = string2.getClass().getName();
                String string5 = string4.substring(string4.lastIndexOf(46) + 1);
                stringBuffer.append(string3).append(':').append("List<").append(string5).append(">").append(string).append('\"');
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    stringBuffer.append(e).append(',');
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer.append('\"');
                continue;
            }
            object = "";
            if (!(object2 instanceof String)) {
                string2 = object2.getClass().getName();
                object = new StringBuffer(":").append(string2.substring(string2.lastIndexOf(46) + 1)).toString();
            }
            stringBuffer.append(string3).append((String)object).append(string).append('\"').append(object2).append('\"');
        }
        return stringBuffer.toString();
    }

    String getInternalNameSpace() {
        return null;
    }

    public BaseDescription getFragmentDeclaration() {
        return null;
    }

    @Override
    public BundleCapability getCapability() {
        return this.getCapability(null);
    }

    BundleCapability getCapability(String string) {
        BaseDescriptionImpl baseDescriptionImpl = (BaseDescriptionImpl)this.getFragmentDeclaration();
        if (baseDescriptionImpl != null) {
            return baseDescriptionImpl.getCapability(string);
        }
        if (string == null) {
            string = this.getInternalNameSpace();
        }
        if (string == null) {
            return null;
        }
        return new BaseCapability(string);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseCapability
    implements BundleCapability {
        private final String namespace;

        public BaseCapability(String string) {
            this.namespace = string;
        }

        @Override
        public BundleRevision getRevision() {
            return BaseDescriptionImpl.this.getSupplier();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public Map<String, String> getDirectives() {
            return BaseDescriptionImpl.this.getDeclaredDirectives();
        }

        @Override
        public Map<String, Object> getAttributes() {
            Map<String, Object> map = BaseDescriptionImpl.this.getDeclaredAttributes();
            String string = BaseDescriptionImpl.this.getInternalNameSpace();
            if (this.namespace.equals(string)) {
                return map;
            }
            Object object = (map = new HashMap<String, Object>(map)).remove(string);
            if (object != null) {
                map.put(this.namespace, object);
            }
            return Collections.unmodifiableMap(map);
        }

        public int hashCode() {
            return System.identityHashCode(BaseDescriptionImpl.this);
        }

        protected BaseDescriptionImpl getBaseDescription() {
            return BaseDescriptionImpl.this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BaseCapability)) {
                return false;
            }
            return ((BaseCapability)object).getBaseDescription() == BaseDescriptionImpl.this && this.namespace.equals(((BaseCapability)object).getNamespace());
        }

        public String toString() {
            return new StringBuffer(String.valueOf(this.getNamespace())).append(BaseDescriptionImpl.toString(this.getAttributes(), false)).toString();
        }
    }
}

