/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class SecurityRowSnapShot
implements ConditionalPermissionInfo {
    private final String name;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfo[] permissionInfos;
    private final String decision;

    public SecurityRowSnapShot(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray, String string2) {
        boolean bl;
        if (permissionInfoArray == null || permissionInfoArray.length == 0) {
            throw new IllegalArgumentException("It is invalid to have empty permissionInfos");
        }
        boolean bl2 = "deny".equals(string2 = string2.toLowerCase());
        if (!(bl2 | (bl = "allow".equals(string2)))) {
            throw new IllegalArgumentException("Invalid decision: " + string2);
        }
        conditionInfoArray = conditionInfoArray == null ? new ConditionInfo[]{} : conditionInfoArray;
        this.name = string;
        this.conditionInfos = (ConditionInfo[])SecurityRow.cloneArray(conditionInfoArray);
        this.permissionInfos = (PermissionInfo[])SecurityRow.cloneArray(permissionInfoArray);
        this.decision = string2;
    }

    public ConditionInfo[] getConditionInfos() {
        return (ConditionInfo[])SecurityRow.cloneArray(this.conditionInfos);
    }

    public String getAccessDecision() {
        return this.decision;
    }

    public String getName() {
        return this.name;
    }

    public PermissionInfo[] getPermissionInfos() {
        return (PermissionInfo[])SecurityRow.cloneArray(this.permissionInfos);
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getEncoded();
    }

    public String getEncoded() {
        return SecurityRow.getEncoded(this.name, this.conditionInfos, this.permissionInfos, "deny".equalsIgnoreCase(this.decision));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConditionalPermissionInfo)) {
            return false;
        }
        return this.getEncoded().equals(((ConditionalPermissionInfo)object).getEncoded());
    }

    public int hashCode() {
        return SecurityRow.getHashCode(this.name, this.conditionInfos, this.permissionInfos, this.getAccessDecision());
    }
}

