/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.PermissionAdminTable;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurePermissionStorage;
import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.eclipse.osgi.internal.permadmin.SecurityRowSnapShot;
import org.eclipse.osgi.internal.permadmin.SecurityTable;
import org.eclipse.osgi.internal.permadmin.SecurityTableUpdate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityAdmin
implements PermissionAdmin,
ConditionalPermissionAdmin {
    private static final PermissionCollection DEFAULT_DEFAULT;
    private static final String ADMIN_IMPLIED_ACTIONS = "resource,metadata,class,context";
    private static final PermissionInfo[] EMPTY_PERM_INFO;
    private final PermissionAdminTable permAdminTable = new PermissionAdminTable();
    private SecurityTable condAdminTable;
    private PermissionInfoCollection permAdminDefaults;
    private long timeStamp = 0L;
    private long nextID = System.currentTimeMillis();
    private final PermissionStorage permissionStorage;
    private final Object lock = new Object();
    private final Framework framework;
    private final PermissionInfo[] impliedPermissionInfos;
    private final EquinoxSecurityManager supportedSecurityManager;
    static /* synthetic */ Class class$0;

    static {
        AllPermission allPermission = new AllPermission();
        DEFAULT_DEFAULT = allPermission.newPermissionCollection();
        if (DEFAULT_DEFAULT != null) {
            DEFAULT_DEFAULT.add(allPermission);
        }
        EMPTY_PERM_INFO = new PermissionInfo[0];
    }

    private SecurityAdmin(EquinoxSecurityManager equinoxSecurityManager, Framework framework, PermissionInfo[] permissionInfoArray, PermissionInfoCollection permissionInfoCollection) {
        this.supportedSecurityManager = equinoxSecurityManager;
        this.framework = framework;
        this.impliedPermissionInfos = permissionInfoArray;
        this.permAdminDefaults = permissionInfoCollection;
        this.permissionStorage = null;
    }

    public SecurityAdmin(EquinoxSecurityManager equinoxSecurityManager, Framework framework, PermissionStorage permissionStorage) throws IOException {
        String[] stringArray;
        Object[] objectArray;
        String[] stringArray2;
        this.supportedSecurityManager = equinoxSecurityManager;
        this.framework = framework;
        this.permissionStorage = new SecurePermissionStorage(permissionStorage);
        this.impliedPermissionInfos = SecurityAdmin.getPermissionInfos(this.getClass().getResource("implied.permissions"), framework);
        String[] stringArray3 = permissionStorage.getPermissionData(null);
        PermissionInfo[] permissionInfoArray = SecurityAdmin.getPermissionInfos(stringArray3);
        if (permissionInfoArray != null) {
            this.permAdminDefaults = new PermissionInfoCollection(permissionInfoArray);
        }
        if ((stringArray2 = permissionStorage.getLocations()) != null) {
            int n = 0;
            while (n < stringArray2.length) {
                objectArray = permissionStorage.getPermissionData(stringArray2[n]);
                if (objectArray != null) {
                    PermissionInfo[] permissionInfoArray2 = SecurityAdmin.getPermissionInfos((String[])objectArray);
                    this.permAdminTable.setPermissions(stringArray2[n], permissionInfoArray2);
                }
                ++n;
            }
        }
        if ((stringArray = permissionStorage.getConditionalPermissionInfos()) == null) {
            this.condAdminTable = new SecurityTable(this, new SecurityRow[0]);
        } else {
            objectArray = new SecurityRow[stringArray.length];
            try {
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = SecurityRow.createSecurityRow(this, stringArray[n]);
                    ++n;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                objectArray = new SecurityRow[]{};
            }
            this.condAdminTable = new SecurityTable(this, (SecurityRow[])objectArray);
        }
    }

    private static PermissionInfo[] getPermissionInfos(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        PermissionInfo[] permissionInfoArray = new PermissionInfo[stringArray.length];
        int n = 0;
        while (n < permissionInfoArray.length) {
            permissionInfoArray[n] = new PermissionInfo(stringArray[n]);
            ++n;
        }
        return permissionInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPermission(Permission permission, BundlePermissions bundlePermissions) {
        PermissionInfoCollection permissionInfoCollection;
        SecurityTable securityTable;
        PermissionInfoCollection permissionInfoCollection2;
        Object object = this.lock;
        synchronized (object) {
            Bundle bundle = bundlePermissions.getBundle();
            permissionInfoCollection2 = bundle instanceof AbstractBundle ? this.permAdminTable.getCollection(((AbstractBundle)bundle).getBundleData().getLocation()) : null;
            securityTable = this.condAdminTable;
            permissionInfoCollection = this.permAdminDefaults;
        }
        if (permissionInfoCollection2 != null) {
            return permissionInfoCollection2.implies(permission);
        }
        if (securityTable.isEmpty()) {
            return permissionInfoCollection != null ? permissionInfoCollection.implies(permission) : DEFAULT_DEFAULT.implies(permission);
        }
        int n = securityTable.evaluate(bundlePermissions, permission);
        if ((n & 1) != 0) {
            return true;
        }
        if ((n & 2) != 0) {
            return false;
        }
        return (n & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo[] getDefaultPermissions() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.permAdminDefaults != null) break block4;
                return null;
            }
            return this.permAdminDefaults.getPermissionInfos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLocations() {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.permAdminTable.getLocations();
            return stringArray.length == 0 ? null : stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo[] getPermissions(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.permAdminTable.getPermissions(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultPermissions(PermissionInfo[] permissionInfoArray) {
        SecurityAdmin.checkAllPermission();
        Object object = this.lock;
        synchronized (object) {
            this.permAdminDefaults = permissionInfoArray == null ? null : new PermissionInfoCollection(permissionInfoArray);
            try {
                this.permissionStorage.setPermissionData(null, SecurityAdmin.getEncodedPermissionInfos(permissionInfoArray));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void checkAllPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
    }

    private static String[] getEncodedPermissionInfos(PermissionInfo[] permissionInfoArray) {
        if (permissionInfoArray == null) {
            return null;
        }
        String[] stringArray = new String[permissionInfoArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = permissionInfoArray[n].getEncoded();
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissions(String string, PermissionInfo[] permissionInfoArray) {
        SecurityAdmin.checkAllPermission();
        Object object = this.lock;
        synchronized (object) {
            this.permAdminTable.setPermissions(string, permissionInfoArray);
            try {
                this.permissionStorage.setPermissionData(string, SecurityAdmin.getEncodedPermissionInfos(permissionInfoArray));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(SecurityRow securityRow, boolean bl) {
        ConditionalPermissionUpdate conditionalPermissionUpdate = this.newConditionalPermissionUpdate();
        List<ConditionalPermissionInfo> list = conditionalPermissionUpdate.getConditionalPermissionInfos();
        Iterator<ConditionalPermissionInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            ConditionalPermissionInfo conditionalPermissionInfo = iterator.next();
            if (!securityRow.getName().equals(conditionalPermissionInfo.getName())) continue;
            iterator.remove();
            Object object = this.lock;
            synchronized (object) {
                if (!conditionalPermissionUpdate.commit() && bl) {
                    this.delete(securityRow, false);
                }
                break;
            }
        }
    }

    @Override
    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray) {
        return this.setConditionalPermissionInfo(null, conditionInfoArray, permissionInfoArray, true);
    }

    @Override
    public ConditionalPermissionInfo newConditionalPermissionInfo(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray, String string2) {
        return new SecurityRowSnapShot(string, conditionInfoArray, permissionInfoArray, string2);
    }

    @Override
    public ConditionalPermissionInfo newConditionalPermissionInfo(String string) {
        return SecurityRow.createSecurityRowSnapShot(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionalPermissionUpdate newConditionalPermissionUpdate() {
        Object object = this.lock;
        synchronized (object) {
            return new SecurityTableUpdate(this, this.condAdminTable.getRows(), this.timeStamp);
        }
    }

    @Override
    public AccessControlContext getAccessControlContext(String[] stringArray) {
        SecurityAdmin securityAdmin = this.getSnapShot();
        return new AccessControlContext(new ProtectionDomain[]{this.createProtectionDomain(SecurityAdmin.createMockBundle(stringArray), securityAdmin)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionalPermissionInfo getConditionalPermissionInfo(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.condAdminTable.getRow(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<ConditionalPermissionInfo> getConditionalPermissionInfos() {
        Object object = this.lock;
        synchronized (object) {
            SecurityRow[] securityRowArray = this.condAdminTable.getRows();
            ArrayList<SecurityRow> arrayList = new ArrayList<SecurityRow>(securityRowArray.length);
            int n = 0;
            while (n < securityRowArray.length) {
                arrayList.add(securityRowArray[n]);
                ++n;
            }
            return Collections.enumeration(arrayList);
        }
    }

    @Override
    public ConditionalPermissionInfo setConditionalPermissionInfo(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray) {
        return this.setConditionalPermissionInfo(string, conditionInfoArray, permissionInfoArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityAdmin getSnapShot() {
        SecurityAdmin securityAdmin;
        Object object = this.lock;
        synchronized (object) {
            securityAdmin = new SecurityAdmin(this.supportedSecurityManager, this.framework, this.impliedPermissionInfos, this.permAdminDefaults);
            SecurityRow[] securityRowArray = this.condAdminTable.getRows();
            SecurityRow[] securityRowArray2 = new SecurityRow[securityRowArray.length];
            int n = 0;
            while (n < securityRowArray.length) {
                securityRowArray2[n] = new SecurityRow(securityAdmin, securityRowArray[n].getName(), securityRowArray[n].getConditionInfos(), securityRowArray[n].getPermissionInfos(), securityRowArray[n].getAccessDecision());
                ++n;
            }
            securityAdmin.condAdminTable = new SecurityTable(securityAdmin, securityRowArray2);
        }
        return securityAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConditionalPermissionInfo setConditionalPermissionInfo(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray, boolean bl) {
        ConditionalPermissionUpdate conditionalPermissionUpdate = this.newConditionalPermissionUpdate();
        List<ConditionalPermissionInfo> list = conditionalPermissionUpdate.getConditionalPermissionInfos();
        ConditionalPermissionInfo conditionalPermissionInfo = this.newConditionalPermissionInfo(string, conditionInfoArray, permissionInfoArray, "allow");
        int n = -1;
        if (string != null) {
            int n2 = 0;
            while (n2 < list.size() && n < 0) {
                ConditionalPermissionInfo conditionalPermissionInfo2 = list.get(n2);
                if (string.equals(conditionalPermissionInfo2.getName())) {
                    n = n2;
                }
                ++n2;
            }
        }
        if (n < 0) {
            list.add(0, conditionalPermissionInfo);
            n = 0;
        } else {
            list.set(n, conditionalPermissionInfo);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!conditionalPermissionUpdate.commit() && bl) {
                this.setConditionalPermissionInfo(string, conditionInfoArray, permissionInfoArray, false);
            }
            return this.condAdminTable.getRow(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean commit(List<ConditionalPermissionInfo> list, long l) {
        SecurityAdmin.checkAllPermission();
        Object object = this.lock;
        synchronized (object) {
            block10: {
                if (l == this.timeStamp) break block10;
                return false;
            }
            SecurityRow[] securityRowArray = new SecurityRow[list.size()];
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < securityRowArray.length) {
                ConditionalPermissionInfo conditionalPermissionInfo = list.get(n);
                if (!(conditionalPermissionInfo instanceof ConditionalPermissionInfo)) {
                    throw new IllegalStateException(new StringBuffer("Invalid type \"").append(conditionalPermissionInfo.getClass().getName()).append("\" at row: ").append(n).toString());
                }
                ConditionalPermissionInfo conditionalPermissionInfo2 = conditionalPermissionInfo;
                String string = conditionalPermissionInfo2.getName();
                if (string == null) {
                    string = this.generateName();
                }
                if (arrayList.contains(string)) {
                    throw new IllegalStateException(new StringBuffer("Duplicate name \"").append(string).append("\" at row: ").append(n).toString());
                }
                securityRowArray[n] = new SecurityRow(this, string, conditionalPermissionInfo2.getConditionInfos(), conditionalPermissionInfo2.getPermissionInfos(), conditionalPermissionInfo2.getAccessDecision());
                ++n;
            }
            this.condAdminTable = new SecurityTable(this, securityRowArray);
            try {
                this.permissionStorage.saveConditionalPermissionInfos(this.condAdminTable.getEncodedRows());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++this.timeStamp;
            return true;
        }
    }

    private String generateName() {
        return new StringBuffer("generated_").append(Long.toString(this.nextID++)).toString();
    }

    public BundleProtectionDomain createProtectionDomain(Bundle bundle) {
        return this.createProtectionDomain(bundle, this);
    }

    private BundleProtectionDomain createProtectionDomain(Bundle bundle, SecurityAdmin securityAdmin) {
        PermissionInfoCollection permissionInfoCollection = this.getImpliedPermission(bundle);
        PermissionInfo[] permissionInfoArray = this.getFileRelativeInfos(SecurityAdmin.getPermissionInfos(bundle.getEntry("OSGI-INF/permissions.perm"), this.framework), bundle);
        PermissionInfoCollection permissionInfoCollection2 = permissionInfoArray == null ? null : new PermissionInfoCollection(permissionInfoArray);
        BundlePermissions bundlePermissions = new BundlePermissions(bundle, securityAdmin, permissionInfoCollection, permissionInfoCollection2);
        return new BundleProtectionDomain(bundlePermissions, null, bundle);
    }

    private PermissionInfoCollection getImpliedPermission(Bundle bundle) {
        if (this.impliedPermissionInfos == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.AdminPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PermissionInfo permissionInfo = new PermissionInfo(clazz.getName(), new StringBuffer("(id=").append(bundle.getBundleId()).append(")").toString(), ADMIN_IMPLIED_ACTIONS);
        PermissionInfo[] permissionInfoArray = new PermissionInfo[this.impliedPermissionInfos.length + 1];
        System.arraycopy(this.impliedPermissionInfos, 0, permissionInfoArray, 0, this.impliedPermissionInfos.length);
        permissionInfoArray[this.impliedPermissionInfos.length] = permissionInfo;
        return new PermissionInfoCollection(this.getFileRelativeInfos(permissionInfoArray, bundle));
    }

    private PermissionInfo[] getFileRelativeInfos(PermissionInfo[] permissionInfoArray, Bundle bundle) {
        if (permissionInfoArray == null || !(bundle instanceof AbstractBundle)) {
            return permissionInfoArray;
        }
        PermissionInfo[] permissionInfoArray2 = new PermissionInfo[permissionInfoArray.length];
        int n = 0;
        while (n < permissionInfoArray.length) {
            File file;
            File file2;
            permissionInfoArray2[n] = permissionInfoArray[n];
            if ("java.io.FilePermission".equals(permissionInfoArray[n].getType()) && !"<<ALL FILES>>".equals(permissionInfoArray[n].getName()) && !(file2 = new File(permissionInfoArray[n].getName())).isAbsolute() && (file = ((AbstractBundle)bundle).getBundleData().getDataFile(permissionInfoArray[n].getName())) != null) {
                permissionInfoArray2[n] = new PermissionInfo(permissionInfoArray[n].getType(), file.getPath(), permissionInfoArray[n].getActions());
            }
            ++n;
        }
        return permissionInfoArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        SecurityRow[] securityRowArray;
        PermissionInfoCollection[] permissionInfoCollectionArray;
        Object object = this.lock;
        synchronized (object) {
            permissionInfoCollectionArray = this.permAdminTable.getCollections();
            securityRowArray = this.condAdminTable.getRows();
        }
        int n = 0;
        while (n < permissionInfoCollectionArray.length) {
            permissionInfoCollectionArray[n].clearPermissionCache();
            ++n;
        }
        n = 0;
        while (n < securityRowArray.length) {
            securityRowArray[n].clearCaches();
            ++n;
        }
    }

    EquinoxSecurityManager getSupportedSecurityManager() {
        return this.supportedSecurityManager != null ? this.supportedSecurityManager : SecurityAdmin.getSupportedSystemSecurityManager();
    }

    private static EquinoxSecurityManager getSupportedSystemSecurityManager() {
        try {
            EquinoxSecurityManager equinoxSecurityManager = (EquinoxSecurityManager)System.getSecurityManager();
            return equinoxSecurityManager != null && equinoxSecurityManager.inCheckPermission() ? equinoxSecurityManager : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static PermissionInfo[] getPermissionInfos(URL uRL, Framework framework) {
        PermissionInfo[] permissionInfoArray;
        block21: {
            if (uRL == null) {
                return null;
            }
            permissionInfoArray = EMPTY_PERM_INFO;
            DataInputStream dataInputStream = null;
            try {
                try {
                    String string;
                    BufferedReader bufferedReader;
                    dataInputStream = new DataInputStream(uRL.openStream());
                    ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
                    }
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() == 0 || string.startsWith("#") || string.startsWith("//")) continue;
                        try {
                            arrayList.add(new PermissionInfo(string));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (framework == null) continue;
                            framework.publishFrameworkEvent(2, framework.getBundle(0L), illegalArgumentException);
                        }
                    }
                    int n = arrayList.size();
                    if (n > 0) {
                        permissionInfoArray = arrayList.toArray(new PermissionInfo[n]);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException2) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (dataInputStream != null) {
                        dataInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return permissionInfoArray;
    }

    private static Bundle createMockBundle(String[] stringArray) {
        HashMap<X509Certificate, List<X509Certificate>> hashMap = new HashMap<X509Certificate, List<X509Certificate>>();
        int n = 0;
        while (n < stringArray.length) {
            List<String> list = SecurityAdmin.parseDNchain(stringArray[n]);
            ArrayList<MockX509Certificate> arrayList = new ArrayList<MockX509Certificate>();
            MockPrincipal mockPrincipal = null;
            MockPrincipal mockPrincipal2 = null;
            MockX509Certificate mockX509Certificate = null;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                mockPrincipal = mockPrincipal2 == null ? new MockPrincipal(iterator.next()) : mockPrincipal2;
                mockPrincipal2 = iterator.hasNext() ? new MockPrincipal(iterator.next()) : mockPrincipal;
                MockX509Certificate mockX509Certificate2 = new MockX509Certificate(mockPrincipal, mockPrincipal2);
                if (mockX509Certificate == null) {
                    mockX509Certificate = mockX509Certificate2;
                }
                arrayList.add(mockX509Certificate2);
            }
            if (mockPrincipal != mockPrincipal2) {
                arrayList.add(new MockX509Certificate(mockPrincipal2, mockPrincipal2));
            }
            hashMap.put(mockX509Certificate, arrayList);
            ++n;
        }
        return new MockBundle(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<String> parseDNchain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The DN chain must not be null.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        n = SecurityAdmin.skipSpaces(string, n);
        while (n < string.length()) {
            int n2 = n;
            boolean bl = false;
            block6: while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\"': {
                        bl = !bl;
                        break;
                    }
                    case '\\': {
                        ++n2;
                        break;
                    }
                    case ';': {
                        if (!bl) break block6;
                    }
                }
                ++n2;
            }
            if (n2 > string.length()) {
                throw new IllegalArgumentException("unterminated escape");
            }
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
            n = SecurityAdmin.skipSpaces(string, n);
        }
        return arrayList;
    }

    private static int skipSpaces(String string, int n) {
        while (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return n;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockBundle
    implements Bundle {
        private final Map<X509Certificate, List<X509Certificate>> signers;

        MockBundle(Map<X509Certificate, List<X509Certificate>> map) {
            this.signers = map;
        }

        @Override
        public Enumeration<URL> findEntries(String string, String string2, boolean bl) {
            return null;
        }

        @Override
        public BundleContext getBundleContext() {
            return null;
        }

        @Override
        public long getBundleId() {
            return -1L;
        }

        @Override
        public URL getEntry(String string) {
            return null;
        }

        @Override
        public Enumeration<String> getEntryPaths(String string) {
            return null;
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return new Hashtable<String, String>();
        }

        @Override
        public Dictionary<String, String> getHeaders(String string) {
            return this.getHeaders();
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getLocation() {
            return "";
        }

        @Override
        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        @Override
        public URL getResource(String string) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            return null;
        }

        @Override
        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        @Override
        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int n) {
            return new HashMap<X509Certificate, List<X509Certificate>>(this.signers);
        }

        @Override
        public int getState() {
            return 1;
        }

        @Override
        public String getSymbolicName() {
            return null;
        }

        @Override
        public Version getVersion() {
            return Version.emptyVersion;
        }

        @Override
        public boolean hasPermission(Object object) {
            return false;
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            throw new IllegalStateException();
        }

        @Override
        public void start(int n) throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public void start() throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public void stop(int n) throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public void stop() throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public void uninstall() throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public void update() throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public void update(InputStream inputStream) throws BundleException {
            throw new IllegalStateException();
        }

        @Override
        public int compareTo(Bundle bundle) {
            return 0;
        }

        @Override
        public <A> A adapt(Class<A> clazz) {
            throw new IllegalStateException();
        }

        @Override
        public File getDataFile(String string) {
            return null;
        }
    }

    private static class MockPrincipal
    implements Principal {
        private final String name;

        MockPrincipal(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof MockPrincipal) {
                return this.name.equals(((MockPrincipal)object).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockX509Certificate
    extends X509Certificate {
        private final Principal subject;
        private final Principal issuer;

        MockX509Certificate(Principal principal, Principal principal2) {
            this.subject = principal;
            this.issuer = principal2;
        }

        @Override
        public Principal getSubjectDN() {
            return this.subject;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof MockX509Certificate) {
                return this.subject.equals(((MockX509Certificate)object).subject) && this.issuer.equals(((MockX509Certificate)object).issuer);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.subject.hashCode() + this.issuer.hashCode();
        }

        @Override
        public String toString() {
            return this.subject.toString();
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBasicConstraints() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getIssuerDN() {
            return this.issuer;
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean[] getKeyUsage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getNotAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getNotBefore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getSerialNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSigAlgName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSigAlgOID() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getSigAlgParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublicKey getPublicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void verify(PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getExtensionValue(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            throw new UnsupportedOperationException();
        }
    }
}

