/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.osgi.service.condpermadmin.Condition;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxSecurityManager
extends SecurityManager {
    private final ThreadLocal<CheckContext> localCheckContext = new ThreadLocal();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager$CheckPermissionAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class clazz2 = clazz;
        Class clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager$CheckContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz2 = clazz3;
        clazz2.getName();
    }

    boolean addConditionsForDomain(SecurityRow.Decision[] decisionArray) {
        CheckContext checkContext = this.localCheckContext.get();
        if (checkContext == null) {
            return false;
        }
        List<SecurityRow.Decision[]> list = checkContext.depthCondSets.get(checkContext.getDepth());
        if (list == null) {
            list = new ArrayList<SecurityRow.Decision[]>(1);
            checkContext.depthCondSets.set(checkContext.getDepth(), list);
        }
        list.add(decisionArray);
        return true;
    }

    boolean inCheckPermission() {
        return this.localCheckContext.get() != null;
    }

    @Override
    public void checkPermission(Permission permission, Object object) {
        AccessController.doPrivileged(new CheckPermissionAction(this, permission, object));
    }

    public AccessControlContext getContextToBeChecked() {
        CheckContext checkContext = this.localCheckContext.get();
        if (checkContext != null && checkContext.accs != null && !checkContext.accs.isEmpty()) {
            return checkContext.accs.get(checkContext.accs.size() - 1);
        }
        return null;
    }

    void internalCheckPermission(Permission permission, Object object) {
        AccessControlContext accessControlContext = (AccessControlContext)object;
        CheckContext checkContext = this.localCheckContext.get();
        if (checkContext == null) {
            checkContext = new CheckContext();
            this.localCheckContext.set(checkContext);
        }
        checkContext.depthCondSets.add(null);
        checkContext.accs.add(accessControlContext);
        try {
            accessControlContext.checkPermission(permission);
            List<SecurityRow.Decision[]> list = checkContext.depthCondSets.get(checkContext.getDepth());
            if (list == null) {
                return;
            }
            HashMap<Class<? extends Condition>, Dictionary<Object, Object>> hashMap = new HashMap<Class<? extends Condition>, Dictionary<Object, Object>>();
            for (SecurityRow.Decision[] decisionArray : list) {
                boolean bl = false;
                int n = 0;
                while (n < decisionArray.length) {
                    if (decisionArray[n] == null) break;
                    if ((decisionArray[n].decision & 4) == 0) {
                        if ((decisionArray[n].decision & 8) == 0) {
                            if ((decisionArray[n].decision & 1) == 0) break;
                            bl = true;
                            break;
                        }
                        int n2 = this.getPostponedDecision(decisionArray[n], hashMap, checkContext);
                        if ((n2 & 4) == 0) {
                            if ((n2 & 1) == 0) break;
                            bl = true;
                            break;
                        }
                    }
                    ++n;
                }
                if (bl) continue;
                throw new SecurityException("Conditions not satisfied");
            }
        }
        finally {
            checkContext.depthCondSets.remove(checkContext.getDepth());
            checkContext.accs.remove(checkContext.accs.size() - 1);
        }
    }

    private int getPostponedDecision(SecurityRow.Decision decision, Map<Class<? extends Condition>, Dictionary<Object, Object>> map, CheckContext checkContext) {
        Condition[] conditionArray = decision.postponed;
        int n = 0;
        while (n < conditionArray.length) {
            Dictionary<Object, Object> dictionary = map.get(conditionArray[n].getClass());
            if (dictionary == null) {
                dictionary = new Hashtable<Object, Object>();
                map.put(conditionArray[n].getClass(), dictionary);
            }
            if (checkContext.CondClassSet == null) {
                checkContext.CondClassSet = new ArrayList(2);
            }
            if (checkContext.CondClassSet.contains(conditionArray[n].getClass())) {
                return 4;
            }
            checkContext.CondClassSet.add(conditionArray[n].getClass());
            try {
                boolean bl = conditionArray[n].isMutable();
                boolean bl2 = conditionArray[n].isSatisfied(new Condition[]{conditionArray[n]}, dictionary);
                decision.handleImmutable(conditionArray[n], bl2, bl);
                if (!bl2) {
                    return 4;
                }
            }
            finally {
                checkContext.CondClassSet.remove(conditionArray[n].getClass());
            }
            ++n;
        }
        return decision.decision;
    }

    @Override
    public void checkPermission(Permission permission) {
        this.checkPermission(permission, this.getSecurityContext());
    }

    @Override
    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    static class CheckContext {
        List<List<SecurityRow.Decision[]>> depthCondSets = new ArrayList<List<SecurityRow.Decision[]>>(2);
        List<AccessControlContext> accs = new ArrayList<AccessControlContext>(2);
        List<Class<?>> CondClassSet;

        CheckContext() {
        }

        public int getDepth() {
            return this.depthCondSets.size() - 1;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CheckPermissionAction
    implements PrivilegedAction<Object> {
        Permission perm;
        Object context;
        EquinoxSecurityManager fsm;

        CheckPermissionAction(EquinoxSecurityManager equinoxSecurityManager, Permission permission, Object object) {
            this.fsm = equinoxSecurityManager;
            this.perm = permission;
            this.context = object;
        }

        @Override
        public Object run() {
            this.fsm.internalCheckPermission(this.perm, this.context);
            return null;
        }
    }
}

