/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingChecker {
    final PackageRoots nullPackageRoots = new PackageRoots(null);
    private Map<ResolverBundle, Map<String, PackageRoots>> bundles = new HashMap<ResolverBundle, Map<String, PackageRoots>>();

    public void populateRoots(ResolverBundle resolverBundle) {
        ExportPackageDescription[] exportPackageDescriptionArray;
        Object object;
        if (this.bundles.containsKey(resolverBundle)) {
            return;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            object = (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier();
            if (object != null) {
                this.isConsistentInternal(resolverBundle, (ResolverBundle)object, new ArrayList<ResolverBundle>(1), true, null);
            }
            ++n;
        }
        ExportPackageDescription[] exportPackageDescriptionArray2 = exportPackageDescriptionArray = resolverBundle.getBundleDescription().getResolvedImports();
        int n2 = exportPackageDescriptionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = exportPackageDescriptionArray2[n3];
            List list = resolverBundle.getResolver().getResolverExports().get(object.getName());
            for (ResolverExport resolverExport : list) {
                if (resolverExport.getExportPackageDescription() != object) continue;
                this.isConsistentInternal(resolverBundle, resolverExport, true, null);
            }
            ++n3;
        }
    }

    public void populateRoots(ResolverBundle resolverBundle, ResolverExport resolverExport) {
        Map<String, PackageRoots> map = this.bundles.get(resolverBundle);
        if (map != null) {
            map.remove(resolverExport.getName());
        }
        PackageRoots packageRoots = this.getPackageRoots(resolverExport.getExporter(), resolverExport.getName(), null);
        map.put(resolverExport.getName(), packageRoots);
    }

    public PackageRoots[][] isConsistent(ResolverBundle resolverBundle, ResolverBundle resolverBundle2) {
        List<PackageRoots[]> list = this.isConsistentInternal(resolverBundle, resolverBundle2, new ArrayList<ResolverBundle>(1), false, null);
        return list == null ? null : (PackageRoots[][])list.toArray((T[])new PackageRoots[list.size()][]);
    }

    private List<PackageRoots[]> isConsistentInternal(ResolverBundle resolverBundle, ResolverBundle resolverBundle2, List<ResolverBundle> list, boolean bl, List<PackageRoots[]> list2) {
        if (list.contains(resolverBundle2)) {
            return list2;
        }
        list.add(resolverBundle2);
        ResolverExport[] resolverExportArray = resolverBundle2.getExportPackages();
        int n = 0;
        while (n < resolverExportArray.length) {
            ResolverExport resolverExport = resolverExportArray[n];
            if (resolverExportArray[n].getSubstitute() != null) {
                resolverExport = (ResolverExport)resolverExportArray[n].getSubstitute();
            }
            list2 = this.isConsistentInternal(resolverBundle, resolverExport, bl, list2);
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle2.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            ResolverBundle resolverBundle3 = (ResolverBundle)bundleConstraintArray[n2].getSelectedSupplier();
            if (resolverBundle3 != null && ((BundleSpecification)bundleConstraintArray[n2].getVersionConstraint()).isExported()) {
                list2 = this.isConsistentInternal(resolverBundle, resolverBundle3, list, bl, list2);
            }
            ++n2;
        }
        return list2;
    }

    public PackageRoots[][] isConsistent(ResolverBundle resolverBundle, ResolverExport resolverExport) {
        List<PackageRoots[]> list = this.isConsistentInternal(resolverBundle, resolverExport, false, null);
        return list == null ? null : (PackageRoots[][])list.toArray((T[])new PackageRoots[list.size()][]);
    }

    public PackageRoots[][] isConsistent(ResolverBundle resolverBundle, GenericCapability genericCapability) {
        String[] stringArray = genericCapability.getUsesDirective();
        if (stringArray == null) {
            return null;
        }
        ArrayList<PackageRoots[]> arrayList = new ArrayList<PackageRoots[]>(0);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            PackageRoots packageRoots = this.getPackageRoots(genericCapability.getResolverBundle(), string, null);
            packageRoots.addConflicts(resolverBundle, string, null, arrayList);
            ++n2;
        }
        return arrayList.size() == 0 ? null : (PackageRoots[][])arrayList.toArray((T[])new PackageRoots[arrayList.size()][]);
    }

    public PackageRoots[][] isDynamicConsistent(ResolverBundle resolverBundle, ResolverExport resolverExport) {
        List<PackageRoots[]> list = this.isConsistentInternal(resolverBundle, resolverExport, true, null);
        return list == null ? null : (PackageRoots[][])list.toArray((T[])new PackageRoots[list.size()][]);
    }

    private List<PackageRoots[]> isConsistentInternal(ResolverBundle resolverBundle, ResolverExport resolverExport, boolean bl, List<PackageRoots[]> list) {
        Object object;
        Object object2;
        PackageRoots packageRoots = this.getPackageRoots(resolverExport.getExporter(), resolverExport.getName(), null);
        list = packageRoots.isConsistentClassSpace(resolverBundle, null, list);
        if (!bl) {
            return list;
        }
        PackageRoots packageRoots2 = this.getPackageRoots(resolverBundle, resolverExport.getName(), null);
        Map<String, PackageRoots> map = this.bundles.get(resolverBundle);
        if (map != null) {
            object2 = map.values().iterator();
            while (object2.hasNext()) {
                object = (PackageRoots)object2.next();
                if (object == packageRoots2) continue;
                list = ((PackageRoots)object).isConsistentClassSpace(packageRoots, resolverExport.getExporter(), null, list);
            }
        }
        Object object3 = object2 = resolverBundle.getGenericRequires();
        int n = ((Object)object3).length;
        int n2 = 0;
        while (n2 < n) {
            GenericCapability genericCapability;
            String[] stringArray;
            object = object3[n2];
            if (((GenericConstraint)object).supplierHasUses() && (stringArray = (genericCapability = (GenericCapability)((ResolverConstraint)object).getSelectedSupplier()).getUsesDirective()) != null) {
                String[] stringArray2 = stringArray;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray2[n4];
                    if (string.equals(resolverExport.getName())) {
                        list = packageRoots.addConflicts(genericCapability.getResolverBundle(), string, null, list);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return list;
    }

    PackageRoots getPackageRoots(ResolverBundle resolverBundle, String string, List<ResolverBundle> arrayList) {
        PackageRoots packageRoots;
        Map<String, PackageRoots> map = this.bundles.get(resolverBundle);
        if (map == null) {
            map = new HashMap<String, PackageRoots>(5);
            this.bundles.put(resolverBundle, map);
        }
        if ((packageRoots = map.get(string)) == null) {
            packageRoots = this.createPackageRoots(resolverBundle, string, arrayList == null ? new ArrayList(1) : arrayList);
            map.put(string, packageRoots);
        }
        return packageRoots != null ? packageRoots : this.nullPackageRoots;
    }

    /*
     * WARNING - void declaration
     */
    private PackageRoots createPackageRoots(ResolverBundle resolverBundle, String string, List<ResolverBundle> list) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        if (list.contains(resolverBundle)) {
            return null;
        }
        list.add(resolverBundle);
        if (resolverBundle.getBundleDescription().isResolved()) {
            object3 = object4 = resolverBundle.getBundleDescription().getResolvedImports();
            n = ((ExportPackageDescription[])object3).length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object3[n2];
                if (object2.getExporter() != resolverBundle.getBundleDescription() && object2.getName().equals(string)) {
                    object = resolverBundle.getResolver().getResolverExports().get(string);
                    for (ResolverExport resolverExport : object) {
                        if (resolverExport.getExportPackageDescription() != object2) continue;
                        return this.getPackageRoots(resolverExport.getExporter(), string, list);
                    }
                }
                ++n2;
            }
        } else {
            object4 = resolverBundle.getImport(string);
            if (object4 != null && ((ResolverConstraint)object4).getSelectedSupplier() != null && ((ResolverExport)(object2 = (ResolverExport)((ResolverConstraint)object4).getSelectedSupplier())).getExporter() != resolverBundle) {
                return this.getPackageRoots(((ResolverExport)object2).getExporter(), string, list);
            }
        }
        object4 = resolverBundle.getExports(string);
        object2 = new ArrayList(0);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        n = 0;
        while (n < bundleConstraintArray.length) {
            object3 = (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier();
            if (object3 != null) {
                if (((ResolverBundle)object3).getExport(string) != null) {
                    object = this.getPackageRoots((ResolverBundle)object3, string, list);
                    if (object != this.nullPackageRoots) {
                        object2.add(object);
                    }
                } else {
                    void var10_16;
                    object = ((ResolverBundle)object3).getRequires();
                    boolean n3 = false;
                    while (var10_16 < ((BundleConstraint[])object).length) {
                        PackageRoots packageRoots;
                        ResolverBundle resolverBundle2 = (ResolverBundle)object[var10_16].getSelectedSupplier();
                        if (resolverBundle2 != null && ((BundleSpecification)object[var10_16].getVersionConstraint()).isExported() && resolverBundle2.getExport(string) != null && (packageRoots = this.getPackageRoots(resolverBundle2, string, list)) != this.nullPackageRoots) {
                            object2.add(packageRoots);
                        }
                        ++var10_16;
                    }
                }
            }
            ++n;
        }
        if (((Object)object4).length > 0 || object2.size() > 1) {
            PackageRoots[] packageRootsArray = object2.toArray(new PackageRoots[object2.size()]);
            if (((Object)object4).length == 0) {
                object3 = packageRootsArray[0];
                int n4 = 1;
                while (n4 < packageRootsArray.length) {
                    if (packageRootsArray[n4].superSet((PackageRoots)object3)) {
                        object3 = packageRootsArray[n4];
                    } else if (!((PackageRoots)object3).superSet(packageRootsArray[n4])) {
                        object3 = null;
                        break;
                    }
                    ++n4;
                }
                if (object3 != null) {
                    return object3;
                }
            }
            object3 = new PackageRoots(string);
            int n5 = 0;
            while (n5 < packageRootsArray.length) {
                ((PackageRoots)object3).merge(packageRootsArray[n5]);
                ++n5;
            }
            n5 = 0;
            while (n5 < ((Object)object4).length) {
                ((PackageRoots)object3).addRoot((ResolverExport)object4[n5]);
                ++n5;
            }
            return object3;
        }
        return object2.size() == 0 ? this.nullPackageRoots : (PackageRoots)object2.get(0);
    }

    public void clear() {
        this.bundles.clear();
    }

    public void clear(ResolverBundle resolverBundle) {
        this.bundles.remove(resolverBundle);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PackageRoots {
        private String name;
        private ResolverExport[] roots;

        PackageRoots(String string) {
            this.name = string;
        }

        public boolean hasRoots() {
            return this.roots != null && this.roots.length > 0;
        }

        public void addRoot(ResolverExport resolverExport) {
            if (this.roots == null) {
                this.roots = new ResolverExport[]{resolverExport};
                return;
            }
            String string = resolverExport.getExporter().getName();
            if (string != null) {
                int n = 0;
                while (n < this.roots.length) {
                    if (resolverExport.getExporter() != this.roots[n].getExporter() && string.equals(this.roots[n].getExporter().getName())) {
                        return;
                    }
                    ++n;
                }
            }
            if (!this.contains(resolverExport, this.roots)) {
                ResolverExport[] resolverExportArray = new ResolverExport[this.roots.length + 1];
                System.arraycopy(this.roots, 0, resolverExportArray, 0, this.roots.length);
                resolverExportArray[this.roots.length] = resolverExport;
                this.roots = resolverExportArray;
            }
        }

        private boolean contains(ResolverExport resolverExport, ResolverExport[] resolverExportArray) {
            int n = 0;
            while (n < resolverExportArray.length) {
                if (resolverExportArray[n] == resolverExport) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void merge(PackageRoots packageRoots) {
            if (packageRoots == null || packageRoots.roots == null) {
                return;
            }
            int n = packageRoots.roots.length;
            int n2 = 0;
            while (n2 < n) {
                this.addRoot(packageRoots.roots[n2]);
                ++n2;
            }
        }

        public List<PackageRoots[]> isConsistentClassSpace(ResolverBundle resolverBundle, List<PackageRoots> list, List<PackageRoots[]> list2) {
            if (this.roots == null) {
                return list2;
            }
            if (list == null) {
                list = new ArrayList<PackageRoots>(1);
            }
            if (list.contains(this)) {
                return list2;
            }
            list.add(this);
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport resolverExport = this.roots[n2];
                String[] stringArray = resolverExport.getUsesDirective();
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        PackageRoots packageRoots;
                        PackageRoots packageRoots2;
                        if (!stringArray[n3].equals(resolverExport.getName()) && (packageRoots2 = GroupingChecker.this.getPackageRoots(resolverExport.getExporter(), stringArray[n3], null)) != (packageRoots = GroupingChecker.this.getPackageRoots(resolverBundle, stringArray[n3], null))) {
                            if (packageRoots2 != GroupingChecker.this.nullPackageRoots && packageRoots != GroupingChecker.this.nullPackageRoots && !this.subSet(packageRoots2.roots, packageRoots.roots) && !this.subSet(packageRoots.roots, packageRoots2.roots)) {
                                if (list2 == null) {
                                    list2 = new ArrayList<PackageRoots[]>(1);
                                }
                                list2.add(new PackageRoots[]{this, packageRoots});
                            }
                            list2 = packageRoots2.isConsistentClassSpace(resolverBundle, list, list2);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return list2;
        }

        public List<PackageRoots[]> isConsistentClassSpace(PackageRoots packageRoots, ResolverBundle resolverBundle, List<PackageRoots> list, List<PackageRoots[]> list2) {
            if (this.roots == null) {
                return list2;
            }
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport resolverExport = this.roots[n2];
                String[] stringArray = resolverExport.getUsesDirective();
                if (stringArray != null) {
                    if (list == null) {
                        list = new ArrayList<PackageRoots>(1);
                    }
                    if (list.contains(this)) {
                        return list2;
                    }
                    list.add(this);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (!stringArray[n3].equals(resolverExport.getName()) && stringArray[n3].equals(packageRoots.name)) {
                            PackageRoots packageRoots2 = GroupingChecker.this.getPackageRoots(resolverExport.getExporter(), stringArray[n3], null);
                            PackageRoots packageRoots3 = GroupingChecker.this.getPackageRoots(resolverBundle, stringArray[n3], null);
                            if (packageRoots2 == packageRoots) {
                                return list2;
                            }
                            if (packageRoots2 != GroupingChecker.this.nullPackageRoots && packageRoots3 != GroupingChecker.this.nullPackageRoots && !this.subSet(packageRoots2.roots, packageRoots3.roots) && !this.subSet(packageRoots3.roots, packageRoots2.roots)) {
                                if (list2 == null) {
                                    list2 = new ArrayList<PackageRoots[]>(1);
                                }
                                list2.add(new PackageRoots[]{this, packageRoots3});
                            }
                            list2 = packageRoots2.isConsistentClassSpace(packageRoots, resolverBundle, list, list2);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return list2;
        }

        List<PackageRoots[]> addConflicts(ResolverBundle resolverBundle, String string, List<PackageRoots> list, List<PackageRoots[]> list2) {
            PackageRoots packageRoots = GroupingChecker.this.getPackageRoots(resolverBundle, string, null);
            if (this == packageRoots) {
                return list2;
            }
            if (this != GroupingChecker.this.nullPackageRoots && packageRoots != GroupingChecker.this.nullPackageRoots && !this.subSet(this.roots, packageRoots.roots) && !this.subSet(packageRoots.roots, this.roots)) {
                if (list2 == null) {
                    list2 = new ArrayList<PackageRoots[]>(1);
                }
                list2.add(new PackageRoots[]{this, packageRoots});
            }
            return this.isConsistentClassSpace(packageRoots, resolverBundle, list, list2);
        }

        private boolean subSet(ResolverExport[] resolverExportArray, ResolverExport[] resolverExportArray2) {
            int n = 0;
            while (n < resolverExportArray2.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < resolverExportArray.length) {
                    if (resolverExportArray2[n].getExporter() == resolverExportArray[n2].getExporter()) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean superSet(PackageRoots packageRoots) {
            return this.subSet(this.roots, packageRoots.roots);
        }

        public String getName() {
            return this.name;
        }

        public ResolverExport[] getRoots() {
            return this.roots;
        }
    }
}

