/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.loader.PackageSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSourcePackage
extends PackageSource {
    BundleLoaderProxy supplier;

    public SingleSourcePackage(String string, BundleLoaderProxy bundleLoaderProxy) {
        super(string);
        this.supplier = bundleLoaderProxy;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return new SingleSourcePackage[]{this};
    }

    public String toString() {
        return new StringBuffer(String.valueOf(this.id)).append(" -> ").append(this.supplier).toString();
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.supplier.getBundleLoader().findLocalClass(string);
    }

    @Override
    public URL getResource(String string) {
        return this.supplier.getBundleLoader().findLocalResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) {
        return this.supplier.getBundleLoader().findLocalResources(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SingleSourcePackage)) {
            return false;
        }
        SingleSourcePackage singleSourcePackage = (SingleSourcePackage)object;
        return this.supplier == singleSourcePackage.supplier && this.id == singleSourcePackage.getId();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.id.hashCode();
        n = 31 * n + this.supplier.hashCode();
        return n;
    }

    @Override
    public Collection<String> listResources(String string, String string2) {
        BundleClassLoader bundleClassLoader = this.supplier.getBundleLoader().createClassLoader();
        return bundleClassLoader.listLocalResources(string, string2, 0);
    }
}

