/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.loader.SingleSourcePackage;
import org.eclipse.osgi.util.ManifestElement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredSourcePackage
extends SingleSourcePackage {
    private static final char ALL = '*';
    String[] includes;
    String[] excludes;
    String[] friends;

    public FilteredSourcePackage(String string, BundleLoaderProxy bundleLoaderProxy, String string2, String string3, String[] stringArray) {
        super(string, bundleLoaderProxy);
        if (string2 != null) {
            this.includes = ManifestElement.getArrayFromList(string2);
        }
        if (string3 != null) {
            this.excludes = ManifestElement.getArrayFromList(string3);
        }
        this.friends = stringArray;
    }

    @Override
    public boolean isFriend(String string) {
        if (this.friends == null) {
            return true;
        }
        int n = 0;
        while (n < this.friends.length) {
            if (this.friends[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public URL getResource(String string) {
        if (this.isFiltered(string, this.getId())) {
            return null;
        }
        return super.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) {
        if (this.isFiltered(string, this.getId())) {
            return null;
        }
        return super.getResources(string);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.isFiltered(string, this.getId())) {
            return null;
        }
        return super.loadClass(string);
    }

    private boolean isFiltered(String string, String string2) {
        String string3 = this.getName(string, string2);
        return !this.isIncluded(string3) || this.isExcluded(string3);
    }

    private String getName(String string, String string2) {
        if (!".".equals(string2) && string2.length() + 1 <= string.length()) {
            return string.substring(string2.length() + 1);
        }
        return string;
    }

    private boolean isIncluded(String string) {
        if (this.includes == null) {
            return true;
        }
        return this.isInList(string, this.includes);
    }

    private boolean isExcluded(String string) {
        if (this.excludes == null) {
            return false;
        }
        return this.isInList(string, this.excludes);
    }

    private boolean isInList(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].length();
            if (n2 != 0) {
                if (stringArray[n].charAt(0) == '*' && n2 == 1) {
                    return true;
                }
                if (stringArray[n].charAt(n2 - 1) == '*' && string.startsWith(stringArray[n].substring(0, n2 - 1))) {
                    return true;
                }
                if (string.equals(stringArray[n])) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    @Override
    public Collection<String> listResources(String string, String string2) {
        Collection<String> collection = super.listResources(string, string2);
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4 = iterator.next();
            int n = string4.lastIndexOf(47);
            String string5 = string3 = n >= 0 ? string4.substring(n + 1) : string4;
            if (this.isIncluded(string3) && !this.isExcluded(string3)) continue;
            iterator.remove();
        }
        return collection;
    }
}

