/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.composite;

import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.composite.CompositeBase;
import org.eclipse.osgi.internal.composite.CompositeHelper;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.service.internal.composite.CompositeModule;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.service.framework.SurrogateBundle;

public class SurrogateImpl
extends CompositeBase
implements SurrogateBundle {
    private final CompositeBundle composite = (CompositeBundle)FrameworkProperties.getProperties().get(PROP_COMPOSITE);

    public SurrogateImpl(BundleData bundleData, org.eclipse.osgi.framework.internal.core.Framework framework) throws BundleException {
        super(bundleData, framework);
    }

    protected Framework findCompanionFramework(org.eclipse.osgi.framework.internal.core.Framework framework, BundleData bundleData) {
        return (Framework)FrameworkProperties.getProperties().get(PROP_PARENTFRAMEWORK);
    }

    public BundleContext getCompositeBundleContext() {
        return this.composite.getBundleContext();
    }

    protected Bundle getCompanionBundle() {
        return this.composite;
    }

    protected boolean isSurrogate() {
        return true;
    }

    public boolean giveExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        if (this.resolving.get() == null) {
            return false;
        }
        if (exportPackageDescriptionArray == null) {
            CompositeHelper.setDisabled(true, this.getBundleDescription());
            return true;
        }
        return this.validExports(exportPackageDescriptionArray);
    }

    private boolean validExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        CompositeModule compositeModule = (CompositeModule)((Object)this.getCompanionBundle());
        BundleDescription bundleDescription = compositeModule.getCompositeDescription();
        ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getExportPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray2.length) {
                if (exportPackageDescriptionArray[n].getName().equals(exportPackageDescriptionArray2[n2].getName()) && !this.validateExport(exportPackageDescriptionArray[n], exportPackageDescriptionArray2[n2])) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    private boolean validateExport(ExportPackageDescription exportPackageDescription, ExportPackageDescription exportPackageDescription2) {
        Version version = exportPackageDescription.getVersion();
        Version version2 = exportPackageDescription2.getVersion();
        if (!version2.equals(Version.emptyVersion) && !version.equals(version2)) {
            return false;
        }
        if (!ResolverBundle.equivalentMaps(exportPackageDescription2.getAttributes(), exportPackageDescription.getAttributes(), false)) {
            return false;
        }
        return ResolverBundle.equivalentMaps(exportPackageDescription2.getDirectives(), exportPackageDescription.getDirectives(), false);
    }

    protected void startHook() {
        ((CompositeModule)((Object)this.getCompanionBundle())).started(this);
    }

    protected void stopHook() {
        ((CompositeModule)((Object)this.getCompanionBundle())).stopped(this);
    }
}

