/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemBundleData
extends BaseData {
    private static final String OSGI_FRAMEWORK = "osgi.framework";

    public SystemBundleData(BaseAdaptor baseAdaptor) throws BundleException {
        super(0L, baseAdaptor);
        File file = this.getOsgiBase();
        this.createBundleFile(file);
        this.manifest = this.createManifest(file);
        this.setMetaData();
        this.setLastModified(System.currentTimeMillis());
        StorageHook[] storageHookArray = baseAdaptor.getHookRegistry().getStorageHooks();
        StorageHook[] storageHookArray2 = new StorageHook[storageHookArray.length];
        int n = 0;
        while (n < storageHookArray.length) {
            storageHookArray2[n] = storageHookArray[n].create(this);
            ++n;
        }
        this.setStorageHooks(storageHookArray2);
    }

    private File getOsgiBase() {
        String string = FrameworkProperties.getProperty(OSGI_FRAMEWORK);
        if (string != null && string.startsWith("file:")) {
            return new File(string.substring(5));
        }
        try {
            URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            if ("file".equals(uRL.getProtocol())) {
                return new File(uRL.getPath());
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private Headers<String, String> createManifest(File file) throws BundleException {
        InputStream inputStream = null;
        if (file != null && file.exists()) {
            try {
                BundleEntry bundleEntry = this.getBundleFile().getEntry("META-INF/MANIFEST.MF");
                if (bundleEntry != null) {
                    inputStream = bundleEntry.getInputStream();
                }
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = this.getManifestAsResource();
        }
        if (Debug.DEBUG_GENERAL && inputStream == null) {
            Debug.println("Unable to find system bundle manifest META-INF/MANIFEST.MF");
        }
        if (inputStream == null) {
            throw new BundleException(AdaptorMsg.SYSTEMBUNDLE_MISSING_MANIFEST, 3);
        }
        return Headers.parseManifest(inputStream);
    }

    private InputStream getManifestAsResource() {
        URL uRL = this.getManifestURL();
        try {
            return uRL == null ? null : uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL getManifestURL() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader != null ? classLoader.getResources("META-INF/MANIFEST.MF") : ClassLoader.getSystemResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try {
                    Headers<String, String> headers = Headers.parseManifest(uRL.openStream());
                    if (!"true".equals(headers.get("Eclipse-SystemBundle"))) continue;
                    return uRL;
                }
                catch (BundleException bundleException) {}
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private void createBundleFile(File file) {
        if (file != null) {
            try {
                this.bundleFile = this.getAdaptor().createBundleFile(file, this);
            }
            catch (IOException iOException) {}
        } else {
            this.bundleFile = new BundleFile(file){

                @Override
                public File getFile(String string, boolean bl) {
                    return null;
                }

                @Override
                public BundleEntry getEntry(String string) {
                    if ("META-INF/MANIFEST.MF".equals(string)) {
                        System.err.println(new StringBuffer("Getting system bundle manifest: ").append(string).toString());
                        return new BundleEntry(){

                            public InputStream getInputStream() throws IOException {
                                return SystemBundleData.this.getManifestURL().openStream();
                            }

                            public long getSize() {
                                return 0L;
                            }

                            public String getName() {
                                return "META-INF/MANIFEST.MF";
                            }

                            public long getTime() {
                                return 0L;
                            }

                            public URL getLocalURL() {
                                return SystemBundleData.this.getManifestURL();
                            }

                            public URL getFileURL() {
                                return null;
                            }
                        };
                    }
                    return null;
                }

                @Override
                public Enumeration<String> getEntryPaths(String string) {
                    return null;
                }

                @Override
                public void close() {
                }

                @Override
                public void open() {
                }

                @Override
                public boolean containsDir(String string) {
                    return false;
                }
            };
        }
    }

    private void setMetaData() throws BundleException {
        this.setLocation("System Bundle");
        BaseStorageHook.loadManifest(this, this.manifest);
    }

    @Override
    public BundleClassLoader createClassLoader(ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, String[] stringArray) {
        return null;
    }

    public File createGenerationDir() {
        return null;
    }

    @Override
    public String findLibrary(String string) {
        return null;
    }

    @Override
    public void installNativeCode(String[] stringArray) throws BundleException {
    }

    @Override
    public int getStartLevel() {
        return 0;
    }

    @Override
    public int getStatus() {
        return 1;
    }

    @Override
    public void save() {
    }
}

