/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.baseadaptor.loader.FragmentClasspath;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevClassLoadingHook
implements ClassLoadingHook,
HookConfigurator,
KeyedElement {
    public static final String KEY;
    public static final int HASHCODE;
    private static final String FRAGMENT = "@fragment@";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.baseadaptor.DevClassLoadingHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
    }

    @Override
    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        return null;
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        String[] stringArray;
        String[] stringArray2 = stringArray = !DevClassPathHelper.inDevelopmentMode() ? null : DevClassPathHelper.getDevClassPath(baseData.getSymbolicName());
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        if (arrayList.size() > 0 && arrayList.get(0).getUserObject(KEY) != null) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (ClasspathManager.addClassPathEntry(arrayList, stringArray[n], classpathManager, baseData, protectionDomain)) {
                bl = true;
            } else {
                ClasspathEntry classpathEntry;
                Object object;
                String string2 = stringArray[n];
                boolean bl2 = string2.endsWith(FRAGMENT);
                if (!bl2 && string2.indexOf("..") >= 0) {
                    object = baseData.getBundleFile().getBaseFile();
                    if (((File)object).isDirectory() && (classpathEntry = classpathManager.getExternalClassPath(new File((File)object, string2).getAbsolutePath(), baseData, protectionDomain)) != null) {
                        arrayList.add(classpathEntry);
                        bl = true;
                    }
                } else {
                    if (bl2) {
                        string2 = string2.substring(0, string2.length() - FRAGMENT.length());
                    }
                    if ((object = this.findFragmentSource(baseData, string2, classpathManager, bl2)) != null && (classpathEntry = classpathManager.getExternalClassPath(string2, (BaseData)object, protectionDomain)) != null) {
                        arrayList.add(classpathEntry);
                        bl = true;
                    }
                }
            }
            ++n;
        }
        if (bl && arrayList.size() > 0) {
            arrayList.get(0).addUserObject(this);
        }
        return bl;
    }

    private BaseData findFragmentSource(BaseData baseData, String string, ClasspathManager classpathManager, boolean bl) {
        if (baseData != classpathManager.getBaseData()) {
            return baseData;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            return baseData;
        }
        FragmentClasspath[] fragmentClasspathArray = classpathManager.getFragmentClasspaths();
        int n = 0;
        while (n < fragmentClasspathArray.length) {
            BundleFile bundleFile = fragmentClasspathArray[n].getBundleData().getBundleFile();
            File file2 = bundleFile.getBaseFile();
            if (file2 != null && file.getPath().startsWith(file2.getPath())) {
                return fragmentClasspathArray[n].getBundleData();
            }
            ++n;
        }
        return bl ? null : baseData;
    }

    @Override
    public String findLibrary(BaseData baseData, String string) {
        return null;
    }

    @Override
    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    @Override
    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        return null;
    }

    @Override
    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        if (DevClassPathHelper.inDevelopmentMode()) {
            hookRegistry.addClassLoadingHook(new DevClassLoadingHook());
        }
    }

    @Override
    public boolean compare(KeyedElement keyedElement) {
        return keyedElement.getKey() == KEY;
    }

    @Override
    public Object getKey() {
        return KEY;
    }

    @Override
    public int getKeyHashCode() {
        return HASHCODE;
    }
}

