/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFileWrapperChain;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.baseadaptor.bundlefile.NestedDirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BasePermissionStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.internal.baseadaptor.BundleInstall;
import org.eclipse.osgi.internal.baseadaptor.BundleUninstall;
import org.eclipse.osgi.internal.baseadaptor.BundleUpdate;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.storagemanager.ManagedOutputStream;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStorage
implements SynchronousBundleListener {
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin";
    private static final String OPTION_PLATFORM_ADMIN_RESOLVER = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver";
    private static final String OPTION_MONITOR_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.osgi/eclipseadaptor/resolver/reader/timing";
    private static final String PROP_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_BUNDLE_STORE = "osgi.bundlestore";
    static final String DATA_DIR_NAME = "data";
    static final String LIB_TEMP = "libtemp";
    private static final String PROP_ENABLE_STATE_SAVER = "eclipse.enableStateSaver";
    static final String BUNDLEFILE_NAME = "bundlefile";
    private static final String PROP_CLEAN = "osgi.clean";
    public static final byte BUNDLEDATA_VERSION = 18;
    public static final byte EXTENSION_INITIALIZE = 1;
    public static final byte EXTENSION_INSTALLED = 2;
    public static final byte EXTENSION_UNINSTALLED = 4;
    public static final byte EXTENSION_UPDATED = 8;
    public static final int TYPE_DIRECTORYBUNDLE = 0x10000000;
    public static final int TYPE_FILEBUNDLE = 0x20000000;
    public static final String DELETE_FLAG = ".delete";
    private static final String PERM_DATA_FILE = ".permdata";
    private static final byte PERMDATA_VERSION = 1;
    private MRUBundleFileList mruList = new MRUBundleFileList();
    BaseAdaptor adaptor;
    private String installPath;
    private StorageManager storageManager;
    private StateManager stateManager;
    private KeyedHashSet storageHooks = new KeyedHashSet(5, false);
    private BundleContext context;
    private SynchronousBundleListener extensionListener;
    private final Method addFwkURLMethod;
    private final Method addExtURLMethod;
    private String[] configuredExtensions;
    private long timeStamp = 0L;
    private int initialBundleStartLevel = 1;
    private final Object nextIdMonitor = new Object();
    private volatile long nextId = 1L;
    private File bundleStoreRoot;
    private BasePermissionStorage permissionStorage;
    private StateSaver stateSaver;
    private boolean invalidState;
    private boolean storageManagerClosed;
    static /* synthetic */ Class class$0;

    BaseStorage() {
        this.addFwkURLMethod = BaseStorage.findAddURLMethod(this.getFwkClassLoader(), "addURL");
        this.addExtURLMethod = BaseStorage.findAddURLMethod(this.getExtClassLoader(), "addURL");
    }

    public void initialize(BaseAdaptor baseAdaptor) throws IOException {
        Location location;
        this.adaptor = baseAdaptor;
        BaseStorage.setDebugOptions();
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_CLEAN)).booleanValue()) {
            this.cleanOSGiCache();
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            URL uRL = location.getURL();
            this.installPath = uRL.getPath();
        }
        boolean bl = LocationManager.getConfigurationLocation().isReadOnly();
        this.storageManager = this.initFileManager(LocationManager.getOSGiConfigurationDir(), bl ? "none" : null, bl);
        this.storageManagerClosed = false;
        StorageHook[] storageHookArray = baseAdaptor.getHookRegistry().getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length) {
            this.storageHooks.add(storageHookArray[n]);
            ++n;
        }
    }

    private static Method findAddURLMethod(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return null;
        }
        Class<?> clazz = classLoader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        return BaseStorage.findMethod(clazz, string, classArray);
    }

    private static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        return BaseStorage.findMethod(clazz.getSuperclass(), string, classArray);
    }

    private static void callAddURLMethod(ClassLoader classLoader, Method method, URL uRL) throws InvocationTargetException {
        try {
            method.invoke((Object)classLoader, uRL);
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable);
        }
    }

    private ClassLoader getFwkClassLoader() {
        return this.getClass().getClassLoader();
    }

    private ClassLoader getExtClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = classLoader.getParent();
        while (classLoader2 != null && classLoader2.getParent() != null) {
            classLoader2 = classLoader2.getParent();
        }
        return classLoader2;
    }

    private static void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        StateManager.DEBUG = frameworkDebugOptions != null;
        StateManager.DEBUG_READER = frameworkDebugOptions.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateManager.MONITOR_PLATFORM_ADMIN = frameworkDebugOptions.getBooleanOption(OPTION_MONITOR_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN = frameworkDebugOptions.getBooleanOption(OPTION_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER = frameworkDebugOptions.getBooleanOption(OPTION_PLATFORM_ADMIN_RESOLVER, false);
    }

    protected StorageManager initFileManager(File file, String string, boolean bl) throws IOException {
        StorageManager storageManager = new StorageManager(file, string, bl);
        try {
            storageManager.open(!bl);
        }
        catch (IOException iOException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println(new StringBuffer("Error reading framework metadata: ").append(iOException.getMessage()).toString());
                Debug.printStackTrace(iOException);
            }
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, iOException.getMessage());
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, iOException, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            FrameworkProperties.setProperty("eclipse.exitcode", "15");
            String string3 = new StringBuffer("<title>").append(AdaptorMsg.ADAPTOR_STORAGE_INIT_FAILED_TITLE).append("</title>").append(NLS.bind(AdaptorMsg.ADAPTOR_STORAGE_INIT_FAILED_MSG, file)).append("\n").append(iOException.getMessage()).toString();
            FrameworkProperties.setProperty("eclipse.exitdata", string3);
            throw iOException;
        }
        return storageManager;
    }

    public boolean isReadOnly() {
        return this.storageManager.isReadOnly();
    }

    public void compact() {
        if (!this.isReadOnly()) {
            this.compact(this.getBundleStoreRoot());
        }
    }

    private void compact(File file) {
        String[] stringArray;
        if (Debug.DEBUG_GENERAL) {
            Debug.println(new StringBuffer("compact(").append(file.getPath()).append(")").toString());
        }
        if ((stringArray = file.list()) == null) {
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2;
            if (!DATA_DIR_NAME.equals(stringArray[n2]) && (file2 = new File(file, stringArray[n2])).isDirectory()) {
                File file3 = new File(file2, DELETE_FLAG);
                if (file3.exists()) {
                    if (!AdaptorUtil.rm(file2) && !file3.exists()) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println(new StringBuffer("Unable to write ").append(file3.getPath()).append(": ").append(iOException.getMessage()).toString());
                            }
                        }
                    }
                } else {
                    this.compact(file2);
                }
            }
            ++n2;
        }
    }

    public long getFreeSpace() throws IOException {
        return -1L;
    }

    public File getDataFile(BaseData baseData, String string) {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            return null;
        }
        return baseStorageHook.getDataFile(string);
    }

    BaseAdaptor getAdaptor() {
        return this.adaptor;
    }

    public void installNativeCode(BaseData baseData, String[] stringArray) throws BundleException {
        BaseStorageHook baseStorageHook;
        if (stringArray.length > 0 && (baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY)) != null) {
            baseStorageHook.installNativePaths(stringArray);
        }
    }

    public Dictionary<String, String> loadManifest(BaseData baseData) throws BundleException {
        return this.loadManifest(baseData, false);
    }

    public Dictionary<String, String> loadManifest(BaseData baseData, boolean bl) throws BundleException {
        Dictionary<String, String> dictionary = null;
        StorageHook[] storageHookArray = baseData.getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length && dictionary == null) {
            dictionary = storageHookArray[n].getManifest(bl);
            ++n;
        }
        if (dictionary == null) {
            dictionary = AdaptorUtil.loadManifestFrom(baseData);
        }
        if (dictionary == null) {
            throw new BundleException(NLS.bind(AdaptorMsg.MANIFEST_NOT_FOUND_EXCEPTION, "META-INF/MANIFEST.MF", baseData.getLocation()), 3);
        }
        return dictionary;
    }

    public File getExtractFile(BaseData baseData, String string) {
        File file;
        File file2;
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            return null;
        }
        File file3 = baseStorageHook.getGenerationDir();
        if (file3 != null && (file2 = new File(file3, string)).exists()) {
            return file2;
        }
        file2 = baseStorageHook.getParentGenerationDir();
        if (file2 != null && (file = new File(file2, string)).exists()) {
            return file;
        }
        file = baseStorageHook.createGenerationDir();
        if (file != null && file.exists()) {
            return new File(file, string);
        }
        return null;
    }

    public BaseData[] getInstalledBundles() {
        try {
            return this.readBundleDatas();
        }
        catch (Throwable throwable) {
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "Error loading bundle datas.  Recalculating cache.", 0, throwable, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseData[] readBundleDatas() {
        InputStream inputStream = this.findStorageStream(".bundledata");
        if (inputStream == null) {
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                ArrayList<BaseData> arrayList;
                StorageHook[] storageHookArray;
                byte by = dataInputStream.readByte();
                if (by != 18) {
                    return null;
                }
                this.timeStamp = dataInputStream.readLong();
                this.initialBundleStartLevel = dataInputStream.readInt();
                this.nextId = dataInputStream.readLong();
                int n = dataInputStream.readInt();
                if (n != (storageHookArray = this.adaptor.getHookRegistry().getStorageHooks()).length) {
                    return null;
                }
                int n2 = 0;
                while (n2 < n) {
                    arrayList = storageHookArray[n2].getKey();
                    int n3 = storageHookArray[n2].getStorageVersion();
                    if (!((Object)arrayList).equals(dataInputStream.readUTF())) return null;
                    if (n3 != dataInputStream.readInt()) {
                        return null;
                    }
                    ++n2;
                }
                n2 = dataInputStream.readInt();
                arrayList = new ArrayList<BaseData>(n2);
                long l = -1L;
                boolean bl = false;
                int n4 = 0;
                while (n4 < n2) {
                    StorageHook[] storageHookArray2;
                    BaseData baseData;
                    boolean bl2;
                    block23: {
                        bl2 = false;
                        baseData = null;
                        try {
                            l = dataInputStream.readLong();
                            if (l != 0L) {
                                baseData = this.loadBaseData(l, dataInputStream);
                                baseData.getBundleFile();
                                storageHookArray2 = baseData.getStorageHooks();
                                int n5 = 0;
                                while (n5 < storageHookArray2.length) {
                                    storageHookArray2[n5].validate();
                                    ++n5;
                                }
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println(new StringBuffer("BundleData created: ").append(baseData).toString());
                                }
                                this.processExtension(baseData, (byte)1);
                                arrayList.add(baseData);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            bl = true;
                            bl2 = true;
                        }
                        catch (BundleException bundleException) {
                            bl = true;
                            bl2 = true;
                        }
                        catch (IOException iOException) {
                            bl = true;
                            bl2 = true;
                            if (!Debug.DEBUG_GENERAL) break block23;
                            Debug.println(new StringBuffer("Error reading framework metadata: ").append(iOException.getMessage()).toString());
                            Debug.printStackTrace(iOException);
                        }
                    }
                    if (bl2 && baseData != null) {
                        storageHookArray2 = (StorageHook[])baseData.getStorageHook(BaseStorageHook.KEY);
                        storageHookArray2.delete(true, 1);
                    }
                    ++n4;
                }
                if (bl) {
                    FrameworkProperties.setProperty("eclipse.refreshBundles", "true");
                }
                BaseData[] baseDataArray = arrayList.toArray(new BaseData[arrayList.size()]);
                return baseDataArray;
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.println(new StringBuffer("Error reading framework metadata: ").append(iOException.getMessage()).toString());
            Debug.printStackTrace(iOException);
            return null;
        }
    }

    void saveAllData(boolean bl) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Saving framework data ...");
        }
        if (this.storageManagerClosed) {
            try {
                this.storageManager.open(!LocationManager.getConfigurationLocation().isReadOnly());
                this.storageManagerClosed = false;
            }
            catch (IOException iOException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, iOException.getMessage());
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, iOException, null);
                this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            }
        }
        this.saveBundleDatas();
        this.saveStateData(bl);
        this.savePermissionStorage();
        if (bl) {
            this.stateManager.stopDataManager();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BasePermissionStorage readPermissionData() {
        BasePermissionStorage basePermissionStorage = new BasePermissionStorage(this);
        InputStream inputStream = this.findStorageStream(PERM_DATA_FILE);
        if (inputStream == null) {
            return basePermissionStorage;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                String[] stringArray;
                int n;
                int n2;
                if (1 != dataInputStream.readByte()) {
                    BasePermissionStorage basePermissionStorage2 = basePermissionStorage;
                    return basePermissionStorage2;
                }
                int n3 = dataInputStream.readInt();
                if (n3 > 0) {
                    String[] stringArray2 = new String[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        stringArray2[n2] = dataInputStream.readUTF();
                        ++n2;
                    }
                    basePermissionStorage.setPermissionData(null, stringArray2);
                }
                if ((n = dataInputStream.readInt()) > 0) {
                    n2 = 0;
                    while (n2 < n) {
                        stringArray = dataInputStream.readUTF();
                        n3 = dataInputStream.readInt();
                        String[] stringArray3 = new String[n3];
                        int n4 = 0;
                        while (n4 < n3) {
                            stringArray3[n4] = dataInputStream.readUTF();
                            ++n4;
                        }
                        basePermissionStorage.setPermissionData((String)stringArray, stringArray3);
                        ++n2;
                    }
                }
                if ((n2 = dataInputStream.readInt()) > 0) {
                    stringArray = new String[n2];
                    int n5 = 0;
                    while (n5 < n2) {
                        stringArray[n5] = dataInputStream.readUTF();
                        ++n5;
                    }
                    basePermissionStorage.saveConditionalPermissionInfos(stringArray);
                }
                basePermissionStorage.setDirty(false);
                return basePermissionStorage;
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
        }
        return basePermissionStorage;
    }

    private void savePermissionStorage() {
        if (this.permissionStorage == null || this.isReadOnly() || !this.permissionStorage.isDirty()) {
            return;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("About to save permission data ...");
        }
        try {
            ManagedOutputStream managedOutputStream = this.storageManager.getOutputStream(PERM_DATA_FILE);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(managedOutputStream));
            boolean bl = true;
            try {
                String[] stringArray;
                String[] stringArray2;
                dataOutputStream.writeByte(1);
                String[] stringArray3 = this.permissionStorage.getPermissionData(null);
                dataOutputStream.writeInt(stringArray3 == null ? 0 : stringArray3.length);
                if (stringArray3 != null) {
                    int n = 0;
                    while (n < stringArray3.length) {
                        dataOutputStream.writeUTF(stringArray3[n]);
                        ++n;
                    }
                }
                dataOutputStream.writeInt((stringArray2 = this.permissionStorage.getLocations()) == null ? 0 : stringArray2.length);
                if (stringArray2 != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        dataOutputStream.writeUTF(stringArray2[n]);
                        String[] stringArray4 = this.permissionStorage.getPermissionData(stringArray2[n]);
                        dataOutputStream.writeInt(stringArray4 == null ? 0 : stringArray4.length);
                        if (stringArray4 != null) {
                            int n2 = 0;
                            while (n2 < stringArray4.length) {
                                dataOutputStream.writeUTF(stringArray4[n2]);
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
                dataOutputStream.writeInt((stringArray = this.permissionStorage.getConditionalPermissionInfos()) == null ? 0 : stringArray.length);
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        dataOutputStream.writeUTF(stringArray[n]);
                        ++n;
                    }
                }
                dataOutputStream.close();
                this.permissionStorage.setDirty(false);
                bl = false;
            }
            catch (Throwable throwable) {
                if (bl) {
                    managedOutputStream.abort();
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bl) {
                managedOutputStream.abort();
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
            return;
        }
    }

    private void saveBundleDatas() {
        if (this.stateManager == null || this.isReadOnly() || this.timeStamp == this.stateManager.getSystemState().getTimeStamp() && !this.stateManager.saveNeeded()) {
            return;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Saving bundle data ...");
        }
        try {
            ManagedOutputStream managedOutputStream = this.storageManager.getOutputStream(".bundledata");
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(managedOutputStream));
            boolean bl = true;
            try {
                dataOutputStream.writeByte(18);
                dataOutputStream.writeLong(this.stateManager.getSystemState().getTimeStamp());
                dataOutputStream.writeInt(this.initialBundleStartLevel);
                dataOutputStream.writeLong(this.nextId);
                StorageHook[] storageHookArray = this.adaptor.getHookRegistry().getStorageHooks();
                dataOutputStream.writeInt(storageHookArray.length);
                int n = 0;
                while (n < storageHookArray.length) {
                    dataOutputStream.writeUTF((String)storageHookArray[n].getKey());
                    dataOutputStream.writeInt(storageHookArray[n].getStorageVersion());
                    ++n;
                }
                Bundle[] bundleArray = this.context.getBundles();
                dataOutputStream.writeInt(bundleArray.length);
                int n2 = 0;
                while (n2 < bundleArray.length) {
                    long l = bundleArray[n2].getBundleId();
                    dataOutputStream.writeLong(l);
                    if (l != 0L) {
                        BundleData bundleData = ((AbstractBundle)bundleArray[n2]).getBundleData();
                        this.saveBaseData((BaseData)bundleData, dataOutputStream);
                    }
                    ++n2;
                }
                dataOutputStream.close();
                this.timeStamp = this.stateManager.getSystemState().getTimeStamp();
                bl = false;
            }
            catch (Throwable throwable) {
                if (bl) {
                    managedOutputStream.abort();
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bl) {
                managedOutputStream.abort();
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
            return;
        }
    }

    private void cleanRemovalPendings(State state, BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray.length == 0) {
            return;
        }
        state.resolve(bundleDescriptionArray);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            Object object = bundleDescriptionArray[n].getUserObject();
            if (object instanceof BundleLoaderProxy) {
                BundleLoader.closeBundleLoader((BundleLoaderProxy)object);
                try {
                    ((BundleLoaderProxy)object).getBundleData().close();
                }
                catch (IOException iOException) {}
            } else if (object instanceof BundleData) {
                try {
                    ((BundleData)object).close();
                }
                catch (IOException iOException) {}
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateData(boolean bl) {
        BundleDescription[] bundleDescriptionArray;
        State state = this.stateManager.getSystemState();
        if (bl && "true".equals(FrameworkProperties.getProperty("osgi.forcedRestart"))) {
            state.setTimeStamp(state.getTimeStamp() + 1L);
        }
        if ((bundleDescriptionArray = state.getRemovalPending()).length > 0) {
            if (!bl) {
                return;
            }
            this.cleanRemovalPendings(state, bundleDescriptionArray);
        }
        if (this.stateManager == null || this.isReadOnly() || !this.stateManager.saveNeeded()) {
            return;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Saving resolver state data ...");
        }
        File file = null;
        File file2 = null;
        try {
            try {
                file = File.createTempFile(".state", ".new", LocationManager.getOSGiConfigurationDir());
                file2 = File.createTempFile(".lazy", ".new", LocationManager.getOSGiConfigurationDir());
                if (bl) {
                    this.stateManager.shutdown(file, file2);
                } else {
                    StateManager stateManager = this.stateManager;
                    synchronized (stateManager) {
                        this.stateManager.update(file, file2);
                    }
                }
                this.storageManager.lookup(".state", true);
                this.storageManager.lookup(".lazy", true);
                this.storageManager.update(new String[]{".state", ".lazy"}, new String[]{file.getName(), file2.getName()});
            }
            catch (IOException iOException) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
                if (file != null && file.exists()) {
                    file.delete();
                }
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
        }
    }

    public PermissionStorage getPermissionStorage() {
        if (this.permissionStorage == null) {
            this.permissionStorage = this.readPermissionData();
        }
        return this.permissionStorage;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int n) {
        this.initialBundleStartLevel = n;
        this.requestSave();
    }

    public void save(BaseData baseData) {
        if (baseData.isDirty()) {
            --this.timeStamp;
            this.requestSave();
            baseData.setDirty(false);
        }
    }

    public BundleOperation installBundle(String string, URLConnection uRLConnection) {
        BaseData baseData = this.createBaseData(this.getNextBundleId(), string);
        return new BundleInstall(baseData, uRLConnection, this);
    }

    public BundleOperation updateBundle(BaseData baseData, URLConnection uRLConnection) {
        return new BundleUpdate(baseData, uRLConnection, this);
    }

    public BundleOperation uninstallBundle(BaseData baseData) {
        return new BundleUninstall(baseData, this);
    }

    protected Object getBundleContent(BaseData baseData) {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            throw new IllegalStateException();
        }
        return baseStorageHook.isReference() ? new File(baseStorageHook.getFileName()) : new File(baseStorageHook.getGenerationDir(), baseStorageHook.getFileName());
    }

    public BundleFile createBundleFile(Object object, BaseData baseData) throws IOException {
        BundleFile bundleFile;
        boolean bl = false;
        if (object == null) {
            bl = true;
            object = this.getBundleContent(baseData);
        }
        if ((bundleFile = baseData.getBundleFile(object, bl)) != null) {
            return bundleFile;
        }
        BundleFileFactoryHook[] bundleFileFactoryHookArray = this.adaptor.getHookRegistry().getBundleFileFactoryHooks();
        int n = 0;
        while (n < bundleFileFactoryHookArray.length && bundleFile == null) {
            bundleFile = bundleFileFactoryHookArray[n].createBundleFile(object, baseData, bl);
            ++n;
        }
        if (bundleFile == null && object instanceof File) {
            File file = (File)object;
            bundleFile = this.isDirectory(baseData, bl, file) ? new DirBundleFile(file) : new ZipBundleFile(file, baseData, this.getMRUList());
        }
        if (bundleFile == null && object instanceof String) {
            bundleFile = new NestedDirBundleFile(baseData.getBundleFile(), (String)object);
        }
        if (bundleFile == null) {
            throw new IOException(new StringBuffer("Cannot create bundle file for content of type: ").append(object.getClass().getName()).toString());
        }
        BundleFileWrapperFactoryHook[] bundleFileWrapperFactoryHookArray = this.adaptor.getHookRegistry().getBundleFileWrapperFactoryHooks();
        BundleFileWrapperChain bundleFileWrapperChain = bundleFileWrapperFactoryHookArray.length == 0 ? null : new BundleFileWrapperChain(bundleFile, null);
        int n2 = 0;
        while (n2 < bundleFileWrapperFactoryHookArray.length) {
            BundleFile bundleFile2 = bundleFileWrapperFactoryHookArray[n2].wrapBundleFile(bundleFile, object, baseData, bl);
            if (bundleFile2 != null && bundleFile2 != bundleFile) {
                bundleFileWrapperChain = new BundleFileWrapperChain(bundleFile2, bundleFileWrapperChain);
                bundleFile = bundleFileWrapperChain;
            }
            ++n2;
        }
        if (!bl) {
            baseData.setBundleFile(object, bundleFile);
        }
        return bundleFile;
    }

    private synchronized MRUBundleFileList getMRUList() {
        if (this.mruList == null) {
            this.mruList = new MRUBundleFileList();
        }
        return this.mruList;
    }

    private boolean isDirectory(BaseData baseData, boolean bl, File file) {
        if (!bl) {
            return file.isDirectory();
        }
        boolean bl2 = false;
        int n = baseData.getType();
        if ((n & 0x30000000) == 0) {
            bl2 = file.isDirectory();
            baseData.setType(n | (bl2 ? 0x10000000 : 0x20000000));
        } else {
            bl2 = (n & 0x10000000) != 0;
        }
        return bl2;
    }

    public synchronized StateManager getStateManager() {
        if (this.stateManager != null) {
            return this.stateManager;
        }
        this.stateManager = this.readStateData();
        this.checkSystemState(this.stateManager.getSystemState());
        return this.stateManager;
    }

    private void checkSystemState(State state) {
        BundleDescription bundleDescription;
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        if (bundleDescriptionArray == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (this.adaptor.getBundle(bundleDescriptionArray[n].getBundleId()) == null) {
                state.removeBundle(bundleDescriptionArray[n]);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            state.resolve(false);
        }
        if ((bundleDescription = state.getBundle(0L)) == null || !bundleDescription.isResolved()) {
            ResolverError[] resolverErrorArray = bundleDescription == null ? new ResolverError[]{} : state.getResolverErrors(bundleDescription);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < resolverErrorArray.length) {
                stringBuffer.append(resolverErrorArray[n2].toString());
                if (n2 < resolverErrorArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            throw new IllegalStateException(NLS.bind(AdaptorMsg.SYSTEMBUNDLE_NOTRESOLVED, stringBuffer.toString()));
        }
    }

    private StateManager readStateData() {
        File[] fileArray = this.findStorageFiles(new String[]{".state", ".lazy"});
        File file = fileArray[0];
        File file2 = fileArray[1];
        this.stateManager = new StateManager(file, file2, this.context, this.timeStamp);
        State state = null;
        if (!this.invalidState && (state = this.stateManager.readSystemState()) != null) {
            return this.stateManager;
        }
        state = this.stateManager.createSystemState();
        Bundle[] bundleArray = this.context.getBundles();
        if (bundleArray == null) {
            return this.stateManager;
        }
        StateObjectFactory stateObjectFactory = this.stateManager.getFactory();
        int n = 0;
        while (n < bundleArray.length) {
            AbstractBundle abstractBundle = (AbstractBundle)bundleArray[n];
            try {
                Dictionary<String, String> dictionary = this.loadManifest((BaseData)abstractBundle.getBundleData(), true);
                BundleDescription bundleDescription = stateObjectFactory.createBundleDescription(state, dictionary, abstractBundle.getLocation(), abstractBundle.getBundleId());
                state.addBundle(bundleDescription);
            }
            catch (BundleException bundleException) {}
            ++n;
        }
        state.resolve();
        this.invalidState = false;
        return this.stateManager;
    }

    private File[] findStorageFiles(String[] stringArray) {
        File[] fileArray;
        block16: {
            block15: {
                fileArray = new File[stringArray.length];
                try {
                    int n = 0;
                    while (n < fileArray.length) {
                        fileArray[n] = this.storageManager.lookup(stringArray[n], false);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.DEBUG_GENERAL) break block15;
                    Debug.println(new StringBuffer("Error reading state file ").append(iOException.getMessage()).toString());
                    Debug.printStackTrace(iOException);
                }
            }
            boolean bl = true;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] == null || !fileArray[n].isFile()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                return fileArray;
            }
            Location location = null;
            Location location2 = LocationManager.getConfigurationLocation();
            if (location2 != null && (location = location2.getParentLocation()) != null) {
                try {
                    File file = new File(location.getURL().getFile(), "org.eclipse.osgi");
                    StorageManager storageManager = this.initFileManager(file, "none", true);
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        fileArray[n2] = storageManager.lookup(stringArray[n2], false);
                        ++n2;
                    }
                    storageManager.close();
                }
                catch (IOException iOException) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(new StringBuffer("Error reading state file ").append(iOException.getMessage()).toString());
                        Debug.printStackTrace(iOException);
                    }
                    break block16;
                }
            }
            try {
                if (!this.isReadOnly()) {
                    int n3 = 0;
                    while (n3 < fileArray.length) {
                        fileArray[n3] = this.storageManager.lookup(stringArray[n3], true);
                        ++n3;
                    }
                }
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block16;
                Debug.println(new StringBuffer("Error reading state file ").append(iOException.getMessage()).toString());
                Debug.printStackTrace(iOException);
            }
        }
        return fileArray;
    }

    public void frameworkStart(BundleContext bundleContext) {
        this.context = bundleContext;
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_ENABLE_STATE_SAVER, "true")).booleanValue()) {
            this.stateSaver = new StateSaver();
        }
    }

    public void frameworkStop(BundleContext bundleContext) {
        MRUBundleFileList mRUBundleFileList;
        if (this.stateSaver != null) {
            this.stateSaver.shutdown();
        }
        this.saveAllData(true);
        this.storageManager.close();
        this.storageManagerClosed = true;
        if (this.extensionListener != null) {
            this.context.removeBundleListener(this.extensionListener);
        }
        if ((mRUBundleFileList = this.mruList) != null) {
            mRUBundleFileList.shutdown();
        }
        this.mruList = null;
        this.stateManager = null;
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
        if (this.addFwkURLMethod != null) {
            properties.put("org.osgi.supports.framework.extension", "true");
        }
        properties.put(PROP_BUNDLE_STORE, this.getBundleStoreRoot().getAbsolutePath());
    }

    private InputStream findStorageStream(String string) {
        InputStream inputStream;
        block7: {
            inputStream = null;
            try {
                inputStream = this.storageManager.getInputStream(string);
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block7;
                Debug.println(new StringBuffer("Error reading framework metadata: ").append(iOException.getMessage()).toString());
                Debug.printStackTrace(iOException);
            }
        }
        if (inputStream == null) {
            Location location = LocationManager.getConfigurationLocation();
            Location location2 = null;
            if (location != null && (location2 = location.getParentLocation()) != null) {
                try {
                    File file = new File(location2.getURL().getFile(), "org.eclipse.osgi");
                    StorageManager storageManager = this.initFileManager(file, "none", true);
                    inputStream = storageManager.getInputStream(string);
                    storageManager.close();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
        return inputStream;
    }

    protected void saveBaseData(BaseData baseData, DataOutputStream dataOutputStream) throws IOException {
        StorageHook[] storageHookArray = baseData.getStorageHooks();
        dataOutputStream.writeInt(storageHookArray.length);
        int n = 0;
        while (n < storageHookArray.length) {
            dataOutputStream.writeUTF((String)storageHookArray[n].getKey());
            storageHookArray[n].save(dataOutputStream);
            ++n;
        }
    }

    protected BaseData loadBaseData(long l, DataInputStream dataInputStream) throws IOException {
        BaseData baseData = new BaseData(l, this.adaptor);
        int n = dataInputStream.readInt();
        StorageHook[] storageHookArray = new StorageHook[n];
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            StorageHook storageHook = (StorageHook)this.storageHooks.getByKey(string);
            if (storageHook == null) {
                throw new IOException();
            }
            storageHookArray[n2] = storageHook.load(baseData, dataInputStream);
            ++n2;
        }
        baseData.setStorageHooks(storageHookArray);
        return baseData;
    }

    protected BaseData createBaseData(long l, String string) {
        BaseData baseData = new BaseData(l, this.adaptor);
        baseData.setLocation(string);
        return baseData;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    private void cleanOSGiCache() {
        File file = LocationManager.getOSGiConfigurationDir();
        if (!AdaptorUtil.rm(file)) {
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, new StringBuffer("The -clean (osgi.clean) option was not successful. Unable to clean the storage area: ").append(file.getAbsolutePath()).toString(), 0, null, null));
        }
    }

    protected void processExtension(BaseData baseData, byte by) throws BundleException {
        if ((baseData.getType() & 2) != 0) {
            this.validateExtension(baseData);
            this.processFrameworkExtension(baseData, by);
        } else if ((baseData.getType() & 4) != 0) {
            this.validateExtension(baseData);
            this.processBootExtension(baseData, by);
        } else if ((baseData.getType() & 0x10) != 0) {
            this.validateExtension(baseData);
            this.processExtExtension(baseData, by);
        }
    }

    private void validateExtension(BundleData bundleData) throws BundleException {
        Dictionary<String, String> dictionary = bundleData.getManifest();
        if (dictionary.get("Import-Package") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_IMPORT_ERROR, bundleData.getLocation()), 3);
        }
        if (dictionary.get("Require-Bundle") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_REQUIRE_ERROR, bundleData.getLocation()), 3);
        }
        if (dictionary.get("Bundle-NativeCode") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_NATIVECODE_ERROR, bundleData.getLocation()), 3);
        }
    }

    protected void processFrameworkExtension(BaseData baseData, byte by) throws BundleException {
        if (this.addFwkURLMethod == null) {
            throw new BundleException("Framework extensions are not supported.", 1, new UnsupportedOperationException());
        }
        this.addExtensionContent(baseData, by, this.getFwkClassLoader(), this.addFwkURLMethod);
    }

    protected void processExtExtension(BaseData baseData, byte by) throws BundleException {
        if (this.addExtURLMethod == null) {
            throw new BundleException("Extension classpath extensions are not supported.", 1, new UnsupportedOperationException());
        }
        this.addExtensionContent(baseData, by, this.getExtClassLoader(), this.addExtURLMethod);
    }

    private void addExtensionContent(BaseData baseData, byte by, ClassLoader classLoader, Method method) {
        if ((by & 0xC) != 0) {
            return;
        }
        String[] stringArray = this.getConfiguredExtensions();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(baseData.getSymbolicName())) {
                return;
            }
            ++n;
        }
        if ((by & 2) != 0) {
            if (this.extensionListener == null) {
                this.extensionListener = this;
                this.context.addBundleListener(this.extensionListener);
            }
            return;
        }
        File[] fileArray = this.getExtensionFiles(baseData);
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2] != null) {
                try {
                    BaseStorage.callAddURLMethod(classLoader, method, AdaptorUtil.encodeFileURL(fileArray[n2]));
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), invocationTargetException);
                }
                catch (MalformedURLException malformedURLException) {
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), malformedURLException);
                }
            }
            ++n2;
        }
        try {
            classLoader.loadClass("thisIsNotAClass");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    protected String[] getConfiguredExtensions() {
        if (this.configuredExtensions != null) {
            return this.configuredExtensions;
        }
        String string = FrameworkProperties.getProperty(PROP_FRAMEWORK_EXTENSIONS);
        this.configuredExtensions = string == null || string.trim().length() == 0 ? new String[0] : ManifestElement.getArrayFromList(string);
        return this.configuredExtensions;
    }

    protected void processBootExtension(BundleData bundleData, byte by) throws BundleException {
        throw new BundleException("Boot classpath extensions are not supported.", 1, new UnsupportedOperationException());
    }

    private void initBundleStoreRoot() {
        File file = LocationManager.getOSGiConfigurationDir();
        this.bundleStoreRoot = file != null ? new File(file, "bundles") : new File("bundles");
    }

    public File getBundleStoreRoot() {
        if (this.bundleStoreRoot == null) {
            this.initBundleStoreRoot();
        }
        return this.bundleStoreRoot;
    }

    protected File[] getExtensionFiles(BaseData baseData) {
        File[] fileArray = null;
        try {
            Object object;
            String[] stringArray = baseData.getClassPath();
            if (DevClassPathHelper.inDevelopmentMode()) {
                object = DevClassPathHelper.getDevClassPath(baseData.getSymbolicName());
                String[] stringArray2 = stringArray;
                stringArray = new String[stringArray2.length + ((String[])object).length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                System.arraycopy(object, 0, stringArray, stringArray2.length, ((Object)object).length);
            }
            object = new ArrayList(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (".".equals(stringArray[n])) {
                    object.add(baseData.getBundleFile().getBaseFile());
                } else {
                    File file = baseData.getBundleFile().getFile(stringArray[n], false);
                    if (file != null) {
                        object.add(file);
                    }
                }
                ++n;
            }
            return object.toArray(new File[object.size()]);
        }
        catch (BundleException bundleException) {
            this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), bundleException);
            return fileArray;
        }
    }

    void requestSave() {
        if (this.stateSaver == null) {
            return;
        }
        this.stateSaver.requestSave();
    }

    public void updateState(BaseData baseData, int n) throws BundleException {
        if (this.stateManager == null) {
            this.invalidState = true;
            return;
        }
        State state = this.stateManager.getSystemState();
        BundleDescription bundleDescription = null;
        BundleDescription bundleDescription2 = null;
        switch (n) {
            case 1: 
            case 8: {
                if (n == 8) {
                    bundleDescription = state.getBundle(baseData.getBundleID());
                }
                bundleDescription2 = this.stateManager.getFactory().createBundleDescription(state, baseData.getManifest(), baseData.getLocation(), baseData.getBundleID());
                bundleDescription2.setUserObject(baseData);
                if (bundleDescription == null) {
                    state.addBundle(bundleDescription2);
                    break;
                }
                state.updateBundle(bundleDescription2);
                break;
            }
            case 16: {
                state.removeBundle(baseData.getBundleID());
            }
        }
        if (bundleDescription2 != null) {
            this.validateNativeCodePaths(bundleDescription2, baseData);
        }
    }

    private void validateNativeCodePaths(BundleDescription bundleDescription, BaseData baseData) {
        NativeCodeSpecification nativeCodeSpecification = bundleDescription.getNativeCodeSpecification();
        if (nativeCodeSpecification == null) {
            return;
        }
        NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
        int n = 0;
        while (n < nativeCodeDescriptionArray.length) {
            BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
            if (baseStorageHook != null) {
                try {
                    baseStorageHook.validateNativePaths(nativeCodeDescriptionArray[n].getNativePaths());
                }
                catch (BundleException bundleException) {
                    this.stateManager.getSystemState().setNativePathsInvalid(nativeCodeDescriptionArray[n], true);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextBundleId() {
        Object object = this.nextIdMonitor;
        synchronized (object) {
            return this.nextId++;
        }
    }

    @Override
    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() != 32) {
            return;
        }
        BaseData baseData = (BaseData)((AbstractBundle)bundleEvent.getBundle()).getBundleData();
        try {
            if ((baseData.getType() & 2) != 0) {
                this.processFrameworkExtension(baseData, (byte)1);
            } else if ((baseData.getType() & 4) != 0) {
                this.processBootExtension(baseData, (byte)1);
            } else if ((baseData.getType() & 0x10) != 0) {
                this.processExtExtension(baseData, (byte)1);
            }
        }
        catch (BundleException bundleException) {}
    }

    public String copyToTempLibrary(BaseData baseData, String string) throws IOException {
        File file = this.getBundleStoreRoot();
        File file2 = new File(file, LIB_TEMP);
        File file3 = new File(string);
        String string2 = file3.getName();
        File file4 = null;
        File file5 = null;
        Long l = new Long(baseData.getBundleID());
        int n = 0;
        while (n < Integer.MAX_VALUE) {
            file4 = new File(file2, new StringBuffer(String.valueOf(l.toString())).append("_").append(new Integer(n).toString()).toString());
            file5 = new File(file4, string2);
            if (!file4.exists() || !file5.exists()) break;
            ++n;
        }
        if (!file4.exists()) {
            file4.mkdirs();
            file4.deleteOnExit();
            File file6 = new File(file2, DELETE_FLAG);
            if (!file6.exists()) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file6);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        FileInputStream fileInputStream = new FileInputStream(file3);
        AdaptorUtil.readFile(fileInputStream, file5);
        BundleFile.setPermissions(file5);
        file5.deleteOnExit();
        return file5.getAbsolutePath();
    }

    private class StateSaver
    implements Runnable {
        private final long delay_interval;
        private final long max_total_delay_interval;
        private boolean shutdown = false;
        private long lastSaveTime = 0L;
        private Thread runningThread = null;
        private Thread shutdownHook = null;

        StateSaver() {
            String string = FrameworkProperties.getProperty("eclipse.stateSaveDelayInterval");
            long l = 30000L;
            long l2 = 1800000L;
            if (string != null) {
                try {
                    long l3 = Long.parseLong(string);
                    if (l3 >= 1000L && l3 <= 1800000L) {
                        l = l3;
                        l2 = l3 * 60L;
                    } else if (l3 == 0L) {
                        l = 0L;
                        l2 = 0L;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.delay_interval = l;
            this.max_total_delay_interval = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var2_2 = var1_1 = BaseStorage.this.adaptor.getState();
            synchronized (var2_2) {
                var3_3 = this.lastSaveTime;
                var5_4 = 0L;
                do lbl-1000:
                // 3 sources

                {
                    block9: {
                        block8: {
                            block10: {
                                if (System.currentTimeMillis() - var3_3 <= this.max_total_delay_interval) break block10;
                                var5_4 = this.lastSaveTime;
                                break block9;
                            }
                            var7_5 = Math.min(this.delay_interval, this.lastSaveTime - var5_4);
                            var5_4 = this.lastSaveTime;
                            try {
                                if (this.shutdown) break block8;
                                var1_1.wait(var7_5);
                            }
                            catch (InterruptedException v0) {
                                var5_4 = this.lastSaveTime;
                                break block9;
                            }
                        }
                        if (!this.shutdown && var5_4 < this.lastSaveTime) ** GOTO lbl-1000
                    }
                    BaseStorage.this.saveAllData(false);
                } while (!this.shutdown && var5_4 < this.lastSaveTime);
                this.runningThread = null;
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException v1) {}
                this.shutdownHook = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            block8: {
                State state = BaseStorage.this.adaptor.getState();
                Thread thread = null;
                State state2 = state;
                synchronized (state2) {
                    this.shutdown = true;
                    thread = this.runningThread;
                    state.notifyAll();
                }
                try {
                    if (thread != null) {
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("About to join saving thread");
                        }
                        thread.join();
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("Joined with saving thread");
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!Debug.DEBUG_GENERAL) break block8;
                    Debug.println("Error shutdowning StateSaver: " + interruptedException.getMessage());
                    Debug.printStackTrace(interruptedException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestSave() {
            State state;
            State state2 = state = BaseStorage.this.adaptor.getState();
            synchronized (state2) {
                if (this.shutdown) {
                    return;
                }
                if (this.delay_interval == 0L) {
                    BaseStorage.this.saveAllData(false);
                    return;
                }
                this.lastSaveTime = System.currentTimeMillis();
                if (this.runningThread == null) {
                    this.shutdownHook = new Thread(new Runnable(){

                        public void run() {
                            StateSaver.this.shutdown();
                        }
                    });
                    this.runningThread = new Thread((Runnable)this, "State Saver");
                    this.runningThread.start();
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                }
            }
        }
    }
}

