/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();
    static final ClassLoader bootClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new ClassLoader(clazz.getClassLoader()){};
        }
    });
    static /* synthetic */ Class class$0;

    SecureAction() {
    }

    public static PrivilegedAction<SecureAction> createSecureAction() {
        return new PrivilegedAction<SecureAction>(){

            @Override
            public SecureAction run() {
                return new SecureAction();
            }
        };
    }

    public String getProperty(final String string) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FrameworkProperties.getProperty(string);
            }
        }, this.controlContext);
    }

    public String getProperty(final String string, final String string2) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(string, string2);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FrameworkProperties.getProperty(string, string2);
            }
        }, this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperties();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return FrameworkProperties.getProperties();
            }
        }, this.controlContext);
    }

    public FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public FileOutputStream getFileOutputStream(final File file, final boolean bl) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), bl);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file.getAbsolutePath(), bl);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public long length(final File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return new Long(file.length());
            }
        }, this.controlContext);
    }

    public String getCanonicalPath(final File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalPath();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return file.getCanonicalPath();
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public boolean exists(final File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public boolean isDirectory(final File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public long lastModified(final File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return new Long(file.lastModified());
            }
        }, this.controlContext);
    }

    public String[] list(final File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list();
            }
        }, this.controlContext);
    }

    public ZipFile getZipFile(final File file) throws IOException {
        try {
            if (System.getSecurityManager() == null) {
                return new ZipFile(file);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ZipFile>(){

                    @Override
                    public ZipFile run() throws IOException {
                        return new ZipFile(file);
                    }
                }, this.controlContext);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        catch (ZipException zipException) {
            ZipException zipException2 = new ZipException(new StringBuffer("Exception in opening zip file: ").append(file.getPath()).toString());
            zipException2.initCause(zipException);
            throw zipException2;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(new StringBuffer("Exception in opening zip file: ").append(file.getPath()).toString());
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public URL getURL(final String string, final String string2, final int n, final String string3, final URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(string, string2, n, string3, uRLStreamHandler);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(string, string2, n, string3, uRLStreamHandler);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof MalformedURLException) {
                throw (MalformedURLException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public Thread createThread(final Runnable runnable, final String string, final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return this.createThread0(runnable, string, classLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SecureAction.this.createThread0(runnable, string, classLoader);
            }
        }, this.controlContext);
    }

    Thread createThread0(Runnable runnable, String string, ClassLoader classLoader) {
        Thread thread = new Thread(runnable, string);
        if (classLoader != null) {
            thread.setContextClassLoader(classLoader);
        }
        return thread;
    }

    public <S> S getService(final ServiceReference<S> serviceReference, final BundleContext bundleContext) {
        if (System.getSecurityManager() == null) {
            return bundleContext.getService(serviceReference);
        }
        return (S)AccessController.doPrivileged(new PrivilegedAction<S>(){

            @Override
            public S run() {
                return bundleContext.getService(serviceReference);
            }
        }, this.controlContext);
    }

    public Class<?> forName(final String string) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    return Class.forName(string);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public Class<?> loadSystemClass(final String string) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            return classLoader != null ? classLoader.loadClass(string) : bootClassLoader.loadClass(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    return classLoader != null ? classLoader.loadClass(string) : bootClassLoader.loadClass(string);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public void open(final ServiceTracker<?, ?> serviceTracker) {
        if (System.getSecurityManager() == null) {
            serviceTracker.open();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                serviceTracker.open();
                return null;
            }
        }, this.controlContext);
    }

    public void start(final Bundle bundle, final int n) throws BundleException {
        if (System.getSecurityManager() == null) {
            bundle.start(n);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws BundleException {
                    bundle.start(n);
                    return null;
                }
            }, this.controlContext);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof BundleException) {
                throw (BundleException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public void start(Bundle bundle) throws BundleException {
        this.start(bundle, 0);
    }
}

