/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;

public class ReliableFile {
    public static final int OPEN_BEST_AVAILABLE = 0;
    public static final int OPEN_FAIL_ON_PRIMARY = 1;
    public static final int GENERATION_LATEST = 0;
    public static final int GENERATIONS_INFINITE = 0;
    public static final String tmpExt = ".tmp";
    public static final String PROP_MAX_BUFFER = "osgi.reliableFile.maxInputStreamBuffer";
    public static final String PROP_MAX_GENERATIONS = "osgi.ReliableFile.maxGenerations";
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    private static final int FILETYPE_VALID = 0;
    private static final int FILETYPE_CORRUPT = 1;
    private static final int FILETYPE_NOSIGNATURE = 2;
    private static final byte[] identifier1 = new byte[]{46, 99, 114, 99};
    private static final byte[] identifier2 = new byte[]{46, 118, 49, 10};
    private static final int BUF_SIZE = 4096;
    private static final int maxInputStreamBuffer;
    private static final int defaultMaxGenerations;
    private static final boolean fileSharing;
    private static File lastGenerationFile;
    private static int[] lastGenerations;
    private static final Object lastGenerationLock;
    private File referenceFile;
    private static Hashtable<File, CacheInfo> cacheFiles;
    private File inputFile = null;
    private File outputFile = null;
    private Checksum appendChecksum = null;

    static {
        lastGenerationFile = null;
        lastGenerations = null;
        lastGenerationLock = new Object();
        String string = FrameworkProperties.getProperty(PROP_MAX_BUFFER);
        int n = 131072;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        maxInputStreamBuffer = n;
        int n2 = 2;
        string = FrameworkProperties.getProperty(PROP_MAX_GENERATIONS);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        defaultMaxGenerations = n2;
        string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        boolean bl = true;
        if (string != null && string.equals("none")) {
            bl = false;
        }
        fileSharing = bl;
        cacheFiles = new Hashtable(20);
    }

    static ReliableFile getReliableFile(String string) throws IOException {
        return ReliableFile.getReliableFile(new File(string));
    }

    static ReliableFile getReliableFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new FileNotFoundException("file is a directory");
        }
        return new ReliableFile(file);
    }

    private ReliableFile(File file) {
        this.referenceFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getFileGenerations(File file) {
        Object object;
        block32: {
            Object object2;
            int n;
            ArrayList<Integer> arrayList;
            Object object3;
            block30: {
                block31: {
                    String[] stringArray;
                    int n2;
                    String string;
                    block28: {
                        block29: {
                            if (!fileSharing) {
                                object3 = lastGenerationLock;
                                synchronized (object3) {
                                    if (lastGenerationFile != null && file.equals(lastGenerationFile)) {
                                        return lastGenerations;
                                    }
                                }
                            }
                            object3 = null;
                            String string2 = file.getName();
                            string = String.valueOf(string2) + '.';
                            n2 = string.length();
                            File file2 = new File(file.getParent());
                            stringArray = file2.list();
                            if (stringArray != null) break block28;
                            if (fileSharing) break block29;
                            Object object4 = lastGenerationLock;
                            synchronized (object4) {
                                lastGenerationFile = file;
                                lastGenerations = (int[])object3;
                            }
                        }
                        return null;
                    }
                    arrayList = new ArrayList<Integer>(defaultMaxGenerations);
                    if (file.exists()) {
                        arrayList.add(new Integer(0));
                    }
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].startsWith(string)) {
                            try {
                                n = Integer.parseInt(stringArray[n3].substring(n2));
                                arrayList.add(new Integer(n));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        ++n3;
                    }
                    if (arrayList.size() != 0) break block30;
                    if (fileSharing) break block31;
                    Object object5 = lastGenerationLock;
                    synchronized (object5) {
                        lastGenerationFile = file;
                        lastGenerations = (int[])object3;
                    }
                }
                return null;
            }
            try {
                Object[] objectArray = arrayList.toArray();
                Arrays.sort(objectArray);
                object3 = new int[objectArray.length];
                n = 0;
                int n4 = objectArray.length - 1;
                while (n < objectArray.length) {
                    object3[n] = (Integer)objectArray[n4];
                    ++n;
                    --n4;
                }
                object = object3;
                if (fileSharing) break block32;
                object2 = lastGenerationLock;
            }
            catch (Throwable throwable) {
                if (!fileSharing) {
                    Object object6 = lastGenerationLock;
                    synchronized (object6) {
                        lastGenerationFile = file;
                        lastGenerations = (int[])object3;
                    }
                }
                throw throwable;
            }
            synchronized (object2) {
                lastGenerationFile = file;
                lastGenerations = (int[])object3;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream(int n, int n2) throws IOException {
        boolean bl;
        if (this.inputFile != null) {
            throw new IOException("Input stream already open");
        }
        int[] nArray = ReliableFile.getFileGenerations(this.referenceFile);
        if (nArray == null) {
            throw new FileNotFoundException("File not found");
        }
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        boolean bl2 = bl = (n2 & 1) != 0;
        if (bl && n == 0) {
            n = nArray[0];
        }
        File file2 = null;
        InputStream inputStream = null;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == 0 || nArray[n3] <= n && (!bl || nArray[n3] == n)) {
                CacheInfo cacheInfo;
                File file3 = nArray[n3] != 0 ? new File(file, String.valueOf(string) + '.' + nArray[n3]) : this.referenceFile;
                InputStream inputStream2 = null;
                Hashtable<File, CacheInfo> hashtable = cacheFiles;
                synchronized (hashtable) {
                    cacheInfo = cacheFiles.get(file3);
                    long l = file3.lastModified();
                    if (cacheInfo == null || l != cacheInfo.timeStamp) {
                        try {
                            inputStream2 = new FileInputStream(file3);
                            if (((InputStream)inputStream2).available() < maxInputStreamBuffer) {
                                inputStream2 = new BufferedInputStream(inputStream2);
                            }
                            Checksum checksum = this.getChecksumCalculator();
                            int n4 = this.getStreamType(inputStream2, checksum);
                            cacheInfo = new CacheInfo(n4, checksum, l);
                            cacheFiles.put(file3, cacheInfo);
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (bl) {
                    if (cacheInfo != null && cacheInfo.filetype == 0) {
                        this.inputFile = file3;
                        if (inputStream2 != null) {
                            return inputStream2;
                        }
                        return new FileInputStream(file3);
                    }
                    throw new IOException("ReliableFile is corrupt");
                }
                if (cacheInfo != null) {
                    switch (cacheInfo.filetype) {
                        case 0: {
                            this.inputFile = file3;
                            if (inputStream2 != null) {
                                return inputStream2;
                            }
                            return new FileInputStream(file3);
                        }
                        case 2: {
                            if (file2 != null) break;
                            file2 = file3;
                            inputStream = inputStream2;
                        }
                    }
                }
            }
            ++n3;
        }
        if (file2 != null) {
            this.inputFile = file2;
            if (inputStream != null) {
                return inputStream;
            }
            return new FileInputStream(file2);
        }
        throw new IOException("ReliableFile is corrupt");
    }

    OutputStream getOutputStream(boolean bl, int n) throws IOException {
        InputStream inputStream;
        if (this.outputFile != null) {
            throw new IOException("Output stream is already open");
        }
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        File file2 = File.createTempFile(string, tmpExt, file);
        if (!bl) {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.outputFile = file2;
            return fileOutputStream;
        }
        try {
            inputStream = this.getInputStream(n, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.outputFile = file2;
            return fileOutputStream;
        }
        try {
            CacheInfo cacheInfo = cacheFiles.get(this.inputFile);
            this.appendChecksum = cacheInfo.checksum;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            if (cacheInfo.filetype == 2) {
                ReliableFile.cp(inputStream, fileOutputStream, 0);
            } else {
                ReliableFile.cp(inputStream, fileOutputStream, 16);
            }
            this.outputFile = file2;
            FileOutputStream fileOutputStream2 = fileOutputStream;
            return fileOutputStream2;
        }
        finally {
            this.closeInputFile();
        }
    }

    void closeOutputFile(Checksum checksum) throws IOException {
        if (this.outputFile == null) {
            throw new IOException("Output stream is not open");
        }
        int[] nArray = ReliableFile.getFileGenerations(this.referenceFile);
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        File file2 = nArray == null ? new File(file, String.valueOf(string) + ".1") : new File(file, String.valueOf(string) + '.' + (nArray[0] + 1));
        ReliableFile.mv(this.outputFile, file2);
        this.outputFile = null;
        this.appendChecksum = null;
        CacheInfo cacheInfo = new CacheInfo(0, checksum, file2.lastModified());
        cacheFiles.put(file2, cacheInfo);
        this.cleanup(nArray, true);
        lastGenerationFile = null;
        lastGenerations = null;
    }

    void abortOutputFile() {
        if (this.outputFile == null) {
            return;
        }
        this.outputFile.delete();
        this.outputFile = null;
        this.appendChecksum = null;
    }

    File getOutputFile() {
        return this.outputFile;
    }

    void closeInputFile() {
        this.inputFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(int[] nArray, boolean bl) {
        if (nArray == null) {
            return;
        }
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        int n = nArray.length;
        if (nArray[n - 1] == 0) {
            --n;
        }
        int n2 = n - defaultMaxGenerations;
        if (bl) {
            ++n2;
        }
        if (n2 < 1) {
            return;
        }
        Hashtable<File, CacheInfo> hashtable = cacheFiles;
        synchronized (hashtable) {
            int n3 = 0;
            int n4 = n - n2;
            while (n3 < n4) {
                File file2 = new File(file, String.valueOf(string) + '.' + nArray[n3]);
                CacheInfo cacheInfo = cacheFiles.get(file2);
                if (cacheInfo != null && cacheInfo.filetype == 1) {
                    --n2;
                }
                ++n3;
            }
            n3 = n - 1;
            while (n2 > 0) {
                File file3 = new File(file, String.valueOf(string) + '.' + nArray[n3]);
                file3.delete();
                cacheFiles.remove(file3);
                --n3;
                --n2;
            }
        }
    }

    private static void mv(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            throw new IOException("rename failed");
        }
    }

    private static void cp(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        try {
            int n2 = inputStream.available();
            n2 = n > n2 ? 0 : (n2 -= n);
            if (n2 > 0) {
                int n3;
                int n4 = n2 > 4096 ? 4096 : n2;
                byte[] byArray = new byte[n4];
                int n5 = 0;
                while ((n3 = inputStream.read(byArray, 0, n2)) > 0) {
                    if (n5 + n3 >= n2) {
                        n3 = n2 - n5;
                    }
                    outputStream.write(byArray, 0, n3);
                    n5 += n3;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            outputStream.close();
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        outputStream.close();
    }

    public static boolean exists(File file) {
        String string = String.valueOf(file.getName()) + '.';
        File file2 = new File(file.getParent());
        int n = string.length();
        String[] stringArray = file2.list();
        if (stringArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith(string)) {
                try {
                    Integer.parseInt(stringArray[n2].substring(n));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        return file.exists();
    }

    public static long lastModified(File file) {
        int[] nArray = ReliableFile.getFileGenerations(file);
        if (nArray == null) {
            return 0L;
        }
        if (nArray[0] == 0) {
            return file.lastModified();
        }
        String string = file.getName();
        File file2 = new File(file.getParent());
        File file3 = new File(file2, String.valueOf(string) + '.' + nArray[0]);
        return file3.lastModified();
    }

    public long lastModified() {
        if (this.inputFile != null) {
            return this.inputFile.lastModified();
        }
        return 0L;
    }

    public static int lastModifiedVersion(File file) {
        int[] nArray = ReliableFile.getFileGenerations(file);
        if (nArray == null) {
            return -1;
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File file) {
        int[] nArray = ReliableFile.getFileGenerations(file);
        if (nArray == null) {
            return false;
        }
        String string = file.getName();
        File file2 = new File(file.getParent());
        Hashtable<File, CacheInfo> hashtable = cacheFiles;
        synchronized (hashtable) {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != 0) {
                    File file3 = new File(file2, String.valueOf(string) + '.' + nArray[n]);
                    if (file3.exists()) {
                        file3.delete();
                    }
                    cacheFiles.remove(file3);
                }
                ++n;
            }
        }
        return true;
    }

    public static String[] getBaseFiles(File file) throws IOException {
        Object object;
        if (!file.isDirectory()) {
            throw new IOException("Not a valid directory");
        }
        String[] stringArray = file.list();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length / 2);
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            int n2 = ((String)object).lastIndexOf(46);
            if (n2 != -1) {
                String string = ((String)object).substring(n2 + 1);
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                if (n3 != 0) {
                    String string2 = ((String)object).substring(0, n2);
                    hashSet.add(string2);
                }
            }
            ++n;
        }
        stringArray = new String[hashSet.size()];
        n = 0;
        object = hashSet.iterator();
        while (object.hasNext()) {
            stringArray[n++] = (String)object.next();
        }
        return stringArray;
    }

    public static void cleanupGenerations(File file) {
        ReliableFile reliableFile = new ReliableFile(file);
        int[] nArray = ReliableFile.getFileGenerations(file);
        reliableFile.cleanup(nArray, false);
        lastGenerationFile = null;
        lastGenerations = null;
    }

    public static void fileUpdated(File file) {
        lastGenerationFile = null;
        lastGenerations = null;
    }

    void writeChecksumSignature(OutputStream outputStream, Checksum checksum) throws IOException {
        outputStream.write(identifier1);
        outputStream.write(ReliableFile.intToHex((int)checksum.getValue()));
        outputStream.write(identifier2);
    }

    int getSignatureSize() throws IOException {
        CacheInfo cacheInfo;
        if (this.inputFile != null && (cacheInfo = cacheFiles.get(this.inputFile)) != null) {
            switch (cacheInfo.filetype) {
                case 0: 
                case 1: {
                    return 16;
                }
                case 2: {
                    return 0;
                }
            }
        }
        throw new IOException("ReliableFile signature size is unknown");
    }

    Checksum getFileChecksum() throws IOException {
        if (this.appendChecksum == null) {
            throw new IOException("Checksum is invalid!");
        }
        return this.appendChecksum;
    }

    Checksum getChecksumCalculator() {
        return new CRC32();
    }

    private int getStreamType(InputStream inputStream, Checksum checksum) throws IOException {
        boolean bl = inputStream.markSupported();
        if (bl) {
            inputStream.mark(inputStream.available());
        }
        try {
            long l;
            int n;
            int n2;
            int n3 = inputStream.available();
            if (n3 < 16) {
                byte[] byArray;
                int n4;
                if (checksum != null && (n4 = inputStream.read(byArray = new byte[16])) > 0) {
                    checksum.update(byArray, 0, n4);
                }
                return 2;
            }
            n3 -= 16;
            int n5 = 0;
            byte[] byArray = new byte[4096];
            while (n5 < n3) {
                n2 = byArray.length;
                if (n5 + n2 > n3) {
                    n2 = n3 - n5;
                }
                if ((n = inputStream.read(byArray, 0, n2)) == -1) {
                    throw new IOException("Unable to read entire file.");
                }
                checksum.update(byArray, 0, n);
                n5 += n;
            }
            n2 = inputStream.read(byArray);
            if (n2 != 16) {
                throw new IOException("Unable to read entire file.");
            }
            n = 0;
            while (n < 4) {
                if (identifier1[n] != byArray[n]) {
                    checksum.update(byArray, 0, 16);
                    return 2;
                }
                ++n;
            }
            n = 0;
            int n6 = 12;
            while (n < 4) {
                if (identifier2[n] != byArray[n6]) {
                    checksum.update(byArray, 0, 16);
                    return 2;
                }
                ++n;
                ++n6;
            }
            try {
                l = Long.valueOf(new String(byArray, 4, 8, "UTF-8"), 16);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                l = Long.valueOf(new String(byArray, 4, 8), 16);
            }
            if (l == checksum.getValue()) {
                return 0;
            }
            return 1;
        }
        finally {
            if (bl) {
                inputStream.reset();
            }
        }
    }

    private static byte[] intToHex(int n) {
        byte[] byArray = new byte[8];
        int n2 = 8;
        do {
            int n3;
            n3 = (n3 = n & 0xF) > 9 ? n3 - 10 + 97 : (n3 += 48);
            byArray[--n2] = (byte)n3;
            n >>= 4;
        } while (n2 > 0);
        return byArray;
    }

    private class CacheInfo {
        int filetype;
        Checksum checksum;
        long timeStamp;

        CacheInfo(int n, Checksum checksum, long l) {
            this.filetype = n;
            this.checksum = checksum;
            this.timeStamp = l;
        }
    }
}

