/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiplexingFactory {
    protected static final String PACKAGEADMINCLASS = "org.osgi.service.packageadmin.PackageAdmin";
    protected BundleContext context;
    protected FrameworkAdaptor adaptor;
    private List<Object> factories;
    private ServiceTracker<ServiceReference<?>, PackageAdmin> packageAdminTracker;
    private static InternalSecurityManager internalSecurityManager = new InternalSecurityManager();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    MultiplexingFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        this.context = bundleContext;
        this.adaptor = frameworkAdaptor;
        this.packageAdminTracker = new ServiceTracker(bundleContext, PACKAGEADMINCLASS, null);
        this.packageAdminTracker.open();
    }

    public abstract void setParentFactory(Object var1);

    public abstract Object getParentFactory();

    public boolean isMultiplexing() {
        return this.getFactories() != null;
    }

    public void register(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("setParentFactory", classArray);
            method.invoke(object, this.getParentFactory());
        }
        catch (Exception exception) {
            FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkLog.log(new FrameworkLogEntry(clazz.getName(), 4, 0, "register", 4, exception, null));
            throw new RuntimeException(exception.getMessage(), exception);
        }
        this.addFactory(object);
    }

    public void unregister(Object object) {
        this.removeFactory(object);
        try {
            Method method = object.getClass().getSuperclass().getDeclaredMethod("closePackageAdminTracker", null);
            method.setAccessible(true);
            method.invoke(object, null);
        }
        catch (Exception exception) {
            FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkLog.log(new FrameworkLogEntry(clazz.getName(), 4, 0, "unregister", 4, exception, null));
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public Object designateSuccessor() {
        List<Object> list = this.releaseFactories();
        if (list == null || list.isEmpty()) {
            return this.getParentFactory();
        }
        Object object = list.remove(0);
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("register", classArray);
            for (Object object2 : list) {
                method.invoke(object, object2);
            }
        }
        catch (Exception exception) {
            FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkLog.log(new FrameworkLogEntry(clazz.getName(), 4, 0, "designateSuccessor", 4, exception, null));
            throw new RuntimeException(exception.getMessage(), exception);
        }
        this.closePackageAdminTracker();
        return object;
    }

    private void closePackageAdminTracker() {
        this.packageAdminTracker.close();
    }

    public Object findAuthorizedFactory(List<Class<?>> list) {
        List<Object> list2 = this.getFactories();
        Class<?>[] classArray = internalSecurityManager.getClassContext();
        int n = 0;
        while (n < classArray.length) {
            Class<?> clazz = classArray[n];
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory$InternalSecurityManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz3 && !list.contains(clazz)) {
                    if (this.hasAuthority(clazz)) {
                        return this;
                    }
                    if (list2 != null) {
                        for (Object object : list2) {
                            try {
                                Class<?> clazz4 = object.getClass();
                                Class[] classArray2 = new Class[1];
                                Class<?> clazz5 = class$3;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = Class.forName("java.lang.Class");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                classArray2[0] = clazz5;
                                Method method = clazz4.getMethod("hasAuthority", classArray2);
                                if (!((Boolean)method.invoke(object, clazz)).booleanValue()) continue;
                                return object;
                            }
                            catch (Exception exception) {
                                FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
                                Class<?> clazz6 = class$1;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                frameworkLog.log(new FrameworkLogEntry(clazz6.getName(), 4, 0, "findAuthorizedURLStreamHandler-loop", 4, exception, null));
                                throw new RuntimeException(exception.getMessage(), exception);
                            }
                        }
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public boolean hasAuthority(Class<?> clazz) {
        PackageAdmin packageAdmin = this.packageAdminTracker.getService();
        if (packageAdmin != null) {
            return packageAdmin.getBundle(clazz) != null;
        }
        return false;
    }

    private synchronized List<Object> getFactories() {
        return this.factories;
    }

    private synchronized List<Object> releaseFactories() {
        if (this.factories == null) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>(this.factories);
        this.factories = null;
        return linkedList;
    }

    private synchronized void addFactory(Object object) {
        LinkedList<Object> linkedList = this.factories == null ? new LinkedList<Object>() : new LinkedList<Object>(this.factories);
        linkedList.add(object);
        this.factories = linkedList;
    }

    private synchronized void removeFactory(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>(this.factories);
        linkedList.remove(object);
        this.factories = linkedList.isEmpty() ? null : linkedList;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalSecurityManager
    extends SecurityManager {
        InternalSecurityManager() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

