/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.Headers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestLocalization {
    static final String DEFAULT_ROOT = FrameworkProperties.getProperty("equinox.root.locale", "en");
    private final AbstractBundle bundle;
    private final Dictionary<String, String> rawHeaders;
    private Dictionary<String, String> defaultLocaleHeaders = null;
    private final Hashtable<String, BundleResourceBundle> cache = new Hashtable(5);

    public ManifestLocalization(AbstractBundle abstractBundle, Dictionary<String, String> dictionary) {
        this.bundle = abstractBundle;
        this.rawHeaders = dictionary;
    }

    Dictionary<String, String> getHeaders(String string) {
        if (string.length() == 0) {
            return this.rawHeaders;
        }
        boolean bl = string.equals(Locale.getDefault().toString());
        Dictionary<String, String> dictionary = this.defaultLocaleHeaders;
        if (bl && dictionary != null) {
            return dictionary;
        }
        try {
            this.bundle.checkValid();
        }
        catch (IllegalStateException illegalStateException) {
            if (dictionary != null) {
                return dictionary;
            }
            return this.rawHeaders;
        }
        ResourceBundle resourceBundle = this.getResourceBundle(string, bl);
        Enumeration<String> enumeration = this.rawHeaders.keys();
        Headers<String, String> headers = new Headers<String, String>(this.rawHeaders.size());
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            String string3 = this.rawHeaders.get(string2);
            if (string3.startsWith("%") && string3.length() > 1) {
                String string4 = string3.substring(1);
                try {
                    string3 = resourceBundle == null ? string4 : (String)resourceBundle.getObject(string4);
                }
                catch (MissingResourceException missingResourceException) {
                    string3 = string4;
                }
            }
            headers.set(string2, string3);
        }
        headers.setReadOnly();
        if (bl) {
            this.defaultLocaleHeaders = headers;
        }
        return headers;
    }

    private String[] buildNLVariants(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > 0) {
            arrayList.add(string);
            int n = string.lastIndexOf(95);
            String string2 = string = n < 0 ? "" : string.substring(0, n);
        }
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    ResourceBundle getResourceBundle(String string, boolean bl) {
        BundleResourceBundle bundleResourceBundle = this.lookupResourceBundle(string);
        if (bl) {
            return (ResourceBundle)((Object)bundleResourceBundle);
        }
        if (bundleResourceBundle == null || bundleResourceBundle.isStemEmpty()) {
            return (ResourceBundle)((Object)this.lookupResourceBundle(Locale.getDefault().toString()));
        }
        return (ResourceBundle)((Object)bundleResourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleResourceBundle lookupResourceBundle(String string) {
        String string2 = this.rawHeaders.get("Bundle-Localization");
        if (string2 == null) {
            string2 = "OSGI-INF/l10n/bundle";
        }
        Hashtable<String, BundleResourceBundle> hashtable = this.cache;
        synchronized (hashtable) {
            BundleResourceBundle bundleResourceBundle = this.cache.get(string);
            if (bundleResourceBundle != null) {
                return bundleResourceBundle.isEmpty() ? null : bundleResourceBundle;
            }
            String[] stringArray = this.buildNLVariants(string);
            BundleResourceBundle bundleResourceBundle2 = null;
            int n = stringArray.length - 1;
            while (n >= 0) {
                BundleResourceBundle bundleResourceBundle3;
                block24: {
                    bundleResourceBundle3 = null;
                    URL uRL = this.findResource(new StringBuffer(String.valueOf(string2)).append(stringArray[n].equals("") ? stringArray[n] : new StringBuffer(String.valueOf('_')).append(stringArray[n]).toString()).append(".properties").toString());
                    if (uRL == null) {
                        bundleResourceBundle3 = this.cache.get(stringArray[n]);
                    } else {
                        InputStream inputStream = null;
                        try {
                            try {
                                inputStream = uRL.openStream();
                                bundleResourceBundle3 = new LocalizationResourceBundle(inputStream);
                            }
                            catch (IOException iOException) {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (bundleResourceBundle3 == null) {
                    bundleResourceBundle3 = new EmptyResouceBundle(stringArray[n]);
                }
                if (bundleResourceBundle2 != null) {
                    bundleResourceBundle3.setParent((ResourceBundle)((Object)bundleResourceBundle2));
                }
                this.cache.put(stringArray[n], bundleResourceBundle3);
                bundleResourceBundle2 = bundleResourceBundle3;
                --n;
            }
            bundleResourceBundle = this.cache.get(string);
            BundleResourceBundle bundleResourceBundle4 = bundleResourceBundle.isEmpty() ? null : bundleResourceBundle;
            return bundleResourceBundle4;
        }
    }

    private URL findResource(String string) {
        AbstractBundle abstractBundle = this.bundle;
        if (this.bundle.isResolved()) {
            if (this.bundle.isFragment() && this.bundle.getHosts() != null && (abstractBundle = this.bundle.getHosts()[0]).getState() == 1) {
                abstractBundle = this.bundle;
            }
            return ManifestLocalization.findInResolved(string, abstractBundle);
        }
        return abstractBundle.getEntry0(string);
    }

    private static URL findInResolved(String string, AbstractBundle abstractBundle) {
        URL uRL = abstractBundle.getEntry0(string);
        if (uRL != null) {
            return uRL;
        }
        return ManifestLocalization.findInFragments(string, abstractBundle);
    }

    private static URL findInFragments(String string, AbstractBundle abstractBundle) {
        BundleFragment[] bundleFragmentArray = abstractBundle.getFragments();
        URL uRL = null;
        int n = 0;
        while (bundleFragmentArray != null && n < bundleFragmentArray.length && uRL == null) {
            if (bundleFragmentArray[n].getState() != 1) {
                uRL = bundleFragmentArray[n].getEntry0(string);
            }
            ++n;
        }
        return uRL;
    }

    private static interface BundleResourceBundle {
        public void setParent(ResourceBundle var1);

        public boolean isEmpty();

        public boolean isStemEmpty();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyResouceBundle
    extends ResourceBundle
    implements BundleResourceBundle {
        private final String localeString;

        public EmptyResouceBundle(String string) {
            this.localeString = string;
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String string) throws MissingResourceException {
            return null;
        }

        @Override
        public void setParent(ResourceBundle resourceBundle) {
            super.setParent(resourceBundle);
        }

        @Override
        public boolean isEmpty() {
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isEmpty();
        }

        @Override
        public boolean isStemEmpty() {
            if (DEFAULT_ROOT.equals(this.localeString)) {
                return false;
            }
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isStemEmpty();
        }
    }

    private class LocalizationResourceBundle
    extends PropertyResourceBundle
    implements BundleResourceBundle {
        public LocalizationResourceBundle(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public void setParent(ResourceBundle resourceBundle) {
            super.setParent(resourceBundle);
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isStemEmpty() {
            return this.parent == null;
        }
    }
}

