/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSystemBundle
extends BundleHost
implements org.osgi.framework.launch.Framework {
    private final FrameworkStartLevel fsl;
    ProtectionDomain systemDomain;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected InternalSystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        Constants.setInternalSymbolicName(this.bundledata.getSymbolicName());
        this.state = 4;
        this.context = this.createContext();
        this.fsl = new EquinoxStartLevel();
    }

    @Override
    protected void load() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.systemDomain = this.getClass().getProtectionDomain();
        }
    }

    @Override
    protected boolean reload(AbstractBundle abstractBundle) {
        return false;
    }

    @Override
    protected void refresh() {
    }

    @Override
    protected boolean unload() {
        return false;
    }

    @Override
    protected void close() {
        this.context.close();
        this.context = null;
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (bl) {
            this.framework.checkAdminPermission(this, "class");
            this.checkValid();
        }
        return Class.forName(string);
    }

    @Override
    public URL getResource(String string) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    @Override
    public void start() {
        this.framework.checkAdminPermission(this, "execute");
    }

    @Override
    public void start(int n) {
        this.framework.checkAdminPermission(this, "execute");
    }

    @Override
    protected void resume() {
        this.framework.startLevelManager.initialize();
        this.loadInstalledBundles(this.framework.startLevelManager.getInstalledBundles(this.framework.bundles, false));
        try {
            this.framework.systemBundle.state = 8;
            this.framework.systemBundle.context.start();
            this.framework.publishBundleEvent(128, this.framework.systemBundle);
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println(new StringBuffer("SLL: Bundle resume exception: ").append(bundleException.getMessage()).toString());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
            throw new RuntimeException(bundleException.getMessage(), bundleException);
        }
    }

    private void loadInstalledBundles(AbstractBundle[] abstractBundleArray) {
        int n = 0;
        while (n < abstractBundleArray.length) {
            AbstractBundle abstractBundle = abstractBundleArray[n];
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println(new StringBuffer("SLL: Trying to load bundle ").append(abstractBundle).toString());
            }
            abstractBundle.load();
            ++n;
        }
    }

    @Override
    public void stop() {
        this.framework.checkAdminPermission(this, "execute");
        if ((this.state & 0x28) != 0) {
            Thread thread = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    try {
                        InternalSystemBundle.this.framework.close();
                    }
                    catch (Throwable throwable) {
                        InternalSystemBundle.this.framework.adaptor.handleRuntimeError(throwable);
                    }
                }
            }, "System Bundle Shutdown", this.framework.getContextFinder());
            thread.start();
        }
    }

    @Override
    public void stop(int n) {
        this.stop();
    }

    protected void suspend() {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
        this.framework.publishBundleEvent(4, this);
    }

    @Override
    protected void suspend(boolean bl) {
    }

    @Override
    public void update() {
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.state & 0x28) != 0) {
            Thread thread = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    int n = InternalSystemBundle.this.framework.startLevelManager.getStartLevel();
                    FrameworkProperties.setProperty("osgi.framework.relaunch", "");
                    InternalSystemBundle.this.framework.shutdown(128);
                    InternalSystemBundle.this.framework.launch();
                    if (n > 0) {
                        InternalSystemBundle.this.framework.startLevelManager.doSetStartLevel(n, new FrameworkListener[0]);
                    }
                    FrameworkProperties.clearProperty("osgi.framework.relaunch");
                }
            }, "System Bundle Update", this.framework.getContextFinder());
            thread.start();
        }
    }

    @Override
    public void update(InputStream inputStream) {
        this.update();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission(this, "lifecycle");
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    @Override
    public boolean hasPermission(Object object) {
        if (this.systemDomain != null) {
            if (object instanceof Permission) {
                return this.systemDomain.implies((Permission)object);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(AbstractBundle[] abstractBundleArray) {
    }

    @Override
    public Dictionary<String, String> getHeaders(String string) {
        return new SystemBundleHeaders(super.getHeaders(string));
    }

    @Override
    public void init() {
    }

    @Override
    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        return this.framework.waitForStop(l);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    protected <A> A adapt0(Class<A> clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.framework.startlevel.FrameworkStartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return (A)this.fsl;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.osgi.framework.wiring.FrameworkWiring");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(clazz)) {
            return (A)this.framework.getPackageAdmin();
        }
        return super.adapt0(clazz);
    }

    class EquinoxStartLevel
    implements FrameworkStartLevel {
        EquinoxStartLevel() {
        }

        public void setStartLevel(int n, FrameworkListener[] frameworkListenerArray) {
            InternalSystemBundle.this.framework.startLevelManager.setStartLevel(n, InternalSystemBundle.this, frameworkListenerArray);
        }

        public int getInitialBundleStartLevel() {
            return InternalSystemBundle.this.framework.startLevelManager.getInitialBundleStartLevel();
        }

        public void setInitialBundleStartLevel(int n) {
            InternalSystemBundle.this.framework.startLevelManager.setInitialBundleStartLevel(n);
        }

        public Bundle getBundle() {
            return InternalSystemBundle.this;
        }

        public int getStartLevel() {
            return InternalSystemBundle.this.framework.startLevelManager.getStartLevel();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SystemBundleHeaders
    extends Dictionary<String, String> {
        private final Dictionary<String, String> headers;

        public SystemBundleHeaders(Dictionary<String, String> dictionary) {
            this.headers = dictionary;
        }

        @Override
        public Enumeration<String> elements() {
            return this.headers.elements();
        }

        @Override
        public String get(Object object) {
            if (!(object instanceof String)) {
                return null;
            }
            if ("Export-Package".equalsIgnoreCase((String)object)) {
                return this.getExtra("Export-Package", "org.osgi.framework.system.packages", "org.osgi.framework.system.packages.extra");
            }
            if ("Provide-Capability".equalsIgnoreCase((String)object)) {
                return this.getExtra("Provide-Capability", "org.osgi.framework.system.capabilities", "org.osgi.framework.system.capabilities.extra");
            }
            return this.headers.get(object);
        }

        private String getExtra(String string, String string2, String string3) {
            String string4 = FrameworkProperties.getProperty(string2);
            String string5 = FrameworkProperties.getProperty(string3);
            if (string4 == null) {
                string4 = string5;
            } else if (string5 != null) {
                string4 = new StringBuffer(String.valueOf(string4)).append(", ").append(string5).toString();
            }
            String string6 = this.headers.get(string);
            if (string4 != null) {
                string6 = string6 != null ? new StringBuffer(String.valueOf(string6)).append(", ").append(string4).toString() : string4;
            }
            return string6;
        }

        @Override
        public boolean isEmpty() {
            return this.headers.isEmpty();
        }

        @Override
        public Enumeration<String> keys() {
            return this.headers.keys();
        }

        @Override
        public String put(String string, String string2) {
            return this.headers.put(string, string2);
        }

        @Override
        public String remove(Object object) {
            return this.headers.remove(object);
        }

        @Override
        public int size() {
            return this.headers.size();
        }
    }
}

