/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkProperties {
    private static Properties properties;
    private static final String USING_SYSTEM_PROPERTIES_KEY = "osgi.framework.useSystemProperties";
    private static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Properties getProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return FrameworkProperties.internalGetProperties(null);
    }

    public static String getProperty(String string) {
        return FrameworkProperties.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return FrameworkProperties.internalGetProperties(null).getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)FrameworkProperties.internalGetProperties(null).put(string, string2);
    }

    public static String clearProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)FrameworkProperties.internalGetProperties(null).remove(string);
    }

    private static synchronized Properties internalGetProperties(String string) {
        if (properties == null) {
            Properties properties = System.getProperties();
            if (string == null) {
                string = properties.getProperty(USING_SYSTEM_PROPERTIES_KEY);
            }
            if (string == null || string.equalsIgnoreCase(Boolean.TRUE.toString())) {
                FrameworkProperties.properties = properties;
            } else {
                FrameworkProperties.properties = new Properties();
                FrameworkProperties.properties.putAll((Map<?, ?>)properties);
            }
        }
        return properties;
    }

    public static synchronized void setProperties(Map<String, String> map) {
        if (map == null) {
            FrameworkProperties.internalGetProperties("false");
            return;
        }
        properties = null;
        Properties properties = FrameworkProperties.internalGetProperties("false");
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (string2 instanceof String) {
                properties.setProperty(string, string2);
                continue;
            }
            string2 = map.get(string);
            if (string2 != null) {
                properties.put(string, string2);
                continue;
            }
            properties.remove(string);
        }
    }

    public static synchronized boolean inUse() {
        return properties != null;
    }

    public static void initializeProperties() {
        if (FrameworkProperties.getProperty(PROP_FRAMEWORK) == null || FrameworkProperties.getProperty(PROP_INSTALL_AREA) == null) {
            CodeSource codeSource;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkProperties");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((codeSource = clazz.getProtectionDomain().getCodeSource()) == null) {
                throw new IllegalArgumentException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_PROPS_NOT_SET, "osgi.framework, osgi.install.area"));
            }
            URL uRL = codeSource.getLocation();
            if (FrameworkProperties.getProperty(PROP_FRAMEWORK) == null) {
                FrameworkProperties.setProperty(PROP_FRAMEWORK, uRL.toExternalForm());
            }
            if (FrameworkProperties.getProperty(PROP_INSTALL_AREA) == null) {
                String string = uRL.getFile();
                FrameworkProperties.setProperty(PROP_INSTALL_AREA, string.substring(0, string.lastIndexOf(47)));
            }
        }
        FrameworkProperties.setProperty(PROP_FRAMEWORK, FrameworkProperties.decode(FrameworkProperties.getProperty(PROP_FRAMEWORK)));
        FrameworkProperties.setProperty(PROP_INSTALL_AREA, FrameworkProperties.decode(FrameworkProperties.getProperty(PROP_INSTALL_AREA)));
    }

    public static String decode(String string) {
        char c;
        int n;
        Object object;
        Object object2;
        try {
            Object object3;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            object2 = clazz2.getDeclaredMethod("decode", classArray);
            if (string.indexOf(43) >= 0) {
                int n2 = string.length();
                object = new StringBuffer(n2);
                n = 0;
                while (n < n2) {
                    c = string.charAt(n);
                    if (c == '+') {
                        ((StringBuffer)object).append("%2B");
                    } else {
                        ((StringBuffer)object).append(c);
                    }
                    ++n;
                }
                string = ((StringBuffer)object).toString();
            }
            if ((object3 = ((Method)object2).invoke(null, string, "UTF-8")) != null) {
                return (String)object3;
            }
        }
        catch (Exception exception) {}
        boolean bl = false;
        object2 = string.getBytes();
        char c2 = ((byte[])object2).length;
        object = new byte[c2];
        n = 0;
        c = '\u0000';
        while (c < c2) {
            byte by = object2[c];
            if (by == 37) {
                byte by2 = object2[++c];
                byte by3 = object2[++c];
                by = (byte)((FrameworkProperties.hexToByte(by2) << 4) + FrameworkProperties.hexToByte(by3));
                bl = true;
            }
            object[n++] = by;
            ++c;
        }
        if (!bl) {
            return string;
        }
        try {
            return new String((byte[])object, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String((byte[])object, 0, n);
        }
    }

    private static int hexToByte(byte by) {
        switch (by) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }
}

