/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkCommandProvider
implements CommandProvider,
SynchronousBundleListener {
    private final Framework framework;
    private final BundleContext context;
    private final StartLevelManager slImpl;
    private final SecurityAdmin securityAdmin;
    private ServiceRegistration<?> providerReg;
    private static final String tab = "\t";
    private static final String newline = "\r\n";
    private final List<Bundle> lazyActivation = new ArrayList<Bundle>();
    private Map<String, String[]> commandsHelp = null;
    private Map<String, String[]> commandGroups = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public FrameworkCommandProvider(Framework framework) {
        this.framework = framework;
        this.context = framework.systemBundle.getContext();
        this.slImpl = framework.startLevelManager;
        this.securityAdmin = framework.securityAdmin;
    }

    void start() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        ((Dictionary)hashtable).put("service.ranking", new Integer(Integer.MAX_VALUE));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.providerReg = this.context.registerService(clazz.getName(), (Object)this, hashtable);
        this.context.addBundleListener(this);
    }

    void stop() {
        this.context.removeBundleListener(this);
        if (this.providerReg != null) {
            this.providerReg.unregister();
        }
    }

    @Override
    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.commandsHelp == null) {
            this.initializeCommandsHelp();
        }
        if (this.commandGroups == null) {
            this.initializeCommandGroups();
        }
        if (string != null) {
            if (this.commandsHelp.containsKey(string)) {
                this.addCommand(string, this.commandsHelp.get(string), stringBuffer);
            }
            return stringBuffer.toString();
        }
        for (Map.Entry<String, String[]> entry : this.commandGroups.entrySet()) {
            this.addHeader(entry.getKey(), stringBuffer);
            String[] stringArray = entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                this.addCommand(string2, this.commandsHelp.get(string2), stringBuffer);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private void initializeCommandsHelp() {
        this.commandsHelp = new HashMap<String, String[]>();
        this.commandsHelp.put("launch", new String[]{ConsoleMsg.CONSOLE_HELP_LAUNCH_COMMAND_DESCRIPTION});
        this.commandsHelp.put("shutdown", new String[]{ConsoleMsg.CONSOLE_HELP_SHUTDOWN_COMMAND_DESCRIPTION});
        this.commandsHelp.put("close", new String[]{ConsoleMsg.CONSOLE_HELP_CLOSE_COMMAND_DESCRIPTION});
        this.commandsHelp.put("exit", new String[]{ConsoleMsg.CONSOLE_HELP_EXIT_COMMAND_DESCRIPTION});
        this.commandsHelp.put("init", new String[]{ConsoleMsg.CONSOLE_HELP_INIT_COMMAND_DESCRIPTION});
        this.commandsHelp.put("setprop", new String[]{ConsoleMsg.CONSOLE_HELP_KEYVALUE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SETPROP_COMMAND_DESCRIPTION});
        this.commandsHelp.put("setp", new String[]{ConsoleMsg.CONSOLE_HELP_KEYVALUE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SETPROP_COMMAND_DESCRIPTION});
        this.commandsHelp.put("install", new String[]{ConsoleMsg.CONSOLE_HELP_INSTALL_COMMAND_DESCRIPTION});
        this.commandsHelp.put("i", new String[]{ConsoleMsg.CONSOLE_HELP_INSTALL_COMMAND_DESCRIPTION});
        this.commandsHelp.put("uninstall", new String[]{ConsoleMsg.CONSOLE_HELP_UNINSTALL_COMMAND_DESCRIPTION});
        this.commandsHelp.put("un", new String[]{ConsoleMsg.CONSOLE_HELP_UNINSTALL_COMMAND_DESCRIPTION});
        this.commandsHelp.put("start", new String[]{ConsoleMsg.CONSOLE_HELP_START_COMMAND_DESCRIPTION});
        this.commandsHelp.put("sta", new String[]{ConsoleMsg.CONSOLE_HELP_START_COMMAND_DESCRIPTION});
        this.commandsHelp.put("stop", new String[]{ConsoleMsg.CONSOLE_HELP_STOP_COMMAND_DESCRIPTION});
        this.commandsHelp.put("sto", new String[]{ConsoleMsg.CONSOLE_HELP_STOP_COMMAND_DESCRIPTION});
        this.commandsHelp.put("refresh", new String[]{ConsoleMsg.CONSOLE_HELP_REFRESH_COMMAND_DESCRIPTION});
        this.commandsHelp.put("r", new String[]{ConsoleMsg.CONSOLE_HELP_REFRESH_COMMAND_DESCRIPTION});
        this.commandsHelp.put("update", new String[]{ConsoleMsg.CONSOLE_HELP_UPDATE_COMMAND_DESCRIPTION});
        this.commandsHelp.put("up", new String[]{ConsoleMsg.CONSOLE_HELP_UPDATE_COMMAND_DESCRIPTION});
        this.commandsHelp.put("status", new String[]{ConsoleMsg.CONSOLE_HELP_STATE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_STATUS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("s", new String[]{ConsoleMsg.CONSOLE_HELP_STATE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_STATUS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("ss", new String[]{ConsoleMsg.CONSOLE_HELP_STATE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("services", new String[]{ConsoleMsg.CONSOLE_HELP_FILTER_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SERVICES_COMMAND_DESCRIPTION});
        this.commandsHelp.put("packages", new String[]{ConsoleMsg.CONSOLE_HELP_PACKAGES_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_PACKAGES_COMMAND_DESCRIPTION});
        this.commandsHelp.put("p", new String[]{ConsoleMsg.CONSOLE_HELP_PACKAGES_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_PACKAGES_COMMAND_DESCRIPTION});
        this.commandsHelp.put("bundles", new String[]{ConsoleMsg.CONSOLE_HELP_STATE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_BUNDLES_COMMAND_DESCRIPTION});
        this.commandsHelp.put("bundle", new String[]{ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_BUNDLE_COMMAND_DESCRIPTION});
        this.commandsHelp.put("b", new String[]{ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_BUNDLE_COMMAND_DESCRIPTION});
        this.commandsHelp.put("headers", new String[]{ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_HEADERS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("h", new String[]{ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_HEADERS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("exec", new String[]{ConsoleMsg.CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_EXEC_COMMAND_DESCRIPTION});
        this.commandsHelp.put("fork", new String[]{ConsoleMsg.CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_FORK_COMMAND_DESCRIPTION});
        this.commandsHelp.put("gc", new String[]{ConsoleMsg.CONSOLE_HELP_GC_COMMAND_DESCRIPTION});
        this.commandsHelp.put("getprop", new String[]{ConsoleMsg.CONSOLE_HELP_GETPROP_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_GETPROP_COMMAND_DESCRIPTION});
        this.commandsHelp.put("props", new String[]{ConsoleMsg.CONSOLE_PROPS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("pr", new String[]{ConsoleMsg.CONSOLE_PROPS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("threads", new String[]{ConsoleMsg.CONSOLE_THREADS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("t", new String[]{ConsoleMsg.CONSOLE_THREADS_COMMAND_DESCRIPTION});
        this.commandsHelp.put("sl", new String[]{ConsoleMsg.CONSOLE_HELP_OPTIONAL_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SL});
        this.commandsHelp.put("setfwsl", new String[]{ConsoleMsg.STARTLEVEL_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETFWSL});
        this.commandsHelp.put("setbsl", new String[]{ConsoleMsg.STARTLEVEL_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETBSL});
        this.commandsHelp.put("setibsl", new String[]{ConsoleMsg.STARTLEVEL_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETIBSL});
        this.commandsHelp.put("profilelog", new String[]{ConsoleMsg.CONSOLE_HELP_PROFILELOG_DESCRIPTION});
    }

    private void initializeCommandGroups() {
        this.commandGroups = new LinkedHashMap<String, String[]>();
        this.commandGroups.put(ConsoleMsg.CONSOLE_HELP_CONTROLLING_FRAMEWORK_HEADER, new String[]{"launch", "shutdown", "close", "exit", "init", "setprop"});
        this.commandGroups.put(ConsoleMsg.CONSOLE_HELP_CONTROLLING_BUNDLES_HEADER, new String[]{"install", "uninstall", "start", "stop", "refresh", "update"});
        this.commandGroups.put(ConsoleMsg.CONSOLE_HELP_DISPLAYING_STATUS_HEADER, new String[]{"status", "ss", "services", "packages", "bundles", "bundle", "headers"});
        this.commandGroups.put(ConsoleMsg.CONSOLE_HELP_EXTRAS_HEADER, new String[]{"exec", "fork", "gc", "getprop", "props", "threads"});
        this.commandGroups.put(ConsoleMsg.STARTLEVEL_HELP_HEADING, new String[]{"sl", "setfwsl", "setbsl", "setibsl"});
        this.commandGroups.put(ConsoleMsg.CONSOLE_HELP_PROFILE_HEADING, new String[]{"profilelog"});
    }

    private void addHeader(String string, StringBuffer stringBuffer) {
        stringBuffer.append("---");
        stringBuffer.append(string);
        stringBuffer.append("---");
        stringBuffer.append(newline);
    }

    private void addCommand(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(tab);
        stringBuffer.append(string);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(newline);
    }

    private void addCommand(String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(tab);
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" - ");
        stringBuffer.append(string3);
        stringBuffer.append(newline);
    }

    private void addCommand(String string, String[] stringArray, StringBuffer stringBuffer) {
        if (stringArray.length == 1) {
            this.addCommand(string, stringArray[0], stringBuffer);
        } else if (stringArray.length == 2) {
            this.addCommand(string, stringArray[0], stringArray[1], stringBuffer);
        }
    }

    public void _exit(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.println();
        System.exit(0);
    }

    public void _launch(CommandInterpreter commandInterpreter) throws Exception {
        this.framework.launch();
    }

    public void _shutdown(CommandInterpreter commandInterpreter) throws Exception {
        this.framework.shutdown(64);
    }

    public void _sta(CommandInterpreter commandInterpreter) throws Exception {
        this._start(commandInterpreter);
    }

    public void _start(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                abstractBundle.start();
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _sto(CommandInterpreter commandInterpreter) throws Exception {
        this._stop(commandInterpreter);
    }

    public void _stop(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                abstractBundle.stop();
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _i(CommandInterpreter commandInterpreter) throws Exception {
        this._install(commandInterpreter);
    }

    public void _install(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NOTHING_TO_INSTALL_ERROR);
        } else {
            String string2;
            AbstractBundle abstractBundle = (AbstractBundle)this.context.installBundle(string);
            commandInterpreter.print(ConsoleMsg.CONSOLE_BUNDLE_ID_MESSAGE);
            commandInterpreter.println(new Long(abstractBundle.getBundleId()));
            String string3 = commandInterpreter.nextArgument();
            if (string3 != null && FrameworkCommandProvider.matchCommand("start", string2 = string3.toLowerCase(), 1)) {
                abstractBundle.start();
            }
        }
    }

    private static boolean matchCommand(String string, String string2, int n) {
        int n2;
        if (n <= 0) {
            n = string.length();
        }
        if (n > (n2 = string2.length())) {
            n2 = n;
        }
        return string.regionMatches(0, string2, 0, n2);
    }

    public void _up(CommandInterpreter commandInterpreter) throws Exception {
        this._update(commandInterpreter);
    }

    public void _update(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            Object object;
            if ("*".equals(string)) {
                object = (AbstractBundle[])this.context.getBundles();
                int n = ((AbstractBundle[])object).length;
                if (n > 0) {
                    int n2 = 0;
                    while (n2 < n) {
                        Object object2 = object[n2];
                        if (((AbstractBundle)object2).getBundleId() != 0L) {
                            try {
                                ((AbstractBundle)object2).update();
                            }
                            catch (BundleException bundleException) {
                                commandInterpreter.printStackTrace(bundleException);
                            }
                        }
                        ++n2;
                    }
                } else {
                    commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
                }
            } else {
                object = this.getBundleFromToken(commandInterpreter, string, true);
                if (object != null) {
                    String string2 = commandInterpreter.nextArgument();
                    try {
                        if (string2 != null) {
                            ((AbstractBundle)object).update(new URL(string2).openStream());
                        }
                        ((AbstractBundle)object).update();
                    }
                    catch (BundleException bundleException) {
                        commandInterpreter.printStackTrace(bundleException);
                    }
                }
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _un(CommandInterpreter commandInterpreter) throws Exception {
        this._uninstall(commandInterpreter);
    }

    public void _uninstall(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                abstractBundle.uninstall();
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _s(CommandInterpreter commandInterpreter) throws Exception {
        this._status(commandInterpreter);
    }

    private Object[] processOption(CommandInterpreter commandInterpreter) {
        String string;
        String string2 = commandInterpreter.nextArgument();
        String string3 = null;
        int n = -1;
        if (string2 != null && string2.equals("-s")) {
            string = commandInterpreter.nextArgument();
            if (string == null) {
                string = "";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string4 = (String)stringTokenizer.nextElement();
                Field field = null;
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.osgi.framework.Bundle");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    field = clazz.getField(string4.toUpperCase());
                    if (n == -1) {
                        n = 0;
                    }
                    n |= field.getInt(field);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    commandInterpreter.println(new StringBuffer(String.valueOf(ConsoleMsg.CONSOLE_INVALID_INPUT)).append(": ").append(string4).toString());
                    return null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    commandInterpreter.println(new StringBuffer(String.valueOf(ConsoleMsg.CONSOLE_INVALID_INPUT)).append(": ").append(string4).toString());
                    return null;
                }
            }
        } else {
            string3 = string2;
        }
        string = commandInterpreter.nextArgument();
        if (string != null) {
            string3 = string;
        }
        return new Object[]{string3, new Integer(n)};
    }

    public void _status(CommandInterpreter commandInterpreter) throws Exception {
        if (this.framework.isActive()) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        commandInterpreter.println();
        Object[] objectArray = this.processOption(commandInterpreter);
        if (objectArray == null) {
            return;
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        int n = abstractBundleArray.length;
        if (n == 0) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        commandInterpreter.print(ConsoleMsg.CONSOLE_ID);
        commandInterpreter.print(tab);
        commandInterpreter.println(ConsoleMsg.CONSOLE_BUNDLE_LOCATION_MESSAGE);
        commandInterpreter.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_FILE_NAME_HEADER);
        int n2 = 0;
        while (n2 < n) {
            AbstractBundle abstractBundle = abstractBundleArray[n2];
            if (this.match(abstractBundle, (String)objectArray[0], (Integer)objectArray[1])) {
                commandInterpreter.print(new Long(abstractBundle.getBundleId()));
                commandInterpreter.print(tab);
                commandInterpreter.println(abstractBundle.getLocation());
                commandInterpreter.print("  ");
                commandInterpreter.print(this.getStateName(abstractBundle));
                commandInterpreter.println(abstractBundle.bundledata);
            }
            ++n2;
        }
        ServiceReference<?>[] serviceReferenceArray = this.context.getServiceReferences((String)null, (String)null);
        if (serviceReferenceArray != null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
            n = serviceReferenceArray.length;
            int n3 = 0;
            while (n3 < n) {
                commandInterpreter.println(serviceReferenceArray[n3]);
                ++n3;
            }
        }
    }

    public void _se(CommandInterpreter commandInterpreter) throws Exception {
        this._services(commandInterpreter);
    }

    public void _services(CommandInterpreter commandInterpreter) throws Exception {
        int n;
        Serializable serializable;
        String string = null;
        String string2 = commandInterpreter.nextArgument();
        if (string2 != null) {
            serializable = new StringBuffer();
            while (string2 != null) {
                ((StringBuffer)serializable).append(' ');
                ((StringBuffer)serializable).append(string2);
                string2 = commandInterpreter.nextArgument();
            }
            string = ((StringBuffer)serializable).toString();
        }
        serializable = null;
        ServiceReference[] serviceReferenceArray = null;
        try {
            serviceReferenceArray = this.context.getServiceReferences((String)null, string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            serializable = invalidSyntaxException;
        }
        if (string != null) {
            string = string.trim();
        }
        if (serializable != null && !string.startsWith("(") && string.indexOf(32) < 0) {
            try {
                string = new StringBuffer("(objectClass=").append(string).append(")").toString();
                serviceReferenceArray = this.context.getServiceReferences((String)null, string);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw serializable;
            }
        } else if (serializable != null) {
            throw serializable;
        }
        if (serviceReferenceArray != null && (n = serviceReferenceArray.length) > 0) {
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                commandInterpreter.println(serviceReference);
                commandInterpreter.print("  ");
                commandInterpreter.print(ConsoleMsg.CONSOLE_REGISTERED_BY_BUNDLE_MESSAGE);
                commandInterpreter.print(" ");
                commandInterpreter.println(serviceReference.getBundle());
                Bundle[] bundleArray = serviceReference.getUsingBundles();
                if (bundleArray != null) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_BUNDLES_USING_SERVICE_MESSAGE);
                    int n3 = 0;
                    while (n3 < bundleArray.length) {
                        commandInterpreter.print("    ");
                        commandInterpreter.println(bundleArray[n3]);
                        ++n3;
                    }
                } else {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLES_USING_SERVICE_MESSAGE);
                }
                ++n2;
            }
            return;
        }
        commandInterpreter.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
    }

    public void _p(CommandInterpreter commandInterpreter) throws Exception {
        this._packages(commandInterpreter);
    }

    public void _packages(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference<?> serviceReference;
        AbstractBundle abstractBundle = null;
        String string = commandInterpreter.nextArgument();
        if (string != null) {
            abstractBundle = this.getBundleFromToken(commandInterpreter, string, false);
        }
        if ((serviceReference = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin")) != null) {
            PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(serviceReference);
            if (packageAdmin != null) {
                try {
                    ExportedPackage[] exportedPackageArray = null;
                    if (string != null) {
                        exportedPackageArray = packageAdmin.getExportedPackages(string);
                    }
                    if (exportedPackageArray == null) {
                        exportedPackageArray = packageAdmin.getExportedPackages(abstractBundle);
                    }
                    if (exportedPackageArray == null) {
                        commandInterpreter.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                    }
                    int n = 0;
                    while (n < exportedPackageArray.length) {
                        Bundle bundle;
                        ExportedPackage exportedPackage = exportedPackageArray[n];
                        commandInterpreter.print(exportedPackage);
                        boolean bl = exportedPackage.isRemovalPending();
                        if (bl) {
                            commandInterpreter.print("(");
                            commandInterpreter.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                            commandInterpreter.println(")");
                        }
                        if ((bundle = exportedPackage.getExportingBundle()) != null) {
                            commandInterpreter.print("<");
                            commandInterpreter.print(bundle);
                            commandInterpreter.println(">");
                            Bundle[] bundleArray = exportedPackage.getImportingBundles();
                            int n2 = 0;
                            while (n2 < bundleArray.length) {
                                commandInterpreter.print("  ");
                                commandInterpreter.print(bundleArray[n2]);
                                commandInterpreter.print(" ");
                                commandInterpreter.println(ConsoleMsg.CONSOLE_IMPORTS_MESSAGE);
                                ++n2;
                            }
                        } else {
                            commandInterpreter.print("<");
                            commandInterpreter.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                            commandInterpreter.println(">");
                        }
                        ++n;
                    }
                }
                finally {
                    this.context.ungetService(serviceReference);
                }
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    public void _bundles(CommandInterpreter commandInterpreter) throws Exception {
        Object[] objectArray = this.processOption(commandInterpreter);
        if (objectArray == null) {
            return;
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        int n = abstractBundleArray.length;
        if (n == 0) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            AbstractBundle abstractBundle = abstractBundleArray[n2];
            if (this.match(abstractBundle, (String)objectArray[0], (Integer)objectArray[1])) {
                Object object;
                long l = abstractBundle.getBundleId();
                commandInterpreter.println(abstractBundle);
                commandInterpreter.print("  ");
                commandInterpreter.print(NLS.bind(ConsoleMsg.CONSOLE_ID_MESSAGE, String.valueOf(l)));
                commandInterpreter.print(", ");
                commandInterpreter.print(NLS.bind(ConsoleMsg.CONSOLE_STATUS_MESSAGE, this.getStateName(abstractBundle)));
                if (l != 0L) {
                    object = this.framework.getDataFile(abstractBundle, "");
                    String string = object == null ? null : ((File)object).getAbsolutePath();
                    commandInterpreter.print(NLS.bind(ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, string));
                } else {
                    commandInterpreter.println();
                }
                object = abstractBundle.getRegisteredServices();
                if (object != null) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        commandInterpreter.print("    ");
                        commandInterpreter.println(object[n3]);
                        ++n3;
                    }
                } else {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
                }
                object = abstractBundle.getServicesInUse();
                if (object != null) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                    int n4 = 0;
                    while (n4 < ((Object)object).length) {
                        commandInterpreter.print("    ");
                        commandInterpreter.println(object[n4]);
                        ++n4;
                    }
                } else {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
                }
            }
            ++n2;
        }
    }

    public void _b(CommandInterpreter commandInterpreter) throws Exception {
        this._bundle(commandInterpreter);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void _bundle(CommandInterpreter var1_1) throws Exception {
        var2_2 = var1_1.nextArgument();
        if (var2_2 == null) {
            var1_1.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (var2_2 != null) {
            var3_3 = this.getBundleFromToken(var1_1, var2_2, true);
            if (var3_3 != null) {
                var4_4 = var3_3.getBundleId();
                var1_1.println(var3_3);
                var1_1.print("  ");
                var1_1.print(NLS.bind(ConsoleMsg.CONSOLE_ID_MESSAGE, String.valueOf(var4_4)));
                var1_1.print(", ");
                var1_1.print(NLS.bind(ConsoleMsg.CONSOLE_STATUS_MESSAGE, this.getStateName(var3_3)));
                if (var4_4 != 0L) {
                    var6_5 = this.framework.getDataFile(var3_3, "");
                    var7_6 = var6_5 == null ? null : var6_5.getAbsolutePath();
                    var1_1.print(NLS.bind(ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, var7_6));
                    var1_1.println();
                } else {
                    var1_1.println();
                }
                var6_5 = var3_3.getRegisteredServices();
                if (var6_5 != null) {
                    var1_1.print("  ");
                    var1_1.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                    var7_7 = 0;
                    while (var7_7 < ((Object)var6_5).length) {
                        var1_1.print("    ");
                        var1_1.println(var6_5[var7_7]);
                        ++var7_7;
                    }
                } else {
                    var1_1.print("  ");
                    var1_1.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
                }
                var6_5 = var3_3.getServicesInUse();
                if (var6_5 != null) {
                    var1_1.print("  ");
                    var1_1.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                    var7_9 = 0;
                    while (var7_9 < ((Object)var6_5).length) {
                        var1_1.print("    ");
                        var1_1.println(var6_5[var7_9]);
                        ++var7_9;
                    }
                } else {
                    var1_1.print("  ");
                    var1_1.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
                }
                var7_6 = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
                if (var7_6 != null) {
                    var8_10 = var3_3.getBundleDescription();
                    if (var8_10 != null) {
                        var9_11 = true;
                        try {
                            var10_13 = var8_10.getSelectedExports();
                            if (var10_13 == null || var10_13.length == 0) {
                                var1_1.print("  ");
                                var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                            } else {
                                var9_11 = true;
                                var11_15 = 0;
                                while (var11_15 < var10_13.length) {
                                    if (var9_11) {
                                        var1_1.print("  ");
                                        var1_1.println(ConsoleMsg.CONSOLE_EXPORTED_PACKAGES_MESSAGE);
                                        var9_11 = false;
                                    }
                                    var1_1.print("    ");
                                    var1_1.print(var10_13[var11_15].getName());
                                    var1_1.print("; version=\"");
                                    var1_1.print(var10_13[var11_15].getVersion());
                                    var1_1.print("\"");
                                    if (var8_10.isRemovalPending()) {
                                        var1_1.println(ConsoleMsg.CONSOLE_EXPORTED_REMOVAL_PENDING_MESSAGE);
                                    } else {
                                        var1_1.println(ConsoleMsg.CONSOLE_EXPORTED_MESSAGE);
                                    }
                                    ++var11_15;
                                }
                                if (var9_11) {
                                    var1_1.print("  ");
                                    var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                                }
                            }
                            var9_11 = true;
                            if (var8_10 != null) {
                                var11_16 = new ArrayList<Object>();
                                var12_17 = var8_10.getFragments();
                                var13_19 = 0;
                                while (var13_19 < var12_17.length) {
                                    var14_22 = var12_17[var13_19].getImportPackages();
                                    var15_26 = 0;
                                    while (var15_26 < var14_22.length) {
                                        var11_16.add(var14_22[var15_26]);
                                        ++var15_26;
                                    }
                                    ++var13_19;
                                }
                                if (var11_16.size() > 0) {
                                    var14_22 = var8_10.getImportPackages();
                                    var13_18 /* !! */  = new ImportPackageSpecification[var14_22.length + var11_16.size()];
                                    var15_26 = 0;
                                    while (var15_26 < var14_22.length) {
                                        var13_18 /* !! */ [var15_26] = var14_22[var15_26];
                                        ++var15_26;
                                    }
                                    var15_26 = var14_22.length;
                                    var16_27 = 0;
                                    while (var16_27 < var11_16.size()) {
                                        var13_18 /* !! */ [var15_26 + var16_27] = (ImportPackageSpecification)var11_16.get(var16_27);
                                        ++var16_27;
                                    }
                                } else {
                                    var13_18 /* !! */  = var8_10.getImportPackages();
                                }
                                var14_22 = null;
                                var14_22 = var8_10.getContainingState().getStateHelper().getVisiblePackages((BundleDescription)var8_10, 3);
                                var15_25 = new ArrayList();
                                var16_27 = 0;
                                while (var16_27 < var13_18 /* !! */ .length) {
                                    if (var13_18 /* !! */ [var16_27].getDirective("resolution").equals("optional")) {
                                        if (var13_18 /* !! */ [var16_27].getSupplier() == null) {
                                            var15_25.add((ImportPackageSpecification)var13_18 /* !! */ [var16_27]);
                                        }
                                    } else if (var13_18 /* !! */ [var16_27].getDirective("resolution").equals("dynamic")) {
                                        var17_28 = false;
                                        var18_30 = 0;
                                        while (var18_30 < var14_22.length) {
                                            if (var13_18 /* !! */ [var16_27].isSatisfiedBy((BaseDescription)var14_22[var18_30])) {
                                                var17_28 = true;
                                            }
                                            ++var18_30;
                                        }
                                        if (!var17_28) {
                                            var15_25.add(var13_18 /* !! */ [var16_27]);
                                        }
                                    }
                                    ++var16_27;
                                }
                                var9_11 = this.printImportedPackages((ExportPackageDescription[])var14_22, var1_1, var9_11);
                                if (var8_10.isResolved() && !var15_25.isEmpty()) {
                                    this.printUnwiredDynamicImports((List<ImportPackageSpecification>)var15_25, var1_1);
                                    var9_11 = false;
                                }
                            }
                            if (var9_11) {
                                var1_1.print("  ");
                                var1_1.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                            }
                            if ((var11_14 = (PackageAdmin)this.context.getService(var7_6)) == null) ** GOTO lbl219
                            var1_1.print("  ");
                            if ((var11_14.getBundleType(var3_3) & 1) > 0) {
                                var12_17 = var11_14.getHosts(var3_3);
                                if (var12_17 != null) {
                                    var1_1.println(ConsoleMsg.CONSOLE_HOST_MESSAGE);
                                    var13_20 = 0;
                                    while (var13_20 < var12_17.length) {
                                        var1_1.print("    ");
                                        var1_1.println(var12_17[var13_20]);
                                        ++var13_20;
                                    }
                                } else {
                                    var1_1.println(ConsoleMsg.CONSOLE_NO_HOST_MESSAGE);
                                }
                            } else {
                                var12_17 = var11_14.getFragments(var3_3);
                                if (var12_17 != null) {
                                    var1_1.println(ConsoleMsg.CONSOLE_FRAGMENT_MESSAGE);
                                    var13_21 = 0;
                                    while (var13_21 < var12_17.length) {
                                        var1_1.print("    ");
                                        var1_1.println(var12_17[var13_21]);
                                        ++var13_21;
                                    }
                                } else {
                                    var1_1.println(ConsoleMsg.CONSOLE_NO_FRAGMENT_MESSAGE);
                                }
                            }
                            var12_17 = var11_14.getRequiredBundles(null);
                            var13_18 /* !! */  = null;
                            if (var12_17 != null) {
                                var14_23 = 0;
                                while (var14_23 < var12_17.length) {
                                    if (var12_17[var14_23].getBundle() == var3_3) {
                                        var13_18 /* !! */  = var12_17[var14_23];
                                        break;
                                    }
                                    ++var14_23;
                                }
                            }
                            if (var13_18 /* !! */  == null) {
                                var1_1.print("  ");
                                var1_1.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                            } else {
                                var1_1.print("  ");
                                var1_1.println(ConsoleMsg.CONSOLE_NAMED_CLASS_SPACE_MESSAGE);
                                var1_1.print("    ");
                                var1_1.print(var13_18 /* !! */ );
                                if (var13_18 /* !! */ .isRemovalPending()) {
                                    var1_1.println(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                                } else {
                                    var1_1.println(ConsoleMsg.CONSOLE_PROVIDED_MESSAGE);
                                }
                            }
                            var9_11 = true;
                            var14_24 = 0;
                            while (var14_24 < var12_17.length) {
                                if (var12_17[var14_24] != var13_18 /* !! */  && (var15_25 = var12_17[var14_24].getRequiringBundles()) != null) {
                                    var16_27 = 0;
                                    while (var16_27 < var15_25.length) {
                                        if (var15_25[var16_27] == var3_3) {
                                            if (var9_11) {
                                                var1_1.print("  ");
                                                var1_1.println(ConsoleMsg.CONSOLE_REQUIRED_BUNDLES_MESSAGE);
                                                var9_11 = false;
                                            }
                                            var1_1.print("    ");
                                            var1_1.print(var12_17[var14_24]);
                                            var17_29 = var12_17[var14_24].getBundle();
                                            var1_1.print("<");
                                            var1_1.print(var17_29);
                                            var1_1.println(">");
                                        }
                                        ++var16_27;
                                    }
                                }
                                ++var14_24;
                            }
                            if (!var9_11) ** GOTO lbl219
                            var1_1.print("  ");
                            var1_1.println(ConsoleMsg.CONSOLE_NO_REQUIRED_BUNDLES_MESSAGE);
                        }
                        finally {
                            this.context.ungetService((ServiceReference<?>)var7_6);
                        }
                    }
                } else {
                    var1_1.print("  ");
                    var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
                }
lbl219:
                // 5 sources

                if ((var8_10 = System.getSecurityManager()) != null) {
                    var9_12 = var3_3.getProtectionDomain();
                    var1_1.println(var9_12);
                }
            }
            var2_2 = var1_1.nextArgument();
        }
    }

    private boolean printImportedPackages(ExportPackageDescription[] exportPackageDescriptionArray, CommandInterpreter commandInterpreter, boolean bl) {
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (bl) {
                commandInterpreter.print("  ");
                commandInterpreter.println(ConsoleMsg.CONSOLE_IMPORTED_PACKAGES_MESSAGE);
                bl = false;
            }
            commandInterpreter.print("    ");
            commandInterpreter.print(exportPackageDescriptionArray[n].getName());
            commandInterpreter.print("; version=\"");
            commandInterpreter.print(exportPackageDescriptionArray[n].getVersion());
            commandInterpreter.print("\"");
            Bundle bundle = this.context.getBundle(exportPackageDescriptionArray[n].getSupplier().getBundleId());
            if (bundle != null) {
                commandInterpreter.print("<");
                commandInterpreter.print(bundle);
                commandInterpreter.println(">");
            } else {
                commandInterpreter.print("<");
                commandInterpreter.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                commandInterpreter.println(">");
            }
            ++n;
        }
        return bl;
    }

    private void printUnwiredDynamicImports(List<ImportPackageSpecification> list, CommandInterpreter commandInterpreter) {
        int n = 0;
        while (n < list.size()) {
            ImportPackageSpecification importPackageSpecification = list.get(n);
            commandInterpreter.print("    ");
            commandInterpreter.print(importPackageSpecification.getName());
            commandInterpreter.print("; version=\"");
            commandInterpreter.print(importPackageSpecification.getVersionRange());
            commandInterpreter.print("\"");
            commandInterpreter.print("<");
            commandInterpreter.print("unwired");
            commandInterpreter.print(">");
            commandInterpreter.print("<");
            commandInterpreter.print(importPackageSpecification.getDirective("resolution"));
            commandInterpreter.println(">");
            ++n;
        }
    }

    public void _gc(CommandInterpreter commandInterpreter) throws Exception {
        long l = Runtime.getRuntime().freeMemory();
        System.gc();
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long l2 = Runtime.getRuntime().freeMemory();
        commandInterpreter.print(ConsoleMsg.CONSOLE_TOTAL_MEMORY_MESSAGE);
        commandInterpreter.println(String.valueOf(Runtime.getRuntime().totalMemory()));
        commandInterpreter.print(ConsoleMsg.CONSOLE_FREE_MEMORY_BEFORE_GARBAGE_COLLECTION_MESSAGE);
        commandInterpreter.println(String.valueOf(l));
        commandInterpreter.print(ConsoleMsg.CONSOLE_FREE_MEMORY_AFTER_GARBAGE_COLLECTION_MESSAGE);
        commandInterpreter.println(String.valueOf(l2));
        commandInterpreter.print(ConsoleMsg.CONSOLE_MEMORY_GAINED_WITH_GARBAGE_COLLECTION_MESSAGE);
        commandInterpreter.println(String.valueOf(l2 - l));
    }

    public void _init(CommandInterpreter commandInterpreter) throws Exception {
        Object object;
        if (this.framework.isActive()) {
            commandInterpreter.print(newline);
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_LAUNCHED_PLEASE_SHUTDOWN_MESSAGE);
            return;
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        int n = abstractBundleArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                object = abstractBundleArray[n2];
                if (((AbstractBundle)object).getBundleId() != 0L) {
                    try {
                        ((AbstractBundle)object).uninstall();
                    }
                    catch (BundleException bundleException) {
                        commandInterpreter.printStackTrace(bundleException);
                    }
                }
                ++n2;
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        }
        if (this.securityAdmin != null) {
            this.securityAdmin.setDefaultPermissions(null);
            String[] stringArray = this.securityAdmin.getLocations();
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    this.securityAdmin.setPermissions(stringArray[n3], null);
                    ++n3;
                }
            }
            object = this.securityAdmin.newConditionalPermissionUpdate();
            object.getConditionalPermissionInfos().clear();
            object.commit();
        }
        if (this.securityAdmin != null) {
            Enumeration<ConditionalPermissionInfo> enumeration = this.securityAdmin.getConditionalPermissionInfos();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().delete();
            }
        }
    }

    public void _close(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.println();
        this.framework.close();
        System.exit(0);
    }

    public void _r(CommandInterpreter commandInterpreter) throws Exception {
        this._refresh(commandInterpreter);
    }

    public void _refresh(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference<?> serviceReference = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (serviceReference != null) {
            PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(serviceReference);
            if (packageAdmin != null) {
                try {
                    Bundle[] bundleArray = null;
                    String string = commandInterpreter.nextArgument();
                    if (string != null) {
                        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>();
                        while (string != null) {
                            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
                            if (abstractBundle != null) {
                                arrayList.add(abstractBundle);
                            }
                            string = commandInterpreter.nextArgument();
                        }
                        int n = arrayList.size();
                        if (n == 0) {
                            commandInterpreter.println(ConsoleMsg.CONSOLE_INVALID_BUNDLE_SPECIFICATION_ERROR);
                            return;
                        }
                        bundleArray = new Bundle[n];
                        arrayList.toArray(bundleArray);
                    }
                    packageAdmin.refreshPackages(bundleArray);
                }
                finally {
                    this.context.ungetService(serviceReference);
                }
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_CAN_NOT_REFRESH_NO_PACKAGE_ADMIN_ERROR);
        }
    }

    public void _exec(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process process = Runtime.getRuntime().exec(string);
        commandInterpreter.println(NLS.bind(ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, string, String.valueOf(process)));
        int n = process.waitFor();
        commandInterpreter.println(NLS.bind(ConsoleMsg.CONSOLE_EXECUTED_RESULT_CODE_MESSAGE, string, String.valueOf(n)));
    }

    public void _fork(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process process = Runtime.getRuntime().exec(string);
        commandInterpreter.println(NLS.bind(ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, string, String.valueOf(process)));
    }

    public void _h(CommandInterpreter commandInterpreter) throws Exception {
        this._headers(commandInterpreter);
    }

    public void _headers(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                commandInterpreter.printDictionary(abstractBundle.getHeaders(), ConsoleMsg.CONSOLE_BUNDLE_HEADERS_TITLE);
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _pr(CommandInterpreter commandInterpreter) throws Exception {
        this._props(commandInterpreter);
    }

    public void _props(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.printDictionary(FrameworkProperties.getProperties(), ConsoleMsg.CONSOLE_SYSTEM_PROPERTIES_TITLE);
    }

    public void _setp(CommandInterpreter commandInterpreter) throws Exception {
        this._setprop(commandInterpreter);
    }

    public void _setprop(CommandInterpreter commandInterpreter) throws Exception {
        block14: {
            String string = commandInterpreter.nextArgument();
            if (string == null) {
                commandInterpreter.println(ConsoleMsg.CONSOLE_NO_PARAMETERS_SPECIFIED_TITLE);
                this._props(commandInterpreter);
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                try {
                    try {
                        Properties properties = FrameworkProperties.getProperties();
                        Properties properties2 = new Properties();
                        properties2.load(byteArrayInputStream);
                        commandInterpreter.println(ConsoleMsg.CONSOLE_SETTING_PROPERTIES_TITLE);
                        Enumeration<?> enumeration = properties2.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            String string3 = (String)properties2.get(string2);
                            properties.put(string2, string3);
                            commandInterpreter.println(new StringBuffer(tab).append(string2).append(" = ").append(string3).toString());
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            ((InputStream)byteArrayInputStream).close();
                        }
                        catch (IOException iOException2) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void _ss(CommandInterpreter commandInterpreter) throws Exception {
        if (this.framework.isActive()) {
            commandInterpreter.println();
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            commandInterpreter.println();
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        Object[] objectArray = this.processOption(commandInterpreter);
        if (objectArray == null) {
            return;
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        if (abstractBundleArray.length == 0) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        } else {
            commandInterpreter.print(newline);
            commandInterpreter.print(ConsoleMsg.CONSOLE_ID);
            commandInterpreter.print(tab);
            commandInterpreter.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_TITLE);
            int n = 0;
            while (n < abstractBundleArray.length) {
                AbstractBundle abstractBundle = abstractBundleArray[n];
                if (this.match(abstractBundle, (String)objectArray[0], (Integer)objectArray[1])) {
                    int n2;
                    AbstractBundle[] abstractBundleArray2;
                    String string = abstractBundle.getSymbolicName();
                    string = string == null || string.length() == 0 ? abstractBundle.toString() : new StringBuffer(String.valueOf(string)).append("_").append(abstractBundle.getVersion()).toString();
                    commandInterpreter.println(new StringBuffer(String.valueOf(abstractBundle.getBundleId())).append(tab).append(this.getStateName(abstractBundle)).append(string).toString());
                    if (abstractBundle.isFragment()) {
                        abstractBundleArray2 = abstractBundle.getHosts();
                        if (abstractBundleArray2 != null) {
                            n2 = 0;
                            while (n2 < abstractBundleArray2.length) {
                                commandInterpreter.println(new StringBuffer("\t            Master=").append(abstractBundleArray2[n2].getBundleId()).toString());
                                ++n2;
                            }
                        }
                    } else {
                        abstractBundleArray2 = abstractBundle.getFragments();
                        if (abstractBundleArray2 != null) {
                            commandInterpreter.print("\t            Fragments=");
                            n2 = 0;
                            while (n2 < abstractBundleArray2.length) {
                                AbstractBundle abstractBundle2 = abstractBundleArray2[n2];
                                commandInterpreter.print(new StringBuffer(String.valueOf(n2 > 0 ? ", " : "")).append(abstractBundle2.getBundleId()).toString());
                                ++n2;
                            }
                            commandInterpreter.println();
                        }
                    }
                }
                ++n;
            }
        }
    }

    private boolean match(Bundle bundle, String string, int n) {
        if ((bundle.getState() & n) == 0) {
            return false;
        }
        return string == null || bundle.getSymbolicName() == null || bundle.getSymbolicName().indexOf(string) != -1;
    }

    public void _t(CommandInterpreter commandInterpreter) throws Exception {
        this._threads(commandInterpreter);
    }

    public void _threads(CommandInterpreter commandInterpreter) throws Exception {
        Object[] objectArray = this.getThreadGroups();
        Util.sortByString(objectArray);
        Object object = this.getTopThreadGroup();
        Object[] objectArray2 = new Thread[((ThreadGroup)object).activeCount()];
        int n = ((ThreadGroup)object).enumerate((Thread[])objectArray2, true);
        Util.sortByString(objectArray2);
        StringBuffer stringBuffer = new StringBuffer(120);
        commandInterpreter.println();
        commandInterpreter.println(ConsoleMsg.CONSOLE_THREADGROUP_TITLE);
        int n2 = 0;
        while (n2 < objectArray.length) {
            object = objectArray[n2];
            int n3 = ((ThreadGroup)object).activeCount();
            int n4 = ((ThreadGroup)object).enumerate(new Thread[n3], false);
            ThreadGroup threadGroup = ((ThreadGroup)object).getParent();
            String string = threadGroup == null ? "-none-" : threadGroup.getName();
            stringBuffer.setLength(0);
            stringBuffer.append(Util.toString(this.simpleClassName(object), 18)).append(" ").append(Util.toString(((ThreadGroup)object).getName(), 21)).append(" ").append(Util.toString(string, 16)).append(Util.toString(new Integer(((ThreadGroup)object).getMaxPriority()), 3)).append(Util.toString(new Integer(n4), 4)).append("/").append(Util.toString(String.valueOf(n3), 6));
            commandInterpreter.println(stringBuffer.toString());
            ++n2;
        }
        commandInterpreter.print(newline);
        commandInterpreter.println(ConsoleMsg.CONSOLE_THREADTYPE_TITLE);
        n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray2[n2];
            if (object2 != null) {
                stringBuffer.setLength(0);
                stringBuffer.append(Util.toString(this.simpleClassName(object2), 18)).append(" ").append(Util.toString(((Thread)object2).getName(), 21)).append(" ").append(Util.toString(((Thread)object2).getThreadGroup().getName(), 16)).append(Util.toString(new Integer(((Thread)object2).getPriority()), 3));
                if (((Thread)object2).isDaemon()) {
                    stringBuffer.append(" [daemon]");
                }
                commandInterpreter.println(stringBuffer.toString());
            }
            ++n2;
        }
    }

    public void _sl(CommandInterpreter commandInterpreter) throws Exception {
        if (this.isStartLevelSvcPresent(commandInterpreter)) {
            AbstractBundle abstractBundle = null;
            String string = commandInterpreter.nextArgument();
            int n = 0;
            if (string != null && (abstractBundle = this.getBundleFromToken(commandInterpreter, string, true)) == null) {
                return;
            }
            if (abstractBundle == null) {
                n = this.slImpl.getStartLevel();
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(n)));
            } else {
                n = this.slImpl.getBundleStartLevel(abstractBundle);
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, new Long(abstractBundle.getBundleId()), new Integer(n)));
            }
        }
    }

    public void _setfwsl(CommandInterpreter commandInterpreter) throws Exception {
        if (this.isStartLevelSvcPresent(commandInterpreter)) {
            int n = 0;
            String string = commandInterpreter.nextArgument();
            if (string == null) {
                commandInterpreter.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_GIVEN);
                n = this.slImpl.getStartLevel();
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(n)));
            } else {
                n = this.getStartLevelFromToken(commandInterpreter, string);
                if (n > 0) {
                    try {
                        this.slImpl.setStartLevel(n);
                        commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(n)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        commandInterpreter.println(illegalArgumentException.getMessage());
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void _setbsl(CommandInterpreter var1_1) throws Exception {
        block5: {
            if (!this.isStartLevelSvcPresent(var1_1)) break block5;
            var3_2 = null;
            var2_3 = var1_1.nextArgument();
            if (var2_3 == null) {
                var1_1.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
                return;
            }
            var4_4 = this.getStartLevelFromToken(var1_1, var2_3);
            var2_3 = var1_1.nextArgument();
            if (var2_3 != null) ** GOTO lbl21
            var1_1.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
            return;
lbl-1000:
            // 1 sources

            {
                var3_2 = this.getBundleFromToken(var1_1, var2_3, true);
                if (var3_2 != null) {
                    try {
                        this.slImpl.setBundleStartLevel(var3_2, var4_4);
                        var1_1.println(NLS.bind(ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, new Long(var3_2.getBundleId()), new Integer(var4_4)));
                    }
                    catch (IllegalArgumentException var5_5) {
                        var1_1.println(var5_5.getMessage());
                    }
                }
                var2_3 = var1_1.nextArgument();
lbl21:
                // 2 sources

                ** while (var2_3 != null)
            }
        }
    }

    public void _setibsl(CommandInterpreter commandInterpreter) throws Exception {
        if (this.isStartLevelSvcPresent(commandInterpreter)) {
            int n = 0;
            String string = commandInterpreter.nextArgument();
            if (string == null) {
                commandInterpreter.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_GIVEN);
                n = this.slImpl.getInitialBundleStartLevel();
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, String.valueOf(n)));
            } else {
                n = this.getStartLevelFromToken(commandInterpreter, string);
                if (n > 0) {
                    try {
                        this.slImpl.setInitialBundleStartLevel(n);
                        commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, String.valueOf(n)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        commandInterpreter.println(illegalArgumentException.getMessage());
                    }
                }
            }
        }
    }

    public void _requiredBundles(CommandInterpreter commandInterpreter) {
        this._classSpaces(commandInterpreter);
    }

    public void _classSpaces(CommandInterpreter commandInterpreter) {
        String string = commandInterpreter.nextArgument();
        ServiceReference<?> serviceReference = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (serviceReference != null) {
            PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(serviceReference);
            if (packageAdmin != null) {
                try {
                    RequiredBundle[] requiredBundleArray = null;
                    requiredBundleArray = packageAdmin.getRequiredBundles(string);
                    if (requiredBundleArray == null) {
                        commandInterpreter.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                    }
                    int n = 0;
                    while (n < requiredBundleArray.length) {
                        Bundle bundle;
                        RequiredBundle requiredBundle = requiredBundleArray[n];
                        commandInterpreter.print(requiredBundle);
                        boolean bl = requiredBundle.isRemovalPending();
                        if (bl) {
                            commandInterpreter.print("(");
                            commandInterpreter.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                            commandInterpreter.println(")");
                        }
                        if ((bundle = requiredBundle.getBundle()) != null) {
                            commandInterpreter.print("<");
                            commandInterpreter.print(bundle);
                            commandInterpreter.println(">");
                            Bundle[] bundleArray = requiredBundle.getRequiringBundles();
                            if (bundleArray != null) {
                                int n2 = 0;
                                while (n2 < bundleArray.length) {
                                    commandInterpreter.print("  ");
                                    commandInterpreter.print(bundleArray[n2]);
                                    commandInterpreter.print(" ");
                                    commandInterpreter.println(ConsoleMsg.CONSOLE_REQUIRES_MESSAGE);
                                    ++n2;
                                }
                            }
                        } else {
                            commandInterpreter.print("<");
                            commandInterpreter.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                            commandInterpreter.println(">");
                        }
                        ++n;
                    }
                }
                finally {
                    this.context.ungetService(serviceReference);
                }
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    public void _profilelog(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.println(Profile.getProfileLog());
    }

    public void _getPackages(CommandInterpreter commandInterpreter) {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            return;
        }
        AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
        ServiceReference<?> serviceReference = this.context.getServiceReference("org.eclipse.osgi.service.resolver.PlatformAdmin");
        if (serviceReference == null) {
            return;
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
        try {
            ExportPackageDescription[] exportPackageDescriptionArray = platformAdmin.getStateHelper().getVisiblePackages(abstractBundle.getBundleDescription(), 3);
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                commandInterpreter.println(new StringBuffer().append(exportPackageDescriptionArray[n]).append(": ").append(platformAdmin.getStateHelper().getAccessCode(abstractBundle.getBundleDescription(), exportPackageDescriptionArray[n])).toString());
                ++n;
            }
        }
        finally {
            this.context.ungetService(serviceReference);
        }
    }

    public Object _help(CommandInterpreter commandInterpreter) {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            return new Boolean(false);
        }
        String string2 = this.getHelp(string);
        return string2.length() > 0 ? string2 : new Boolean(false);
    }

    protected boolean isStartLevelSvcPresent(CommandInterpreter commandInterpreter) {
        boolean bl = false;
        ServiceReference<?> serviceReference = this.context.getServiceReference("org.osgi.service.startlevel.StartLevel");
        if (serviceReference != null) {
            StartLevel startLevel = (StartLevel)this.context.getService(serviceReference);
            if (startLevel != null) {
                bl = true;
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_CAN_NOT_USE_STARTLEVEL_NO_STARTLEVEL_SVC_ERROR);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractBundle getBundleFromToken(CommandInterpreter var1_1, String var2_2, boolean var3_3) {
        block8: {
            var4_4 = null;
            try {
                var5_5 = Long.parseLong(var2_2);
                var4_4 = (AbstractBundle)this.context.getBundle(var5_5);
                break block8;
            }
            catch (NumberFormatException v0) {
                var5_6 = var2_2;
                var6_7 = null;
                var7_8 = var2_2.indexOf("@");
                if (var7_8 != -1 && var7_8 + 1 != var2_2.length()) {
                    try {
                        var6_7 = Version.parseVersion(var2_2.substring(var7_8 + 1, var2_2.length()));
                        var5_6 = var2_2.substring(0, var7_8);
                    }
                    catch (IllegalArgumentException v1) {}
                }
                var8_9 = this.context.getBundles();
                var9_10 = 0;
                var10_11 = var8_9.length;
                ** while (var9_10 < var10_11)
            }
lbl-1000:
            // 1 sources

            {
                var11_12 = (AbstractBundle)var8_9[var9_10];
                if (var5_6.equals(var11_12.getSymbolicName()) && (var6_7 == null || var6_7.equals(var11_12.getVersion())) || var2_2.equals(var11_12.getLocation())) {
                    var4_4 = var11_12;
                    break;
                }
                ++var9_10;
                continue;
            }
        }
        if (var4_4 == null && var3_3) {
            var1_1.println(NLS.bind(ConsoleMsg.CONSOLE_CANNOT_FIND_BUNDLE_ERROR, var2_2));
        }
        return var4_4;
    }

    protected int getStartLevelFromToken(CommandInterpreter commandInterpreter, String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
            if (Integer.parseInt(string) <= 0) {
                commandInterpreter.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            commandInterpreter.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getStateName(Bundle bundle) {
        int n = bundle.getState();
        switch (n) {
            case 1: {
                return "UNINSTALLED ";
            }
            case 2: {
                if (this.isDisabled(bundle)) {
                    return "<DISABLED>  ";
                }
                return "INSTALLED   ";
            }
            case 4: {
                return "RESOLVED    ";
            }
            case 8: {
                List<Bundle> list = this.lazyActivation;
                synchronized (list) {
                    if (this.lazyActivation.contains(bundle)) {
                        return "<<LAZY>>    ";
                    }
                    return "STARTING    ";
                }
            }
            case 16: {
                return "STOPPING    ";
            }
            case 32: {
                return "ACTIVE      ";
            }
        }
        return Integer.toHexString(n);
    }

    private boolean isDisabled(Bundle bundle) {
        boolean bl = false;
        ServiceReference<?> serviceReference = null;
        try {
            BundleDescription bundleDescription;
            State state;
            DisabledInfo[] disabledInfoArray;
            PlatformAdmin platformAdmin;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((serviceReference = this.context.getServiceReference(clazz.getName())) != null && (platformAdmin = (PlatformAdmin)this.context.getService(serviceReference)) != null && (disabledInfoArray = (state = platformAdmin.getState(false)).getDisabledInfos(bundleDescription = state.getBundle(bundle.getBundleId()))) != null && disabledInfoArray.length != 0) {
                bl = true;
            }
        }
        finally {
            if (serviceReference != null) {
                this.context.ungetService(serviceReference);
            }
        }
        return bl;
    }

    protected ThreadGroup[] getThreadGroups() {
        ThreadGroup[] threadGroupArray;
        ThreadGroup threadGroup = this.getTopThreadGroup();
        int n = threadGroup.enumerate(threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount()], true);
        if (n == threadGroupArray.length) {
            return threadGroupArray;
        }
        ThreadGroup[] threadGroupArray2 = new ThreadGroup[n];
        System.arraycopy(threadGroupArray, 0, threadGroupArray2, 0, n);
        return threadGroupArray2;
    }

    protected ThreadGroup getTopThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup != null) {
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
        }
        return threadGroup;
    }

    public String simpleClassName(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.getClass().getName(), ".");
        int n = stringTokenizer.countTokens();
        int n2 = 1;
        while (n2 < n) {
            stringTokenizer.nextToken();
            ++n2;
        }
        return stringTokenizer.nextToken();
    }

    public void _getprop(CommandInterpreter commandInterpreter) throws Exception {
        Properties properties = FrameworkProperties.getProperties();
        String string = commandInterpreter.nextArgument();
        for (String string2 : new TreeSet<Object>(properties.keySet())) {
            if (string != null && !string2.startsWith(string)) continue;
            commandInterpreter.println(new StringBuffer(String.valueOf(string2)).append('=').append(properties.getProperty(string2)).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bundleChanged(BundleEvent bundleEvent) {
        int n = bundleEvent.getType();
        Bundle bundle = bundleEvent.getBundle();
        List<Bundle> list = this.lazyActivation;
        synchronized (list) {
            switch (n) {
                case 512: {
                    if (this.lazyActivation.contains(bundle)) break;
                    this.lazyActivation.add(bundle);
                    break;
                }
                default: {
                    this.lazyActivation.remove(bundle);
                }
            }
        }
    }
}

