/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkConsole;
import org.eclipse.osgi.framework.internal.core.FrameworkConsoleSession;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleManager
implements ServiceTrackerCustomizer<ConsoleSession, FrameworkConsole> {
    public static final String PROP_CONSOLE = "osgi.console";
    private static final String PROP_SYSTEM_IN_OUT = "console.systemInOut";
    private static final String CONSOLE_NAME = "OSGi Console";
    private static final String PROP_CONSOLE_ENABLED = "osgi.console.enable.builtin";
    private final Framework framework;
    private final ServiceTracker<CommandProvider, CommandProvider> cpTracker;
    private final ServiceTracker<ConsoleSession, FrameworkConsole> sessions;
    private final String consolePort;
    private final String consoleHost;
    private FrameworkCommandProvider fwkCommands;
    private ServiceRegistration<?> builtinSession;
    private ConsoleSocketGetter socketGetter;
    private final boolean isEnabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConsoleManager(Framework framework, String string) {
        String string2 = null;
        String string3 = null;
        if (string != null) {
            int n = string.lastIndexOf(":");
            if (n > -1) {
                string3 = string.substring(0, n);
            }
            string2 = string.substring(n + 1);
        }
        if ("false".equals(FrameworkProperties.getProperty(PROP_CONSOLE_ENABLED)) || "none".equals(string2)) {
            this.isEnabled = false;
            this.framework = null;
            this.cpTracker = null;
            this.sessions = null;
            this.consoleHost = null;
            this.consolePort = null;
            return;
        }
        this.isEnabled = true;
        this.framework = framework;
        this.consoleHost = string3 != null ? string3.trim() : string3;
        this.consolePort = string2 != null ? string2.trim() : string2;
        BundleContextImpl bundleContextImpl = framework.getSystemBundleContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cpTracker = new ServiceTracker((BundleContext)bundleContextImpl, clazz.getName(), null);
        BundleContextImpl bundleContextImpl2 = framework.getSystemBundleContext();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.osgi.framework.console.ConsoleSession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.sessions = new ServiceTracker<ConsoleSession, FrameworkConsole>((BundleContext)bundleContextImpl2, clazz2.getName(), this);
    }

    public static ConsoleManager startConsole(Framework framework) {
        ConsoleManager consoleManager = new ConsoleManager(framework, FrameworkProperties.getProperty(PROP_CONSOLE));
        consoleManager.startConsole();
        return consoleManager;
    }

    private void startConsole() {
        if (!this.isEnabled) {
            return;
        }
        this.cpTracker.open();
        this.sessions.open();
        this.fwkCommands = new FrameworkCommandProvider(this.framework);
        this.fwkCommands.start();
        if (this.consolePort == null) {
            return;
        }
        int n = -1;
        try {
            if (this.consolePort.length() > 0) {
                n = Integer.parseInt(this.consolePort);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (n < 0) {
            FilterInputStream filterInputStream = new FilterInputStream(System.in){

                public void close() throws IOException {
                }
            };
            FilterOutputStream filterOutputStream = new FilterOutputStream(System.out){

                public void close() throws IOException {
                }

                public void write(byte[] byArray, int n, int n2) throws IOException {
                    this.out.write(byArray, n, n2);
                }
            };
            FrameworkConsoleSession frameworkConsoleSession = new FrameworkConsoleSession(filterInputStream, filterOutputStream, null);
            Hashtable<String, Boolean> hashtable = null;
            hashtable = new Hashtable<String, Boolean>(1);
            ((Dictionary)hashtable).put(PROP_SYSTEM_IN_OUT, Boolean.TRUE);
            BundleContextImpl bundleContextImpl = this.framework.getSystemBundleContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.ConsoleSession");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.builtinSession = bundleContextImpl.registerService(clazz.getName(), (Object)frameworkConsoleSession, hashtable);
        } else {
            try {
                this.socketGetter = this.consoleHost != null ? new ConsoleSocketGetter(new ServerSocket(n, 0, InetAddress.getByName(this.consoleHost))) : new ConsoleSocketGetter(new ServerSocket(n));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void stopConsole() {
        if (!this.isEnabled) {
            return;
        }
        if (this.builtinSession != null) {
            try {
                this.builtinSession.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.sessions.close();
        this.cpTracker.close();
        if (this.socketGetter != null) {
            this.socketGetter.shutdown();
        }
        if (this.fwkCommands != null) {
            this.fwkCommands.stop();
        }
    }

    @Override
    public FrameworkConsole addingService(ServiceReference<ConsoleSession> serviceReference) {
        FrameworkConsole frameworkConsole = null;
        Boolean bl = (Boolean)serviceReference.getProperty(PROP_SYSTEM_IN_OUT);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        ConsoleSession consoleSession = this.framework.getSystemBundleContext().getService(serviceReference);
        frameworkConsole = new FrameworkConsole(this.framework.getSystemBundleContext(), consoleSession, bl, this.cpTracker);
        Thread thread = new Thread((Runnable)frameworkConsole, CONSOLE_NAME);
        thread.setDaemon(false);
        thread.start();
        return frameworkConsole;
    }

    @Override
    public void modifiedService(ServiceReference<ConsoleSession> serviceReference, FrameworkConsole frameworkConsole) {
    }

    @Override
    public void removedService(ServiceReference<ConsoleSession> serviceReference, FrameworkConsole frameworkConsole) {
        frameworkConsole.shutdown();
    }

    class ConsoleSocketGetter
    implements Runnable {
        private final ServerSocket server;
        private volatile boolean shutdown = false;

        ConsoleSocketGetter(ServerSocket serverSocket) {
            Object object;
            this.server = serverSocket;
            try {
                object = serverSocket.getClass().getMethod("setReuseAddress", Boolean.TYPE);
                ((Method)object).invoke((Object)serverSocket, Boolean.TRUE);
            }
            catch (Exception exception) {}
            object = new Thread((Runnable)this, "ConsoleSocketGetter");
            ((Thread)object).setDaemon(false);
            ((Thread)object).start();
        }

        public void run() {
            System.out.println(NLS.bind(ConsoleMsg.CONSOLE_LISTENING_ON_PORT, String.valueOf(this.server.getInetAddress().toString()) + ':' + Integer.toString(this.server.getLocalPort())));
            while (!this.shutdown) {
                try {
                    Socket socket = this.server.accept();
                    if (socket == null) {
                        throw new IOException("No socket available.  Probably caused by a shutdown.");
                    }
                    FrameworkConsoleSession frameworkConsoleSession = new FrameworkConsoleSession(socket.getInputStream(), socket.getOutputStream(), socket);
                    BundleContextImpl bundleContextImpl = ConsoleManager.this.framework.getSystemBundleContext();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.osgi.framework.console.ConsoleSession");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    bundleContextImpl.registerService(clazz.getName(), (Object)frameworkConsoleSession, null);
                }
                catch (Exception exception) {
                    if (this.shutdown) continue;
                    exception.printStackTrace();
                }
            }
        }

        public void shutdown() {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

