/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Tokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasMapper {
    private static Map<String, Object> processorAliasTable;
    private static Map<String, Object> osnameAliasTable;
    static /* synthetic */ Class class$0;

    private static synchronized Map<String, Object> getProcessorAliasTable() {
        if (processorAliasTable == null) {
            InputStream inputStream;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.AliasMapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((inputStream = clazz.getResourceAsStream("processor.aliases")) != null) {
                try {
                    processorAliasTable = AliasMapper.initAliases(inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return processorAliasTable;
    }

    private static synchronized Map<String, Object> getOSNameAliasTable() {
        if (osnameAliasTable == null) {
            InputStream inputStream;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.AliasMapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((inputStream = clazz.getResourceAsStream("osname.aliases")) != null) {
                try {
                    osnameAliasTable = AliasMapper.initAliases(inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return osnameAliasTable;
    }

    public String aliasProcessor(String string) {
        String string2;
        string = string.toLowerCase();
        Map<String, Object> map = AliasMapper.getProcessorAliasTable();
        if (map != null && (string2 = (String)map.get(string)) != null) {
            string = string2;
        }
        return string;
    }

    public Object aliasOSName(String string) {
        Object object;
        string = string.toLowerCase();
        Map<String, Object> map = AliasMapper.getOSNameAliasTable();
        if (map != null && (object = map.get(string)) != null) {
            if (object instanceof String) {
                string = (String)object;
            } else {
                return object;
            }
        }
        return string;
    }

    protected static Map<String, Object> initAliases(InputStream inputStream) {
        HashMap<String, Object> hashMap;
        block8: {
            hashMap = new HashMap<String, Object>(37);
            try {
                String string;
                BufferedReader bufferedReader;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                }
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    Tokenizer tokenizer = new Tokenizer(string);
                    String string3 = tokenizer.getString("# \t");
                    if (string3 == null) continue;
                    hashMap.put(string3.toLowerCase(), string3);
                    while ((string2 = tokenizer.getString("# \t")) != null) {
                        ArrayList<String> arrayList;
                        String string4 = string2.toLowerCase();
                        Object v = hashMap.get(string4);
                        if (v == null) {
                            hashMap.put(string4, string3);
                            continue;
                        }
                        if (v instanceof String) {
                            arrayList = new ArrayList<String>();
                            arrayList.add((String)v);
                            arrayList.add(string3);
                            hashMap.put(string4, arrayList);
                            continue;
                        }
                        arrayList = (ArrayList<String>)v;
                        arrayList.add(string3);
                    }
                }
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block8;
                Debug.printStackTrace(iOException);
            }
        }
        return hashMap;
    }
}

