/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.composite.CompositeImpl;
import org.eclipse.osgi.internal.composite.SurrogateImpl;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBundle
implements Bundle,
Comparable<Bundle>,
KeyedElement,
BundleStartLevel,
BundleReference,
BundleRevisions {
    private static final long STATE_CHANGE_TIMEOUT;
    protected final Framework framework;
    protected volatile int state = 2;
    protected volatile Thread stateChanging = null;
    protected BundleData bundledata;
    protected final Object statechangeLock = new Object();
    protected BundleProtectionDomain domain;
    protected volatile ManifestLocalization manifestLocalization = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        long l = 5000L;
        try {
            String string = FrameworkProperties.getProperty("equinox.statechange.timeout");
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (Throwable throwable) {
            l = 5000L;
        }
        STATE_CHANGE_TIMEOUT = l;
    }

    protected static AbstractBundle createBundle(BundleData bundleData, Framework framework, boolean bl) throws BundleException {
        AbstractBundle abstractBundle = (bundleData.getType() & 1) > 0 ? new BundleFragment(bundleData, framework) : ((bundleData.getType() & 0x20) > 0 ? new CompositeImpl(bundleData, framework) : ((bundleData.getType() & 0x40) > 0 ? new SurrogateImpl(bundleData, framework) : new BundleHost(bundleData, framework)));
        if (bl) {
            bundleData.setBundle(abstractBundle);
        }
        return abstractBundle;
    }

    protected AbstractBundle(BundleData bundleData, Framework framework) {
        this.bundledata = bundleData;
        this.framework = framework;
    }

    protected abstract void load();

    protected abstract boolean reload(AbstractBundle var1);

    protected abstract void refresh();

    protected abstract boolean unload();

    protected void close() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println(new StringBuffer("Bundle.close called when state != INSTALLED: ").append(this).toString());
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 1;
    }

    protected BundleActivator loadBundleActivator() throws BundleException {
        String string = this.bundledata.getActivator();
        if (string != null) {
            try {
                Class<?> clazz = this.loadClass(string, false);
                return (BundleActivator)clazz.newInstance();
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(throwable);
                }
                throw new BundleException(NLS.bind(Msg.BUNDLE_INVALID_ACTIVATOR_EXCEPTION, string, this.bundledata.getSymbolicName()), 5, throwable);
            }
        }
        return null;
    }

    protected abstract Class<?> loadClass(String var1, boolean var2) throws ClassNotFoundException;

    @Override
    public int getState() {
        return this.state;
    }

    public Framework getFramework() {
        return this.framework;
    }

    protected boolean isActive() {
        return (this.state & 0x28) != 0;
    }

    boolean isLazyStart() {
        int n = this.bundledata.getStatus();
        return (n & 4) != 0 && (n & 2) != 0;
    }

    public boolean isResolved() {
        return (this.state & 3) == 0;
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    @Override
    public void start(int n) throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.startWorker(n);
        }
        finally {
            this.completeStateChange();
        }
    }

    protected abstract void startWorker(int var1) throws BundleException;

    protected boolean readyToResume() {
        return false;
    }

    protected void resume() throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            if (this.readyToResume()) {
                this.startWorker(1);
            }
        }
        finally {
            this.completeStateChange();
        }
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    @Override
    public void stop(int n) throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.stopWorker(n);
        }
        finally {
            this.completeStateChange();
        }
    }

    protected abstract void stopWorker(int var1) throws BundleException;

    protected void setStatus(final int n, final boolean bl) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    boolean bl3;
                    int n2 = AbstractBundle.this.bundledata.getStatus();
                    boolean bl2 = bl3 = (n2 & n) != 0;
                    if (bl3 != bl) {
                        AbstractBundle.this.bundledata.setStatus(bl ? n2 | n : n2 & ~n);
                        AbstractBundle.this.bundledata.save();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.framework.publishFrameworkEvent(2, this, privilegedActionException.getException());
        }
    }

    protected void suspend(boolean bl) throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            this.stopWorker(1);
        }
        finally {
            if (!bl) {
                this.completeStateChange();
            }
        }
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(final InputStream inputStream) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println(new StringBuffer("update location ").append(this.bundledata.getLocation()).toString());
            Debug.println(new StringBuffer("   from: ").append(inputStream).toString());
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 0x16) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.updateWorker(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws BundleException {
                    URLConnection uRLConnection = null;
                    if (inputStream == null) {
                        String string = AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation");
                        if (string == null) {
                            string = AbstractBundle.this.bundledata.getLocation();
                        }
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println(new StringBuffer("   from location: ").append(string).toString());
                        }
                        uRLConnection = AbstractBundle.this.framework.adaptor.mapLocationToURLConnection(string);
                    } else {
                        uRLConnection = new BundleSource(inputStream);
                    }
                    AbstractBundle.this.updateWorkerPrivileged(uRLConnection, accessControlContext);
                    return null;
                }
            });
        }
        finally {
            this.completeStateChange();
        }
    }

    protected void updateWorker(PrivilegedExceptionAction<Object> privilegedExceptionAction) throws BundleException {
        int n;
        block15: {
            n = 0;
            if (!this.isFragment()) {
                n = this.state;
            }
            if ((n & 0x28) != 0) {
                try {
                    this.stopWorker(1);
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, this, bundleException);
                    if ((this.state & 0x28) == 0) break block15;
                    throw bundleException;
                }
            }
        }
        try {
            try {
                AccessController.doPrivileged(privilegedExceptionAction);
                this.framework.publishBundleEvent(8, this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof RuntimeException) {
                    throw (RuntimeException)privilegedActionException.getException();
                }
                throw (BundleException)privilegedActionException.getException();
            }
        }
        catch (Throwable throwable) {
            if ((n & 0x28) != 0) {
                try {
                    this.startWorker(1 | ((n & 8) != 0 ? 2 : 0));
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, this, bundleException);
                }
            }
            throw throwable;
        }
        if ((n & 0x28) != 0) {
            try {
                this.startWorker(1 | ((n & 8) != 0 ? 2 : 0));
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, this, bundleException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWorkerPrivileged(URLConnection uRLConnection, AccessControlContext accessControlContext) throws BundleException {
        AbstractBundle abstractBundle = AbstractBundle.createBundle(this.bundledata, this.framework, false);
        boolean bl = false;
        BundleOperation bundleOperation = this.framework.adaptor.updateBundle(this.bundledata, uRLConnection);
        BundleRepository bundleRepository = this.framework.getBundles();
        try {
            boolean bl2;
            BundleData bundleData = bundleOperation.begin();
            final AbstractBundle abstractBundle2 = this.framework.createAndVerifyBundle(bundleData, false);
            int n = this.getState();
            BundleRepository bundleRepository2 = bundleRepository;
            synchronized (bundleRepository2) {
                String string = this.getSymbolicName();
                bl2 = this.reload(abstractBundle2);
                bundleRepository.update(string, this);
                this.manifestLocalization = null;
            }
            bl = true;
            if (System.getSecurityManager() != null) {
                boolean bl3;
                boolean bl4 = bl3 = (this.bundledata.getType() & 0x16) != 0;
                if (bl3 && !this.hasPermission(new AllPermission())) {
                    throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, 6, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            AbstractBundle.this.framework.checkAdminPermission(abstractBundle2, "lifecycle");
                            if (bl3) {
                                AbstractBundle.this.framework.checkAdminPermission(abstractBundle2, "extensionLifecycle");
                            }
                            return null;
                        }
                    }, accessControlContext);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            if (n == 4) {
                this.framework.publishBundleEvent(64, this);
            }
            bundleOperation.commit(bl2);
        }
        catch (Throwable throwable) {
            block17: {
                try {
                    bundleOperation.undo();
                    if (!bl) break block17;
                    BundleRepository bundleRepository3 = bundleRepository;
                    synchronized (bundleRepository3) {
                        String string = this.getSymbolicName();
                        this.reload(abstractBundle);
                        bundleRepository.update(string, this);
                    }
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, this, bundleException);
                }
            }
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            if (throwable instanceof BundleException) {
                throw (BundleException)throwable;
            }
            throw new BundleException(throwable.getMessage(), throwable);
        }
    }

    @Override
    public void uninstall() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println(new StringBuffer("uninstall location: ").append(this.bundledata.getLocation()).toString());
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 0x16) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            this.uninstallWorker(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws BundleException {
                    AbstractBundle.this.uninstallWorkerPrivileged();
                    return null;
                }
            });
        }
        finally {
            this.completeStateChange();
        }
    }

    protected void uninstallWorker(PrivilegedExceptionAction<Object> privilegedExceptionAction) throws BundleException {
        boolean bl = false;
        if (!this.isFragment()) {
            boolean bl2 = bl = (this.state & 0x28) != 0;
        }
        if (bl) {
            try {
                this.stopWorker(1);
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, this, bundleException);
            }
        }
        try {
            AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (bl) {
                try {
                    this.startWorker(1);
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, this, bundleException);
                }
            }
            throw (BundleException)privilegedActionException.getException();
        }
        this.framework.publishBundleEvent(16, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallWorkerPrivileged() throws BundleException {
        BundleWatcher bundleWatcher = this.framework.adaptor.getBundleWatcher();
        if (bundleWatcher != null) {
            bundleWatcher.watchBundle(this, 64);
        }
        boolean bl = false;
        this.getHeaders();
        BundleOperation bundleOperation = this.framework.adaptor.uninstallBundle(this.bundledata);
        BundleRepository bundleRepository = this.framework.getBundles();
        try {
            try {
                boolean bl2;
                bundleOperation.begin();
                int n = this.getState();
                BundleRepository bundleRepository2 = bundleRepository;
                synchronized (bundleRepository2) {
                    bundleRepository.remove(this);
                    bl2 = this.unload();
                }
                if (n == 4) {
                    this.framework.publishBundleEvent(64, this);
                }
                bl = true;
                bundleOperation.commit(bl2);
                this.close();
            }
            catch (BundleException bundleException) {
                block17: {
                    try {
                        bundleOperation.undo();
                        if (!bl) break block17;
                        BundleRepository bundleRepository3 = bundleRepository;
                        synchronized (bundleRepository3) {
                            this.load();
                            bundleRepository.add(this);
                        }
                    }
                    catch (BundleException bundleException2) {
                        this.framework.publishFrameworkEvent(2, this, bundleException2);
                    }
                }
                throw bundleException;
            }
        }
        finally {
            if (bundleWatcher != null) {
                bundleWatcher.watchBundle(this, 128);
            }
        }
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    @Override
    public Dictionary<String, String> getHeaders(String string) {
        ManifestLocalization manifestLocalization;
        this.framework.checkAdminPermission(this, "metadata");
        try {
            manifestLocalization = this.getManifestLocalization();
        }
        catch (BundleException bundleException) {
            this.framework.publishFrameworkEvent(2, this, bundleException);
            return new Hashtable<String, String>();
        }
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        return manifestLocalization.getHeaders(string);
    }

    @Override
    public long getBundleId() {
        return this.bundledata.getBundleID();
    }

    @Override
    public String getLocation() {
        this.framework.checkAdminPermission(this, "metadata");
        return this.bundledata.getLocation();
    }

    @Override
    public boolean hasPermission(Object object) {
        this.checkValid();
        if (this.domain != null) {
            if (object instanceof Permission) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof EquinoxSecurityManager) {
                    AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{this.domain});
                    try {
                        securityManager.checkPermission((Permission)object, accessControlContext);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return this.domain.implies((Permission)object);
            }
            return false;
        }
        return true;
    }

    protected void beginStateChange() throws BundleException {
        Object object = this.statechangeLock;
        synchronized (object) {
            boolean bl = false;
            while (true) {
                if (this.stateChanging == null) {
                    this.stateChanging = Thread.currentThread();
                    return;
                }
                if (bl || this.stateChanging == Thread.currentThread()) {
                    throw new BundleException(NLS.bind(Msg.BUNDLE_STATE_CHANGE_EXCEPTION, this.getBundleData().getLocation(), this.stateChanging.getName()), 7, new BundleStatusException(null, 4, this.stateChanging));
                }
                try {
                    long l;
                    long l2 = 0L;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(new StringBuffer(" Waiting for state to change in bundle ").append(this).toString());
                        l2 = System.currentTimeMillis();
                    }
                    this.statechangeLock.wait(STATE_CHANGE_TIMEOUT);
                    if (Debug.DEBUG_GENERAL && (l = System.currentTimeMillis()) - l2 > 0L) {
                        System.out.println(new StringBuffer("Waiting... : ").append(this.getSymbolicName()).append(' ').append(l - l2).toString());
                    }
                }
                catch (InterruptedException interruptedException) {}
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeStateChange() {
        Object object = this.statechangeLock;
        synchronized (object) {
            if (this.stateChanging == Thread.currentThread()) {
                this.stateChanging = null;
                this.statechangeLock.notify();
            }
        }
    }

    public String toString() {
        String string = this.bundledata.getSymbolicName();
        if (string == null) {
            string = "unknown";
        }
        return new StringBuffer(String.valueOf(string)).append('_').append(this.bundledata.getVersion()).append(" [").append(this.getBundleId()).append("]").toString();
    }

    @Override
    public int compareTo(Bundle bundle) {
        int n = this.getInternalStartLevel() - ((AbstractBundle)bundle).getInternalStartLevel();
        if (n != 0) {
            return n;
        }
        long l = this.getBundleId() - ((AbstractBundle)bundle).getBundleId();
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    protected void checkValid() {
        if (this.state == 1) {
            throw new IllegalStateException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
    }

    public BundleProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    protected BundleFragment[] getFragments() {
        this.checkValid();
        return null;
    }

    protected boolean isFragment() {
        return false;
    }

    BundleHost[] getHosts() {
        this.checkValid();
        return null;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    @Override
    public Enumeration<String> getEntryPaths(final String string) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        return AccessController.doPrivileged(new PrivilegedAction<Enumeration<String>>(){

            @Override
            public Enumeration<String> run() {
                return AbstractBundle.this.bundledata.getEntryPaths(string);
            }
        });
    }

    @Override
    public URL getEntry(String string) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        return this.getEntry0(string);
    }

    URL getEntry0(String string) {
        this.checkValid();
        return this.bundledata.getEntry(string);
    }

    @Override
    public String getSymbolicName() {
        return this.bundledata.getSymbolicName();
    }

    @Override
    public long getLastModified() {
        return this.bundledata.getLastModified();
    }

    public BundleData getBundleData() {
        return this.bundledata;
    }

    @Override
    public Version getVersion() {
        return this.bundledata.getVersion();
    }

    public BundleDescription getBundleDescription() {
        return this.framework.adaptor.getState().getBundle(this.getBundleId());
    }

    int getInternalStartLevel() {
        return this.bundledata.getStartLevel();
    }

    protected abstract BundleLoader getBundleLoader();

    protected void resolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println(new StringBuffer("Bundle.resolve called when state != INSTALLED: ").append(this).toString());
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 2) {
            this.state = 4;
        }
    }

    @Override
    public BundleContext getBundleContext() {
        this.framework.checkAdminPermission(this, "context");
        return this.getContext();
    }

    protected abstract BundleContextImpl getContext();

    public BundleException getResolutionFailureException() {
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return new BundleException(NLS.bind(Msg.BUNDLE_UNRESOLVED_EXCEPTION, this.toString()), 4);
        }
        if (bundleDescription.isResolved()) {
            return new BundleException(Msg.BUNDLE_UNRESOLVED_STATE_CONFLICT, 4);
        }
        return this.getResolverError(bundleDescription);
    }

    private BundleException getResolverError(BundleDescription bundleDescription) {
        ResolverError[] resolverErrorArray = this.framework.adaptor.getState().getResolverErrors(bundleDescription);
        if (resolverErrorArray == null || resolverErrorArray.length == 0) {
            return new BundleException(NLS.bind(Msg.BUNDLE_UNRESOLVED_EXCEPTION, this.toString()), 4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 4;
        int n2 = 0;
        while (n2 < resolverErrorArray.length) {
            if ((resolverErrorArray[n2].getType() & 0x20000) != 0) {
                n = 8;
            }
            stringBuffer.append(resolverErrorArray[n2].toString());
            if (n2 < resolverErrorArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        return new BundleException(NLS.bind(Msg.BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION, this.toString(), stringBuffer.toString()), n);
    }

    @Override
    public int getKeyHashCode() {
        long l = this.getBundleId();
        return (int)(l ^ l >>> 32);
    }

    @Override
    public boolean compare(KeyedElement keyedElement) {
        return this.getBundleId() == ((AbstractBundle)keyedElement).getBundleId();
    }

    @Override
    public Object getKey() {
        return new Long(this.getBundleId());
    }

    public ResourceBundle getResourceBundle(String string) {
        ManifestLocalization manifestLocalization;
        try {
            manifestLocalization = this.getManifestLocalization();
        }
        catch (BundleException bundleException) {
            return null;
        }
        String string2 = Locale.getDefault().toString();
        if (string == null) {
            string = string2;
        }
        return manifestLocalization.getResourceBundle(string, string2.equals(string));
    }

    private synchronized ManifestLocalization getManifestLocalization() throws BundleException {
        ManifestLocalization manifestLocalization = this.manifestLocalization;
        if (manifestLocalization == null) {
            Dictionary<String, String> dictionary = this.bundledata.getManifest();
            this.manifestLocalization = manifestLocalization = new ManifestLocalization(this, dictionary);
        }
        return manifestLocalization;
    }

    public boolean testStateChanging(Object object) {
        return this.stateChanging == object;
    }

    public Thread getStateChanging() {
        return this.stateChanging;
    }

    @Override
    public Enumeration<URL> findEntries(String string, String string2, boolean bl) {
        BundleFragment[] bundleFragmentArray;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (!this.isResolved()) {
            this.framework.packageAdmin.resolveBundles(new Bundle[]{this});
        }
        ArrayList<BundleData> arrayList = new ArrayList<BundleData>(((bundleFragmentArray = this.getFragments()) == null ? 0 : bundleFragmentArray.length) + 1);
        arrayList.add(this.getBundleData());
        if (bundleFragmentArray != null) {
            BundleFragment[] bundleFragmentArray2 = bundleFragmentArray;
            int n = bundleFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleFragment bundleFragment = bundleFragmentArray2[n2];
                arrayList.add(bundleFragment.getBundleData());
                ++n2;
            }
        }
        int n = bl ? 1 : 0;
        return this.framework.getAdaptor().findEntries(arrayList, string, string2, n);
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int n) {
        Map map = Collections.EMPTY_MAP;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(new StringBuffer("Invalid signers type: ").append(n).toString());
        }
        if (this.framework == null) {
            return map;
        }
        SignedContentFactory signedContentFactory = this.framework.getSignedContentFactory();
        if (signedContentFactory == null) {
            return map;
        }
        try {
            SignedContent signedContent = signedContentFactory.getSignedContent(this);
            SignerInfo[] signerInfoArray = signedContent.getSignerInfos();
            if (signerInfoArray.length == 0) {
                return map;
            }
            HashMap<X509Certificate, List<X509Certificate>> hashMap = new HashMap<X509Certificate, List<X509Certificate>>(signerInfoArray.length);
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                Certificate[] certificateArray;
                if ((n != 2 || signerInfoArray[n2].isTrusted()) && (certificateArray = signerInfoArray[n2].getCertificateChain()) != null && certificateArray.length != 0) {
                    ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                    int n3 = 0;
                    while (n3 < certificateArray.length) {
                        arrayList.add((X509Certificate)certificateArray[n3]);
                        ++n3;
                    }
                    hashMap.put((X509Certificate)certificateArray[0], arrayList);
                }
                ++n2;
            }
            return hashMap;
        }
        catch (Exception exception) {
            return map;
        }
    }

    @Override
    public final <A> A adapt(Class<A> clazz) {
        this.checkAdaptPermission(clazz);
        return this.adapt0(clazz);
    }

    @Override
    public List<BundleRevision> getRevisions() {
        BundleDescription[] bundleDescriptionArray;
        ArrayList<BundleRevision> arrayList = new ArrayList<BundleRevision>();
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription != null) {
            arrayList.add(bundleDescription);
        }
        BundleDescription[] bundleDescriptionArray2 = bundleDescriptionArray = this.framework.adaptor.getState().getRemovalPending();
        int n = bundleDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundleDescription2 = bundleDescriptionArray2[n2];
            if (bundleDescription2.getBundleId() == this.getBundleId() && bundleDescription2 != bundleDescription) {
                arrayList.add(bundleDescription2);
            }
            ++n2;
        }
        return arrayList;
    }

    protected <A> A adapt0(Class<A> clazz) {
        if (clazz.isInstance(this)) {
            return (A)this;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.framework.BundleContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            try {
                return (A)this.getBundleContext();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.osgi.framework.wiring.BundleWiring");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(clazz)) {
            if (this.state == 1) {
                return null;
            }
            BundleDescription bundleDescription = this.getBundleDescription();
            return (A)bundleDescription.getWiring();
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.osgi.framework.wiring.BundleRevision");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(clazz)) {
            if (this.state == 1) {
                return null;
            }
            return (A)this.getBundleDescription();
        }
        return null;
    }

    private <A> void checkAdaptPermission(Class<A> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(new AdaptPermission(clazz.getName(), this, "adapt"));
    }

    @Override
    public File getDataFile(String string) {
        return this.framework.getDataFile(this, string);
    }

    @Override
    public Bundle getBundle() {
        return this;
    }

    @Override
    public int getStartLevel() {
        if (this.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
        return this.getInternalStartLevel();
    }

    @Override
    public void setStartLevel(int n) {
        this.framework.startLevelManager.setBundleStartLevel(this, n);
    }

    @Override
    public boolean isPersistentlyStarted() {
        if (this.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
        return (this.getBundleData().getStatus() & 1) != 0;
    }

    @Override
    public boolean isActivationPolicyUsed() {
        if (this.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
        return (this.getBundleData().getStatus() & 4) != 0;
    }

    class BundleStatusException
    extends Throwable
    implements StatusException {
        private static final long serialVersionUID = 7201911791818929100L;
        private int code;
        private Object status;

        BundleStatusException(String string, int n, Object object) {
            super(string);
            this.code = n;
            this.status = object;
        }

        public Object getStatus() {
            return this.status;
        }

        public int getStatusCode() {
            return this.code;
        }
    }
}

