/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;

public class ZipBundleEntry
extends BundleEntry {
    protected final ZipEntry zipEntry;
    protected final ZipBundleFile bundleFile;

    ZipBundleEntry(ZipEntry zipEntry, ZipBundleFile zipBundleFile) {
        this.zipEntry = zipEntry;
        this.bundleFile = zipBundleFile;
    }

    public InputStream getInputStream() throws IOException {
        ZipBundleFile zipBundleFile = this.bundleFile;
        if (!zipBundleFile.isMruEnabled()) {
            return this.bundleFile.getZipFile().getInputStream(this.zipEntry);
        }
        zipBundleFile.incrementReference();
        ZipBundleEntryInputStream zipBundleEntryInputStream = null;
        try {
            ZipBundleEntryInputStream zipBundleEntryInputStream2 = zipBundleEntryInputStream = new ZipBundleEntryInputStream(zipBundleFile.getZipFile().getInputStream(this.zipEntry));
            return zipBundleEntryInputStream2;
        }
        finally {
            if (zipBundleEntryInputStream == null) {
                zipBundleFile.decrementReference();
            }
        }
    }

    public long getSize() {
        return this.zipEntry.getSize();
    }

    public String getName() {
        return this.zipEntry.getName();
    }

    public long getTime() {
        return this.zipEntry.getTime();
    }

    public URL getLocalURL() {
        try {
            return new URL("jar:" + this.bundleFile.basefile.toURL() + "!/" + this.zipEntry.getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getFileURL() {
        try {
            File file = this.bundleFile.getFile(this.zipEntry.getName(), false);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private class ZipBundleEntryInputStream
    extends InputStream {
        private final InputStream stream;
        private boolean closed = false;

        public ZipBundleEntryInputStream(InputStream inputStream) {
            this.stream = inputStream;
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                ZipBundleEntryInputStream zipBundleEntryInputStream = this;
                synchronized (zipBundleEntryInputStream) {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                }
                ZipBundleEntry.this.bundleFile.decrementReference();
                throw throwable;
            }
            ZipBundleEntryInputStream zipBundleEntryInputStream = this;
            synchronized (zipBundleEntryInputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            ZipBundleEntry.this.bundleFile.decrementReference();
        }

        public void mark(int n) {
            this.stream.mark(n);
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.stream.read(byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            return this.stream.read(byArray);
        }

        public void reset() throws IOException {
            this.stream.reset();
        }

        public long skip(long l) throws IOException {
            return this.stream.skip(l);
        }
    }
}

