/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.FileBundleEntry;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirBundleFile
extends BundleFile {
    public DirBundleFile(File file) throws IOException {
        super(file);
        if (!BundleFile.secureAction.exists(file) || !BundleFile.secureAction.isDirectory(file)) {
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_EXCEPTION, file));
        }
    }

    @Override
    public File getFile(String string, boolean bl) {
        boolean bl2 = string != null && string.indexOf("..") >= 0;
        File file = new File(this.basefile, string);
        if (!BundleFile.secureAction.exists(file)) {
            return null;
        }
        if (bl2) {
            try {
                if (!BundleFile.secureAction.getCanonicalPath(file).startsWith(BundleFile.secureAction.getCanonicalPath(this.basefile))) {
                    return null;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return file;
    }

    @Override
    public BundleEntry getEntry(String string) {
        File file = this.getFile(string, false);
        if (file == null) {
            return null;
        }
        return new FileBundleEntry(file, string);
    }

    @Override
    public boolean containsDir(String string) {
        File file = this.getFile(string, false);
        return file != null && BundleFile.secureAction.isDirectory(file);
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) {
        File file;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if ((file = this.getFile(string, false)) == null || !BundleFile.secureAction.isDirectory(file)) {
            return null;
        }
        final String[] stringArray = BundleFile.secureAction.list(file);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        final String string2 = string.length() == 0 || string.charAt(string.length() - 1) == '/' ? string : new StringBuffer(String.valueOf(string)).append('/').toString();
        return new Enumeration<String>(){
            int cur = 0;

            @Override
            public boolean hasMoreElements() {
                return stringArray != null && this.cur < stringArray.length;
            }

            @Override
            public String nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                File file2 = new File(file, stringArray[this.cur]);
                StringBuffer stringBuffer = new StringBuffer(string2).append(stringArray[this.cur++]);
                if (BundleFile.secureAction.isDirectory(file2)) {
                    stringBuffer.append("/");
                }
                return stringBuffer.toString();
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }
}

