/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.protocol.bundleresource.Handler;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.util.ManifestElement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleFile {
    protected static final String PROP_SETPERMS_CMD = "osgi.filepermissions.command";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    protected File basefile;
    private int mruIndex = -1;

    public BundleFile() {
    }

    public BundleFile(File file) {
        this.basefile = file;
    }

    public abstract File getFile(String var1, boolean var2);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration<String> getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public URL getResourceURL(String string, long l) {
        return this.getResourceURL(string, l, 0);
    }

    public URL getResourceURL(String string, long l, int n) {
        return this.internalGetResourceURL(string, null, l, n);
    }

    public URL getResourceURL(String string, BaseData baseData, int n) {
        return this.internalGetResourceURL(string, baseData, 0L, n);
    }

    private URL internalGetResourceURL(String string, BaseData baseData, long l, int n) {
        BundleEntry bundleEntry = this.getEntry(string);
        if (bundleEntry == null) {
            return null;
        }
        if (baseData != null) {
            l = baseData.getBundleID();
        }
        string = BundleFile.fixTrailingSlash(string, bundleEntry);
        try {
            return secureAction.getURL("bundleresource", new StringBuffer(String.valueOf(Long.toString(l))).append(".fwk").append(Integer.toString(baseData.getAdaptor().hashCode())).toString(), n, string, new Handler(bundleEntry, baseData == null ? null : baseData.getAdaptor()));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getBaseFile() {
        return this.basefile;
    }

    void setMruIndex(int n) {
        this.mruIndex = n;
    }

    int getMruIndex() {
        return this.mruIndex;
    }

    public static void setPermissions(File file) {
        String string = FrameworkProperties.getProperty(PROP_SETPERMS_CMD);
        if (string == null) {
            string = FrameworkProperties.getProperty("org.osgi.framework.command.execpermission");
        }
        if (string == null) {
            return;
        }
        String[] stringArray = ManifestElement.getArrayFromList(string, " ");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if ("[fullpath]".equals(stringArray[n]) || "${abspath}".equals(stringArray[n])) {
                arrayList.add(file.getAbsolutePath());
                bl = true;
            } else {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(file.getAbsolutePath());
        }
        try {
            Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()])).waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return String.valueOf(this.basefile);
    }

    public static String fixTrailingSlash(String string, BundleEntry bundleEntry) {
        boolean bl;
        String string2;
        if (string.length() == 0) {
            return "/";
        }
        if (string.charAt(0) != '/') {
            string = new StringBuffer(String.valueOf('/')).append(string).toString();
        }
        if ((string2 = bundleEntry.getName()).length() == 0) {
            return string;
        }
        boolean bl2 = string.charAt(string.length() - 1) == '/';
        boolean bl3 = bl = string2.length() > 0 && string2.charAt(string2.length() - 1) == '/';
        if (bl != bl2) {
            string = bl ? new StringBuffer(String.valueOf(string)).append('/').toString() : string.substring(0, string.length() - 1);
        }
        return string;
    }
}

