/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.osgi.framework.debug.Debug;

public abstract class BundleEntry {
    protected static final int BUF_SIZE = 8192;

    public abstract InputStream getInputStream() throws IOException;

    public abstract long getSize();

    public abstract String getName();

    public abstract long getTime();

    public abstract URL getLocalURL();

    public abstract URL getFileURL();

    public String toString() {
        return this.getName();
    }

    public byte[] getBytes() throws IOException {
        byte[] byArray;
        InputStream inputStream = this.getInputStream();
        int n = (int)this.getSize();
        int n2 = 0;
        if (Debug.DEBUG_LOADER) {
            Debug.println("  about to read " + n + " bytes from " + this.getName());
        }
        try {
            byte[] byArray2;
            if (n > 0) {
                byArray = new byte[n];
                while (n2 < n) {
                    int n3 = inputStream.read(byArray, n2, n - n2);
                    if (n3 > 0) {
                        n2 += n3;
                        continue;
                    }
                    break;
                }
            } else {
                n = 8192;
                byArray = new byte[n];
                while (true) {
                    if (n2 < n) {
                        int n4 = inputStream.read(byArray, n2, n - n2);
                        if (n4 > 0) {
                            n2 += n4;
                            continue;
                        }
                        break;
                    }
                    byArray2 = byArray;
                    byArray = new byte[n += 8192];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
            }
            if (byArray.length > n2) {
                byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return byArray;
    }
}

