/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.osgi.service.log.LogListener;

public class ExtendedLogReaderServiceImpl
implements ExtendedLogReaderService {
    private final ExtendedLogReaderServiceFactory factory;
    private Set<LogListener> listeners = new HashSet<LogListener>();

    ExtendedLogReaderServiceImpl(ExtendedLogReaderServiceFactory extendedLogReaderServiceFactory) {
        this.factory = extendedLogReaderServiceFactory;
    }

    public synchronized void addLogListener(LogListener logListener, LogFilter logFilter) {
        this.checkShutdown();
        if (logListener == null) {
            throw new IllegalArgumentException("LogListener must not be null");
        }
        if (logFilter == null) {
            throw new IllegalArgumentException("LogFilter must not be null");
        }
        this.listeners.add(logListener);
        this.factory.addLogListener(logListener, logFilter);
    }

    public void addLogListener(LogListener logListener) {
        this.addLogListener(logListener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
    }

    public Enumeration getLog() {
        this.checkShutdown();
        return this.factory.getLog();
    }

    public synchronized void removeLogListener(LogListener logListener) {
        this.checkShutdown();
        if (logListener == null) {
            throw new IllegalArgumentException("LogListener must not be null");
        }
        this.factory.removeLogListener(logListener);
        this.listeners.remove(logListener);
    }

    private synchronized void checkShutdown() {
        if (this.listeners == null) {
            throw new IllegalStateException("LogReaderService is shutdown.");
        }
    }

    synchronized void shutdown() {
        Iterator<LogListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LogListener logListener = iterator.next();
            this.factory.removeLogListener(logListener);
        }
        this.listeners = null;
    }
}

