/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdminLogListener
implements SynchronousLogListener {
    public static final String TOPIC = "org/osgi/service/log/LogEntry";
    public static final char TOPIC_SEPARATOR = '/';
    public static final String LOG_ERROR = "LOG_ERROR";
    public static final String LOG_WARNING = "LOG_WARNING";
    public static final String LOG_INFO = "LOG_INFO";
    public static final String LOG_DEBUG = "LOG_DEBUG";
    public static final String LOG_OTHER = "LOG_OTHER";
    public static final String TIMESTAMP = "timestamp";
    public static final String MESSAGE = "message";
    public static final String LOG_LEVEL = "log.level";
    public static final String LOG_ENTRY = "log.entry";
    public static final String SERVICE = "service";
    public static final String SERVICE_ID = "service.id";
    public static final String SERVICE_OBJECTCLASS = "service.objectClass";
    public static final String SERVICE_PID = "service.pid";
    public static final String BUNDLE = "bundle";
    public static final String BUNDLE_ID = "bundle.id";
    public static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    public static final String EVENT = "event";
    public static final String EXCEPTION = "exception";
    public static final String EXCEPTION_CLASS = "exception.class";
    public static final String EXCEPTION_MESSAGE = "exception.message";
    private final Object eventAdmin;
    private final Method postEvent;
    private final Constructor<?> event;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EventAdminLogListener(Object object) throws ClassNotFoundException, NoSuchMethodException {
        this.eventAdmin = object;
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> clazz2 = classLoader.loadClass("org.osgi.service.event.Event");
        this.postEvent = clazz.getMethod("postEvent", clazz2);
        Class[] classArray = new Class[2];
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.util.Dictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz4;
        this.event = clazz2.getConstructor(classArray);
    }

    @Override
    public void logged(LogEntry logEntry) {
        try {
            Object object = this.convertEvent(logEntry);
            this.postEvent.invoke(this.eventAdmin, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Object convertEvent(LogEntry logEntry) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ServiceReference serviceReference;
        String string = TOPIC;
        int n = logEntry.getLevel();
        switch (n) {
            case 1: {
                string = new StringBuffer(String.valueOf(string)).append("/LOG_ERROR").toString();
                break;
            }
            case 2: {
                string = new StringBuffer(String.valueOf(string)).append("/LOG_WARNING").toString();
                break;
            }
            case 3: {
                string = new StringBuffer(String.valueOf(string)).append("/LOG_INFO").toString();
                break;
            }
            case 4: {
                string = new StringBuffer(String.valueOf(string)).append("/LOG_DEBUG").toString();
                break;
            }
            default: {
                string = new StringBuffer(String.valueOf(string)).append("/LOG_OTHER").toString();
            }
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Bundle bundle = logEntry.getBundle();
        if (bundle == null) {
            throw new RuntimeException("LogEntry.getBundle() returns null");
        }
        EventAdminLogListener.putBundleProperties(hashtable, bundle);
        Throwable throwable = logEntry.getException();
        if (throwable != null) {
            EventAdminLogListener.putExceptionProperties(hashtable, throwable);
        }
        if ((serviceReference = logEntry.getServiceReference()) != null) {
            EventAdminLogListener.putServiceReferenceProperties(hashtable, serviceReference);
        }
        hashtable.put(LOG_ENTRY, logEntry);
        hashtable.put(LOG_LEVEL, new Integer(logEntry.getLevel()));
        if (logEntry.getMessage() != null) {
            hashtable.put(MESSAGE, logEntry.getMessage());
        }
        hashtable.put(TIMESTAMP, new Long(logEntry.getTime()));
        return this.event.newInstance(string, hashtable);
    }

    public static void putServiceReferenceProperties(Hashtable<String, Object> hashtable, ServiceReference<?> serviceReference) {
        Object object;
        hashtable.put(SERVICE, serviceReference);
        hashtable.put(SERVICE_ID, serviceReference.getProperty(SERVICE_ID));
        Object object2 = serviceReference.getProperty(SERVICE_PID);
        if (object2 != null && object2 instanceof String) {
            hashtable.put(SERVICE_PID, object2);
        }
        if ((object = serviceReference.getProperty("objectClass")) != null && object instanceof String[]) {
            hashtable.put(SERVICE_OBJECTCLASS, object);
        }
    }

    public static void putBundleProperties(Hashtable<String, Object> hashtable, Bundle bundle) {
        hashtable.put(BUNDLE_ID, new Long(bundle.getBundleId()));
        String string = bundle.getSymbolicName();
        if (string != null) {
            hashtable.put(BUNDLE_SYMBOLICNAME, string);
        }
        hashtable.put(BUNDLE, bundle);
    }

    public static void putExceptionProperties(Hashtable<String, Object> hashtable, Throwable throwable) {
        hashtable.put(EXCEPTION, throwable);
        hashtable.put(EXCEPTION_CLASS, throwable.getClass().getName());
        String string = throwable.getMessage();
        if (string != null) {
            hashtable.put(EXCEPTION_MESSAGE, throwable.getMessage());
        }
    }
}

