/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.internal.stats.ClassStats;
import org.eclipse.core.runtime.internal.stats.ResourceBundleStats;
import org.eclipse.core.runtime.internal.stats.StatsManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassloaderStats {
    private String id;
    private long loadingTime;
    private Map<String, ClassStats> classes = Collections.synchronizedMap(new HashMap(20));
    private List<ResourceBundleStats> bundles = new ArrayList<ResourceBundleStats>(2);
    private boolean keepTraces = false;
    private static List<String> packageFilters = new ArrayList<String>(4);
    private static Set<String> pluginFilters = new HashSet<String>(5);
    private static Hashtable<Thread, Stack<ClassStats>> classStacks = new Hashtable();
    private static Map<String, ClassloaderStats> loaders = Collections.synchronizedMap(new HashMap(20));
    public static File traceFile;

    static {
        if (StatsManager.TRACE_CLASSES || StatsManager.TRACE_BUNDLES) {
            ClassloaderStats.initializeTraceOptions();
        }
    }

    private static void initializeTraceOptions() {
        String string = StatsManager.TRACE_FILENAME;
        traceFile = new File(string);
        traceFile.delete();
        if (!StatsManager.TRACE_CLASSES) {
            return;
        }
        string = StatsManager.TRACE_FILTERS;
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            File file = new File(string);
            System.out.print(new StringBuffer("Runtime tracing elements defined in: ").append(file.getAbsolutePath()).append("...").toString());
            FileInputStream fileInputStream = new FileInputStream(file);
            System.out.println("  Loaded.");
            Properties properties = new Properties(){
                private static final long serialVersionUID = 3546359543853365296L;

                public synchronized Object put(Object object, Object object2) {
                    ClassloaderStats.addFilters((String)object, (String)object2);
                    return null;
                }
            };
            try {
                properties.load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            System.out.println("  No trace filters loaded.");
        }
    }

    protected static void addFilters(String string, String string2) {
        String[] stringArray = StatsManager.getArrayFromList(string2);
        if ("plugins".equals(string)) {
            pluginFilters.addAll(Arrays.asList(stringArray));
        }
        if ("packages".equals(string)) {
            packageFilters.addAll(Arrays.asList(stringArray));
        }
    }

    public static void startLoadingClass(String string, String string2) {
        ClassloaderStats.findLoader(string).startLoadClass(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassloaderStats findLoader(String string) {
        Map<String, ClassloaderStats> map = loaders;
        synchronized (map) {
            ClassloaderStats classloaderStats = loaders.get(string);
            if (classloaderStats == null) {
                classloaderStats = new ClassloaderStats(string);
                loaders.put(string, classloaderStats);
            }
            return classloaderStats;
        }
    }

    public static synchronized Stack<ClassStats> getClassStack() {
        Stack<ClassStats> stack = classStacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new Stack();
            classStacks.put(Thread.currentThread(), stack);
        }
        return stack;
    }

    public static ClassloaderStats[] getLoaders() {
        return loaders.values().toArray(new ClassloaderStats[0]);
    }

    public static void endLoadingClass(String string, String string2, boolean bl) {
        ClassloaderStats.findLoader(string).endLoadClass(string2, bl);
    }

    public static void loadedBundle(String string, ResourceBundleStats resourceBundleStats) {
        ClassloaderStats.findLoader(string).loadedBundle(resourceBundleStats);
    }

    public static ClassloaderStats getLoader(String string) {
        return loaders.get(string);
    }

    public ClassloaderStats(String string) {
        this.id = string;
        this.keepTraces = pluginFilters.contains(string);
    }

    public void addBaseClasses(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (this.classes.get(string) == null) {
                ClassStats classStats = new ClassStats(string, this);
                classStats.toBaseClass();
                this.classes.put(string, classStats);
            }
            ++n;
        }
    }

    private void loadedBundle(ResourceBundleStats resourceBundleStats) {
        this.bundles.add(resourceBundleStats);
    }

    public List<ResourceBundleStats> getBundles() {
        return this.bundles;
    }

    private synchronized void startLoadClass(String string) {
        ClassloaderStats.getClassStack().push(this.findClass(string));
    }

    private ClassStats findClass(String string) {
        ClassStats classStats = this.classes.get(string);
        return classStats == null ? new ClassStats(string, this) : classStats;
    }

    private synchronized void endLoadClass(String string, boolean bl) {
        ClassStats classStats = ClassloaderStats.getClassStack().pop();
        if (!bl) {
            return;
        }
        if (classStats.getLoadOrder() >= 0) {
            return;
        }
        this.classes.put(string, classStats);
        classStats.setLoadOrder(this.classes.size());
        classStats.loadingDone();
        this.traceLoad(string, classStats);
        Stack<ClassStats> stack = ClassloaderStats.getClassStack();
        if (stack.size() != 0) {
            ClassStats classStats2 = stack.peek();
            classStats2.addTimeLoadingOthers(classStats.getTimeLoading());
            classStats.setLoadedBy(classStats2);
            classStats2.loaded(classStats);
        } else {
            this.loadingTime += classStats.getTimeLoading();
        }
    }

    private void traceLoad(String string, ClassStats classStats) {
        if (!this.keepTraces) {
            boolean bl = false;
            int n = 0;
            while (!bl && n < packageFilters.size()) {
                if (string.startsWith(packageFilters.get(n))) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
        }
        try {
            classStats.setTraceStart(traceFile.length());
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(traceFile.getAbsolutePath(), true));
            try {
                printWriter.println(new StringBuffer("Loading class: ").append(string).toString());
                printWriter.println("Class loading stack:");
                printWriter.println(new StringBuffer("\t").append(string).toString());
                Stack<ClassStats> stack = ClassloaderStats.getClassStack();
                int n = stack.size() - 1;
                while (n >= 0) {
                    printWriter.println(new StringBuffer("\t").append(((ClassStats)stack.get(n)).getClassName()).toString());
                    --n;
                }
                printWriter.println("Stack trace:");
                new Throwable().printStackTrace(printWriter);
            }
            finally {
                printWriter.close();
            }
            classStats.setTraceEnd(traceFile.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public int getClassLoadCount() {
        return this.classes.size();
    }

    public long getClassLoadTime() {
        return this.loadingTime;
    }

    public ClassStats[] getClasses() {
        return this.classes.values().toArray(new ClassStats[0]);
    }

    public String getId() {
        return this.id;
    }
}

