/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.IPluginInfo;
import org.eclipse.core.runtime.internal.adaptor.PluginParser;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginConverterImpl
implements PluginConverter {
    public static boolean DEBUG = false;
    public static final byte MANIFEST_TYPE_UNKNOWN = 0;
    public static final byte MANIFEST_TYPE_BUNDLE = 1;
    public static final byte MANIFEST_TYPE_PLUGIN = 2;
    public static final byte MANIFEST_TYPE_FRAGMENT = 4;
    public static final byte MANIFEST_TYPE_JAR = 8;
    private static final String SEMICOLON = "; ";
    private static final String UTF_8 = "UTF-8";
    private static final String LIST_SEPARATOR = ",\n ";
    private static final String LINE_SEPARATOR = "\n ";
    private static final String DOT = ".";
    private static int MAXLINE = 511;
    private BundleContext context;
    private FrameworkAdaptor adaptor;
    private BufferedWriter out;
    private IPluginInfo pluginInfo;
    private File pluginManifestLocation;
    private ZipFile pluginZip;
    private Dictionary<String, String> generatedManifest;
    private byte manifestType;
    private Version target;
    private Dictionary<String, String> devProperties;
    static final Version TARGET31 = new Version(3, 1, 0);
    static final Version TARGET32 = new Version(3, 2, 0);
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private static final String PLUGIN_PROPERTIES_FILENAME = "plugin";
    private static PluginConverterImpl instance;
    private static final String[] ARCH_LIST;
    public static final String FRAGMENT_MANIFEST = "fragment.xml";
    public static final String GENERATED_FROM = "Generated-from";
    public static final String MANIFEST_TYPE_ATTRIBUTE = "type";
    private static final String[] OS_LIST;
    protected static final String PI_RUNTIME = "org.eclipse.core.runtime";
    protected static final String PI_BOOT = "org.eclipse.core.boot";
    protected static final String PI_RUNTIME_COMPATIBILITY = "org.eclipse.core.runtime.compatibility";
    public static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String COMPATIBILITY_ACTIVATOR = "org.eclipse.core.internal.compatibility.PluginActivator";
    private static final String[] WS_LIST;
    private static final String IGNORE_DOT = "@ignoredot@";

    static {
        ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "x86_64", "ia64"};
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    }

    public static PluginConverterImpl getDefault() {
        return instance;
    }

    public PluginConverterImpl(FrameworkAdaptor frameworkAdaptor, BundleContext bundleContext) {
        this.context = bundleContext;
        this.adaptor = frameworkAdaptor;
        instance = this;
    }

    private void init() {
        this.out = null;
        this.pluginInfo = null;
        this.pluginManifestLocation = null;
        this.pluginZip = null;
        this.generatedManifest = new Hashtable<String, String>(10);
        this.manifestType = 0;
        this.target = null;
        this.devProperties = null;
    }

    private void fillPluginInfo(File file) throws PluginConversionException {
        String string;
        this.pluginManifestLocation = file;
        if (this.pluginManifestLocation == null) {
            throw new IllegalArgumentException();
        }
        InputStream inputStream = null;
        try {
            try {
                inputStream = this.findPluginManifest(file);
            }
            catch (IOException iOException) {
                throw new PluginConversionException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_FILENOTFOUND, file.getAbsolutePath()), iOException);
            }
            if (inputStream == null) {
                throw new PluginConversionException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_FILENOTFOUND, file.getAbsolutePath()));
            }
            this.pluginInfo = this.parsePluginInfo(inputStream);
        }
        catch (Throwable throwable) {
            if (this.pluginZip != null) {
                try {
                    this.pluginZip.close();
                    this.pluginZip = null;
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (this.pluginZip != null) {
            try {
                this.pluginZip.close();
                this.pluginZip = null;
            }
            catch (IOException iOException) {}
        }
        if ((string = this.pluginInfo.validateForm()) != null) {
            throw new PluginConversionException(string);
        }
    }

    private Set<String> filterExport(Set<String> set, Collection<String> collection) {
        if (collection == null || collection.contains("*")) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        block0: for (String string : set) {
            for (String string2 : collection) {
                int n = string2.indexOf(".*");
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if (!string.equals(string2)) continue;
                hashSet.add(string);
                continue block0;
            }
        }
        return hashSet;
    }

    private List<String> findOSJars(File file, String string, boolean bl) {
        string = string.substring(4);
        ArrayList<String> arrayList = new ArrayList<String>(0);
        int n = 0;
        while (n < OS_LIST.length) {
            String string2 = new StringBuffer("os/").append(OS_LIST[n]).append("/").append(string).toString();
            if (new File(file, string2).exists()) {
                arrayList.add(new StringBuffer(String.valueOf(string2)).append(bl ? new StringBuffer(";(os=").append(WS_LIST[n]).append(")").toString() : "").toString());
            }
            int n2 = 0;
            while (n2 < ARCH_LIST.length) {
                string2 = new StringBuffer("os/").append(OS_LIST[n]).append("/").append(ARCH_LIST[n2]).append("/").append(string).toString();
                if (new File(file, string2).exists()) {
                    arrayList.add(new StringBuffer(String.valueOf(string2)).append(bl ? new StringBuffer(";(& (os=").append(WS_LIST[n]).append(") (arch=").append(ARCH_LIST[n2]).append(")").toString() : "").toString());
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private InputStream findPluginManifest(File file) throws IOException {
        Object object;
        if (this.pluginZip != null) {
            try {
                this.pluginZip.close();
            }
            catch (IOException iOException) {}
        }
        this.pluginZip = null;
        if (!file.isDirectory()) {
            this.manifestType = (byte)(this.manifestType | 8);
            this.pluginZip = new ZipFile(file);
        }
        if (this.pluginZip != null) {
            object = this.pluginZip.getEntry(PLUGIN_MANIFEST);
            if (object != null) {
                this.manifestType = (byte)(this.manifestType | 2);
                return this.pluginZip.getInputStream((ZipEntry)object);
            }
        } else {
            object = new File(file, PLUGIN_MANIFEST);
            if (((File)object).exists()) {
                this.manifestType = (byte)(this.manifestType | 2);
                return new FileInputStream((File)object);
            }
        }
        if (this.pluginZip != null) {
            object = this.pluginZip.getEntry(FRAGMENT_MANIFEST);
            if (object != null) {
                this.manifestType = (byte)(this.manifestType | 2);
                return this.pluginZip.getInputStream((ZipEntry)object);
            }
        } else {
            object = new File(file, FRAGMENT_MANIFEST);
            if (((File)object).exists()) {
                this.manifestType = (byte)(this.manifestType | 4);
                return new FileInputStream((File)object);
            }
        }
        return null;
    }

    private List<String> findWSJars(File file, String string, boolean bl) {
        string = string.substring(4);
        ArrayList<String> arrayList = new ArrayList<String>(0);
        int n = 0;
        while (n < WS_LIST.length) {
            String string2 = new StringBuffer("ws/").append(WS_LIST[n]).append(string).toString();
            if (new File(file, string2).exists()) {
                arrayList.add(new StringBuffer(String.valueOf(string2)).append(bl ? new StringBuffer(";(ws=").append(WS_LIST[n]).append(")").toString() : "").toString());
            }
            ++n;
        }
        return arrayList;
    }

    protected void fillManifest(boolean bl, boolean bl2) {
        this.generateManifestVersion();
        this.generateHeaders();
        this.generateClasspath();
        this.generateActivator();
        this.generatePluginClass();
        if (bl2) {
            this.generateProvidePackage();
        }
        this.generateRequireBundle();
        this.generateLocalizationEntry();
        this.generateEclipseHeaders();
        if (bl) {
            this.generateTimestamp();
        }
    }

    @Override
    public void writeManifest(File file, Dictionary<String, String> dictionary, boolean bl) throws PluginConversionException {
        long l = System.currentTimeMillis();
        try {
            try {
                File file2 = new File(file.getParent());
                file2.mkdirs();
                file.createNewFile();
                if (!file.isFile()) {
                    String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CREATING_BUNDLE_MANIFEST, this.pluginInfo.getUniqueId(), file);
                    throw new PluginConversionException(string);
                }
                dictionary = new Hashtable<String, String>((Hashtable)dictionary);
                this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8));
                this.writeEntry(MANIFEST_VERSION, dictionary.remove(MANIFEST_VERSION));
                this.writeEntry(GENERATED_FROM, dictionary.remove(GENERATED_FROM));
                this.writeEntry("Bundle-ManifestVersion", dictionary.remove("Bundle-ManifestVersion"));
                this.writeEntry("Bundle-Name", dictionary.remove("Bundle-Name"));
                this.writeEntry("Bundle-SymbolicName", dictionary.remove("Bundle-SymbolicName"));
                this.writeEntry("Bundle-Version", dictionary.remove("Bundle-Version"));
                this.writeEntry("Bundle-ClassPath", dictionary.remove("Bundle-ClassPath"));
                this.writeEntry("Bundle-Activator", dictionary.remove("Bundle-Activator"));
                this.writeEntry("Bundle-Vendor", dictionary.remove("Bundle-Vendor"));
                this.writeEntry("Fragment-Host", dictionary.remove("Fragment-Host"));
                this.writeEntry("Bundle-Localization", dictionary.remove("Bundle-Localization"));
                this.writeEntry("Export-Package", dictionary.remove("Export-Package"));
                this.writeEntry("Provide-Package", dictionary.remove("Provide-Package"));
                this.writeEntry("Require-Bundle", dictionary.remove("Require-Bundle"));
                Enumeration<String> enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    this.writeEntry(string, dictionary.get(string));
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CREATING_BUNDLE_MANIFEST, this.pluginInfo.getUniqueId(), file);
                throw new PluginConversionException(string, iOException);
            }
        }
        catch (Throwable throwable) {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
        }
        if (DEBUG) {
            System.out.println(new StringBuffer("Time to write out converted manifest to: ").append(file).append(": ").append(System.currentTimeMillis() - l).append("ms.").toString());
        }
    }

    private void generateLocalizationEntry() {
        this.generatedManifest.put("Bundle-Localization", PLUGIN_PROPERTIES_FILENAME);
    }

    private void generateManifestVersion() {
        this.generatedManifest.put(MANIFEST_VERSION, "1.0");
    }

    private boolean requireRuntimeCompatibility() {
        ArrayList<PluginParser.Prerequisite> arrayList = this.pluginInfo.getRequires();
        Iterator<PluginParser.Prerequisite> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equalsIgnoreCase(PI_RUNTIME_COMPATIBILITY)) continue;
            return true;
        }
        return false;
    }

    private void generateActivator() {
        if (!this.pluginInfo.isFragment()) {
            if (!this.requireRuntimeCompatibility()) {
                String string = this.pluginInfo.getPluginClass();
                if (string != null && !string.trim().equals("")) {
                    this.generatedManifest.put("Bundle-Activator", string);
                }
            } else {
                this.generatedManifest.put("Bundle-Activator", COMPATIBILITY_ACTIVATOR);
            }
        }
    }

    private void generateClasspath() {
        String[] stringArray = this.pluginInfo.getLibrariesName();
        if (stringArray.length != 0) {
            this.generatedManifest.put("Bundle-ClassPath", this.getStringFromArray(stringArray, LIST_SEPARATOR));
        }
    }

    private void generateHeaders() {
        if (TARGET31.compareTo(this.target) <= 0) {
            this.generatedManifest.put("Bundle-ManifestVersion", "2");
        }
        this.generatedManifest.put("Bundle-Name", this.pluginInfo.getPluginName());
        this.generatedManifest.put("Bundle-Version", this.pluginInfo.getVersion());
        this.generatedManifest.put("Bundle-SymbolicName", this.getSymbolicNameEntry());
        String string = this.pluginInfo.getProviderName();
        if (string != null) {
            this.generatedManifest.put("Bundle-Vendor", string);
        }
        if (this.pluginInfo.isFragment()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.pluginInfo.getMasterId());
            String string2 = this.getVersionRange(this.pluginInfo.getMasterVersion(), this.pluginInfo.getMasterMatch());
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            this.generatedManifest.put("Fragment-Host", stringBuffer.toString());
        }
    }

    private String getSymbolicNameEntry() {
        if (!this.pluginInfo.isSingleton()) {
            return this.pluginInfo.getUniqueId();
        }
        StringBuffer stringBuffer = new StringBuffer(this.pluginInfo.getUniqueId());
        stringBuffer.append(SEMICOLON);
        stringBuffer.append("singleton");
        String string = TARGET31.compareTo(this.target) <= 0 ? ":=" : "=";
        stringBuffer.append(string).append("true");
        return stringBuffer.toString();
    }

    private void generatePluginClass() {
        String string;
        if (this.requireRuntimeCompatibility() && (string = this.pluginInfo.getPluginClass()) != null) {
            this.generatedManifest.put("Plugin-Class", string);
        }
    }

    private void generateProvidePackage() {
        Set<String> set = this.getExports();
        if (set != null && set.size() != 0) {
            this.generatedManifest.put(TARGET31.compareTo(this.target) <= 0 ? "Export-Package" : "Provide-Package", this.getStringFromCollection(set, LIST_SEPARATOR));
        }
    }

    private void generateRequireBundle() {
        ArrayList<PluginParser.Prerequisite> arrayList = this.pluginInfo.getRequires();
        if (arrayList.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<PluginParser.Prerequisite> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PluginParser.Prerequisite prerequisite = iterator.next();
            StringBuffer stringBuffer2 = new StringBuffer(prerequisite.getName());
            String string = this.getVersionRange(prerequisite.getVersion(), prerequisite.getMatch());
            if (string != null) {
                stringBuffer2.append(string);
            }
            if (prerequisite.isExported()) {
                if (TARGET31.compareTo(this.target) <= 0) {
                    stringBuffer2.append(';').append("visibility").append(":=").append("reexport");
                } else {
                    stringBuffer2.append(';').append("reprovide").append("=true");
                }
            }
            if (prerequisite.isOptional()) {
                if (TARGET31.compareTo(this.target) <= 0) {
                    stringBuffer2.append(';').append("resolution").append(":=").append("optional");
                } else {
                    stringBuffer2.append(';').append("optional").append("=true");
                }
            }
            stringBuffer.append(stringBuffer2.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(LIST_SEPARATOR);
        }
        this.generatedManifest.put("Require-Bundle", stringBuffer.toString());
    }

    private void generateTimestamp() {
        this.generatedManifest.put(GENERATED_FROM, new StringBuffer(String.valueOf(Long.toString(PluginConverterImpl.getTimeStamp(this.pluginManifestLocation, this.manifestType)))).append(";").append(MANIFEST_TYPE_ATTRIBUTE).append("=").append(this.manifestType).toString());
    }

    private void generateEclipseHeaders() {
        if (this.pluginInfo.isFragment()) {
            return;
        }
        String string = this.pluginInfo.getPluginClass();
        if (this.pluginInfo.hasExtensionExtensionPoints() || string != null && !string.trim().equals("")) {
            this.generatedManifest.put(TARGET32.compareTo(this.target) <= 0 ? "Eclipse-LazyStart" : "Eclipse-AutoStart", "true");
        }
    }

    private Set<String> getExports() {
        Object object;
        Collection<Map.Entry<String, List<String>>> collection;
        String[] stringArray;
        Map<String, List<String>> map = this.pluginInfo.getLibraries();
        if (map == null) {
            return null;
        }
        if (this.devProperties != null || DevClassPathHelper.inDevelopmentMode()) {
            stringArray = DevClassPathHelper.getDevClassPath(this.pluginInfo.getUniqueId(), this.devProperties);
            collection = new ArrayList(map.size());
            Set<Map.Entry<String, List<String>>> set = map.entrySet();
            Iterator object2 = set.iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                collection.addAll((Collection)object.getValue());
            }
            if (stringArray != null) {
                String[] stringArray2 = DevClassPathHelper.getDevClassPath(IGNORE_DOT, this.devProperties);
                if (stringArray.length > 0 && stringArray2 != null && stringArray2.length > 0 && "true".equals(stringArray2[0])) {
                    map.remove(DOT);
                }
                int n = 0;
                while (n < stringArray.length) {
                    map.put(stringArray[n], (List<String>)collection);
                    ++n;
                }
            }
        }
        stringArray = new TreeSet();
        collection = map.entrySet();
        for (Map.Entry entry : collection) {
            Set<Object> set;
            block10: {
                block8: {
                    Object object2;
                    block9: {
                        object = (List)entry.getValue();
                        if (object.size() == 0) continue;
                        String string = ((String)entry.getKey()).trim();
                        object2 = string.equals(DOT) ? this.pluginManifestLocation : (((File)((Object)(set = new File(string)))).isAbsolute() ? set : new File(this.pluginManifestLocation, string));
                        set = null;
                        if (!((File)object2).exists()) break block8;
                        if (!((File)object2).isFile()) break block9;
                        set = this.filterExport(this.getExportsFromJAR((File)object2), (Collection<String>)object);
                        break block10;
                    }
                    if (!((File)object2).isDirectory()) break block10;
                    set = this.filterExport(this.getExportsFromDir((File)object2), (Collection<String>)object);
                    break block10;
                }
                List<String> list = this.getLibrariesExpandingVariables((String)entry.getKey(), false);
                set = new HashSet();
                for (String string : list) {
                    File file = new File(this.pluginManifestLocation, string);
                    if (!file.isFile()) continue;
                    set.addAll(this.filterExport(this.getExportsFromJAR(file), (Collection<String>)object));
                }
            }
            if (set == null) continue;
            stringArray.addAll(set);
        }
        return stringArray;
    }

    private Set<String> getExportsFromDir(File file) {
        return this.getExportsFromDir(file, "");
    }

    private Set<String> getExportsFromDir(File file, String string) {
        String string2 = string.length() > 0 ? new StringBuffer(String.valueOf(string)).append('.').toString() : "";
        String[] stringArray = file.list();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.isValidPackageName(stringArray[n])) {
                    File file2 = new File(file, stringArray[n]);
                    if (file2.isDirectory()) {
                        hashSet.addAll(this.getExportsFromDir(file2, new StringBuffer(String.valueOf(string2)).append(stringArray[n]).toString()));
                    } else {
                        bl = true;
                    }
                }
                ++n;
            }
        }
        if (bl) {
            if (string.length() > 0) {
                hashSet.add(string);
            } else {
                hashSet.add(DOT);
            }
        }
        return hashSet;
    }

    private Set<String> getExportsFromJAR(File file) {
        HashSet<String> hashSet = new HashSet<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_PLUGIN_LIBRARY_IGNORED, file, this.pluginInfo.getUniqueId());
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, iOException, null));
            return hashSet;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!this.isValidPackageName(string)) continue;
            int n = string.lastIndexOf("/");
            if (n != -1) {
                if (n == string.length() - 1 || string.lastIndexOf(32) != -1) continue;
                hashSet.add(string.substring(0, n).replace('/', '.'));
                continue;
            }
            hashSet.add(DOT);
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {}
        return hashSet;
    }

    private List<String> getLibrariesExpandingVariables(String string, boolean bl) {
        String string2 = this.hasPrefix(string);
        if (string2 == null) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(string);
            return arrayList;
        }
        if (string2.equals("ws")) {
            return this.findWSJars(this.pluginManifestLocation, string, bl);
        }
        if (string2.equals("os")) {
            return this.findOSJars(this.pluginManifestLocation, string, bl);
        }
        return new ArrayList<String>(0);
    }

    private String hasPrefix(String string) {
        if (string.startsWith("$ws$")) {
            return "ws";
        }
        if (string.startsWith("$os$")) {
            return "os";
        }
        if (string.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private boolean isValidPackageName(String string) {
        return string.indexOf(32) <= 0 && !string.equalsIgnoreCase("META-INF") && !string.startsWith("META-INF/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPluginInfo parsePluginInfo(InputStream inputStream) throws PluginConversionException {
        PluginParser.PluginInfo pluginInfo;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            pluginInfo = new PluginParser(this.adaptor, this.context, this.target).parsePlugin(bufferedInputStream);
            if (bufferedInputStream == null) return pluginInfo;
        }
        catch (Exception exception) {
            try {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_PARSING_PLUGIN_MANIFEST, this.pluginManifestLocation);
                throw new PluginConversionException(string, exception);
            }
            catch (Throwable throwable) {
                if (bufferedInputStream == null) throw throwable;
                try {
                    ((InputStream)bufferedInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)bufferedInputStream).close();
            return pluginInfo;
        }
        catch (IOException iOException) {}
        return pluginInfo;
    }

    public static boolean upToDate(File file, File file2, byte by) {
        ManifestElement manifestElement;
        if (!file.isFile()) {
            return false;
        }
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                bufferedReader.readLine();
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        String string2 = "Generated-from: ";
        if (string == null || !string.startsWith(string2)) {
            return false;
        }
        string = string.substring(string2.length());
        try {
            manifestElement = ManifestElement.parseHeader(GENERATED_FROM, string)[0];
        }
        catch (BundleException bundleException) {
            return false;
        }
        String string3 = manifestElement.getValue();
        try {
            return Long.parseLong(string3.trim()) == PluginConverterImpl.getTimeStamp(file2, by);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static long getTimeStamp(File file, byte by) {
        if ((by & 8) != 0) {
            return file.lastModified();
        }
        if ((by & 2) != 0) {
            return new File(file, PLUGIN_MANIFEST).lastModified();
        }
        if ((by & 4) != 0) {
            return new File(file, FRAGMENT_MANIFEST).lastModified();
        }
        if ((by & 1) != 0) {
            return new File(file, "META-INF/MANIFEST.MF").lastModified();
        }
        return -1L;
    }

    private void writeEntry(String string, String string2) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.out.write(this.splitOnComma(new StringBuffer(String.valueOf(string)).append(": ").append(string2).toString()));
            this.out.write(10);
        }
    }

    private String splitOnComma(String string) {
        if (string.length() < MAXLINE || string.indexOf(LINE_SEPARATOR) >= 0) {
            return string;
        }
        String[] stringArray = ManifestElement.getArrayFromList(string);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + (stringArray.length - 1) * LIST_SEPARATOR.length());
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuffer.append(stringArray[n]).append(LIST_SEPARATOR);
            ++n;
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    private String getStringFromArray(String[] stringArray, String string) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getStringFromCollection(Collection<String> collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized Dictionary<String, String> convertManifest(File file, boolean bl, String string, boolean bl2, Dictionary<String, String> dictionary) throws PluginConversionException {
        long l = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println(new StringBuffer("Convert ").append(file).toString());
        }
        this.init();
        this.target = string == null ? TARGET32 : new Version(string);
        this.devProperties = dictionary;
        this.fillPluginInfo(file);
        this.fillManifest(bl, bl2);
        if (DEBUG) {
            System.out.println(new StringBuffer("Time to convert manifest for: ").append(file).append(": ").append(System.currentTimeMillis() - l).append("ms.").toString());
        }
        return this.generatedManifest;
    }

    @Override
    public synchronized File convertManifest(File file, File file2, boolean bl, String string, boolean bl2, Dictionary<String, String> dictionary) throws PluginConversionException {
        this.convertManifest(file, bl, string, bl2, dictionary);
        if (file2 == null) {
            String string2 = FrameworkProperties.getProperty("osgi.manifest.cache");
            file2 = new File(string2, new StringBuffer(String.valueOf(this.pluginInfo.getUniqueId())).append('_').append(this.pluginInfo.getVersion()).append(".MF").toString());
        }
        if (PluginConverterImpl.upToDate(file2, this.pluginManifestLocation, this.manifestType)) {
            return file2;
        }
        this.writeManifest(file2, this.generatedManifest, bl);
        return file2;
    }

    private String getVersionRange(String string, String string2) {
        if (string == null) {
            return null;
        }
        Version version = Version.parseVersion(string);
        String string3 = string2 != null ? (string2.equalsIgnoreCase("perfect") ? new VersionRange(version, true, version, true).toString() : (string2.equalsIgnoreCase("equivalent") ? new VersionRange(version, true, new Version(version.getMajor(), version.getMinor() + 1, 0, ""), false).toString() : (string2.equalsIgnoreCase("compatible") ? new VersionRange(version, true, new Version(version.getMajor() + 1, 0, 0, ""), false).toString() : (string2.equalsIgnoreCase("greaterOrEqual") ? string : new VersionRange(version, true, new Version(version.getMajor() + 1, 0, 0, ""), false).toString())))) : new VersionRange(version, true, new Version(version.getMajor() + 1, 0, 0, ""), false).toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(';').append("bundle-version").append('=');
        stringBuffer.append('\"').append(string3).append('\"');
        return stringBuffer.toString();
    }
}

