/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.log.LogEntry;

public class EclipseLogWriter
implements SynchronousLogListener,
LogFilter {
    private static final String PASSWORD = "-password";
    private static final String SESSION = "!SESSION";
    private static final String ENTRY = "!ENTRY";
    private static final String SUBENTRY = "!SUBENTRY";
    private static final String MESSAGE = "!MESSAGE";
    private static final String STACK = "!STACK";
    private static final String LINE_SEPARATOR;
    private static final int DEFAULT_LOG_SIZE = 1000;
    private static final int DEFAULT_LOG_FILES = 10;
    private static final int LOG_SIZE_MIN = 10;
    private static final String PROP_LOG_LEVEL = "eclipse.log.level";
    private static final String PROP_LOG_SIZE_MAX = "eclipse.log.size.max";
    private static final String PROP_LOG_FILE_MAX = "eclipse.log.backup.max";
    private static final String LOG_EXT = ".log";
    private static final String BACKUP_MARK = ".bak_";
    private static final SecureAction secureAction;
    private boolean consoleLog = false;
    private boolean newSession = true;
    private File outFile;
    private Writer writer;
    private final String loggerName;
    private final boolean enabled;
    int maxLogSize = 1000;
    int maxLogFiles = 10;
    int backupIdx = 0;
    private int logLevel = 0;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
        secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    }

    public EclipseLogWriter(File file, String string, boolean bl) {
        this.outFile = file;
        this.writer = null;
        this.loggerName = string;
        this.enabled = bl;
        this.readLogProperties();
    }

    public EclipseLogWriter(Writer writer, String string, boolean bl) {
        this.writer = writer == null ? this.logForStream(System.err) : writer;
        this.loggerName = string;
        this.enabled = bl;
    }

    private Throwable getRoot(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = null;
        if (throwable instanceof BundleException) {
            throwable3 = ((BundleException)throwable).getNestedException();
        }
        if (throwable instanceof InvocationTargetException) {
            throwable3 = ((InvocationTargetException)throwable).getTargetException();
        }
        if ((throwable3 instanceof InvocationTargetException || throwable3 instanceof BundleException) && (throwable2 = this.getRoot(throwable3)) != null) {
            throwable3 = throwable2;
        }
        return throwable3;
    }

    private void writeArgs(String string, String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.write(string);
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0 && PASSWORD.equals(stringArray[n - 1])) {
                this.write(" (omitted)");
            } else {
                this.write(" " + stringArray[n]);
            }
            ++n;
        }
        this.writeln();
    }

    private String getSessionTimestamp() {
        String string = FrameworkProperties.getProperty("eclipse.startTime");
        if (string != null) {
            try {
                return this.getDate(new Date(Long.parseLong(string)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.getDate(new Date());
    }

    private void writeSession() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String string = this.getSessionTimestamp();
        this.write(string);
        this.writeSpace();
        int n = SESSION.length() + string.length();
        while (n < 78) {
            this.write("-");
            ++n;
        }
        this.writeln();
        try {
            String string2 = "eclipse.buildId";
            String string3 = FrameworkProperties.getProperty(string2, "unknown");
            this.writeln(String.valueOf(string2) + "=" + string3);
            string2 = "java.fullversion";
            string3 = System.getProperty(string2);
            if (string3 == null) {
                string2 = "java.version";
                string3 = System.getProperty(string2);
                this.writeln(String.valueOf(string2) + "=" + string3);
                string2 = "java.vendor";
                string3 = System.getProperty(string2);
                this.writeln(String.valueOf(string2) + "=" + string3);
            } else {
                this.writeln(String.valueOf(string2) + "=" + string3);
            }
        }
        catch (Exception exception) {}
        this.write("BootLoader constants: OS=" + EclipseEnvironmentInfo.getDefault().getOS());
        this.write(", ARCH=" + EclipseEnvironmentInfo.getDefault().getOSArch());
        this.write(", WS=" + EclipseEnvironmentInfo.getDefault().getWS());
        this.writeln(", NL=" + EclipseEnvironmentInfo.getDefault().getNL());
        this.writeArgs("Framework arguments: ", EclipseEnvironmentInfo.getDefault().getNonFrameworkArgs());
        this.writeArgs("Command-line arguments: ", EclipseEnvironmentInfo.getDefault().getCommandLineArgs());
    }

    public void close() {
        try {
            if (this.writer != null) {
                Writer writer = this.writer;
                this.writer = null;
                writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void openFile() {
        if (this.writer == null) {
            if (this.outFile != null) {
                try {
                    this.writer = this.logForStream(secureAction.getFileOutputStream(this.outFile, true));
                }
                catch (IOException iOException) {
                    this.writer = this.logForStream(System.err);
                }
            } else {
                this.writer = this.logForStream(System.err);
            }
        }
    }

    private void closeFile() {
        if (this.outFile != null && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.writer = null;
        }
    }

    private synchronized void log(FrameworkLogEntry frameworkLogEntry) {
        if (frameworkLogEntry == null) {
            return;
        }
        if (!this.isLoggable(frameworkLogEntry.getSeverity())) {
            return;
        }
        try {
            try {
                this.checkLogFileSize();
                this.openFile();
                if (this.newSession) {
                    this.writeSession();
                    this.newSession = false;
                }
                this.writeLog(0, frameworkLogEntry);
                this.writer.flush();
            }
            catch (Exception exception) {
                System.err.println("An exception occurred while writing to the platform log:");
                exception.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.writer = this.logForStream(System.err);
                    this.writeLog(0, frameworkLogEntry);
                    this.writer.flush();
                }
                catch (Exception exception2) {
                    System.err.println("An exception occurred while logging to the console:");
                    exception2.printStackTrace(System.err);
                }
                this.closeFile();
            }
        }
        finally {
            this.closeFile();
        }
    }

    public synchronized void setWriter(Writer writer, boolean bl) {
        this.setOutput(null, writer, bl);
    }

    public synchronized void setFile(File file, boolean bl) throws IOException {
        if (file != null && !file.equals(this.outFile)) {
            this.readLogProperties();
            this.backupIdx = 0;
        }
        this.setOutput(file, null, bl);
        FrameworkProperties.setProperty("osgi.logfile", file == null ? "" : file.getAbsolutePath());
    }

    public synchronized File getFile() {
        return this.outFile;
    }

    public void setConsoleLog(boolean bl) {
        this.consoleLog = bl;
    }

    private void setOutput(File file, Writer writer, boolean bl) {
        if (file == null || !file.equals(this.outFile)) {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.writer = null;
            }
            File file2 = this.outFile;
            this.outFile = file;
            this.writer = writer;
            boolean bl2 = false;
            if (bl && file2 != null && file2.isFile()) {
                Reader reader = null;
                try {
                    try {
                        this.openFile();
                        reader = new InputStreamReader((InputStream)secureAction.getFileInputStream(file2), "UTF-8");
                        this.copyReader(reader, this.writer);
                    }
                    catch (IOException iOException) {
                        bl2 = true;
                        iOException.printStackTrace();
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException2) {
                                iOException2.printStackTrace();
                            }
                            if (!bl2) {
                                file2.delete();
                            }
                        }
                        this.closeFile();
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        if (!bl2) {
                            file2.delete();
                        }
                    }
                    this.closeFile();
                }
            }
        }
    }

    private void copyReader(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            writer.write(cArray, 0, n);
        }
    }

    private String getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPaddedInt(calendar.get(1), 4, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(2) + 1, 2, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(5), 2, stringBuffer).append(' ');
        this.appendPaddedInt(calendar.get(11), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(12), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(13), 2, stringBuffer).append('.');
        this.appendPaddedInt(calendar.get(14), 3, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer appendPaddedInt(int var1_1, int var2_2, StringBuffer var3_3) {
        if (--var2_2 == 0) {
            return var3_3.append(Integer.toString(var1_1));
        }
        var4_4 = (int)Math.pow(10.0, var2_2);
        if (var1_1 < var4_4) ** GOTO lbl9
        return var3_3.append(Integer.toString(var1_1));
lbl-1000:
        // 1 sources

        {
            var3_3.append('0');
            var4_4 /= 10;
lbl9:
            // 2 sources

            ** while (var4_4 > var1_1 && var4_4 > 1)
        }
lbl10:
        // 1 sources

        var3_3.append(var1_1);
        return var3_3;
    }

    private String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        Throwable throwable2 = this.getRoot(throwable);
        if (throwable2 != null) {
            printWriter.println("Root exception:");
            throwable2.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    private Writer logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    private void writeLog(int n, FrameworkLogEntry frameworkLogEntry) throws IOException {
        this.writeEntry(n, frameworkLogEntry);
        this.writeMessage(frameworkLogEntry);
        this.writeStack(frameworkLogEntry);
        FrameworkLogEntry[] frameworkLogEntryArray = frameworkLogEntry.getChildren();
        if (frameworkLogEntryArray != null) {
            int n2 = 0;
            while (n2 < frameworkLogEntryArray.length) {
                this.writeLog(n + 1, frameworkLogEntryArray[n2]);
                ++n2;
            }
        }
    }

    private void writeEntry(int n, FrameworkLogEntry frameworkLogEntry) throws IOException {
        if (n == 0) {
            this.writeln();
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(n));
        }
        this.writeSpace();
        this.write(frameworkLogEntry.getEntry());
        this.writeSpace();
        this.write(Integer.toString(frameworkLogEntry.getSeverity()));
        this.writeSpace();
        this.write(Integer.toString(frameworkLogEntry.getBundleCode()));
        this.writeSpace();
        this.write(this.getDate(new Date()));
        this.writeln();
    }

    private void writeMessage(FrameworkLogEntry frameworkLogEntry) throws IOException {
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(frameworkLogEntry.getMessage());
    }

    private void writeStack(FrameworkLogEntry frameworkLogEntry) throws IOException {
        Throwable throwable = frameworkLogEntry.getThrowable();
        if (throwable != null) {
            String string = this.getStackTrace(throwable);
            this.write(STACK);
            this.writeSpace();
            this.write(Integer.toString(frameworkLogEntry.getStackCode()));
            this.writeln();
            this.write(string);
        }
    }

    private void write(String string) throws IOException {
        if (string != null) {
            this.writer.write(string);
            if (this.consoleLog) {
                System.out.print(string);
            }
        }
    }

    private void writeln(String string) throws IOException {
        this.write(string);
        this.writeln();
    }

    private void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    private void writeSpace() throws IOException {
        this.write(" ");
    }

    private boolean checkLogFileSize() {
        if (this.maxLogSize == 0) {
            return true;
        }
        boolean bl = true;
        if (this.outFile != null && secureAction.length(this.outFile) >> 10 > (long)this.maxLogSize) {
            boolean bl2;
            String string = this.outFile.getAbsolutePath();
            String string2 = "";
            string2 = string.toLowerCase().endsWith(LOG_EXT) ? String.valueOf(string.substring(0, string.length() - LOG_EXT.length())) + BACKUP_MARK + this.backupIdx + LOG_EXT : String.valueOf(string) + BACKUP_MARK + this.backupIdx;
            File file = new File(string2);
            if (file.exists() && !file.delete()) {
                System.err.println("Error when trying to delete old log file: " + file.getName());
                if (file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + System.currentTimeMillis()))) {
                    System.err.println("So we rename it to filename: " + file.getName());
                } else {
                    System.err.println("And we also cannot rename it!");
                    bl = false;
                }
            }
            if (!(bl2 = this.outFile.renameTo(file))) {
                System.err.println("Error when trying to rename log file to backup one.");
                bl = false;
            }
            File file2 = new File(string);
            this.setOutput(file2, null, false);
            this.openFile();
            try {
                this.writeSession();
                this.writeln();
                this.writeln("This is a continuation of log file " + file.getAbsolutePath());
                this.writeln("Created Time: " + this.getDate(new Date(System.currentTimeMillis())));
                this.writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            this.closeFile();
            ++this.backupIdx;
            this.backupIdx %= this.maxLogFiles;
        }
        return bl;
    }

    private void readLogProperties() {
        String string;
        String string2;
        String string3 = secureAction.getProperty(PROP_LOG_SIZE_MAX);
        if (string3 != null) {
            this.maxLogSize = Integer.parseInt(string3);
            if (this.maxLogSize != 0 && this.maxLogSize < 10) {
                this.maxLogSize = 10;
            }
        }
        if ((string2 = secureAction.getProperty(PROP_LOG_FILE_MAX)) != null) {
            this.maxLogFiles = Integer.parseInt(string2);
            if (this.maxLogFiles < 1) {
                this.maxLogFiles = 10;
            }
        }
        if ((string = secureAction.getProperty(PROP_LOG_LEVEL)) != null) {
            this.logLevel = string.equals("ERROR") ? 4 : (string.equals("WARNING") ? 6 : (string.equals("INFO") ? 15 : 0));
        }
    }

    private boolean isLoggable(int n) {
        if (this.logLevel == 0) {
            return true;
        }
        return (n & this.logLevel) != 0;
    }

    public boolean isLoggable(Bundle bundle, String string, int n) {
        if (!this.enabled) {
            return false;
        }
        if (this.loggerName.equals(string)) {
            return this.isLoggable(EclipseLogWriter.convertSeverity(n));
        }
        if ("org.eclipse.performance.logger".equals(string)) {
            return false;
        }
        if (!"org.eclipse.equinox.logger".equals(this.loggerName)) {
            return false;
        }
        return n == 1;
    }

    public void logged(LogEntry logEntry) {
        if (!(logEntry instanceof ExtendedLogEntry)) {
            return;
        }
        ExtendedLogEntry extendedLogEntry = (ExtendedLogEntry)logEntry;
        Object object = extendedLogEntry.getContext();
        if (object instanceof FrameworkLogEntry) {
            this.log((FrameworkLogEntry)object);
            return;
        }
        this.log(new FrameworkLogEntry(EclipseLogWriter.getFwkEntryTag(logEntry), EclipseLogWriter.convertSeverity(logEntry.getLevel()), 0, logEntry.getMessage(), 0, logEntry.getException(), null));
    }

    private static String getFwkEntryTag(LogEntry logEntry) {
        Bundle bundle = logEntry.getBundle();
        if (bundle != null && bundle.getSymbolicName() != null) {
            return bundle.getSymbolicName();
        }
        return "unknown";
    }

    private static int convertSeverity(int n) {
        switch (n) {
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
        }
        return 32;
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

