/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.wireadmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.wireadmin.WirePermission;

final class WirePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 2617521094909826016L;
    private final Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof WirePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WirePermission wirePermission = (WirePermission)permission;
        String string = wirePermission.getName();
        WirePermissionCollection wirePermissionCollection = this;
        synchronized (wirePermissionCollection) {
            WirePermission wirePermission2 = (WirePermission)this.permissions.get(string);
            if (wirePermission2 != null) {
                int n;
                int n2 = wirePermission2.getActionsMask();
                if (n2 != (n = wirePermission.getActionsMask())) {
                    this.permissions.put(string, new WirePermission(string, n2 | n));
                }
            } else {
                this.permissions.put(string, wirePermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        int n;
        WirePermission wirePermission;
        if (!(permission instanceof WirePermission)) {
            return false;
        }
        WirePermission wirePermission2 = (WirePermission)permission;
        int n2 = wirePermission2.getActionsMask();
        int n3 = 0;
        String string = wirePermission2.getName();
        WirePermissionCollection wirePermissionCollection = this;
        synchronized (wirePermissionCollection) {
            if (this.all_allowed && (wirePermission = (WirePermission)this.permissions.get("*")) != null && ((n3 |= wirePermission.getActionsMask()) & n2) == n2) {
                return true;
            }
            wirePermission = (WirePermission)this.permissions.get(string);
        }
        if (wirePermission != null && ((n3 |= wirePermission.getActionsMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n4)) != -1) {
            string = string.substring(0, n + 1) + "*";
            WirePermissionCollection wirePermissionCollection2 = this;
            synchronized (wirePermissionCollection2) {
                wirePermission = (WirePermission)this.permissions.get(string);
            }
            if (wirePermission != null && ((n3 |= wirePermission.getActionsMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

