/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.auth.Activator;
import org.eclipse.core.internal.runtime.auth.AuthorizationDatabase;
import org.eclipse.core.internal.runtime.auth.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AuthorizationHandler {
    static final String F_KEYRING = ".keyring";
    private static AuthorizationDatabase keyring = null;
    private static long keyringTimeStamp;
    private static String keyringFile;
    private static String password;
    static /* synthetic */ Class class$0;

    static {
        keyringFile = null;
        password = "";
    }

    private static void loadKeyring() throws CoreException {
        if (keyring != null && new File(keyringFile).lastModified() == keyringTimeStamp) {
            return;
        }
        if (keyringFile == null) {
            ServiceReference[] serviceReferenceArray = null;
            try {
                BundleContext bundleContext = Activator.getContext();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((serviceReferenceArray = bundleContext.getServiceReferences(clazz.getName(), Location.CONFIGURATION_FILTER)) == null || serviceReferenceArray.length == 0) {
                    return;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                return;
            }
            Location location = (Location)Activator.getContext().getService(serviceReferenceArray[0]);
            if (location == null) {
                return;
            }
            File file = new File(String.valueOf(location.getURL().getPath()) + "/org.eclipse.core.runtime");
            Activator.getContext().ungetService(serviceReferenceArray[0]);
            file = new File(file, F_KEYRING);
            keyringFile = file.getAbsolutePath();
        }
        try {
            keyring = new AuthorizationDatabase(keyringFile, password);
        }
        catch (CoreException coreException) {
            Activator.log(coreException.getStatus());
        }
        if (keyring == null) {
            new File(keyringFile).delete();
            keyring = new AuthorizationDatabase(keyringFile, password);
        }
        keyringTimeStamp = new File(keyringFile).lastModified();
    }

    private static void saveKeyring() throws CoreException {
        keyring.save();
        keyringTimeStamp = new File(keyringFile).lastModified();
    }

    public static synchronized void addAuthorizationInfo(URL uRL, String string, String string2, Map map) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.addAuthorizationInfo(uRL, string, string2, new HashMap(map));
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized void addProtectionSpace(URL uRL, String string) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.addProtectionSpace(uRL, string);
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized void flushAuthorizationInfo(URL uRL, String string, String string2) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.flushAuthorizationInfo(uRL, string, string2);
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized Map getAuthorizationInfo(URL uRL, String string, String string2) {
        Map map = null;
        try {
            AuthorizationHandler.loadKeyring();
            map = keyring.getAuthorizationInfo(uRL, string, string2);
        }
        catch (CoreException coreException) {}
        return map == null ? null : new HashMap(map);
    }

    public static synchronized String getProtectionSpace(URL uRL) {
        try {
            AuthorizationHandler.loadKeyring();
        }
        catch (CoreException coreException) {
            return null;
        }
        return keyring.getProtectionSpace(uRL);
    }

    public static void setKeyringFile(String string) {
        if (keyringFile != null) {
            throw new IllegalStateException(NLS.bind((String)Messages.meta_keyringFileAlreadySpecified, (Object)keyringFile));
        }
        keyringFile = string;
    }

    public static void setPassword(String string) {
        password = string;
    }
}

