/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.dynamichelpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.runtime.ReferenceHashSet;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;

public class ExtensionTracker
implements IExtensionTracker,
IRegistryChangeListener {
    private Map extensionToObjects = new HashMap();
    private ListenerList handlers = new ListenerList();
    private final Object lock = new Object();
    private boolean closed = false;
    private IExtensionRegistry registry;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public ExtensionTracker() {
        this(RegistryFactory.getRegistry());
    }

    public ExtensionTracker(IExtensionRegistry iExtensionRegistry) {
        this.registry = iExtensionRegistry;
        if (this.registry != null) {
            this.registry.addRegistryChangeListener(this);
        } else {
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.registry_no_default, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(IExtensionChangeHandler iExtensionChangeHandler, IFilter iFilter) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.handlers.add((Object)new HandlerWrapper(iExtensionChangeHandler, iFilter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(IExtensionChangeHandler iExtensionChangeHandler) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.handlers.remove((Object)new HandlerWrapper(iExtensionChangeHandler, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(IExtension iExtension, Object object, int n) {
        if (iExtension == null || object == null) {
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                return;
            }
            ReferenceHashSet referenceHashSet = (ReferenceHashSet)this.extensionToObjects.get(iExtension);
            if (referenceHashSet == null) {
                referenceHashSet = new ReferenceHashSet();
                this.extensionToObjects.put(iExtension, referenceHashSet);
            }
            referenceHashSet.add(object, n);
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            switch (iExtensionDeltaArray[n2].getKind()) {
                case 1: {
                    this.doAdd(iExtensionDeltaArray[n2]);
                    break;
                }
                case 2: {
                    this.doRemove(iExtensionDeltaArray[n2]);
                    break;
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(IExtensionDelta iExtensionDelta, Object[] objectArray) {
        Object[] objectArray2 = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.handlers == null || this.handlers.isEmpty()) {
                return;
            }
            objectArray2 = this.handlers.getListeners();
        }
        int n = 0;
        while (n < objectArray2.length) {
            HandlerWrapper handlerWrapper = (HandlerWrapper)objectArray2[n];
            if (handlerWrapper.filter == null || handlerWrapper.filter.matches(iExtensionDelta.getExtensionPoint())) {
                if (objectArray == null) {
                    this.applyAdd(handlerWrapper.handler, iExtensionDelta.getExtension());
                } else {
                    this.applyRemove(handlerWrapper.handler, iExtensionDelta.getExtension(), objectArray);
                }
            }
            ++n;
        }
    }

    protected void applyAdd(IExtensionChangeHandler iExtensionChangeHandler, IExtension iExtension) {
        iExtensionChangeHandler.addExtension(this, iExtension);
    }

    private void doAdd(IExtensionDelta iExtensionDelta) {
        this.notify(iExtensionDelta, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(IExtensionDelta iExtensionDelta) {
        Object[] objectArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            ReferenceHashSet referenceHashSet = (ReferenceHashSet)this.extensionToObjects.remove(iExtensionDelta.getExtension());
            objectArray = referenceHashSet == null ? EMPTY_ARRAY : referenceHashSet.toArray();
        }
        this.notify(iExtensionDelta, objectArray);
    }

    protected void applyRemove(IExtensionChangeHandler iExtensionChangeHandler, IExtension iExtension, Object[] objectArray) {
        iExtensionChangeHandler.removeExtension(iExtension, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getObjects(IExtension iExtension) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return EMPTY_ARRAY;
            }
            ReferenceHashSet referenceHashSet = (ReferenceHashSet)this.extensionToObjects.get(iExtension);
            if (referenceHashSet == null) {
                return EMPTY_ARRAY;
            }
            return referenceHashSet.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.registry != null) {
                this.registry.removeRegistryChangeListener(this);
            }
            this.extensionToObjects = null;
            this.handlers = null;
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(IExtension iExtension, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                return;
            }
            ReferenceHashSet referenceHashSet = (ReferenceHashSet)this.extensionToObjects.get(iExtension);
            if (referenceHashSet != null) {
                referenceHashSet.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] unregisterObject(IExtension iExtension) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return EMPTY_ARRAY;
            }
            ReferenceHashSet referenceHashSet = (ReferenceHashSet)this.extensionToObjects.remove(iExtension);
            if (referenceHashSet == null) {
                return EMPTY_ARRAY;
            }
            return referenceHashSet.toArray();
        }
    }

    public static IFilter createExtensionPointFilter(final IExtensionPoint iExtensionPoint) {
        return new IFilter(){

            public boolean matches(IExtensionPoint iExtensionPoint2) {
                return iExtensionPoint.equals(iExtensionPoint2);
            }
        };
    }

    public static IFilter createExtensionPointFilter(final IExtensionPoint[] iExtensionPointArray) {
        return new IFilter(){

            public boolean matches(IExtensionPoint iExtensionPoint) {
                int n = 0;
                while (n < iExtensionPointArray.length) {
                    if (iExtensionPointArray[n].equals(iExtensionPoint)) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
        };
    }

    public static IFilter createNamespaceFilter(final String string) {
        return new IFilter(){

            public boolean matches(IExtensionPoint iExtensionPoint) {
                return string.equals(iExtensionPoint.getNamespaceIdentifier());
            }
        };
    }

    private class HandlerWrapper {
        IExtensionChangeHandler handler;
        IFilter filter;

        public HandlerWrapper(IExtensionChangeHandler iExtensionChangeHandler, IFilter iFilter) {
            this.handler = iExtensionChangeHandler;
            this.filter = iFilter;
        }

        public boolean equals(Object object) {
            return this.handler.equals(((HandlerWrapper)object).handler);
        }

        public int hashCode() {
            return this.handler.hashCode();
        }
    }
}

