/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.internal.adapter.AdapterManagerListener;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.RegistryProviderFactory;
import org.eclipse.core.internal.registry.osgi.EquinoxRegistryStrategy;
import org.eclipse.core.internal.registry.osgi.EquinoxUtils;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryProviderOSGI;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static BundleContext bundleContext;
    private static final String STORAGE_DIR = "org.eclipse.core.runtime";
    private Object masterRegistryKey = new Object();
    private Object userRegistryKey = new Object();
    private IExtensionRegistry defaultRegistry = null;
    private ServiceRegistration registryRegistration;
    private ServiceRegistration commandRegistration;
    private RegistryProviderOSGI defaultProvider;
    private AdapterManagerListener adapterManagerListener = null;
    static /* synthetic */ Class class$0;

    public void start(BundleContext bundleContext) throws Exception {
        Activator.bundleContext = bundleContext;
        RegistryProperties.setContext(Activator.bundleContext);
        this.processCommandLine();
        this.startRegistry();
        this.adapterManagerListener = new AdapterManagerListener();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.adapterManagerListener != null) {
            this.adapterManagerListener.stop();
        }
        this.stopRegistry();
        RegistryProperties.setContext(null);
        Activator.bundleContext = null;
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    private void processCommandLine() {
        ServiceReference serviceReference = Activator.getContext().getServiceReference("org.eclipse.osgi.service.environment.EnvironmentInfo");
        if (serviceReference == null) {
            return;
        }
        String[] stringArray = EquinoxUtils.getCommandLine(bundleContext, serviceReference);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-noregistrycache")) {
                RegistryProperties.setProperty("eclipse.noRegistryCache", "true");
            } else if (stringArray[n].equalsIgnoreCase("-noLazyRegistryCacheLoading")) {
                RegistryProperties.setProperty("eclipse.noLazyRegistryCacheLoading", "true");
            } else if (stringArray[n].equalsIgnoreCase("-registryMultiLanguage")) {
                RegistryProperties.setProperty("eclipse.registry.MultiLanguage", "true");
            }
            ++n;
        }
    }

    public void startRegistry() throws CoreException {
        String string = bundleContext.getProperty("eclipse.createRegistry");
        if (string != null && string.equalsIgnoreCase("false")) {
            return;
        }
        if ("true".equals(bundleContext.getProperty("eclipse.registry.nulltoken"))) {
            this.userRegistryKey = null;
        }
        RegistryStrategyOSGI registryStrategyOSGI = null;
        Location location = OSGIUtils.getDefault().getConfigurationLocation();
        if (location == null) {
            RegistryProperties.setProperty("eclipse.noRegistryCache", "true");
            RegistryProperties.setProperty("eclipse.noLazyRegistryCacheLoading", "true");
            registryStrategyOSGI = new RegistryStrategyOSGI(null, null, this.masterRegistryKey);
        } else {
            boolean[] blArray;
            File[] fileArray;
            File file = new File(String.valueOf(location.getURL().getPath()) + '/' + STORAGE_DIR);
            boolean bl = location.isReadOnly();
            Location location2 = location.getParentLocation();
            if (location2 != null) {
                File file2 = new File(String.valueOf(location2.getURL().getFile()) + '/' + STORAGE_DIR);
                fileArray = new File[]{file, file2};
                blArray = new boolean[]{bl, true};
            } else {
                fileArray = new File[]{file};
                blArray = new boolean[]{bl};
            }
            registryStrategyOSGI = new EquinoxRegistryStrategy(fileArray, blArray, this.masterRegistryKey);
        }
        this.defaultRegistry = RegistryFactory.createRegistry(registryStrategyOSGI, this.masterRegistryKey, this.userRegistryKey);
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registryRegistration = bundleContext.registerService(clazz.getName(), (Object)this.defaultRegistry, new Hashtable());
        this.defaultProvider = new RegistryProviderOSGI();
        RegistryProviderFactory.setDefault(this.defaultProvider);
        this.commandRegistration = EquinoxUtils.registerCommandProvider(Activator.getContext());
    }

    private void stopRegistry() {
        if (this.defaultRegistry != null) {
            RegistryProviderFactory.releaseDefault();
            this.defaultProvider.release();
            this.registryRegistration.unregister();
            this.defaultRegistry.stop(this.masterRegistryKey);
        }
        if (this.commandRegistration != null) {
            this.commandRegistration.unregister();
        }
    }
}

