/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class OffsetTable {
    private static final float GROWTH_FACTOR = 1.33f;
    private int[] valueTable;

    public OffsetTable(int n) {
        this.valueTable = new int[n];
    }

    public int get(int n) {
        if (n < this.valueTable.length) {
            return this.valueTable[n];
        }
        return Integer.MIN_VALUE;
    }

    public void removeKey(int n) {
        if (n < this.valueTable.length) {
            this.valueTable[n] = Integer.MIN_VALUE;
        }
    }

    public void put(int n, int n2) {
        if (n >= this.valueTable.length) {
            int[] nArray = new int[(int)((float)n * 1.33f)];
            System.arraycopy(this.valueTable, 0, nArray, 0, this.valueTable.length);
            this.valueTable = nArray;
        }
        this.valueTable[n] = n2;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        int n = this.valueTable.length;
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeInt(this.valueTable[n2]);
            ++n2;
        }
    }

    public static OffsetTable load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        OffsetTable offsetTable = new OffsetTable(n);
        offsetTable.valueTable = new int[n];
        int n2 = 0;
        while (n2 < n) {
            offsetTable.valueTable[n2] = dataInputStream.readInt();
            ++n2;
        }
        return offsetTable;
    }
}

